package io.qt.test;


/**
 * <p>List of GUI events</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qtesteventlist.html">QList</a></p>
 */
public class QTestEventList extends io.qt.core.QList<io.qt.test.QTestEvent>
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtesteventlist.html#QTestEventList">QTestEventList::QTestEventList()</a></p>
     */
    public QTestEventList(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QTestEventList instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtesteventlist.html#QTestEventList-1">QTestEventList::QTestEventList(QTestEventList)</a></p>
     */
    public QTestEventList(io.qt.test.QTestEventList other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QTestEventList instance, io.qt.test.QTestEventList other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtesteventlist.html#addDelay">QTestEventList::addDelay(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addDelay(int msecs){
        addDelay_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), msecs);
    }
    
    @io.qt.QtUninvokable
    private native void addDelay_native_int(long __this__nativeId, int msecs);
    
    /**
     * <p>Overloaded function for {@link #addKeyClick(io.qt.core.Qt.Key, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>msecs = -1</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void addKeyClick(io.qt.core.Qt.Key qtKey, io.qt.core.Qt.KeyboardModifiers modifiers) {
        addKeyClick(qtKey, modifiers, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #addKeyClick(io.qt.core.Qt.Key, io.qt.core.Qt.KeyboardModifiers, int)}</p>
     * <p>with: </p><ul>
     * <li><code>modifiers = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>msecs = -1</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void addKeyClick(io.qt.core.Qt.Key qtKey) {
        addKeyClick(qtKey, new io.qt.core.Qt.KeyboardModifiers(0), (int)-1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtesteventlist.html#addKeyClick">QTestEventList::addKeyClick(Qt::Key,Qt::KeyboardModifiers,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addKeyClick(io.qt.core.Qt.Key qtKey, io.qt.core.Qt.KeyboardModifiers modifiers, int msecs){
        addKeyClick_native_Qt_Key_QFlags_Qt_KeyboardModifier__int(QtJambi_LibraryUtilities.internal.nativeId(this), qtKey.value(), modifiers.value(), msecs);
    }
    
    @io.qt.QtUninvokable
    private native void addKeyClick_native_Qt_Key_QFlags_Qt_KeyboardModifier__int(long __this__nativeId, int qtKey, int modifiers, int msecs);
    
    /**
     * <p>Overloaded function for {@link #addKeyClick(byte, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>msecs = -1</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void addKeyClick(byte ascii, io.qt.core.Qt.KeyboardModifiers modifiers) {
        addKeyClick(ascii, modifiers, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #addKeyClick(byte, io.qt.core.Qt.KeyboardModifiers, int)}</p>
     * <p>with: </p><ul>
     * <li><code>modifiers = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>msecs = -1</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void addKeyClick(byte ascii) {
        addKeyClick(ascii, new io.qt.core.Qt.KeyboardModifiers(0), (int)-1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtesteventlist.html#addKeyClick-1">QTestEventList::addKeyClick(char,Qt::KeyboardModifiers,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addKeyClick(byte ascii, io.qt.core.Qt.KeyboardModifiers modifiers, int msecs){
        addKeyClick_native_char_QFlags_Qt_KeyboardModifier__int(QtJambi_LibraryUtilities.internal.nativeId(this), ascii, modifiers.value(), msecs);
    }
    
    @io.qt.QtUninvokable
    private native void addKeyClick_native_char_QFlags_Qt_KeyboardModifier__int(long __this__nativeId, byte ascii, int modifiers, int msecs);
    
    /**
     * <p>Overloaded function for {@link #addKeyClicks(java.lang.String, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>msecs = -1</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void addKeyClicks(java.lang.String keys, io.qt.core.Qt.KeyboardModifiers modifiers) {
        addKeyClicks(keys, modifiers, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #addKeyClicks(java.lang.String, io.qt.core.Qt.KeyboardModifiers, int)}</p>
     * <p>with: </p><ul>
     * <li><code>modifiers = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>msecs = -1</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void addKeyClicks(java.lang.String keys) {
        addKeyClicks(keys, new io.qt.core.Qt.KeyboardModifiers(0), (int)-1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtesteventlist.html#addKeyClicks">QTestEventList::addKeyClicks(QString,Qt::KeyboardModifiers,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addKeyClicks(java.lang.String keys, io.qt.core.Qt.KeyboardModifiers modifiers, int msecs){
        addKeyClicks_native_cref_QString_QFlags_Qt_KeyboardModifier__int(QtJambi_LibraryUtilities.internal.nativeId(this), keys, modifiers.value(), msecs);
    }
    
    @io.qt.QtUninvokable
    private native void addKeyClicks_native_cref_QString_QFlags_Qt_KeyboardModifier__int(long __this__nativeId, java.lang.String keys, int modifiers, int msecs);
    
    /**
     * <p>Overloaded function for {@link #addKeyEvent(io.qt.test.QTest.KeyAction, io.qt.core.Qt.Key, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>msecs = -1</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void addKeyEvent(io.qt.test.QTest.KeyAction action, io.qt.core.Qt.Key qtKey, io.qt.core.Qt.KeyboardModifiers modifiers) {
        addKeyEvent(action, qtKey, modifiers, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #addKeyEvent(io.qt.test.QTest.KeyAction, io.qt.core.Qt.Key, io.qt.core.Qt.KeyboardModifiers, int)}</p>
     * <p>with: </p><ul>
     * <li><code>modifiers = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>msecs = -1</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void addKeyEvent(io.qt.test.QTest.KeyAction action, io.qt.core.Qt.Key qtKey) {
        addKeyEvent(action, qtKey, new io.qt.core.Qt.KeyboardModifiers(0), (int)-1);
    }
    
    @io.qt.QtUninvokable
    public final void addKeyEvent(io.qt.test.QTest.KeyAction action, io.qt.core.Qt.Key qtKey, io.qt.core.Qt.KeyboardModifiers modifiers, int msecs){
        addKeyEvent_native_QTest_KeyAction_Qt_Key_QFlags_Qt_KeyboardModifier__int(QtJambi_LibraryUtilities.internal.nativeId(this), action.value(), qtKey.value(), modifiers.value(), msecs);
    }
    
    @io.qt.QtUninvokable
    private native void addKeyEvent_native_QTest_KeyAction_Qt_Key_QFlags_Qt_KeyboardModifier__int(long __this__nativeId, int action, int qtKey, int modifiers, int msecs);
    
    /**
     * <p>Overloaded function for {@link #addKeyEvent(io.qt.test.QTest.KeyAction, byte, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>msecs = -1</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void addKeyEvent(io.qt.test.QTest.KeyAction action, byte ascii, io.qt.core.Qt.KeyboardModifiers modifiers) {
        addKeyEvent(action, ascii, modifiers, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #addKeyEvent(io.qt.test.QTest.KeyAction, byte, io.qt.core.Qt.KeyboardModifiers, int)}</p>
     * <p>with: </p><ul>
     * <li><code>modifiers = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>msecs = -1</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void addKeyEvent(io.qt.test.QTest.KeyAction action, byte ascii) {
        addKeyEvent(action, ascii, new io.qt.core.Qt.KeyboardModifiers(0), (int)-1);
    }
    
    @io.qt.QtUninvokable
    public final void addKeyEvent(io.qt.test.QTest.KeyAction action, byte ascii, io.qt.core.Qt.KeyboardModifiers modifiers, int msecs){
        addKeyEvent_native_QTest_KeyAction_char_QFlags_Qt_KeyboardModifier__int(QtJambi_LibraryUtilities.internal.nativeId(this), action.value(), ascii, modifiers.value(), msecs);
    }
    
    @io.qt.QtUninvokable
    private native void addKeyEvent_native_QTest_KeyAction_char_QFlags_Qt_KeyboardModifier__int(long __this__nativeId, int action, byte ascii, int modifiers, int msecs);
    
    /**
     * <p>Overloaded function for {@link #addKeyPress(io.qt.core.Qt.Key, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>msecs = -1</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void addKeyPress(io.qt.core.Qt.Key qtKey, io.qt.core.Qt.KeyboardModifiers modifiers) {
        addKeyPress(qtKey, modifiers, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #addKeyPress(io.qt.core.Qt.Key, io.qt.core.Qt.KeyboardModifiers, int)}</p>
     * <p>with: </p><ul>
     * <li><code>modifiers = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>msecs = -1</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void addKeyPress(io.qt.core.Qt.Key qtKey) {
        addKeyPress(qtKey, new io.qt.core.Qt.KeyboardModifiers(0), (int)-1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtesteventlist.html#addKeyPress">QTestEventList::addKeyPress(Qt::Key,Qt::KeyboardModifiers,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addKeyPress(io.qt.core.Qt.Key qtKey, io.qt.core.Qt.KeyboardModifiers modifiers, int msecs){
        addKeyPress_native_Qt_Key_QFlags_Qt_KeyboardModifier__int(QtJambi_LibraryUtilities.internal.nativeId(this), qtKey.value(), modifiers.value(), msecs);
    }
    
    @io.qt.QtUninvokable
    private native void addKeyPress_native_Qt_Key_QFlags_Qt_KeyboardModifier__int(long __this__nativeId, int qtKey, int modifiers, int msecs);
    
    /**
     * <p>Overloaded function for {@link #addKeyPress(byte, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>msecs = -1</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void addKeyPress(byte ascii, io.qt.core.Qt.KeyboardModifiers modifiers) {
        addKeyPress(ascii, modifiers, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #addKeyPress(byte, io.qt.core.Qt.KeyboardModifiers, int)}</p>
     * <p>with: </p><ul>
     * <li><code>modifiers = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>msecs = -1</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void addKeyPress(byte ascii) {
        addKeyPress(ascii, new io.qt.core.Qt.KeyboardModifiers(0), (int)-1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtesteventlist.html#addKeyPress-1">QTestEventList::addKeyPress(char,Qt::KeyboardModifiers,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addKeyPress(byte ascii, io.qt.core.Qt.KeyboardModifiers modifiers, int msecs){
        addKeyPress_native_char_QFlags_Qt_KeyboardModifier__int(QtJambi_LibraryUtilities.internal.nativeId(this), ascii, modifiers.value(), msecs);
    }
    
    @io.qt.QtUninvokable
    private native void addKeyPress_native_char_QFlags_Qt_KeyboardModifier__int(long __this__nativeId, byte ascii, int modifiers, int msecs);
    
    /**
     * <p>Overloaded function for {@link #addKeyRelease(io.qt.core.Qt.Key, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>msecs = -1</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void addKeyRelease(io.qt.core.Qt.Key qtKey, io.qt.core.Qt.KeyboardModifiers modifiers) {
        addKeyRelease(qtKey, modifiers, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #addKeyRelease(io.qt.core.Qt.Key, io.qt.core.Qt.KeyboardModifiers, int)}</p>
     * <p>with: </p><ul>
     * <li><code>modifiers = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>msecs = -1</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void addKeyRelease(io.qt.core.Qt.Key qtKey) {
        addKeyRelease(qtKey, new io.qt.core.Qt.KeyboardModifiers(0), (int)-1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtesteventlist.html#addKeyRelease">QTestEventList::addKeyRelease(Qt::Key,Qt::KeyboardModifiers,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addKeyRelease(io.qt.core.Qt.Key qtKey, io.qt.core.Qt.KeyboardModifiers modifiers, int msecs){
        addKeyRelease_native_Qt_Key_QFlags_Qt_KeyboardModifier__int(QtJambi_LibraryUtilities.internal.nativeId(this), qtKey.value(), modifiers.value(), msecs);
    }
    
    @io.qt.QtUninvokable
    private native void addKeyRelease_native_Qt_Key_QFlags_Qt_KeyboardModifier__int(long __this__nativeId, int qtKey, int modifiers, int msecs);
    
    /**
     * <p>Overloaded function for {@link #addKeyRelease(byte, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>msecs = -1</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void addKeyRelease(byte ascii, io.qt.core.Qt.KeyboardModifiers modifiers) {
        addKeyRelease(ascii, modifiers, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #addKeyRelease(byte, io.qt.core.Qt.KeyboardModifiers, int)}</p>
     * <p>with: </p><ul>
     * <li><code>modifiers = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>msecs = -1</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void addKeyRelease(byte ascii) {
        addKeyRelease(ascii, new io.qt.core.Qt.KeyboardModifiers(0), (int)-1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtesteventlist.html#addKeyRelease-1">QTestEventList::addKeyRelease(char,Qt::KeyboardModifiers,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addKeyRelease(byte ascii, io.qt.core.Qt.KeyboardModifiers modifiers, int msecs){
        addKeyRelease_native_char_QFlags_Qt_KeyboardModifier__int(QtJambi_LibraryUtilities.internal.nativeId(this), ascii, modifiers.value(), msecs);
    }
    
    @io.qt.QtUninvokable
    private native void addKeyRelease_native_char_QFlags_Qt_KeyboardModifier__int(long __this__nativeId, byte ascii, int modifiers, int msecs);
    
    /**
     * <p>Overloaded function for {@link #addMouseClick(io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}
     *  with <code>delay = -1</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void addMouseClick(io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos) {
        addMouseClick(button, stateKey, pos, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #addMouseClick(io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void addMouseClick(io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey) {
        addMouseClick(button, stateKey, new io.qt.core.QPoint(), (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #addMouseClick(io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>stateKey = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void addMouseClick(io.qt.core.Qt.MouseButton button) {
        addMouseClick(button, new io.qt.core.Qt.KeyboardModifiers(0), new io.qt.core.QPoint(), (int)-1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtesteventlist.html#addMouseClick">QTestEventList::addMouseClick(Qt::MouseButton,Qt::KeyboardModifiers,QPoint,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addMouseClick(io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos, int delay){
        addMouseClick_native_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(QtJambi_LibraryUtilities.internal.nativeId(this), button.value(), stateKey.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(pos), delay);
    }
    
    @io.qt.QtUninvokable
    private native void addMouseClick_native_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(long __this__nativeId, int button, int stateKey, long pos, int delay);
    
    /**
     * <p>Overloaded function for {@link #addMouseDClick(io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}
     *  with <code>delay = -1</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void addMouseDClick(io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos) {
        addMouseDClick(button, stateKey, pos, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #addMouseDClick(io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void addMouseDClick(io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey) {
        addMouseDClick(button, stateKey, new io.qt.core.QPoint(), (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #addMouseDClick(io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>stateKey = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void addMouseDClick(io.qt.core.Qt.MouseButton button) {
        addMouseDClick(button, new io.qt.core.Qt.KeyboardModifiers(0), new io.qt.core.QPoint(), (int)-1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtesteventlist.html#addMouseDClick">QTestEventList::addMouseDClick(Qt::MouseButton,Qt::KeyboardModifiers,QPoint,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addMouseDClick(io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos, int delay){
        addMouseDClick_native_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(QtJambi_LibraryUtilities.internal.nativeId(this), button.value(), stateKey.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(pos), delay);
    }
    
    @io.qt.QtUninvokable
    private native void addMouseDClick_native_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(long __this__nativeId, int button, int stateKey, long pos, int delay);
    
    /**
     * <p>Overloaded function for {@link #addMouseMove(io.qt.core.QPoint, int)}
     *  with <code>delay = -1</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void addMouseMove(io.qt.core.QPoint pos) {
        addMouseMove(pos, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #addMouseMove(io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void addMouseMove() {
        addMouseMove(new io.qt.core.QPoint(), (int)-1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtesteventlist.html#addMouseMove">QTestEventList::addMouseMove(QPoint,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addMouseMove(io.qt.core.QPoint pos, int delay){
        addMouseMove_native_QPoint_int(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pos), delay);
    }
    
    @io.qt.QtUninvokable
    private native void addMouseMove_native_QPoint_int(long __this__nativeId, long pos, int delay);
    
    /**
     * <p>Overloaded function for {@link #addMousePress(io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}
     *  with <code>delay = -1</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void addMousePress(io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos) {
        addMousePress(button, stateKey, pos, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #addMousePress(io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void addMousePress(io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey) {
        addMousePress(button, stateKey, new io.qt.core.QPoint(), (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #addMousePress(io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>stateKey = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void addMousePress(io.qt.core.Qt.MouseButton button) {
        addMousePress(button, new io.qt.core.Qt.KeyboardModifiers(0), new io.qt.core.QPoint(), (int)-1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtesteventlist.html#addMousePress">QTestEventList::addMousePress(Qt::MouseButton,Qt::KeyboardModifiers,QPoint,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addMousePress(io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos, int delay){
        addMousePress_native_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(QtJambi_LibraryUtilities.internal.nativeId(this), button.value(), stateKey.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(pos), delay);
    }
    
    @io.qt.QtUninvokable
    private native void addMousePress_native_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(long __this__nativeId, int button, int stateKey, long pos, int delay);
    
    /**
     * <p>Overloaded function for {@link #addMouseRelease(io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}
     *  with <code>delay = -1</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void addMouseRelease(io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos) {
        addMouseRelease(button, stateKey, pos, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #addMouseRelease(io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void addMouseRelease(io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey) {
        addMouseRelease(button, stateKey, new io.qt.core.QPoint(), (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #addMouseRelease(io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>stateKey = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void addMouseRelease(io.qt.core.Qt.MouseButton button) {
        addMouseRelease(button, new io.qt.core.Qt.KeyboardModifiers(0), new io.qt.core.QPoint(), (int)-1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtesteventlist.html#addMouseRelease">QTestEventList::addMouseRelease(Qt::MouseButton,Qt::KeyboardModifiers,QPoint,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addMouseRelease(io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos, int delay){
        addMouseRelease_native_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(QtJambi_LibraryUtilities.internal.nativeId(this), button.value(), stateKey.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(pos), delay);
    }
    
    @io.qt.QtUninvokable
    private native void addMouseRelease_native_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(long __this__nativeId, int button, int stateKey, long pos, int delay);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtesteventlist.html#clear">QTestEventList::clear()</a></p>
     */
    @io.qt.QtUninvokable
    public final void purge(){
        purge_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void purge_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtesteventlist.html#simulate">QTestEventList::simulate(QWidget*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void simulate(io.qt.widgets.QWidget w){
        simulate_native_QWidget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(w));
    }
    
    @io.qt.QtUninvokable
    private native void simulate_native_QWidget_ptr(long __this__nativeId, long w);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QTestEventList(QPrivateConstructor p) { super(p); } 
    

    @io.qt.QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    @Override
    public QTestEventList clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QTestEventList clone_native(long __this_nativeId);
}
