#include <QtCore/QtGlobal>
#include <QtTest/qtestevent.h>
#include <QtCore/QVariant>
#include <QtCore/qnamespace.h>
#include <QtCore/qpoint.h>
#include <QtTest/qtestkeyboard.h>
#include <QtWidgets/qwidget.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

// emitting (writeClassCodeInjections)
namespace QtJambiPrivate{
    template<>
    struct supports_stream_operators<QTestEventList> : std::false_type{};
}

void deleter_QTestEventList(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QTestEventList")
    QTestEventList *_ptr = reinterpret_cast<QTestEventList *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QTestEventList()
void __qt_construct_QTestEventList_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QTestEventList()")
    Q_UNUSED(__java_arguments)
    QTestEventList *__qt_this = new(__qtjambi_ptr) QTestEventList();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QTestEventList(QTestEventList)
void __qt_construct_QTestEventList_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QTestEventList(QTestEventList)")
    jobject other0 = __java_arguments[0].l;
    const QTestEventList& __qt_other0 = qtjambi_cast<const QTestEventList& >(__jni_env, other0);
    QTestEventList *__qt_this = new(__qtjambi_ptr) QTestEventList(__qt_other0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// destruct QTestEventList
void __qt_destruct_QTestEventList(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QTestEventList")
    reinterpret_cast<QTestEventList*>(ptr)->~QTestEventList();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QTestEventList::QTestEventList()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_test_QTestEventList_initialize_1native__Lio_qt_test_QTestEventList_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QTestEventList::QTestEventList()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QTestEventList_0, sizeof(QTestEventList), typeid(QTestEventList), false, QtJambiPrivate::QListAccess<QTestEvent*>::newInstance(), &deleter_QTestEventList, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QTestEventList::QTestEventList(QTestEventList)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_test_QTestEventList_initialize_1native__Lio_qt_test_QTestEventList_2Lio_qt_test_QTestEventList_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QTestEventList::QTestEventList(QTestEventList)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QTestEventList_1, sizeof(QTestEventList), typeid(QTestEventList), false, QtJambiPrivate::QListAccess<QTestEvent*>::newInstance(), &deleter_QTestEventList, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QTestEventList::addDelay(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_test_QTestEventList_addDelay_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint msecs0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QTestEventList *__qt_this = QtJambiAPI::objectFromNativeId<QTestEventList>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QTestEventList::addDelay(int)", __qt_this)
        __qt_this->addDelay(static_cast<int>(msecs0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QTestEventList::addKeyClick(Qt::Key,Qt::KeyboardModifiers,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_test_QTestEventList_addKeyClick_1native_1Qt_1Key_1Qt_1KeyboardModifiers_1int__JIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint qtKey0,
 jint modifiers1,
 jint msecs2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QTestEventList *__qt_this = QtJambiAPI::objectFromNativeId<QTestEventList>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QTestEventList::addKeyClick(Qt::Key,Qt::KeyboardModifiers,int)", __qt_this)
        Qt::Key __qt_qtKey0 = qtjambi_cast<Qt::Key>(__jni_env, qtKey0);
        Qt::KeyboardModifiers __qt_modifiers1 = qtjambi_cast<Qt::KeyboardModifiers>(__jni_env, modifiers1);
        __qt_this->addKeyClick(Qt::Key(__qt_qtKey0), Qt::KeyboardModifiers(__qt_modifiers1), static_cast<int>(msecs2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QTestEventList::addKeyClick(char,Qt::KeyboardModifiers,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_test_QTestEventList_addKeyClick_1native_1char_1Qt_1KeyboardModifiers_1int__JBII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte ascii0,
 jint modifiers1,
 jint msecs2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QTestEventList *__qt_this = QtJambiAPI::objectFromNativeId<QTestEventList>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QTestEventList::addKeyClick(char,Qt::KeyboardModifiers,int)", __qt_this)
        Qt::KeyboardModifiers __qt_modifiers1 = qtjambi_cast<Qt::KeyboardModifiers>(__jni_env, modifiers1);
        __qt_this->addKeyClick(static_cast<char>(ascii0), Qt::KeyboardModifiers(__qt_modifiers1), static_cast<int>(msecs2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QTestEventList::addKeyClicks(QString,Qt::KeyboardModifiers,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_test_QTestEventList_addKeyClicks_1native_1cref_1QString_1Qt_1KeyboardModifiers_1int__JLjava_lang_String_2II)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring keys0,
 jint modifiers1,
 jint msecs2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QTestEventList *__qt_this = QtJambiAPI::objectFromNativeId<QTestEventList>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QTestEventList::addKeyClicks(QString,Qt::KeyboardModifiers,int)", __qt_this)
        QString  __qt_keys0 = qtjambi_cast<QString>(__jni_env, keys0);
        Qt::KeyboardModifiers __qt_modifiers1 = qtjambi_cast<Qt::KeyboardModifiers>(__jni_env, modifiers1);
        __qt_this->addKeyClicks(__qt_keys0, Qt::KeyboardModifiers(__qt_modifiers1), static_cast<int>(msecs2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QTestEventList::addKeyEvent(QTest::KeyAction,Qt::Key,Qt::KeyboardModifiers,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_test_QTestEventList_addKeyEvent_1native_1QTest_1KeyAction_1Qt_1Key_1Qt_1KeyboardModifiers_1int__JIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint action0,
 jint qtKey1,
 jint modifiers2,
 jint msecs3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QTestEventList *__qt_this = QtJambiAPI::objectFromNativeId<QTestEventList>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QTestEventList::addKeyEvent(QTest::KeyAction,Qt::Key,Qt::KeyboardModifiers,int)", __qt_this)
        QTest::KeyAction __qt_action0 = qtjambi_cast<QTest::KeyAction>(__jni_env, action0);
        Qt::Key __qt_qtKey1 = qtjambi_cast<Qt::Key>(__jni_env, qtKey1);
        Qt::KeyboardModifiers __qt_modifiers2 = qtjambi_cast<Qt::KeyboardModifiers>(__jni_env, modifiers2);
        __qt_this->addKeyEvent(QTest::KeyAction(__qt_action0), Qt::Key(__qt_qtKey1), Qt::KeyboardModifiers(__qt_modifiers2), static_cast<int>(msecs3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QTestEventList::addKeyEvent(QTest::KeyAction,char,Qt::KeyboardModifiers,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_test_QTestEventList_addKeyEvent_1native_1QTest_1KeyAction_1char_1Qt_1KeyboardModifiers_1int__JIBII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint action0,
 jbyte ascii1,
 jint modifiers2,
 jint msecs3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QTestEventList *__qt_this = QtJambiAPI::objectFromNativeId<QTestEventList>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QTestEventList::addKeyEvent(QTest::KeyAction,char,Qt::KeyboardModifiers,int)", __qt_this)
        QTest::KeyAction __qt_action0 = qtjambi_cast<QTest::KeyAction>(__jni_env, action0);
        Qt::KeyboardModifiers __qt_modifiers2 = qtjambi_cast<Qt::KeyboardModifiers>(__jni_env, modifiers2);
        __qt_this->addKeyEvent(QTest::KeyAction(__qt_action0), static_cast<char>(ascii1), Qt::KeyboardModifiers(__qt_modifiers2), static_cast<int>(msecs3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QTestEventList::addKeyPress(Qt::Key,Qt::KeyboardModifiers,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_test_QTestEventList_addKeyPress_1native_1Qt_1Key_1Qt_1KeyboardModifiers_1int__JIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint qtKey0,
 jint modifiers1,
 jint msecs2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QTestEventList *__qt_this = QtJambiAPI::objectFromNativeId<QTestEventList>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QTestEventList::addKeyPress(Qt::Key,Qt::KeyboardModifiers,int)", __qt_this)
        Qt::Key __qt_qtKey0 = qtjambi_cast<Qt::Key>(__jni_env, qtKey0);
        Qt::KeyboardModifiers __qt_modifiers1 = qtjambi_cast<Qt::KeyboardModifiers>(__jni_env, modifiers1);
        __qt_this->addKeyPress(Qt::Key(__qt_qtKey0), Qt::KeyboardModifiers(__qt_modifiers1), static_cast<int>(msecs2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QTestEventList::addKeyPress(char,Qt::KeyboardModifiers,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_test_QTestEventList_addKeyPress_1native_1char_1Qt_1KeyboardModifiers_1int__JBII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte ascii0,
 jint modifiers1,
 jint msecs2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QTestEventList *__qt_this = QtJambiAPI::objectFromNativeId<QTestEventList>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QTestEventList::addKeyPress(char,Qt::KeyboardModifiers,int)", __qt_this)
        Qt::KeyboardModifiers __qt_modifiers1 = qtjambi_cast<Qt::KeyboardModifiers>(__jni_env, modifiers1);
        __qt_this->addKeyPress(static_cast<char>(ascii0), Qt::KeyboardModifiers(__qt_modifiers1), static_cast<int>(msecs2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QTestEventList::addKeyRelease(Qt::Key,Qt::KeyboardModifiers,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_test_QTestEventList_addKeyRelease_1native_1Qt_1Key_1Qt_1KeyboardModifiers_1int__JIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint qtKey0,
 jint modifiers1,
 jint msecs2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QTestEventList *__qt_this = QtJambiAPI::objectFromNativeId<QTestEventList>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QTestEventList::addKeyRelease(Qt::Key,Qt::KeyboardModifiers,int)", __qt_this)
        Qt::Key __qt_qtKey0 = qtjambi_cast<Qt::Key>(__jni_env, qtKey0);
        Qt::KeyboardModifiers __qt_modifiers1 = qtjambi_cast<Qt::KeyboardModifiers>(__jni_env, modifiers1);
        __qt_this->addKeyRelease(Qt::Key(__qt_qtKey0), Qt::KeyboardModifiers(__qt_modifiers1), static_cast<int>(msecs2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QTestEventList::addKeyRelease(char,Qt::KeyboardModifiers,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_test_QTestEventList_addKeyRelease_1native_1char_1Qt_1KeyboardModifiers_1int__JBII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte ascii0,
 jint modifiers1,
 jint msecs2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QTestEventList *__qt_this = QtJambiAPI::objectFromNativeId<QTestEventList>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QTestEventList::addKeyRelease(char,Qt::KeyboardModifiers,int)", __qt_this)
        Qt::KeyboardModifiers __qt_modifiers1 = qtjambi_cast<Qt::KeyboardModifiers>(__jni_env, modifiers1);
        __qt_this->addKeyRelease(static_cast<char>(ascii0), Qt::KeyboardModifiers(__qt_modifiers1), static_cast<int>(msecs2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QTestEventList::addMouseClick(Qt::MouseButton,Qt::KeyboardModifiers,QPoint,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_test_QTestEventList_addMouseClick_1native_1Qt_1MouseButton_1Qt_1KeyboardModifiers_1QPoint_1int__JIIJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint button0,
 jint stateKey1,
 QtJambiNativeID pos2,
 jint delay3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QTestEventList *__qt_this = QtJambiAPI::objectFromNativeId<QTestEventList>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QTestEventList::addMouseClick(Qt::MouseButton,Qt::KeyboardModifiers,QPoint,int)", __qt_this)
        Qt::MouseButton __qt_button0 = qtjambi_cast<Qt::MouseButton>(__jni_env, button0);
        Qt::KeyboardModifiers __qt_stateKey1 = qtjambi_cast<Qt::KeyboardModifiers>(__jni_env, stateKey1);
        QPoint __qt_pos2 = QtJambiAPI::valueReferenceFromNativeId<QPoint>(pos2);
        __qt_this->addMouseClick(Qt::MouseButton(__qt_button0), Qt::KeyboardModifiers(__qt_stateKey1), __qt_pos2, static_cast<int>(delay3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QTestEventList::addMouseDClick(Qt::MouseButton,Qt::KeyboardModifiers,QPoint,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_test_QTestEventList_addMouseDClick_1native_1Qt_1MouseButton_1Qt_1KeyboardModifiers_1QPoint_1int__JIIJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint button0,
 jint stateKey1,
 QtJambiNativeID pos2,
 jint delay3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QTestEventList *__qt_this = QtJambiAPI::objectFromNativeId<QTestEventList>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QTestEventList::addMouseDClick(Qt::MouseButton,Qt::KeyboardModifiers,QPoint,int)", __qt_this)
        Qt::MouseButton __qt_button0 = qtjambi_cast<Qt::MouseButton>(__jni_env, button0);
        Qt::KeyboardModifiers __qt_stateKey1 = qtjambi_cast<Qt::KeyboardModifiers>(__jni_env, stateKey1);
        QPoint __qt_pos2 = QtJambiAPI::valueReferenceFromNativeId<QPoint>(pos2);
        __qt_this->addMouseDClick(Qt::MouseButton(__qt_button0), Qt::KeyboardModifiers(__qt_stateKey1), __qt_pos2, static_cast<int>(delay3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QTestEventList::addMouseMove(QPoint,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_test_QTestEventList_addMouseMove_1native_1QPoint_1int__JJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID pos0,
 jint delay1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QTestEventList *__qt_this = QtJambiAPI::objectFromNativeId<QTestEventList>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QTestEventList::addMouseMove(QPoint,int)", __qt_this)
        QPoint __qt_pos0 = QtJambiAPI::valueReferenceFromNativeId<QPoint>(pos0);
        __qt_this->addMouseMove(__qt_pos0, static_cast<int>(delay1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QTestEventList::addMousePress(Qt::MouseButton,Qt::KeyboardModifiers,QPoint,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_test_QTestEventList_addMousePress_1native_1Qt_1MouseButton_1Qt_1KeyboardModifiers_1QPoint_1int__JIIJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint button0,
 jint stateKey1,
 QtJambiNativeID pos2,
 jint delay3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QTestEventList *__qt_this = QtJambiAPI::objectFromNativeId<QTestEventList>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QTestEventList::addMousePress(Qt::MouseButton,Qt::KeyboardModifiers,QPoint,int)", __qt_this)
        Qt::MouseButton __qt_button0 = qtjambi_cast<Qt::MouseButton>(__jni_env, button0);
        Qt::KeyboardModifiers __qt_stateKey1 = qtjambi_cast<Qt::KeyboardModifiers>(__jni_env, stateKey1);
        QPoint __qt_pos2 = QtJambiAPI::valueReferenceFromNativeId<QPoint>(pos2);
        __qt_this->addMousePress(Qt::MouseButton(__qt_button0), Qt::KeyboardModifiers(__qt_stateKey1), __qt_pos2, static_cast<int>(delay3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QTestEventList::addMouseRelease(Qt::MouseButton,Qt::KeyboardModifiers,QPoint,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_test_QTestEventList_addMouseRelease_1native_1Qt_1MouseButton_1Qt_1KeyboardModifiers_1QPoint_1int__JIIJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint button0,
 jint stateKey1,
 QtJambiNativeID pos2,
 jint delay3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QTestEventList *__qt_this = QtJambiAPI::objectFromNativeId<QTestEventList>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QTestEventList::addMouseRelease(Qt::MouseButton,Qt::KeyboardModifiers,QPoint,int)", __qt_this)
        Qt::MouseButton __qt_button0 = qtjambi_cast<Qt::MouseButton>(__jni_env, button0);
        Qt::KeyboardModifiers __qt_stateKey1 = qtjambi_cast<Qt::KeyboardModifiers>(__jni_env, stateKey1);
        QPoint __qt_pos2 = QtJambiAPI::valueReferenceFromNativeId<QPoint>(pos2);
        __qt_this->addMouseRelease(Qt::MouseButton(__qt_button0), Qt::KeyboardModifiers(__qt_stateKey1), __qt_pos2, static_cast<int>(delay3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QTestEventList::clear()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_test_QTestEventList_purge_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QTestEventList *__qt_this = QtJambiAPI::objectFromNativeId<QTestEventList>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QTestEventList::clear()", __qt_this)
        __qt_this->clear();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QTestEventList::simulate(QWidget*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_test_QTestEventList_simulate_1native_1QWidget_1ptr__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID w0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QTestEventList *__qt_this = QtJambiAPI::objectFromNativeId<QTestEventList>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QTestEventList::simulate(QWidget*)", __qt_this)
        QWidget* __qt_w0 = QtJambiAPI::objectFromNativeId<QWidget>(w0);
        __qt_this->simulate(__qt_w0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_test_QTestEventList_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QTestEventList *__qt_this = QtJambiAPI::objectFromNativeId<QTestEventList>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_test_QTestEventList_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QTestEventList *__qt_this = QtJambiAPI::objectFromNativeId<QTestEventList>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QTestEventList(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QTestEventList>("QTestEventList", "io/qt/test/QTestEventList");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QTestEventList, {
        ConstructorInfo(&__qt_construct_QTestEventList_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QTestEventList_1, "Lio/qt/test/QTestEventList;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QTestEventList);
    registerMetaType<QTestEventList>("QTestEventList");
    registerContainerAccessFactory(typeId, NewContainerAccessFunction(&QtJambiPrivate::QListAccess<QTestEvent*>::newInstance));
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
