package io.qt.svg;

import io.qt.*;


/**
 * <p>Contains types used by the svg classes</p>
 * <p>Java wrapper for Qt header file <code><a href="https://doc.qt.io/qt/qtsvg.html">QtSvg</a></code></p>
 */
public final class QtSvg
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private QtSvg() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace QtSvg."); }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qtsvg.html#Option-enum">QtSvg::Option</a></code></p>
     * <p>This enum was introduced in Qt 6.7.</p>
     * 
     * @see Options
     */
    public enum Option implements QtFlagEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qtsvg.html#Option-enum">QtSvg::<wbr/>NoOption</a></code></p>
         */
        NoOption(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qtsvg.html#Option-enum">QtSvg::<wbr/>Tiny12FeaturesOnly</a></code></p>
         */
        Tiny12FeaturesOnly(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Option(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        @Override
        public @NonNull Options asFlags() {
            return new Options(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull Options combined(@NonNull Option e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull Options cleared(@NonNull Option e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link Options} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull Options flags(@Nullable Option @NonNull... values) {
            return new Options(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Option resolve(int value) {
            switch (value) {
            case 0: return NoOption;
            case 1: return Tiny12FeaturesOnly;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link Option}
     */
    public static final class Options extends QFlags<Option> implements Comparable<Options> {
        private static final long serialVersionUID = 0x4a6bb5914e7eca36L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new Options where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public Options(@Nullable Option @NonNull... args){
            super(args);
        }

        /**
         * Creates a new Options with given <code>value</code>.
         * @param value
         */
        public Options(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new Options
         */
        @Override
        public final @NonNull Options combined(@StrictNonNull Option e){
            return new Options(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        @Override
        public final @NonNull Options setFlag(@Nullable Option e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        @Override
        public final @NonNull Options setFlag(@Nullable Option e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this Options.
         * @return array of enum entries
         */
        @Override
        public final @NonNull Option @NonNull[] flags(){
            return super.flags(Option.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull Options clone(){
            return new Options(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull Options other){
            return Integer.compare(value(), other.value());
        }
    }
    
    
}
