package io.qt.svg;


/**
 * <p>Used to draw the contents of SVG files onto paint devices</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qsvgrenderer.html">QSvgRenderer</a></p>
 */
public class QSvgRenderer extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSvgRenderer.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#repaintNeeded">QSvgRenderer::repaintNeeded()</a></p>
     */
    public final Signal0 repaintNeeded = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #QSvgRenderer(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QSvgRenderer() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#QSvgRenderer">QSvgRenderer::QSvgRenderer(QObject*)</a></p>
     */
    public QSvgRenderer(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QSvgRenderer instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QSvgRenderer(io.qt.core.QXmlStreamReader, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QSvgRenderer(io.qt.core.QXmlStreamReader contents) {
        this(contents, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#QSvgRenderer-3">QSvgRenderer::QSvgRenderer(QXmlStreamReader*,QObject*)</a></p>
     */
    public QSvgRenderer(io.qt.core.QXmlStreamReader contents, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, contents, parent);
    }
    
    private native static void initialize_native(QSvgRenderer instance, io.qt.core.QXmlStreamReader contents, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QSvgRenderer(io.qt.core.QByteArray, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QSvgRenderer(io.qt.core.QByteArray contents) {
        this(contents, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#QSvgRenderer-2">QSvgRenderer::QSvgRenderer(QByteArray,QObject*)</a></p>
     */
    public QSvgRenderer(io.qt.core.QByteArray contents, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, contents, parent);
    }
    
    private native static void initialize_native(QSvgRenderer instance, io.qt.core.QByteArray contents, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QSvgRenderer(java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QSvgRenderer(java.lang.String filename) {
        this(filename, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#QSvgRenderer-1">QSvgRenderer::QSvgRenderer(QString,QObject*)</a></p>
     */
    public QSvgRenderer(java.lang.String filename, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, filename, parent);
    }
    
    private native static void initialize_native(QSvgRenderer instance, java.lang.String filename, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#animated">QSvgRenderer::animated()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean animated(){
        return animated_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean animated_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final int animationDuration(){
        return animationDuration_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int animationDuration_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#aspectRatioMode-prop">QSvgRenderer::aspectRatioMode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="aspectRatioMode")
    @io.qt.QtUninvokable
    public final io.qt.core.Qt.AspectRatioMode aspectRatioMode(){
        return io.qt.core.Qt.AspectRatioMode.resolve(aspectRatioMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int aspectRatioMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#boundsOnElement">QSvgRenderer::boundsOnElement(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QRectF boundsOnElement(java.lang.String id){
        return boundsOnElement_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF boundsOnElement_native_cref_QString_constfct(long __this__nativeId, java.lang.String id);
    
    @io.qt.QtPropertyReader(name="currentFrame")
    @io.qt.QtUninvokable
    public final int currentFrame(){
        return currentFrame_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int currentFrame_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#defaultSize">QSvgRenderer::defaultSize()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QSize defaultSize(){
        return defaultSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QSize defaultSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#elementExists">QSvgRenderer::elementExists(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean elementExists(java.lang.String id){
        return elementExists_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @io.qt.QtUninvokable
    private native boolean elementExists_native_cref_QString_constfct(long __this__nativeId, java.lang.String id);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#framesPerSecond-prop">QSvgRenderer::framesPerSecond()const</a></p>
     */
    @io.qt.QtPropertyReader(name="framesPerSecond")
    @io.qt.QtUninvokable
    public final int framesPerSecond(){
        return framesPerSecond_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int framesPerSecond_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#isValid">QSvgRenderer::isValid()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#load-2">QSvgRenderer::load(QXmlStreamReader*)</a></p>
     */
    public final boolean load(io.qt.core.QXmlStreamReader contents){
        return load_native_QXmlStreamReader_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(contents));
    }
    
    private native boolean load_native_QXmlStreamReader_ptr(long __this__nativeId, long contents);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#load-1">QSvgRenderer::load(QByteArray)</a></p>
     */
    public final boolean load(io.qt.core.QByteArray contents){
        return load_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(contents));
    }
    
    private native boolean load_native_cref_QByteArray(long __this__nativeId, long contents);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#load">QSvgRenderer::load(QString)</a></p>
     */
    public final boolean load(java.lang.String filename){
        return load_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), filename);
    }
    
    private native boolean load_native_cref_QString(long __this__nativeId, java.lang.String filename);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#render">QSvgRenderer::render(QPainter*)</a></p>
     */
    public final void render(io.qt.gui.QPainter p){
        render_native_QPainter_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(p));
    }
    
    private native void render_native_QPainter_ptr(long __this__nativeId, long p);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#render-1">QSvgRenderer::render(QPainter*,QRectF)</a></p>
     */
    public final void render(io.qt.gui.QPainter p, io.qt.core.QRectF bounds){
        render_native_QPainter_ptr_cref_QRectF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(p), QtJambi_LibraryUtilities.internal.checkedNativeId(bounds));
    }
    
    private native void render_native_QPainter_ptr_cref_QRectF(long __this__nativeId, long p, long bounds);
    
    /**
     * <p>Overloaded function for {@link #render(io.qt.gui.QPainter, java.lang.String, io.qt.core.QRectF)}
     *  with <code>bounds = new io.qt.core.QRectF()</code>.</p>
     */
    public final void render(io.qt.gui.QPainter p, java.lang.String elementId) {
        render(p, elementId, new io.qt.core.QRectF());
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#render-2">QSvgRenderer::render(QPainter*,QString,QRectF)</a></p>
     */
    public final void render(io.qt.gui.QPainter p, java.lang.String elementId, io.qt.core.QRectF bounds){
        render_native_QPainter_ptr_cref_QString_cref_QRectF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(p), elementId, QtJambi_LibraryUtilities.internal.checkedNativeId(bounds));
    }
    
    private native void render_native_QPainter_ptr_cref_QString_cref_QRectF(long __this__nativeId, long p, java.lang.String elementId, long bounds);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#aspectRatioMode-prop">QSvgRenderer::setAspectRatioMode(Qt::AspectRatioMode)</a></p>
     */
    @io.qt.QtPropertyWriter(name="aspectRatioMode")
    @io.qt.QtUninvokable
    public final void setAspectRatioMode(io.qt.core.Qt.AspectRatioMode mode){
        setAspectRatioMode_native_Qt_AspectRatioMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    @io.qt.QtUninvokable
    private native void setAspectRatioMode_native_Qt_AspectRatioMode(long __this__nativeId, int mode);
    
    @io.qt.QtPropertyWriter(name="currentFrame")
    @io.qt.QtUninvokable
    public final void setCurrentFrame(int arg__1){
        setCurrentFrame_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setCurrentFrame_native_int(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#framesPerSecond-prop">QSvgRenderer::setFramesPerSecond(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="framesPerSecond")
    @io.qt.QtUninvokable
    public final void setFramesPerSecond(int num){
        setFramesPerSecond_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), num);
    }
    
    @io.qt.QtUninvokable
    private native void setFramesPerSecond_native_int(long __this__nativeId, int num);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#viewBox-prop">QSvgRenderer::setViewBox(QRect)</a></p>
     */
    @io.qt.QtPropertyWriter(name="viewBox")
    @io.qt.QtUninvokable
    public final void setViewBox(io.qt.core.QRect viewbox){
        setViewBox_native_cref_QRect(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(viewbox));
    }
    
    @io.qt.QtUninvokable
    private native void setViewBox_native_cref_QRect(long __this__nativeId, long viewbox);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#viewBox-prop">QSvgRenderer::setViewBox(QRectF)</a></p>
     */
    @io.qt.QtPropertyWriter(name="viewBox")
    @io.qt.QtUninvokable
    public final void setViewBox(io.qt.core.QRectF viewbox){
        setViewBox_native_cref_QRectF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(viewbox));
    }
    
    @io.qt.QtUninvokable
    private native void setViewBox_native_cref_QRectF(long __this__nativeId, long viewbox);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#transformForElement">QSvgRenderer::transformForElement(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QTransform transformForElement(java.lang.String id){
        return transformForElement_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QTransform transformForElement_native_cref_QString_constfct(long __this__nativeId, java.lang.String id);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#viewBox">QSvgRenderer::viewBox()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QRect viewBox(){
        return viewBox_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRect viewBox_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#viewBox-prop">QSvgRenderer::viewBoxF()const</a></p>
     */
    @io.qt.QtPropertyReader(name="viewBox")
    @io.qt.QtUninvokable
    public final io.qt.core.QRectF viewBoxF(){
        return viewBoxF_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF viewBoxF_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSvgRenderer(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QSvgRenderer(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QSvgRenderer instance, QDeclarativeConstructor constructor);
    
}
