package io.qt.svg;

import io.qt.*;


/**
 * <p>Used to draw the contents of SVG files onto paint devices</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsvgrenderer.html">QSvgRenderer</a></p>
 */
public class QSvgRenderer extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSvgRenderer.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#repaintNeeded">QSvgRenderer::repaintNeeded()</a></p>
     */
    public final @NonNull Signal0 repaintNeeded = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QSvgRenderer() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#QSvgRenderer">QSvgRenderer::QSvgRenderer(QObject*)</a></p>
     */
    public QSvgRenderer(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QSvgRenderer instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QXmlStreamReader, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QSvgRenderer(io.qt.core.@Nullable QXmlStreamReader contents) {
        this(contents, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#QSvgRenderer-3">QSvgRenderer::QSvgRenderer(QXmlStreamReader*,QObject*)</a></p>
     */
    public QSvgRenderer(io.qt.core.@Nullable QXmlStreamReader contents, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, contents, parent);
    }
    
    private native static void initialize_native(QSvgRenderer instance, io.qt.core.QXmlStreamReader contents, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QByteArray, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QSvgRenderer(io.qt.core.@NonNull QByteArray contents) {
        this(contents, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#QSvgRenderer-2">QSvgRenderer::QSvgRenderer(QByteArray,QObject*)</a></p>
     */
    public QSvgRenderer(io.qt.core.@NonNull QByteArray contents, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, contents, parent);
    }
    
    private native static void initialize_native(QSvgRenderer instance, io.qt.core.QByteArray contents, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #(java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QSvgRenderer(java.lang.@NonNull String filename) {
        this(filename, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#QSvgRenderer-1">QSvgRenderer::QSvgRenderer(QString,QObject*)</a></p>
     */
    public QSvgRenderer(java.lang.@NonNull String filename, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, filename, parent);
    }
    
    private native static void initialize_native(QSvgRenderer instance, java.lang.String filename, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#animated">QSvgRenderer::animated()const</a></p>
     */
    @QtUninvokable
    public final boolean animated(){
        return animated_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean animated_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final int animationDuration(){
        return animationDuration_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int animationDuration_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #aspectRatioMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.Qt.@NonNull AspectRatioMode getAspectRatioMode() {
        return aspectRatioMode();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#aspectRatioMode-prop">QSvgRenderer::aspectRatioMode()const</a></p>
     */
    @QtPropertyReader(name="aspectRatioMode")
    @QtUninvokable
    public final io.qt.core.Qt.@NonNull AspectRatioMode aspectRatioMode(){
        return io.qt.core.Qt.AspectRatioMode.resolve(aspectRatioMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int aspectRatioMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#boundsOnElement">QSvgRenderer::boundsOnElement(QString)const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QRectF boundsOnElement(java.lang.@NonNull String id){
        return boundsOnElement_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @QtUninvokable
    private native io.qt.core.QRectF boundsOnElement_native_cref_QString_constfct(long __this__nativeId, java.lang.String id);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #currentFrame()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getCurrentFrame() {
        return currentFrame();
    }
    
    @QtPropertyReader(name="currentFrame")
    @QtUninvokable
    public final int currentFrame(){
        return currentFrame_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int currentFrame_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#defaultSize">QSvgRenderer::defaultSize()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QSize defaultSize(){
        return defaultSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QSize defaultSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#elementExists">QSvgRenderer::elementExists(QString)const</a></p>
     */
    @QtUninvokable
    public final boolean elementExists(java.lang.@NonNull String id){
        return elementExists_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @QtUninvokable
    private native boolean elementExists_native_cref_QString_constfct(long __this__nativeId, java.lang.String id);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #framesPerSecond()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getFramesPerSecond() {
        return framesPerSecond();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#framesPerSecond-prop">QSvgRenderer::framesPerSecond()const</a></p>
     */
    @QtPropertyReader(name="framesPerSecond")
    @QtUninvokable
    public final int framesPerSecond(){
        return framesPerSecond_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int framesPerSecond_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#isValid">QSvgRenderer::isValid()const</a></p>
     */
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#load-2">QSvgRenderer::load(QXmlStreamReader*)</a></p>
     */
    public final boolean load(io.qt.core.@Nullable QXmlStreamReader contents){
        return load_native_QXmlStreamReader_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(contents));
    }
    
    private native boolean load_native_QXmlStreamReader_ptr(long __this__nativeId, long contents);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#load-1">QSvgRenderer::load(QByteArray)</a></p>
     */
    public final boolean load(io.qt.core.@NonNull QByteArray contents){
        return load_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(contents));
    }
    
    private native boolean load_native_cref_QByteArray(long __this__nativeId, long contents);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#load">QSvgRenderer::load(QString)</a></p>
     */
    public final boolean load(java.lang.@NonNull String filename){
        return load_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), filename);
    }
    
    private native boolean load_native_cref_QString(long __this__nativeId, java.lang.String filename);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#render">QSvgRenderer::render(QPainter*)</a></p>
     */
    public final void render(io.qt.gui.@Nullable QPainter p){
        render_native_QPainter_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(p));
    }
    
    private native void render_native_QPainter_ptr(long __this__nativeId, long p);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#render-1">QSvgRenderer::render(QPainter*,QRectF)</a></p>
     */
    public final void render(io.qt.gui.@Nullable QPainter p, io.qt.core.@NonNull QRectF bounds){
        render_native_QPainter_ptr_cref_QRectF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(p), QtJambi_LibraryUtilities.internal.checkedNativeId(bounds));
    }
    
    private native void render_native_QPainter_ptr_cref_QRectF(long __this__nativeId, long p, long bounds);
    
    /**
     * <p>Overloaded function for {@link #render(io.qt.gui.QPainter, java.lang.String, io.qt.core.QRectF)}
     *  with <code>bounds = new io.qt.core.QRectF()</code>.</p>
     */
    public final void render(io.qt.gui.@Nullable QPainter p, java.lang.@NonNull String elementId) {
        render(p, elementId, new io.qt.core.QRectF());
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#render-2">QSvgRenderer::render(QPainter*,QString,QRectF)</a></p>
     */
    public final void render(io.qt.gui.@Nullable QPainter p, java.lang.@NonNull String elementId, io.qt.core.@NonNull QRectF bounds){
        render_native_QPainter_ptr_cref_QString_cref_QRectF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(p), elementId, QtJambi_LibraryUtilities.internal.checkedNativeId(bounds));
    }
    
    private native void render_native_QPainter_ptr_cref_QString_cref_QRectF(long __this__nativeId, long p, java.lang.String elementId, long bounds);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#aspectRatioMode-prop">QSvgRenderer::setAspectRatioMode(Qt::AspectRatioMode)</a></p>
     */
    @QtPropertyWriter(name="aspectRatioMode")
    @QtUninvokable
    public final void setAspectRatioMode(io.qt.core.Qt.@NonNull AspectRatioMode mode){
        setAspectRatioMode_native_Qt_AspectRatioMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    @QtUninvokable
    private native void setAspectRatioMode_native_Qt_AspectRatioMode(long __this__nativeId, int mode);
    
    @QtPropertyWriter(name="currentFrame")
    @QtUninvokable
    public final void setCurrentFrame(int arg__1){
        setCurrentFrame_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native void setCurrentFrame_native_int(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#framesPerSecond-prop">QSvgRenderer::setFramesPerSecond(int)</a></p>
     */
    @QtPropertyWriter(name="framesPerSecond")
    @QtUninvokable
    public final void setFramesPerSecond(int num){
        setFramesPerSecond_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), num);
    }
    
    @QtUninvokable
    private native void setFramesPerSecond_native_int(long __this__nativeId, int num);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#viewBox-prop">QSvgRenderer::setViewBox(QRect)</a></p>
     */
    @QtPropertyWriter(name="viewBox")
    @QtUninvokable
    public final void setViewBox(io.qt.core.@NonNull QRect viewbox){
        setViewBox_native_cref_QRect(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(viewbox));
    }
    
    @QtUninvokable
    private native void setViewBox_native_cref_QRect(long __this__nativeId, long viewbox);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#viewBox-prop">QSvgRenderer::setViewBox(QRectF)</a></p>
     */
    @QtPropertyWriter(name="viewBox")
    @QtUninvokable
    public final void setViewBox(io.qt.core.@NonNull QRectF viewbox){
        setViewBox_native_cref_QRectF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(viewbox));
    }
    
    @QtUninvokable
    private native void setViewBox_native_cref_QRectF(long __this__nativeId, long viewbox);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#transformForElement">QSvgRenderer::transformForElement(QString)const</a></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QTransform transformForElement(java.lang.@NonNull String id){
        return transformForElement_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @QtUninvokable
    private native io.qt.gui.QTransform transformForElement_native_cref_QString_constfct(long __this__nativeId, java.lang.String id);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#viewBox">QSvgRenderer::viewBox()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QRect viewBox(){
        return viewBox_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRect viewBox_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #viewBoxF()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRectF getViewBox() {
        return viewBoxF();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsvgrenderer.html#viewBox-prop">QSvgRenderer::viewBoxF()const</a></p>
     */
    @QtPropertyReader(name="viewBox")
    @QtUninvokable
    public final io.qt.core.@NonNull QRectF viewBoxF(){
        return viewBoxF_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRectF viewBoxF_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QSvgRenderer(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QSvgRenderer(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QSvgRenderer instance, QDeclarativeConstructor constructor);
    
}
