package io.qt.svg;

import io.qt.*;


/**
 * <p>Widget that is used to display the contents of Scalable Vector Graphics (SVG) files</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qsvgwidget.html">QSvgWidget</a></code></p>
 */
public class QSvgWidget extends io.qt.widgets.QWidget
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSvgWidget.class);
    
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsvgwidget.html#QSvgWidget">QSvgWidget::<wbr>QSvgWidget(QWidget*)</a></code></p>
     */
    public QSvgWidget(io.qt.widgets.@Nullable QWidget parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QSvgWidget instance, io.qt.widgets.QWidget parent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsvgwidget.html#QSvgWidget-1">QSvgWidget::<wbr>QSvgWidget(QString,<wbr>QWidget*)</a></code></p>
     */
    public QSvgWidget(java.lang.@NonNull String file, io.qt.widgets.@Nullable QWidget parent){
        super((QPrivateConstructor)null);
        initialize_native(this, file, parent);
    }
    
    private native static void initialize_native(QSvgWidget instance, java.lang.String file, io.qt.widgets.QWidget parent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsvgwidget.html#load-1">QSvgWidget::<wbr>load(QByteArray)</a></code></p>
     */
    public final void load(io.qt.core.@NonNull QByteArray contents){
        load_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(contents));
    }
    
    private native void load_native_cref_QByteArray(long __this__nativeId, long contents);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsvgwidget.html#load">QSvgWidget::<wbr>load(QString)</a></code></p>
     */
    public final void load(java.lang.@NonNull String file){
        load_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), file);
    }
    
    private native void load_native_cref_QString(long __this__nativeId, java.lang.String file);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsvgwidget.html#renderer">QSvgWidget::<wbr>renderer()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.svg.@Nullable QSvgRenderer renderer(){
        return renderer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.svg.QSvgRenderer renderer_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qwidget.html#paintEvent">QWidget::<wbr>paintEvent(QPaintEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void paintEvent(io.qt.gui.@Nullable QPaintEvent event){
        paintEvent_native_QPaintEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void paintEvent_native_QPaintEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qwidget.html#sizeHint-prop">QWidget::<wbr>sizeHint()const</a></code></p>
     */
    @QtUninvokable
    @Override
    public io.qt.core.@NonNull QSize sizeHint(){
        return sizeHint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QSize sizeHint_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QSvgWidget(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QSvgWidget(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QSvgWidget instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QSvgWidget(io.qt.widgets.QWidget)}
     *  with <code>parent = null</code>.</p>
     */
    public QSvgWidget() {
        this((io.qt.widgets.QWidget)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QSvgWidget(java.lang.String, io.qt.widgets.QWidget)}
     *  with <code>parent = null</code>.</p>
     */
    public QSvgWidget(java.lang.@NonNull String file) {
        this(file, (io.qt.widgets.QWidget)null);
    }
}
