package io.qt.svg;

import io.qt.*;


/**
 * <p>Paint device that is used to create SVG drawings</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qsvggenerator.html">QSvgGenerator</a></code></p>
 */
public class QSvgGenerator extends QtObject
    implements io.qt.gui.QPaintDevice
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private Object __rcOutputDevice = null;
    
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsvggenerator.html#QSvgGenerator">QSvgGenerator::<wbr>QSvgGenerator()</a></code></p>
     */
    public QSvgGenerator(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSvgGenerator instance);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qpaintdevice.html#colorCount">QPaintDevice::<wbr>colorCount()const</a></code></p>
     */
    @QtUninvokable
    public final int colorCount(){
        return colorCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int colorCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qpaintdevice.html#depth">QPaintDevice::<wbr>depth()const</a></code></p>
     */
    @QtUninvokable
    public final int depth(){
        return depth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int depth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsvggenerator.html#description-prop">QSvgGenerator::<wbr>description()const</a></code></p>
     */
    @QtPropertyReader(name="description")
    @QtUninvokable
    public final java.lang.@NonNull String description(){
        return description_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String description_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qpaintdevice.html#devicePixelRatio">QPaintDevice::<wbr>devicePixelRatio()const</a></code></p>
     */
    @QtUninvokable
    public final double devicePixelRatio(){
        return devicePixelRatio_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static double devicePixelRatio_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qpaintdevice.html#devicePixelRatioF">QPaintDevice::<wbr>devicePixelRatioF()const</a></code></p>
     */
    @QtUninvokable
    public final double devicePixelRatioF(){
        return devicePixelRatioF_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static double devicePixelRatioF_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsvggenerator.html#fileName-prop">QSvgGenerator::<wbr>fileName()const</a></code></p>
     */
    @QtPropertyReader(name="fileName")
    @QtUninvokable
    public final java.lang.@NonNull String fileName(){
        return fileName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String fileName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qpaintdevice.html#height">QPaintDevice::<wbr>height()const</a></code></p>
     */
    @QtUninvokable
    public final int height(){
        return height_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int height_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qpaintdevice.html#heightMM">QPaintDevice::<wbr>heightMM()const</a></code></p>
     */
    @QtUninvokable
    public final int heightMM(){
        return heightMM_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int heightMM_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qpaintdevice.html#logicalDpiX">QPaintDevice::<wbr>logicalDpiX()const</a></code></p>
     */
    @QtUninvokable
    public final int logicalDpiX(){
        return logicalDpiX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int logicalDpiX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qpaintdevice.html#logicalDpiY">QPaintDevice::<wbr>logicalDpiY()const</a></code></p>
     */
    @QtUninvokable
    public final int logicalDpiY(){
        return logicalDpiY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int logicalDpiY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsvggenerator.html#outputDevice-prop">QSvgGenerator::<wbr>outputDevice()const</a></code></p>
     */
    @QtPropertyReader(name="outputDevice")
    @QtUninvokable
    public final io.qt.core.@Nullable QIODevice outputDevice(){
        return outputDevice_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QIODevice outputDevice_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qpaintdevice.html#paintingActive">QPaintDevice::<wbr>paintingActive()const</a></code></p>
     */
    @QtUninvokable
    public final boolean paintingActive(){
        return paintingActive_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static boolean paintingActive_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qpaintdevice.html#physicalDpiX">QPaintDevice::<wbr>physicalDpiX()const</a></code></p>
     */
    @QtUninvokable
    public final int physicalDpiX(){
        return physicalDpiX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int physicalDpiX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qpaintdevice.html#physicalDpiY">QPaintDevice::<wbr>physicalDpiY()const</a></code></p>
     */
    @QtUninvokable
    public final int physicalDpiY(){
        return physicalDpiY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int physicalDpiY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsvggenerator.html#resolution-prop">QSvgGenerator::<wbr>resolution()const</a></code></p>
     */
    @QtPropertyReader(name="resolution")
    @QtUninvokable
    public final int resolution(){
        return resolution_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int resolution_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsvggenerator.html#description-prop">QSvgGenerator::<wbr>setDescription(QString)</a></code></p>
     */
    @QtPropertyWriter(name="description")
    @QtUninvokable
    public final void setDescription(java.lang.@NonNull String description){
        setDescription_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), description);
    }
    
    @QtUninvokable
    private native void setDescription_native_cref_QString(long __this__nativeId, java.lang.String description);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsvggenerator.html#fileName-prop">QSvgGenerator::<wbr>setFileName(QString)</a></code></p>
     */
    @QtPropertyWriter(name="fileName")
    @QtUninvokable
    public final void setFileName(java.lang.@NonNull String fileName){
        setFileName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), fileName);
    }
    
    @QtUninvokable
    private native void setFileName_native_cref_QString(long __this__nativeId, java.lang.String fileName);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsvggenerator.html#outputDevice-prop">QSvgGenerator::<wbr>setOutputDevice(QIODevice*)</a></code></p>
     */
    @QtPropertyWriter(name="outputDevice")
    @QtUninvokable
    public final void setOutputDevice(io.qt.core.@Nullable QIODevice outputDevice){
        setOutputDevice_native_QIODevice_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(outputDevice));
        __rcOutputDevice = outputDevice;
    }
    
    @QtUninvokable
    private native void setOutputDevice_native_QIODevice_ptr(long __this__nativeId, long outputDevice);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsvggenerator.html#resolution-prop">QSvgGenerator::<wbr>setResolution(int)</a></code></p>
     */
    @QtPropertyWriter(name="resolution")
    @QtUninvokable
    public final void setResolution(int dpi){
        setResolution_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), dpi);
    }
    
    @QtUninvokable
    private native void setResolution_native_int(long __this__nativeId, int dpi);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsvggenerator.html#size-prop">QSvgGenerator::<wbr>setSize(QSize)</a></code></p>
     */
    @QtPropertyWriter(name="size")
    @QtUninvokable
    public final void setSize(io.qt.core.@NonNull QSize size){
        setSize_native_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    @QtUninvokable
    private native void setSize_native_cref_QSize(long __this__nativeId, long size);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsvggenerator.html#title-prop">QSvgGenerator::<wbr>setTitle(QString)</a></code></p>
     */
    @QtPropertyWriter(name="title")
    @QtUninvokable
    public final void setTitle(java.lang.@NonNull String title){
        setTitle_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), title);
    }
    
    @QtUninvokable
    private native void setTitle_native_cref_QString(long __this__nativeId, java.lang.String title);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsvggenerator.html#viewBox-prop">QSvgGenerator::<wbr>setViewBox(QRect)</a></code></p>
     */
    @QtPropertyWriter(name="viewBox")
    @QtUninvokable
    public final void setViewBox(io.qt.core.@NonNull QRect viewBox){
        setViewBox_native_cref_QRect(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(viewBox));
    }
    
    @QtUninvokable
    private native void setViewBox_native_cref_QRect(long __this__nativeId, long viewBox);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsvggenerator.html#viewBox-prop">QSvgGenerator::<wbr>setViewBox(QRectF)</a></code></p>
     */
    @QtPropertyWriter(name="viewBox")
    @QtUninvokable
    public final void setViewBox(io.qt.core.@NonNull QRectF viewBox){
        setViewBox_native_cref_QRectF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(viewBox));
    }
    
    @QtUninvokable
    private native void setViewBox_native_cref_QRectF(long __this__nativeId, long viewBox);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsvggenerator.html#size-prop">QSvgGenerator::<wbr>size()const</a></code></p>
     */
    @QtPropertyReader(name="size")
    @QtUninvokable
    public final io.qt.core.@NonNull QSize size(){
        return size_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QSize size_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsvggenerator.html#title-prop">QSvgGenerator::<wbr>title()const</a></code></p>
     */
    @QtPropertyReader(name="title")
    @QtUninvokable
    public final java.lang.@NonNull String title(){
        return title_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String title_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsvggenerator.html#viewBox">QSvgGenerator::<wbr>viewBox()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QRect viewBox(){
        return viewBox_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRect viewBox_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsvggenerator.html#viewBox-prop">QSvgGenerator::<wbr>viewBoxF()const</a></code></p>
     */
    @QtPropertyReader(name="viewBox")
    @QtUninvokable
    public final io.qt.core.@NonNull QRectF viewBoxF(){
        return viewBoxF_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRectF viewBoxF_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qpaintdevice.html#width">QPaintDevice::<wbr>width()const</a></code></p>
     */
    @QtUninvokable
    public final int width(){
        return width_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int width_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qpaintdevice.html#widthMM">QPaintDevice::<wbr>widthMM()const</a></code></p>
     */
    @QtUninvokable
    public final int widthMM(){
        return widthMM_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int widthMM_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QPaintDevice::<wbr>initPainter(QPainter*)const</code></p>
     */
    @QtUninvokable
    protected void initPainter(io.qt.gui.@Nullable QPainter painter){
        initPainter_native_QPainter_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(painter));
    }
    
    private native static void initPainter_native_QPainter_ptr_constfct(long __this__nativeId, long painter);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qpaintdevice.html#metric">QPaintDevice::<wbr>metric(QPaintDevice::PaintDeviceMetric)const</a></code></p>
     */
    @QtUninvokable
    protected int metric(io.qt.gui.QPaintDevice.@NonNull PaintDeviceMetric metric){
        return metric_native_QPaintDevice_PaintDeviceMetric_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), metric.value());
    }
    
    private native static int metric_native_QPaintDevice_PaintDeviceMetric_constfct(long __this__nativeId, int metric);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qpaintdevice.html#paintEngine">QPaintDevice::<wbr>paintEngine()const</a></code></p>
     */
    @QtUninvokable
    @Override
    public io.qt.gui.@Nullable QPaintEngine paintEngine(){
        return paintEngine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.gui.QPaintEngine paintEngine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QPaintDevice::<wbr>redirected(QPoint*)const</code></p>
     */
    @QtUninvokable
    protected io.qt.gui.@Nullable QPaintDevice redirected(io.qt.core.@Nullable QPoint offset){
        return redirected_native_QPoint_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(offset));
    }
    
    private native static io.qt.gui.QPaintDevice redirected_native_QPoint_ptr_constfct(long __this__nativeId, long offset);
    
    /**
     * <p>See <code>QPaintDevice::<wbr>sharedPainter()const</code></p>
     */
    @QtUninvokable
    protected io.qt.gui.@Nullable QPainter sharedPainter(){
        return sharedPainter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.gui.QPainter sharedPainter_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QPaintDevice::<wbr>devicePixelRatioFScale()</code></p>
     */
    public native static double devicePixelRatioFScale();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QSvgGenerator(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Kotlin property getter. In Java use {@link #description()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getDescription() {
        return description();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #fileName()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getFileName() {
        return fileName();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #outputDevice()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@Nullable QIODevice getOutputDevice() {
        return outputDevice();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #resolution()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getResolution() {
        return resolution();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #size()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QSize getSize() {
        return size();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #title()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getTitle() {
        return title();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #viewBoxF()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRectF getViewBox() {
        return viewBoxF();
    }
}
