package io.qt.svg;

import io.qt.*;


/**
 * <p>QGraphicsItem that can be used to render the contents of SVG files</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qgraphicssvgitem.html">QGraphicsSvgItem</a></code></p>
 */
public class QGraphicsSvgItem extends io.qt.widgets.QGraphicsObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QGraphicsSvgItem.class);
    
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgraphicssvgitem.html#QGraphicsSvgItem">QGraphicsSvgItem::<wbr>QGraphicsSvgItem(QGraphicsItem*)</a></code></p>
     */
    public QGraphicsSvgItem(io.qt.widgets.@Nullable QGraphicsItem parentItem){
        super((QPrivateConstructor)null);
        initialize_native(this, parentItem);
        if (parentItem != null) QtJambi_LibraryUtilities.internal.setCppOwnership(this);
    }
    
    private native static void initialize_native(QGraphicsSvgItem instance, io.qt.widgets.QGraphicsItem parentItem);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgraphicssvgitem.html#QGraphicsSvgItem-1">QGraphicsSvgItem::<wbr>QGraphicsSvgItem(QString,<wbr>QGraphicsItem*)</a></code></p>
     */
    public QGraphicsSvgItem(java.lang.@NonNull String fileName, io.qt.widgets.@Nullable QGraphicsItem parentItem){
        super((QPrivateConstructor)null);
        initialize_native(this, fileName, parentItem);
        if (parentItem != null) QtJambi_LibraryUtilities.internal.setCppOwnership(this);
    }
    
    private native static void initialize_native(QGraphicsSvgItem instance, java.lang.String fileName, io.qt.widgets.QGraphicsItem parentItem);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgraphicssvgitem.html#elementId">QGraphicsSvgItem::<wbr>elementId()const</a></code></p>
     */
    @QtPropertyReader(name="elementId")
    @QtUninvokable
    public final java.lang.@NonNull String elementId(){
        return elementId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String elementId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgraphicssvgitem-obsolete.html#isCachingEnabled">QGraphicsSvgItem::<wbr>isCachingEnabled()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isCachingEnabled(){
        return isCachingEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isCachingEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgraphicssvgitem.html#maximumCacheSize">QGraphicsSvgItem::<wbr>maximumCacheSize()const</a></code></p>
     */
    @QtPropertyReader(name="maximumCacheSize")
    @QtUninvokable
    public final io.qt.core.@NonNull QSize maximumCacheSize(){
        return maximumCacheSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QSize maximumCacheSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgraphicssvgitem.html#renderer">QGraphicsSvgItem::<wbr>renderer()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.svg.@Nullable QSvgRenderer renderer(){
        return renderer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.svg.QSvgRenderer renderer_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgraphicssvgitem-obsolete.html#setCachingEnabled">QGraphicsSvgItem::<wbr>setCachingEnabled(bool)</a></code></p>
     */
    @QtUninvokable
    public final void setCachingEnabled(boolean arg__1){
        setCachingEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native void setCachingEnabled_native_bool(long __this__nativeId, boolean arg__1);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgraphicssvgitem.html#setElementId">QGraphicsSvgItem::<wbr>setElementId(QString)</a></code></p>
     */
    @QtPropertyWriter(name="elementId")
    @QtUninvokable
    public final void setElementId(java.lang.@NonNull String id){
        setElementId_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @QtUninvokable
    private native void setElementId_native_cref_QString(long __this__nativeId, java.lang.String id);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgraphicssvgitem.html#setMaximumCacheSize">QGraphicsSvgItem::<wbr>setMaximumCacheSize(QSize)</a></code></p>
     */
    @QtPropertyWriter(name="maximumCacheSize")
    @QtUninvokable
    public final void setMaximumCacheSize(io.qt.core.@NonNull QSize size){
        setMaximumCacheSize_native_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    @QtUninvokable
    private native void setMaximumCacheSize_native_cref_QSize(long __this__nativeId, long size);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgraphicssvgitem.html#setSharedRenderer">QGraphicsSvgItem::<wbr>setSharedRenderer(QSvgRenderer*)</a></code></p>
     */
    @QtUninvokable
    public final void setSharedRenderer(io.qt.svg.@Nullable QSvgRenderer renderer){
        QSvgRenderer oldRenderer = renderer();
        setSharedRenderer_native_QSvgRenderer_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(renderer));
        if (oldRenderer != null)
            QtJambi_LibraryUtilities.internal.setDefaultOwnership(oldRenderer);
    }
    
    @QtUninvokable
    private native void setSharedRenderer_native_QSvgRenderer_ptr(long __this__nativeId, long renderer);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgraphicsitem.html#boundingRect">QGraphicsItem::<wbr>boundingRect()const</a></code></p>
     */
    @QtUninvokable
    @Override
    public io.qt.core.@NonNull QRectF boundingRect(){
        return boundingRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.core.QRectF boundingRect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qgraphicsitem.html#paint">QGraphicsItem::<wbr>paint(QPainter*,<wbr>const QStyleOptionGraphicsItem*,<wbr>QWidget*)</a></code></p>
     */
    @QtUninvokable
    @Override
    public void paint(io.qt.gui.@Nullable QPainter painter, io.qt.widgets.@Nullable QStyleOptionGraphicsItem option, io.qt.widgets.@Nullable QWidget widget){
        paint_native_QPainter_ptr_const_QStyleOptionGraphicsItem_ptr_QWidget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(painter), QtJambi_LibraryUtilities.internal.checkedNativeId(option), QtJambi_LibraryUtilities.internal.checkedNativeId(widget));
    }
    
    private native static void paint_native_QPainter_ptr_const_QStyleOptionGraphicsItem_ptr_QWidget_ptr(long __this__nativeId, long painter, long option, long widget);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QGraphicsSvgItem(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QGraphicsSvgItem(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QGraphicsSvgItem instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QGraphicsSvgItem(io.qt.widgets.QGraphicsItem)}
     *  with <code>parentItem = null</code>.</p>
     */
    public QGraphicsSvgItem() {
        this((io.qt.widgets.QGraphicsItem)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QGraphicsSvgItem(java.lang.String, io.qt.widgets.QGraphicsItem)}
     *  with <code>parentItem = null</code>.</p>
     */
    public QGraphicsSvgItem(java.lang.@NonNull String fileName) {
        this(fileName, (io.qt.widgets.QGraphicsItem)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #elementId()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getElementId() {
        return elementId();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maximumCacheSize()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QSize getMaximumCacheSize() {
        return maximumCacheSize();
    }
}
