package io.qt.svg;


/**
 * <p>Widget that is used to display the contents of Scalable Vector Graphics (SVG) files</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qsvgwidget.html">QSvgWidget</a></p>
 */
public class QSvgWidget extends io.qt.widgets.QWidget
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSvgWidget.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #QSvgWidget(io.qt.widgets.QWidget)}
     *  with <code>parent = null</code>.</p>
     */
    public QSvgWidget() {
        this((io.qt.widgets.QWidget)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsvgwidget.html#QSvgWidget">QSvgWidget::QSvgWidget(QWidget*)</a></p>
     */
    public QSvgWidget(io.qt.widgets.QWidget parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QSvgWidget instance, io.qt.widgets.QWidget parent);
    
    /**
     * <p>Overloaded constructor for {@link #QSvgWidget(java.lang.String, io.qt.widgets.QWidget)}
     *  with <code>parent = null</code>.</p>
     */
    public QSvgWidget(java.lang.String file) {
        this(file, (io.qt.widgets.QWidget)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsvgwidget.html#QSvgWidget-1">QSvgWidget::QSvgWidget(QString,QWidget*)</a></p>
     */
    public QSvgWidget(java.lang.String file, io.qt.widgets.QWidget parent){
        super((QPrivateConstructor)null);
        initialize_native(this, file, parent);
    }
    
    private native static void initialize_native(QSvgWidget instance, java.lang.String file, io.qt.widgets.QWidget parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsvgwidget.html#load-1">QSvgWidget::load(QByteArray)</a></p>
     */
    public final void load(io.qt.core.QByteArray contents){
        load_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(contents));
    }
    
    private native void load_native_cref_QByteArray(long __this__nativeId, long contents);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsvgwidget.html#load">QSvgWidget::load(QString)</a></p>
     */
    public final void load(java.lang.String file){
        load_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), file);
    }
    
    private native void load_native_cref_QString(long __this__nativeId, java.lang.String file);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsvgwidget.html#renderer">QSvgWidget::renderer()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.svg.QSvgRenderer renderer(){
        return renderer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.svg.QSvgRenderer renderer_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwidget.html#paintEvent">QWidget::paintEvent(QPaintEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void paintEvent(io.qt.gui.QPaintEvent event){
        paintEvent_native_QPaintEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void paintEvent_native_QPaintEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwidget.html#sizeHint-prop">QWidget::sizeHint()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.core.QSize sizeHint(){
        return sizeHint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QSize sizeHint_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSvgWidget(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QSvgWidget(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QSvgWidget instance, QDeclarativeConstructor constructor);
    
}
