package io.qt.svg;


/**
 * <p>Paint device that is used to create SVG drawings</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qsvggenerator.html">QSvgGenerator</a></p>
 */
public class QSvgGenerator extends io.qt.QtObject
    implements io.qt.gui.QPaintDevice
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcOutputDevice = null;
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsvggenerator.html#QSvgGenerator">QSvgGenerator::QSvgGenerator()</a></p>
     */
    public QSvgGenerator(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSvgGenerator instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#colorCount">QPaintDevice::colorCount()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int colorCount(){
        return colorCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int colorCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#depth">QPaintDevice::depth()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int depth(){
        return depth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int depth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsvggenerator.html#description-prop">QSvgGenerator::description()const</a></p>
     */
    @io.qt.QtPropertyReader(name="description")
    @io.qt.QtUninvokable
    public final java.lang.String description(){
        return description_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String description_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#devicePixelRatio">QPaintDevice::devicePixelRatio()const</a></p>
     */
    @io.qt.QtUninvokable
    public final double devicePixelRatio(){
        return devicePixelRatio_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static double devicePixelRatio_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#devicePixelRatioF">QPaintDevice::devicePixelRatioF()const</a></p>
     */
    @io.qt.QtUninvokable
    public final double devicePixelRatioF(){
        return devicePixelRatioF_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static double devicePixelRatioF_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsvggenerator.html#fileName-prop">QSvgGenerator::fileName()const</a></p>
     */
    @io.qt.QtPropertyReader(name="fileName")
    @io.qt.QtUninvokable
    public final java.lang.String fileName(){
        return fileName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String fileName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#height">QPaintDevice::height()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int height(){
        return height_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int height_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#heightMM">QPaintDevice::heightMM()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int heightMM(){
        return heightMM_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int heightMM_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#logicalDpiX">QPaintDevice::logicalDpiX()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int logicalDpiX(){
        return logicalDpiX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int logicalDpiX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#logicalDpiY">QPaintDevice::logicalDpiY()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int logicalDpiY(){
        return logicalDpiY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int logicalDpiY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsvggenerator.html#outputDevice-prop">QSvgGenerator::outputDevice()const</a></p>
     */
    @io.qt.QtPropertyReader(name="outputDevice")
    @io.qt.QtUninvokable
    public final io.qt.core.QIODevice outputDevice(){
        return outputDevice_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QIODevice outputDevice_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#paintingActive">QPaintDevice::paintingActive()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean paintingActive(){
        return paintingActive_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static boolean paintingActive_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#physicalDpiX">QPaintDevice::physicalDpiX()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int physicalDpiX(){
        return physicalDpiX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int physicalDpiX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#physicalDpiY">QPaintDevice::physicalDpiY()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int physicalDpiY(){
        return physicalDpiY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int physicalDpiY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsvggenerator.html#resolution-prop">QSvgGenerator::resolution()const</a></p>
     */
    @io.qt.QtPropertyReader(name="resolution")
    @io.qt.QtUninvokable
    public final int resolution(){
        return resolution_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int resolution_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsvggenerator.html#description-prop">QSvgGenerator::setDescription(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="description")
    @io.qt.QtUninvokable
    public final void setDescription(java.lang.String description){
        setDescription_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), description);
    }
    
    @io.qt.QtUninvokable
    private native void setDescription_native_cref_QString(long __this__nativeId, java.lang.String description);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsvggenerator.html#fileName-prop">QSvgGenerator::setFileName(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="fileName")
    @io.qt.QtUninvokable
    public final void setFileName(java.lang.String fileName){
        setFileName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), fileName);
    }
    
    @io.qt.QtUninvokable
    private native void setFileName_native_cref_QString(long __this__nativeId, java.lang.String fileName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsvggenerator.html#outputDevice-prop">QSvgGenerator::setOutputDevice(QIODevice*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="outputDevice")
    @io.qt.QtUninvokable
    public final void setOutputDevice(io.qt.core.QIODevice outputDevice){
        setOutputDevice_native_QIODevice_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(outputDevice));
        __rcOutputDevice = outputDevice;
    }
    
    @io.qt.QtUninvokable
    private native void setOutputDevice_native_QIODevice_ptr(long __this__nativeId, long outputDevice);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsvggenerator.html#resolution-prop">QSvgGenerator::setResolution(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="resolution")
    @io.qt.QtUninvokable
    public final void setResolution(int dpi){
        setResolution_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), dpi);
    }
    
    @io.qt.QtUninvokable
    private native void setResolution_native_int(long __this__nativeId, int dpi);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsvggenerator.html#size-prop">QSvgGenerator::setSize(QSize)</a></p>
     */
    @io.qt.QtPropertyWriter(name="size")
    @io.qt.QtUninvokable
    public final void setSize(io.qt.core.QSize size){
        setSize_native_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    @io.qt.QtUninvokable
    private native void setSize_native_cref_QSize(long __this__nativeId, long size);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsvggenerator.html#title-prop">QSvgGenerator::setTitle(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="title")
    @io.qt.QtUninvokable
    public final void setTitle(java.lang.String title){
        setTitle_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), title);
    }
    
    @io.qt.QtUninvokable
    private native void setTitle_native_cref_QString(long __this__nativeId, java.lang.String title);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsvggenerator.html#viewBox-prop">QSvgGenerator::setViewBox(QRect)</a></p>
     */
    @io.qt.QtPropertyWriter(name="viewBox")
    @io.qt.QtUninvokable
    public final void setViewBox(io.qt.core.QRect viewBox){
        setViewBox_native_cref_QRect(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(viewBox));
    }
    
    @io.qt.QtUninvokable
    private native void setViewBox_native_cref_QRect(long __this__nativeId, long viewBox);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsvggenerator.html#viewBox-prop">QSvgGenerator::setViewBox(QRectF)</a></p>
     */
    @io.qt.QtPropertyWriter(name="viewBox")
    @io.qt.QtUninvokable
    public final void setViewBox(io.qt.core.QRectF viewBox){
        setViewBox_native_cref_QRectF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(viewBox));
    }
    
    @io.qt.QtUninvokable
    private native void setViewBox_native_cref_QRectF(long __this__nativeId, long viewBox);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsvggenerator.html#size-prop">QSvgGenerator::size()const</a></p>
     */
    @io.qt.QtPropertyReader(name="size")
    @io.qt.QtUninvokable
    public final io.qt.core.QSize size(){
        return size_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QSize size_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsvggenerator.html#title-prop">QSvgGenerator::title()const</a></p>
     */
    @io.qt.QtPropertyReader(name="title")
    @io.qt.QtUninvokable
    public final java.lang.String title(){
        return title_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String title_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsvggenerator.html#viewBox">QSvgGenerator::viewBox()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QRect viewBox(){
        return viewBox_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRect viewBox_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsvggenerator.html#viewBox-prop">QSvgGenerator::viewBoxF()const</a></p>
     */
    @io.qt.QtPropertyReader(name="viewBox")
    @io.qt.QtUninvokable
    public final io.qt.core.QRectF viewBoxF(){
        return viewBoxF_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF viewBoxF_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#width">QPaintDevice::width()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int width(){
        return width_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int width_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#widthMM">QPaintDevice::widthMM()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int widthMM(){
        return widthMM_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int widthMM_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected void initPainter(io.qt.gui.QPainter painter){
        initPainter_native_QPainter_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(painter));
    }
    
    private native static void initPainter_native_QPainter_ptr_constfct(long __this__nativeId, long painter);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#metric">QPaintDevice::metric(QPaintDevice::PaintDeviceMetric)const</a></p>
     */
    @io.qt.QtUninvokable
    protected int metric(io.qt.gui.QPaintDevice.PaintDeviceMetric metric){
        return metric_native_QPaintDevice_PaintDeviceMetric_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), metric.value());
    }
    
    private native static int metric_native_QPaintDevice_PaintDeviceMetric_constfct(long __this__nativeId, int metric);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#paintEngine">QPaintDevice::paintEngine()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.gui.QPaintEngine paintEngine(){
        return paintEngine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.gui.QPaintEngine paintEngine_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected io.qt.gui.QPaintDevice redirected(io.qt.core.QPoint offset){
        return redirected_native_QPoint_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), offset);
    }
    
    private native static io.qt.gui.QPaintDevice redirected_native_QPoint_ptr_constfct(long __this__nativeId, io.qt.core.QPoint offset);
    
    @io.qt.QtUninvokable
    protected io.qt.gui.QPainter sharedPainter(){
        return sharedPainter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.gui.QPainter sharedPainter_native_constfct(long __this__nativeId);
    
    public native static double devicePixelRatioFScale();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSvgGenerator(QPrivateConstructor p) { super(p); } 
    
}
