package io.qt.svg;


/**
 * <p>QGraphicsItem that can be used to render the contents of SVG files</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qgraphicssvgitem.html">QGraphicsSvgItem</a></p>
 */
public class QGraphicsSvgItem extends io.qt.widgets.QGraphicsObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QGraphicsSvgItem.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #QGraphicsSvgItem(io.qt.widgets.QGraphicsItem)}
     *  with <code>parentItem = null</code>.</p>
     */
    public QGraphicsSvgItem() {
        this((io.qt.widgets.QGraphicsItem)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgraphicssvgitem.html#QGraphicsSvgItem">QGraphicsSvgItem::QGraphicsSvgItem(QGraphicsItem*)</a></p>
     */
    public QGraphicsSvgItem(io.qt.widgets.QGraphicsItem parentItem){
        super((QPrivateConstructor)null);
        initialize_native(this, parentItem);
        if (parentItem != null) QtJambi_LibraryUtilities.internal.setCppOwnership(this);
    }
    
    private native static void initialize_native(QGraphicsSvgItem instance, io.qt.widgets.QGraphicsItem parentItem);
    
    /**
     * <p>Overloaded constructor for {@link #QGraphicsSvgItem(java.lang.String, io.qt.widgets.QGraphicsItem)}
     *  with <code>parentItem = null</code>.</p>
     */
    public QGraphicsSvgItem(java.lang.String fileName) {
        this(fileName, (io.qt.widgets.QGraphicsItem)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgraphicssvgitem.html#QGraphicsSvgItem-1">QGraphicsSvgItem::QGraphicsSvgItem(QString,QGraphicsItem*)</a></p>
     */
    public QGraphicsSvgItem(java.lang.String fileName, io.qt.widgets.QGraphicsItem parentItem){
        super((QPrivateConstructor)null);
        initialize_native(this, fileName, parentItem);
        if (parentItem != null) QtJambi_LibraryUtilities.internal.setCppOwnership(this);
    }
    
    private native static void initialize_native(QGraphicsSvgItem instance, java.lang.String fileName, io.qt.widgets.QGraphicsItem parentItem);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgraphicssvgitem.html#elementId">QGraphicsSvgItem::elementId()const</a></p>
     */
    @io.qt.QtPropertyReader(name="elementId")
    @io.qt.QtUninvokable
    public final java.lang.String elementId(){
        return elementId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String elementId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgraphicssvgitem-obsolete.html#isCachingEnabled">QGraphicsSvgItem::isCachingEnabled()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isCachingEnabled(){
        return isCachingEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isCachingEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgraphicssvgitem.html#maximumCacheSize">QGraphicsSvgItem::maximumCacheSize()const</a></p>
     */
    @io.qt.QtPropertyReader(name="maximumCacheSize")
    @io.qt.QtUninvokable
    public final io.qt.core.QSize maximumCacheSize(){
        return maximumCacheSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QSize maximumCacheSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgraphicssvgitem.html#renderer">QGraphicsSvgItem::renderer()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.svg.QSvgRenderer renderer(){
        return renderer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.svg.QSvgRenderer renderer_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgraphicssvgitem-obsolete.html#setCachingEnabled">QGraphicsSvgItem::setCachingEnabled(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setCachingEnabled(boolean arg__1){
        setCachingEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setCachingEnabled_native_bool(long __this__nativeId, boolean arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgraphicssvgitem.html#setElementId">QGraphicsSvgItem::setElementId(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="elementId")
    @io.qt.QtUninvokable
    public final void setElementId(java.lang.String id){
        setElementId_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @io.qt.QtUninvokable
    private native void setElementId_native_cref_QString(long __this__nativeId, java.lang.String id);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgraphicssvgitem.html#setMaximumCacheSize">QGraphicsSvgItem::setMaximumCacheSize(QSize)</a></p>
     */
    @io.qt.QtPropertyWriter(name="maximumCacheSize")
    @io.qt.QtUninvokable
    public final void setMaximumCacheSize(io.qt.core.QSize size){
        setMaximumCacheSize_native_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    @io.qt.QtUninvokable
    private native void setMaximumCacheSize_native_cref_QSize(long __this__nativeId, long size);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgraphicssvgitem.html#setSharedRenderer">QGraphicsSvgItem::setSharedRenderer(QSvgRenderer*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setSharedRenderer(io.qt.svg.QSvgRenderer renderer){
        QSvgRenderer oldRenderer = renderer();
        setSharedRenderer_native_QSvgRenderer_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(renderer));
        if (oldRenderer != null)
            QtJambi_LibraryUtilities.internal.setDefaultOwnership(oldRenderer);
    }
    
    @io.qt.QtUninvokable
    private native void setSharedRenderer_native_QSvgRenderer_ptr(long __this__nativeId, long renderer);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgraphicsitem.html#boundingRect">QGraphicsItem::boundingRect()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.core.QRectF boundingRect(){
        return boundingRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.core.QRectF boundingRect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qgraphicsitem.html#paint">QGraphicsItem::paint(QPainter*,const QStyleOptionGraphicsItem*,QWidget*)</a></p>
     */
    @io.qt.QtUninvokable
    public void paint(io.qt.gui.QPainter painter, io.qt.widgets.QStyleOptionGraphicsItem option, io.qt.widgets.QWidget widget){
        paint_native_QPainter_ptr_const_QStyleOptionGraphicsItem_ptr_QWidget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(painter), option, QtJambi_LibraryUtilities.internal.checkedNativeId(widget));
    }
    
    private native static void paint_native_QPainter_ptr_const_QStyleOptionGraphicsItem_ptr_QWidget_ptr(long __this__nativeId, long painter, io.qt.widgets.QStyleOptionGraphicsItem option, long widget);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QGraphicsSvgItem(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QGraphicsSvgItem(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QGraphicsSvgItem instance, QDeclarativeConstructor constructor);
    
}
