#include "QSvgGenerator_shell.h"
#include <QtJambi/Cast>

void deleter_QSvgGenerator(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QSvgGenerator")
    QSvgGenerator *_ptr = reinterpret_cast<QSvgGenerator *>(ptr);
    if(!isShell){
        struct PaintDeviceAccess : QPaintDevice{
            inline QPainter* getSharedPainter() const { return sharedPainter(); }
        };
        QPaintDevice* device = _ptr;
        if(QPainter* painter = reinterpret_cast<PaintDeviceAccess*>(device)->getSharedPainter()){
            if(painter->isActive()){
                painter->end();
            }
        }
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

QtJambiShell* QSvgGenerator_shell::__shell() const { return *reinterpret_cast<QtJambiShell**>( quintptr(this) + sizeof(QSvgGenerator_shell) ); }

jmethodID QSvgGenerator_oshell::__shell_javaMethod(int pos) const { return QSvgGenerator_shell::__shell()->javaMethod(typeid(QSvgGenerator), pos); }

// emitting (writeShellDestructor)
QSvgGenerator_shell::~QSvgGenerator_shell()
{
    QTJAMBI_IN_DESTRUCTOR_CALL("QSvgGenerator::~QSvgGenerator()", this)
    if(QPainter* painter = QSvgGenerator_shell::sharedPainter()){
        if(painter->isActive()){
            painter->end();
        }
    }
    QSvgGenerator_shell::__shell()->destructed(typeid(QSvgGenerator));
}

QSvgGenerator_oshell::~QSvgGenerator_oshell()
{
    if(QPainter* painter = QSvgGenerator_oshell::sharedPainter()){
        if(painter->isActive()){
            painter->end();
        }
    }
}

// emitting (writeShellConstructor)
QSvgGenerator_shell::QSvgGenerator_shell()
    : QSvgGenerator()
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QSvgGenerator::QSvgGenerator_shell()", this)
    QSvgGenerator_shell::__shell()->constructed(typeid(QSvgGenerator));
}

QSvgGenerator_shell::QSvgGenerator_shell(QSvgGenerator::SvgVersion version0)
    : QSvgGenerator(version0)
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QSvgGenerator::QSvgGenerator_shell(QSvgGenerator::SvgVersion version0)", this)
    QSvgGenerator_shell::__shell()->constructed(typeid(QSvgGenerator));
}

void QSvgGenerator_shell::operator delete(void * ptr) noexcept {
    reinterpret_cast<QSvgGenerator_shell*>(ptr)->QSvgGenerator_shell::__shell()->tryDeleteShell(typeid(QSvgGenerator));
}

void QSvgGenerator_oshell::operator delete(void * ptr) noexcept {
    reinterpret_cast<QSvgGenerator_oshell*>(ptr)->QSvgGenerator_oshell::__shell()->tryDeleteShell(typeid(QSvgGenerator));
}

// emitting Virtual overrides (virtualFunctions)
void QSvgGenerator_oshell::initPainter(QPainter* painter0) const
{
    if(jmethodID method_id = __shell_javaMethod(0)){
        QTJAMBI_JAVA_METHOD_CALL("QSvgGenerator::initPainter(QPainter*)const", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QTJAMBI_TRY {
                if(jobject __java_this = QSvgGenerator_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_painter0 = qtjambi_cast<jobject>(__jni_env, painter0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_painter0);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_painter0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                } else {
                    QSvgGenerator_shell::__shell()->warnForMethod("QSvgGenerator::initPainter(QPainter*)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QSvgGenerator::initPainter(QPainter*)const");
            } QTJAMBI_TRY_END
        }else{
            QPaintDevice::initPainter(painter0);
        }
    }else{
        QPaintDevice::initPainter(painter0);
    }
}

int QSvgGenerator_oshell::metric(QPaintDevice::PaintDeviceMetric metric0) const
{
    if(jmethodID method_id = __shell_javaMethod(1)){
        QTJAMBI_JAVA_METHOD_CALL("QSvgGenerator::metric(QPaintDevice::PaintDeviceMetric)const", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            int  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QSvgGenerator_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_metric0 = qtjambi_cast<jobject>(__jni_env, metric0);
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id, __java_metric0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<int>(__java_return_value);
                } else {
                    QSvgGenerator_shell::__shell()->warnForMethod("QSvgGenerator::metric(QPaintDevice::PaintDeviceMetric)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QSvgGenerator::metric(QPaintDevice::PaintDeviceMetric)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QSvgGenerator::metric(QPaintDevice::PaintDeviceMetric(metric0));
        }
    }else{
        return QSvgGenerator::metric(QPaintDevice::PaintDeviceMetric(metric0));
    }
}

QPaintEngine* QSvgGenerator_oshell::paintEngine() const
{
    if(jmethodID method_id = __shell_javaMethod(2)){
        QTJAMBI_JAVA_METHOD_CALL("QSvgGenerator::paintEngine()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QPaintEngine*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QSvgGenerator_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QPaintEngine*>(__jni_env, __java_return_value);
                } else {
                    QSvgGenerator_shell::__shell()->warnForMethod("QSvgGenerator::paintEngine()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QSvgGenerator::paintEngine()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QSvgGenerator::paintEngine();
        }
    }else{
        return QSvgGenerator::paintEngine();
    }
}

QPaintDevice* QSvgGenerator_oshell::redirected(QPoint* offset0) const
{
    if(jmethodID method_id = __shell_javaMethod(3)){
        QTJAMBI_JAVA_METHOD_CALL("QSvgGenerator::redirected(QPoint*)const", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QPaintDevice*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QSvgGenerator_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_offset0 = qtjambi_cast<jobject>(__jni_env, offset0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_offset0);
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, __java_offset0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QPaintDevice*>(__jni_env, __java_return_value);
                } else {
                    QSvgGenerator_shell::__shell()->warnForMethod("QSvgGenerator::redirected(QPoint*)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QSvgGenerator::redirected(QPoint*)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QPaintDevice::redirected(offset0);
        }
    }else{
        return QPaintDevice::redirected(offset0);
    }
}

QPainter* QSvgGenerator_oshell::sharedPainter() const
{
    if(jmethodID method_id = __shell_javaMethod(4)){
        QTJAMBI_JAVA_METHOD_CALL("QSvgGenerator::sharedPainter()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QPainter*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QSvgGenerator_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QPainter*>(__jni_env, __java_return_value);
                } else {
                    QSvgGenerator_shell::__shell()->warnForMethod("QSvgGenerator::sharedPainter()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QSvgGenerator::sharedPainter()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QPaintDevice::sharedPainter();
        }
    }else{
        return QPaintDevice::sharedPainter();
    }
}

// emitting Functions in shell class (nonVirtualShellFunctions)
// emitting Public Override Functions (publicOverrideFunctions)
// emitting Virtual Override Functions (virtualOverrideFunctions)
void QSvgGenerator_access::__qt_initPainter_QPainter_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID painter0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QPainter* __qt_painter0 = QtJambiAPI::objectFromNativeId<QPainter>(painter0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintDevice::initPainter(__qt_painter0);
    } else {
        initPainter(__qt_painter0);
    }
}

jint QSvgGenerator_access::__qt_metric_QPaintDevice_PaintDeviceMetric_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint metric0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QPaintDevice::PaintDeviceMetric __qt_metric0 = qtjambi_cast<QPaintDevice::PaintDeviceMetric>(__jni_env, metric0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        int __qt_return_value = QSvgGenerator::metric(__qt_metric0);
        return jint(__qt_return_value);
    } else {
        int __qt_return_value = metric(__qt_metric0);
        return jint(__qt_return_value);
    }
}

jobject QSvgGenerator_access::__qt_paintEngine_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintEngine* __qt_return_value = QSvgGenerator::paintEngine();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QPaintEngine* __qt_return_value = paintEngine();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jobject QSvgGenerator_access::__qt_redirected_QPoint_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID offset0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QPoint* __qt_offset0 = QtJambiAPI::objectFromNativeId<QPoint>(offset0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintDevice* __qt_return_value = QPaintDevice::redirected(__qt_offset0);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QPaintDevice* __qt_return_value = redirected(__qt_offset0);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jobject QSvgGenerator_access::__qt_sharedPainter_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPainter* __qt_return_value = QPaintDevice::sharedPainter();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QPainter* __qt_return_value = sharedPainter();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

// emitting (writeConstructors)
// new QSvgGenerator()
void __qt_construct_QSvgGenerator(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool __qtjambi_has_overrides, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QSvgGenerator()")
    Q_UNUSED(__java_arguments)
    QSvgGenerator *__qt_this;
    if(__qtjambi_has_overrides)
        __qt_this = new(__qtjambi_ptr) QSvgGenerator_oshell();
    else
        __qt_this = new(__qtjambi_ptr) QSvgGenerator_shell();
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
}

// QSvgGenerator::QSvgGenerator()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_initialize_1native__Lio_qt_svg_QSvgGenerator_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSvgGenerator::QSvgGenerator()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QSvgGenerator, sizeof(QSvgGenerator_shell), typeid(QSvgGenerator), 0, true, &deleter_QSvgGenerator, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QSvgGenerator(QSvgGenerator::SvgVersion)
void __qt_construct_QSvgGenerator_QSvgGenerator_SvgVersion(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool __qtjambi_has_overrides, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QSvgGenerator(QSvgGenerator::SvgVersion)")
    jobject version0 = __java_arguments[0].l;
    QSvgGenerator::SvgVersion __qt_version0 = qtjambi_cast<QSvgGenerator::SvgVersion>(__jni_env, version0);
    QSvgGenerator *__qt_this;
    if(__qtjambi_has_overrides)
        __qt_this = new(__qtjambi_ptr) QSvgGenerator_oshell(QSvgGenerator::SvgVersion(__qt_version0));
    else
        __qt_this = new(__qtjambi_ptr) QSvgGenerator_shell(QSvgGenerator::SvgVersion(__qt_version0));
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QSvgGenerator::QSvgGenerator(QSvgGenerator::SvgVersion)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_initialize_1native__Lio_qt_svg_QSvgGenerator_2Lio_qt_svg_QSvgGenerator_00024SvgVersion_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject version0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSvgGenerator::QSvgGenerator(QSvgGenerator::SvgVersion)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = version0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QSvgGenerator_QSvgGenerator_SvgVersion, sizeof(QSvgGenerator_shell), typeid(QSvgGenerator), 0, true, &deleter_QSvgGenerator, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QSvgGenerator_shell
void __qt_destruct_QSvgGenerator(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QSvgGenerator")
    reinterpret_cast<QSvgGenerator_shell*>(ptr)->~QSvgGenerator_shell();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QSvgGenerator::colorCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_colorCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::colorCount()const", __this_nativeId)
        __java_return_value = __qt_this->QPaintDevice::colorCount();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSvgGenerator::depth()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_depth_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::depth()const", __this_nativeId)
        __java_return_value = __qt_this->QPaintDevice::depth();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSvgGenerator::description()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_description_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::description()const", __this_nativeId)
        QString __qt_return_value = __qt_this->description();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSvgGenerator::devicePixelRatio()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_devicePixelRatio_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::devicePixelRatio()const", __this_nativeId)
        qreal __qt_return_value = __qt_this->QPaintDevice::devicePixelRatio();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSvgGenerator::devicePixelRatioF()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_devicePixelRatioF_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::devicePixelRatioF()const", __this_nativeId)
        qreal __qt_return_value = __qt_this->QPaintDevice::devicePixelRatioF();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSvgGenerator::fileName()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_fileName_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::fileName()const", __this_nativeId)
        QString __qt_return_value = __qt_this->fileName();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSvgGenerator::height()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_height_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::height()const", __this_nativeId)
        __java_return_value = __qt_this->QPaintDevice::height();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSvgGenerator::heightMM()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_heightMM_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::heightMM()const", __this_nativeId)
        __java_return_value = __qt_this->QPaintDevice::heightMM();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSvgGenerator::logicalDpiX()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_logicalDpiX_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::logicalDpiX()const", __this_nativeId)
        __java_return_value = __qt_this->QPaintDevice::logicalDpiX();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSvgGenerator::logicalDpiY()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_logicalDpiY_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::logicalDpiY()const", __this_nativeId)
        __java_return_value = __qt_this->QPaintDevice::logicalDpiY();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSvgGenerator::outputDevice()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_outputDevice_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::outputDevice()const", __this_nativeId)
        QIODevice* __qt_return_value = __qt_this->outputDevice();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSvgGenerator::paintingActive()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_paintingActive_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::paintingActive()const", __this_nativeId)
        __java_return_value = __qt_this->QPaintDevice::paintingActive();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSvgGenerator::physicalDpiX()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_physicalDpiX_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::physicalDpiX()const", __this_nativeId)
        __java_return_value = __qt_this->QPaintDevice::physicalDpiX();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSvgGenerator::physicalDpiY()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_physicalDpiY_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::physicalDpiY()const", __this_nativeId)
        __java_return_value = __qt_this->QPaintDevice::physicalDpiY();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSvgGenerator::resolution()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_resolution_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::resolution()const", __this_nativeId)
        __java_return_value = __qt_this->resolution();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSvgGenerator::setDescription(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_setDescription_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring description0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::setDescription(QString)", __this_nativeId)
        QString  __qt_description0 = qtjambi_cast<QString>(__jni_env, description0);
        __qt_this->setDescription(__qt_description0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSvgGenerator::setFileName(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_setFileName_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring fileName0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::setFileName(QString)", __this_nativeId)
        QString  __qt_fileName0 = qtjambi_cast<QString>(__jni_env, fileName0);
        __qt_this->setFileName(__qt_fileName0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSvgGenerator::setOutputDevice(QIODevice*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_setOutputDevice_1native_1QIODevice_1ptr__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID outputDevice0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::setOutputDevice(QIODevice*)", __this_nativeId)
        QIODevice* __qt_outputDevice0 = QtJambiAPI::objectFromNativeId<QIODevice>(outputDevice0);
        __qt_this->setOutputDevice(__qt_outputDevice0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSvgGenerator::setResolution(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_setResolution_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint dpi0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::setResolution(int)", __this_nativeId)
        __qt_this->setResolution(static_cast<int>(dpi0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSvgGenerator::setSize(QSize)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_setSize_1native_1cref_1QSize__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID size0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::setSize(QSize)", __this_nativeId)
        const QSize& __qt_size0 = QtJambiAPI::valueReferenceFromNativeId<QSize>(size0);
        __qt_this->setSize(__qt_size0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSvgGenerator::setTitle(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_setTitle_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring title0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::setTitle(QString)", __this_nativeId)
        QString  __qt_title0 = qtjambi_cast<QString>(__jni_env, title0);
        __qt_this->setTitle(__qt_title0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSvgGenerator::setViewBox(QRect)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_setViewBox_1native_1cref_1QRect__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID viewBox0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::setViewBox(QRect)", __this_nativeId)
        const QRect& __qt_viewBox0 = QtJambiAPI::valueReferenceFromNativeId<QRect>(viewBox0);
        __qt_this->setViewBox(__qt_viewBox0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSvgGenerator::setViewBox(QRectF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_setViewBox_1native_1cref_1QRectF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID viewBox0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::setViewBox(QRectF)", __this_nativeId)
        const QRectF& __qt_viewBox0 = QtJambiAPI::valueReferenceFromNativeId<QRectF>(viewBox0);
        __qt_this->setViewBox(__qt_viewBox0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSvgGenerator::size()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_size_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::size()const", __this_nativeId)
        QSize __qt_return_value = __qt_this->size();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSvgGenerator::svgVersion()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_svgVersion_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::svgVersion()const", __this_nativeId)
        QSvgGenerator::SvgVersion __qt_return_value = __qt_this->svgVersion();
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSvgGenerator::title()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_title_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::title()const", __this_nativeId)
        QString __qt_return_value = __qt_this->title();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSvgGenerator::viewBox()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_viewBox_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::viewBox()const", __this_nativeId)
        QRect __qt_return_value = __qt_this->viewBox();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSvgGenerator::viewBoxF()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_viewBoxF_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::viewBoxF()const", __this_nativeId)
        QRectF __qt_return_value = __qt_this->viewBoxF();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSvgGenerator::width()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_width_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::width()const", __this_nativeId)
        __java_return_value = __qt_this->QPaintDevice::width();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSvgGenerator::widthMM()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_widthMM_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::widthMM()const", __this_nativeId)
        __java_return_value = __qt_this->QPaintDevice::widthMM();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSvgGenerator::initPainter(QPainter*)const
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_initPainter_1native_1QPainter_1ptr_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID painter0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::initPainter(QPainter*)const", __this_nativeId)
        static_cast<const QSvgGenerator_access*>(__qt_this)->__qt_initPainter_QPainter_ptr_constfct(__jni_env, __this_nativeId, painter0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSvgGenerator::metric(QPaintDevice::PaintDeviceMetric)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_metric_1native_1QPaintDevice_1PaintDeviceMetric_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint metric0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::metric(QPaintDevice::PaintDeviceMetric)const", __this_nativeId)
        __java_return_value = static_cast<const QSvgGenerator_access*>(__qt_this)->__qt_metric_QPaintDevice_PaintDeviceMetric_constfct(__jni_env, __this_nativeId, metric0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSvgGenerator::paintEngine()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_paintEngine_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::paintEngine()const", __this_nativeId)
        __java_return_value = static_cast<const QSvgGenerator_access*>(__qt_this)->__qt_paintEngine_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSvgGenerator::redirected(QPoint*)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_redirected_1native_1QPoint_1ptr_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID offset0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::redirected(QPoint*)const", __this_nativeId)
        __java_return_value = static_cast<const QSvgGenerator_access*>(__qt_this)->__qt_redirected_QPoint_ptr_constfct(__jni_env, __this_nativeId, offset0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSvgGenerator::sharedPainter()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_sharedPainter_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QSvgGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QSvgGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSvgGenerator::sharedPainter()const", __this_nativeId)
        __java_return_value = static_cast<const QSvgGenerator_access*>(__qt_this)->__qt_sharedPainter_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSvgGenerator::devicePixelRatioFScale()
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_svg_QSvgGenerator_devicePixelRatioFScale__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSvgGenerator::devicePixelRatioFScale()")
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        qreal __qt_return_value = QSvgGenerator::devicePixelRatioFScale();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

void initialize_meta_info_QSvgGenerator(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerObjectTypeInfo<QSvgGenerator>("QSvgGenerator", "io/qt/svg/QSvgGenerator");
// BEGIN: function table
    registerFunctionInfos(typeId, {
        FunctionInfo(/* 0 */ "initPainter", "(Lio/qt/gui/QPainter;)V"),
        FunctionInfo(/* 1 */ "metric", "(Lio/qt/gui/QPaintDevice$PaintDeviceMetric;)I"),
        FunctionInfo(/* 2 */ "paintEngine", "()Lio/qt/gui/QPaintEngine;"),
        FunctionInfo(/* 3 */ "redirected", "(Lio/qt/core/QPoint;)Lio/qt/gui/QPaintDevice;"),
        FunctionInfo(/* 4 */ "sharedPainter", "()Lio/qt/gui/QPainter;")});
    registerConstructorInfos(typeId, 0, &__qt_destruct_QSvgGenerator, {
        ConstructorInfo(&__qt_construct_QSvgGenerator, nullptr)
       ,ConstructorInfo(&__qt_construct_QSvgGenerator_QSvgGenerator_SvgVersion, "Lio/qt/svg/QSvgGenerator$SvgVersion;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QSvgGenerator);
    registerSizeOfShell(typeId, sizeof(QSvgGenerator_shell));
// END: type registration

// BEGIN: polymorphic ids
    registerPolymorphyHandler(typeid(QPaintDevice), typeId, [](void *ptr, qintptr& offset) -> bool {
            QPaintDevice *object = reinterpret_cast<QPaintDevice *>(ptr);
            Q_ASSERT(object);
            bool _result = false;
            QTJAMBI_TRY_ANY {
                if(QSvgGenerator* _object = dynamic_cast<QSvgGenerator*>(object)){
                    offset = qintptr(object)-qintptr(_object);
                    _result = true;
                }
            } QTJAMBI_CATCH_ANY{
            } QTJAMBI_TRY_END
            return _result;
        });
// END: polymorphic ids

    registerInterfaceOffset(typeId, typeid(QPaintDevice), int(reinterpret_cast<quintptr>(static_cast<QPaintDevice *>(reinterpret_cast<QSvgGenerator *>(0x10000000)))) - 0x10000000);

// BEGIN: enums and flags
    registerEnumTypeInfo<QSvgGenerator::SvgVersion>("QSvgGenerator::SvgVersion", "io/qt/svg/QSvgGenerator$SvgVersion");
// END: enums and flags
}
