package io.qt.statemachine;

import io.qt.*;


/**
 * <p>Transition based on a Qt signal</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qsignaltransition.html">QSignalTransition</a></code></p>
 */
public class QSignalTransition extends io.qt.statemachine.QAbstractTransition
{
    @QtPropertyMember(enabled=false)
    private Object __rcSenderObject = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSignalTransition.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsignaltransition.html#senderObjectChanged">QSignalTransition::<wbr>senderObjectChanged()</a></code></p>
     */
    @QtPropertyNotify(name="senderObject")
    public final @NonNull PrivateSignal0 senderObjectChanged = new PrivateSignal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsignaltransition.html#signalChanged">QSignalTransition::<wbr>signalChanged()</a></code></p>
     */
    @QtPropertyNotify(name="signal")
    public final @NonNull PrivateSignal0 signalChanged = new PrivateSignal0();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsignaltransition.html#QSignalTransition">QSignalTransition::<wbr>QSignalTransition(QState*)</a></code></p>
     */
    public QSignalTransition(io.qt.statemachine.@Nullable QState sourceState){
        super((QPrivateConstructor)null);
        initialize_native(this, sourceState);
    }
    
    private native static void initialize_native(QSignalTransition instance, io.qt.statemachine.QState sourceState);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsignaltransition.html#QSignalTransition-1">QSignalTransition::<wbr>QSignalTransition(const QObject*,<wbr>const char*,<wbr>QState*)</a></code></p>
     */
    public QSignalTransition(io.qt.core.@Nullable QObject sender, java.lang.@Nullable String signal, io.qt.statemachine.@Nullable QState sourceState){
        super((QPrivateConstructor)null);
        if(signal!=null && !signal.startsWith("2")){
            io.qt.core.QMetaMethod method = sender.metaObject().method(signal);
            if(method!=null && method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal) {
                signal = "2" + method.cppMethodSignature();
            }
        }
        initialize_native(this, sender, signal, sourceState);
    }
    
    private native static void initialize_native(QSignalTransition instance, io.qt.core.QObject sender, java.lang.String signal, io.qt.statemachine.QState sourceState);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsignaltransition.html#senderObject-prop">QSignalTransition::<wbr>bindableSenderObject()</a></code></p>
     */
    @QtPropertyBindable(name="senderObject")
    @QtUninvokable
    public final io.qt.core.@NonNull QBindable<io.qt.core.@Nullable QObject> bindableSenderObject(){
        return bindableSenderObject_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBindable<io.qt.core.QObject> bindableSenderObject_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsignaltransition.html#signal-prop">QSignalTransition::<wbr>bindableSignal()</a></code></p>
     */
    @QtPropertyBindable(name="signal")
    @QtUninvokable
    public final io.qt.core.@NonNull QBindable<io.qt.core.@NonNull QByteArray> bindableSignal(){
        return bindableSignal_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBindable<io.qt.core.QByteArray> bindableSignal_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsignaltransition.html#senderObject">QSignalTransition::<wbr>senderObject()const</a></code></p>
     */
    @QtPropertyReader(name="senderObject")
    @QtUninvokable
    public final io.qt.core.@Nullable QObject senderObject(){
        return senderObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QObject senderObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsignaltransition.html#setSenderObject">QSignalTransition::<wbr>setSenderObject(const QObject*)</a></code></p>
     */
    @QtPropertyWriter(name="senderObject")
    @QtUninvokable
    public final void setSenderObject(io.qt.core.@Nullable QObject sender){
        setSenderObject_native_const_QObject_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sender));
        __rcSenderObject = sender;
    }
    
    @QtUninvokable
    private native void setSenderObject_native_const_QObject_ptr(long __this__nativeId, long sender);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsignaltransition.html#setSignal">QSignalTransition::<wbr>setSignal(QByteArray)</a></code></p>
     */
    @QtPropertyWriter(name="signal")
    @QtUninvokable
    public final void setSignal(io.qt.core.@NonNull QByteArray signal){
        if(signal!=null && !signal.startsWith("2")){
            io.qt.core.QMetaMethod method = senderObject().metaObject().method(signal.toString());
            if(method!=null && method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal) {
                signal = new io.qt.core.QByteArray("2");
                signal.append(method.cppMethodSignature());
            }
        }
        setSignal_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(signal));
    }
    
    @QtUninvokable
    private native void setSignal_native_cref_QByteArray(long __this__nativeId, long signal);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsignaltransition.html#signal">QSignalTransition::<wbr>signal()const</a></code></p>
     */
    @QtPropertyReader(name="signal")
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray signal(){
        return signal_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray signal_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qobject.html#event">QObject::<wbr>event(QEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    public boolean event(io.qt.core.@Nullable QEvent e){
        return event_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @QtUninvokable
    private native boolean event_native_QEvent_ptr(long __this__nativeId, long e);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstracttransition.html#eventTest">QAbstractTransition::<wbr>eventTest(QEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected boolean eventTest(io.qt.core.@Nullable QEvent event){
        return eventTest_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native boolean eventTest_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstracttransition.html#onTransition">QAbstractTransition::<wbr>onTransition(QEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void onTransition(io.qt.core.@Nullable QEvent event){
        onTransition_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void onTransition_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QSignalTransition(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QSignalTransition(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QSignalTransition instance, QDeclarativeConstructor constructor);
    
    /**
     * Overloaded constructor for {@link #QSignalTransition(io.qt.core.QMetaObject.AbstractSignal, io.qt.core.QState)}.
     */
    public QSignalTransition(io.qt.core.QMetaObject.AbstractSignal signal) {
        this(signal, null);
    }
    
    /**
     * Constructs a new signal transition associated with the given signal of the given sender object and with the given sourceState.
     */
    public QSignalTransition(io.qt.core.QMetaObject.AbstractSignal signal, QState sourceState) {
        super((QPrivateConstructor)null);
        if(signal.containingObject() instanceof io.qt.core.QObject) {
            io.qt.core.QObject sender = (io.qt.core.QObject)signal.containingObject();
            String signalSignature = "2" + sender.metaObject().methods().get(signal.methodIndex()).cppMethodSignature();
            initialize_native(this, sender, signalSignature, sourceState);
        }else {
            throw new IllegalArgumentException("Signal is not owned by a QObject.");
        }
    }
    
    /**
     * Sets the signal associated with this signal transition.
     */
    @QtUninvokable
    public final void setSignal(io.qt.core.QMetaObject.AbstractSignal signal){
        if(signal.containingObject() instanceof io.qt.core.QObject) {
            io.qt.core.QObject sender = (io.qt.core.QObject)signal.containingObject();
            String signalSignature = "2" + sender.metaObject().methods().get(signal.methodIndex()).cppMethodSignature();
            setSenderObject(sender);
            setSignal(new io.qt.core.QByteArray(signalSignature));
        }else {
            throw new IllegalArgumentException("Signal is not owned by a QObject.");
        }
    }
    
    /**
     * <p>Overloaded constructor for {@link #QSignalTransition(io.qt.statemachine.QState)}
     *  with <code>sourceState = null</code>.</p>
     */
    public QSignalTransition() {
        this((io.qt.statemachine.QState)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QSignalTransition(io.qt.core.QObject, java.lang.String, io.qt.statemachine.QState)}
     *  with <code>sourceState = null</code>.</p>
     */
    public QSignalTransition(io.qt.core.@Nullable QObject sender, java.lang.@Nullable String signal) {
        this(sender, signal, (io.qt.statemachine.QState)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #senderObject()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@Nullable QObject getSenderObject() {
        return senderObject();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #signal()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray getSignal() {
        return signal();
    }
}
