package io.qt.statemachine;

import io.qt.*;


/**
 * <p>Means of returning to a previously active substate</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qhistorystate.html">QHistoryState</a></code></p>
 */
public class QHistoryState extends io.qt.statemachine.QAbstractState
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QHistoryState.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qhistorystate.html#HistoryType-enum">QHistoryState::HistoryType</a></code></p>
     */
    public enum HistoryType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qhistorystate.html#HistoryType-enum">QHistoryState::<wbr>ShallowHistory</a></code></p>
         */
        ShallowHistory(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qhistorystate.html#HistoryType-enum">QHistoryState::<wbr>DeepHistory</a></code></p>
         */
        DeepHistory(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private HistoryType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull HistoryType resolve(int value) {
            switch (value) {
            case 0: return ShallowHistory;
            case 1: return DeepHistory;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhistorystate.html#defaultStateChanged">QHistoryState::<wbr>defaultStateChanged()</a></code></p>
     */
    @QtPropertyNotify(name="defaultState")
    public final @NonNull PrivateSignal0 defaultStateChanged = new PrivateSignal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhistorystate.html#defaultTransitionChanged">QHistoryState::<wbr>defaultTransitionChanged()</a></code></p>
     */
    @QtPropertyNotify(name="defaultTransition")
    public final @NonNull PrivateSignal0 defaultTransitionChanged = new PrivateSignal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhistorystate.html#historyTypeChanged">QHistoryState::<wbr>historyTypeChanged()</a></code></p>
     */
    @QtPropertyNotify(name="historyType")
    public final @NonNull PrivateSignal0 historyTypeChanged = new PrivateSignal0();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhistorystate.html#QHistoryState-1">QHistoryState::<wbr>QHistoryState(QHistoryState::HistoryType,<wbr>QState*)</a></code></p>
     */
    public QHistoryState(io.qt.statemachine.QHistoryState.@NonNull HistoryType type, io.qt.statemachine.@Nullable QState parent){
        super((QPrivateConstructor)null);
        initialize_native(this, type, parent);
    }
    
    private native static void initialize_native(QHistoryState instance, io.qt.statemachine.QHistoryState.HistoryType type, io.qt.statemachine.QState parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhistorystate.html#QHistoryState">QHistoryState::<wbr>QHistoryState(QState*)</a></code></p>
     */
    public QHistoryState(io.qt.statemachine.@Nullable QState parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QHistoryState instance, io.qt.statemachine.QState parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhistorystate.html#defaultTransition-prop">QHistoryState::<wbr>bindableDefaultTransition()</a></code></p>
     */
    @QtPropertyBindable(name="defaultTransition")
    @QtUninvokable
    public final io.qt.core.@NonNull QBindable<io.qt.statemachine.@Nullable QAbstractTransition> bindableDefaultTransition(){
        return bindableDefaultTransition_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBindable<io.qt.statemachine.QAbstractTransition> bindableDefaultTransition_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhistorystate.html#historyType-prop">QHistoryState::<wbr>bindableHistoryType()</a></code></p>
     */
    @QtPropertyBindable(name="historyType")
    @QtUninvokable
    public final io.qt.core.@NonNull QBindable<io.qt.statemachine.QHistoryState.@NonNull HistoryType> bindableHistoryType(){
        return bindableHistoryType_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBindable<io.qt.statemachine.QHistoryState.HistoryType> bindableHistoryType_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhistorystate.html#defaultState">QHistoryState::<wbr>defaultState()const</a></code></p>
     */
    @QtPropertyReader(name="defaultState")
    @QtUninvokable
    public final io.qt.statemachine.@Nullable QAbstractState defaultState(){
        return defaultState_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.statemachine.QAbstractState defaultState_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhistorystate.html#defaultTransition">QHistoryState::<wbr>defaultTransition()const</a></code></p>
     */
    @QtPropertyReader(name="defaultTransition")
    @QtUninvokable
    public final io.qt.statemachine.@Nullable QAbstractTransition defaultTransition(){
        return defaultTransition_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.statemachine.QAbstractTransition defaultTransition_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhistorystate.html#historyType">QHistoryState::<wbr>historyType()const</a></code></p>
     */
    @QtPropertyReader(name="historyType")
    @QtUninvokable
    public final io.qt.statemachine.QHistoryState.@NonNull HistoryType historyType(){
        return io.qt.statemachine.QHistoryState.HistoryType.resolve(historyType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int historyType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhistorystate.html#setDefaultState">QHistoryState::<wbr>setDefaultState(QAbstractState*)</a></code></p>
     */
    @QtPropertyWriter(name="defaultState")
    @QtUninvokable
    public final void setDefaultState(io.qt.statemachine.@Nullable QAbstractState state){
        setDefaultState_native_QAbstractState_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(state));
        QtJambi_LibraryUtilities.internal.addReferenceCount(defaultTransition(), QAbstractTransition.class, "__rcTargetStates", false, false, state);
    }
    
    @QtUninvokable
    private native void setDefaultState_native_QAbstractState_ptr(long __this__nativeId, long state);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhistorystate.html#setDefaultTransition">QHistoryState::<wbr>setDefaultTransition(QAbstractTransition*)</a></code></p>
     */
    @QtPropertyWriter(name="defaultTransition")
    @QtUninvokable
    public final void setDefaultTransition(io.qt.statemachine.@Nullable QAbstractTransition transition){
        setDefaultTransition_native_QAbstractTransition_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(transition));
    }
    
    @QtUninvokable
    private native void setDefaultTransition_native_QAbstractTransition_ptr(long __this__nativeId, long transition);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qhistorystate.html#setHistoryType">QHistoryState::<wbr>setHistoryType(QHistoryState::HistoryType)</a></code></p>
     */
    @QtPropertyWriter(name="historyType")
    @QtUninvokable
    public final void setHistoryType(io.qt.statemachine.QHistoryState.@NonNull HistoryType type){
        setHistoryType_native_QHistoryState_HistoryType(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @QtUninvokable
    private native void setHistoryType_native_QHistoryState_HistoryType(long __this__nativeId, int type);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qobject.html#event">QObject::<wbr>event(QEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    public boolean event(io.qt.core.@Nullable QEvent e){
        return event_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @QtUninvokable
    private native boolean event_native_QEvent_ptr(long __this__nativeId, long e);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractstate.html#onEntry">QAbstractState::<wbr>onEntry(QEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void onEntry(io.qt.core.@Nullable QEvent event){
        onEntry_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void onEntry_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractstate.html#onExit">QAbstractState::<wbr>onExit(QEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void onExit(io.qt.core.@Nullable QEvent event){
        onExit_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void onExit_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QHistoryState(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QHistoryState(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QHistoryState instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QHistoryState(io.qt.statemachine.QHistoryState.HistoryType, io.qt.statemachine.QState)}
     *  with <code>parent = null</code>.</p>
     */
    public QHistoryState(io.qt.statemachine.QHistoryState.@NonNull HistoryType type) {
        this(type, (io.qt.statemachine.QState)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QHistoryState(io.qt.statemachine.QState)}
     *  with <code>parent = null</code>.</p>
     */
    public QHistoryState() {
        this((io.qt.statemachine.QState)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #defaultState()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.statemachine.@Nullable QAbstractState getDefaultState() {
        return defaultState();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #defaultTransition()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.statemachine.@Nullable QAbstractTransition getDefaultTransition() {
        return defaultTransition();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #historyType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.statemachine.QHistoryState.@NonNull HistoryType getHistoryType() {
        return historyType();
    }
}
