package io.qt.statemachine;

import io.qt.*;


/**
 * <p>General-purpose state for QStateMachine</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qstate.html">QState</a></code></p>
 */
public class QState extends io.qt.statemachine.QAbstractState
{
    @QtPropertyMember(enabled=false)
    private Object __rcErrorState = null;
    @QtPropertyMember(enabled=false)
    private Object __rcInitialState = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QState.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qstate.html#ChildMode-enum">QState::ChildMode</a></code></p>
     */
    public enum ChildMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qstate.html#ChildMode-enum">QState::<wbr>ExclusiveStates</a></code></p>
         */
        ExclusiveStates(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qstate.html#ChildMode-enum">QState::<wbr>ParallelStates</a></code></p>
         */
        ParallelStates(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ChildMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ChildMode resolve(int value) {
            switch (value) {
            case 0: return ExclusiveStates;
            case 1: return ParallelStates;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qstate.html#RestorePolicy-enum">QState::RestorePolicy</a></code></p>
     */
    public enum RestorePolicy implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qstate.html#RestorePolicy-enum">QState::<wbr>DontRestoreProperties</a></code></p>
         */
        DontRestoreProperties(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qstate.html#RestorePolicy-enum">QState::<wbr>RestoreProperties</a></code></p>
         */
        RestoreProperties(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private RestorePolicy(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull RestorePolicy resolve(int value) {
            switch (value) {
            case 0: return DontRestoreProperties;
            case 1: return RestoreProperties;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qstate.html#childModeChanged">QState::<wbr>childModeChanged()</a></code></p>
     */
    @QtPropertyNotify(name="childMode")
    public final @NonNull PrivateSignal0 childModeChanged = new PrivateSignal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qstate.html#errorStateChanged">QState::<wbr>errorStateChanged()</a></code></p>
     */
    @QtPropertyNotify(name="errorState")
    public final @NonNull PrivateSignal0 errorStateChanged = new PrivateSignal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qstate.html#finished">QState::<wbr>finished()</a></code></p>
     */
    public final @NonNull PrivateSignal0 finished = new PrivateSignal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qstate.html#initialStateChanged">QState::<wbr>initialStateChanged()</a></code></p>
     */
    @QtPropertyNotify(name="initialState")
    public final @NonNull PrivateSignal0 initialStateChanged = new PrivateSignal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qstate.html#propertiesAssigned">QState::<wbr>propertiesAssigned()</a></code></p>
     */
    public final @NonNull PrivateSignal0 propertiesAssigned = new PrivateSignal0();
    
    /**
     * <p>Overloaded constructor for {@link #QState(io.qt.statemachine.QState)}
     *  with <code>parent = null</code>.</p>
     */
    public QState() {
        this((io.qt.statemachine.QState)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qstate.html#QState">QState::<wbr>QState(QState*)</a></code></p>
     */
    public QState(io.qt.statemachine.@Nullable QState parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QState instance, io.qt.statemachine.QState parent);
    
    /**
     * <p>Overloaded constructor for {@link #QState(io.qt.statemachine.QState.ChildMode, io.qt.statemachine.QState)}
     *  with <code>parent = null</code>.</p>
     */
    public QState(io.qt.statemachine.QState.@NonNull ChildMode childMode) {
        this(childMode, (io.qt.statemachine.QState)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qstate.html#QState-1">QState::<wbr>QState(QState::ChildMode,<wbr>QState*)</a></code></p>
     */
    public QState(io.qt.statemachine.QState.@NonNull ChildMode childMode, io.qt.statemachine.@Nullable QState parent){
        super((QPrivateConstructor)null);
        initialize_native(this, childMode, parent);
    }
    
    private native static void initialize_native(QState instance, io.qt.statemachine.QState.ChildMode childMode, io.qt.statemachine.QState parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qstate.html#addTransition-3">QState::<wbr>addTransition(QAbstractState*)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.statemachine.@Nullable QAbstractTransition addTransition(io.qt.statemachine.@StrictNonNull QAbstractState target){
        java.util.Objects.requireNonNull(target, "Argument 'target': null not expected.");
        io.qt.statemachine.@Nullable QAbstractTransition __qt_return_value = addTransition_native_QAbstractState_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(target));
        QtJambi_LibraryUtilities.internal.addReferenceCount(__qt_return_value, QAbstractTransition.class, "__rcTargetStates", false, false, target);
        return __qt_return_value;
    }
    
    @QtUninvokable
    private native io.qt.statemachine.QAbstractTransition addTransition_native_QAbstractState_ptr(long __this__nativeId, long target);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qstate.html#addTransition">QState::<wbr>addTransition(QAbstractTransition*)</a></code></p>
     */
    @QtUninvokable
    public final void addTransition(io.qt.statemachine.@StrictNonNull QAbstractTransition transition){
        java.util.Objects.requireNonNull(transition, "Argument 'transition': null not expected.");
        addTransition_native_QAbstractTransition_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(transition));
    }
    
    @QtUninvokable
    private native void addTransition_native_QAbstractTransition_ptr(long __this__nativeId, long transition);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qstate.html#addTransition-1">QState::<wbr>addTransition(const QObject*,<wbr>const char*,<wbr>QAbstractState*)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.statemachine.@Nullable QSignalTransition addTransition(io.qt.core.@StrictNonNull QObject sender, java.lang.@Nullable String signal, io.qt.statemachine.@StrictNonNull QAbstractState target){
        if(signal==null || signal.isEmpty())
            return null;
        if(!signal.startsWith("2")){
            io.qt.core.QMetaMethod method = sender.metaObject().method(signal);
            if(method!=null && method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal) {
                signal = "2" + method.cppMethodSignature();
            }
        }
        java.util.Objects.requireNonNull(sender, "Argument 'sender': null not expected.");
        java.util.Objects.requireNonNull(target, "Argument 'target': null not expected.");
        io.qt.statemachine.@Nullable QSignalTransition __qt_return_value = addTransition_native_const_QObject_ptr_const_char_ptr_QAbstractState_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sender), signal, QtJambi_LibraryUtilities.internal.checkedNativeId(target));
        QtJambi_LibraryUtilities.internal.addReferenceCount(__qt_return_value, QAbstractTransition.class, "__rcTargetStates", false, false, target);
        return __qt_return_value;
    }
    
    @QtUninvokable
    private native io.qt.statemachine.QSignalTransition addTransition_native_const_QObject_ptr_const_char_ptr_QAbstractState_ptr(long __this__nativeId, long sender, java.lang.String signal, long target);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qstate.html#assignProperty">QState::<wbr>assignProperty(QObject*,<wbr>const char*,<wbr>QVariant)</a></code></p>
     */
    @QtUninvokable
    public final void assignProperty(io.qt.core.@Nullable QObject object, java.lang.@Nullable String name, java.lang.Object value){
        assignProperty_native_QObject_ptr_const_char_ptr_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object), name, value);
    }
    
    @QtUninvokable
    private native void assignProperty_native_QObject_ptr_const_char_ptr_cref_QVariant(long __this__nativeId, long object, java.lang.String name, java.lang.Object value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qstate.html#childMode-prop">QState::<wbr>bindableChildMode()</a></code></p>
     */
    @QtPropertyBindable(name="childMode")
    @QtUninvokable
    public final io.qt.core.@NonNull QBindable<io.qt.statemachine.QState.@NonNull ChildMode> bindableChildMode(){
        return bindableChildMode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBindable<io.qt.statemachine.QState.ChildMode> bindableChildMode_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qstate.html#errorState-prop">QState::<wbr>bindableErrorState()</a></code></p>
     */
    @QtPropertyBindable(name="errorState")
    @QtUninvokable
    public final io.qt.core.@NonNull QBindable<io.qt.statemachine.@Nullable QAbstractState> bindableErrorState(){
        return bindableErrorState_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBindable<io.qt.statemachine.QAbstractState> bindableErrorState_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qstate.html#initialState-prop">QState::<wbr>bindableInitialState()</a></code></p>
     */
    @QtPropertyBindable(name="initialState")
    @QtUninvokable
    public final io.qt.core.@NonNull QBindable<io.qt.statemachine.@Nullable QAbstractState> bindableInitialState(){
        return bindableInitialState_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBindable<io.qt.statemachine.QAbstractState> bindableInitialState_native(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #childMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.statemachine.QState.@NonNull ChildMode getChildMode() {
        return childMode();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qstate.html#childMode">QState::<wbr>childMode()const</a></code></p>
     */
    @QtPropertyReader(name="childMode")
    @QtUninvokable
    public final io.qt.statemachine.QState.@NonNull ChildMode childMode(){
        return io.qt.statemachine.QState.ChildMode.resolve(childMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int childMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #errorState()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.statemachine.@Nullable QAbstractState getErrorState() {
        return errorState();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qstate.html#errorState">QState::<wbr>errorState()const</a></code></p>
     */
    @QtPropertyReader(name="errorState")
    @QtUninvokable
    public final io.qt.statemachine.@Nullable QAbstractState errorState(){
        return errorState_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.statemachine.QAbstractState errorState_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #initialState()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.statemachine.@Nullable QAbstractState getInitialState() {
        return initialState();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qstate.html#initialState">QState::<wbr>initialState()const</a></code></p>
     */
    @QtPropertyReader(name="initialState")
    @QtUninvokable
    public final io.qt.statemachine.@Nullable QAbstractState initialState(){
        return initialState_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.statemachine.QAbstractState initialState_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qstate.html#removeTransition">QState::<wbr>removeTransition(QAbstractTransition*)</a></code></p>
     */
    @QtUninvokable
    public final void removeTransition(io.qt.statemachine.@Nullable QAbstractTransition transition){
        removeTransition_native_QAbstractTransition_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(transition));
    }
    
    @QtUninvokable
    private native void removeTransition_native_QAbstractTransition_ptr(long __this__nativeId, long transition);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qstate.html#setChildMode">QState::<wbr>setChildMode(QState::ChildMode)</a></code></p>
     */
    @QtPropertyWriter(name="childMode")
    @QtUninvokable
    public final void setChildMode(io.qt.statemachine.QState.@NonNull ChildMode mode){
        setChildMode_native_QState_ChildMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    @QtUninvokable
    private native void setChildMode_native_QState_ChildMode(long __this__nativeId, int mode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qstate.html#setErrorState">QState::<wbr>setErrorState(QAbstractState*)</a></code></p>
     */
    @QtPropertyWriter(name="errorState")
    @QtUninvokable
    public final void setErrorState(io.qt.statemachine.@Nullable QAbstractState state){
        setErrorState_native_QAbstractState_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(state));
        __rcErrorState = state;
    }
    
    @QtUninvokable
    private native void setErrorState_native_QAbstractState_ptr(long __this__nativeId, long state);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qstate.html#setInitialState">QState::<wbr>setInitialState(QAbstractState*)</a></code></p>
     */
    @QtPropertyWriter(name="initialState")
    @QtUninvokable
    public final void setInitialState(io.qt.statemachine.@Nullable QAbstractState state){
        setInitialState_native_QAbstractState_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(state));
        __rcInitialState = state;
    }
    
    @QtUninvokable
    private native void setInitialState_native_QAbstractState_ptr(long __this__nativeId, long state);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qstate.html#transitions">QState::<wbr>transitions()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.statemachine.@Nullable QAbstractTransition> transitions(){
        return transitions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.statemachine.QAbstractTransition> transitions_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qobject.html#event">QObject::<wbr>event(QEvent*)</a></code></p>
     */
    @QtUninvokable
    public boolean event(io.qt.core.@Nullable QEvent e){
        return event_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @QtUninvokable
    private native boolean event_native_QEvent_ptr(long __this__nativeId, long e);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractstate.html#onEntry">QAbstractState::<wbr>onEntry(QEvent*)</a></code></p>
     */
    @QtUninvokable
    protected void onEntry(io.qt.core.@Nullable QEvent event){
        onEntry_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void onEntry_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractstate.html#onExit">QAbstractState::<wbr>onExit(QEvent*)</a></code></p>
     */
    @QtUninvokable
    protected void onExit(io.qt.core.@Nullable QEvent event){
        onExit_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void onExit_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QState(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QState(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QState instance, QDeclarativeConstructor constructor);
    
    /**
     * Adds a transition associated with the given signal of the given sender object, and returns the new QSignalTransition object. 
     * The transition has this state as the source, and the given target as the target state.
     */
    @QtUninvokable
    public final QSignalTransition addTransition(io.qt.core.QMetaObject.AbstractSignal signal, QAbstractState target) {
        if(signal.containingObject() instanceof io.qt.core.QObject && signal.methodIndex()!=0) {
            io.qt.core.QObject sender = (io.qt.core.QObject)signal.containingObject();
            String signalSignature = "2" + sender.metaObject().methods().get(signal.methodIndex()).cppMethodSignature();
            return addTransition(sender, signalSignature, target);
        }else {
            throw new IllegalArgumentException("Signal is not owned by a QObject.");
        }
    }
}
