package io.qt.statemachine;

import io.qt.*;


/**
 * <p>The base class of transitions between QAbstractState objects</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qabstracttransition.html">QAbstractTransition</a></code></p>
 */
public abstract class QAbstractTransition extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcAnimation;
    @QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcTargetStates;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractTransition.class);
    
    @NativeAccess
    private static final class ConcreteWrapper extends QAbstractTransition {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        protected boolean eventTest(io.qt.core.@Nullable QEvent event){
            return eventTest_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
        }
        @QtUninvokable
        private native boolean eventTest_native_QEvent_ptr(long __this__nativeId, long event);
        
        
        @Override
        @QtUninvokable
        protected void onTransition(io.qt.core.@Nullable QEvent event){
            onTransition_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
        }
        @QtUninvokable
        private native void onTransition_native_QEvent_ptr(long __this__nativeId, long event);
        
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qabstracttransition.html#TransitionType-enum">QAbstractTransition::TransitionType</a></code></p>
     */
    public enum TransitionType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstracttransition.html#TransitionType-enum">QAbstractTransition::<wbr>ExternalTransition</a></code></p>
         */
        ExternalTransition(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstracttransition.html#TransitionType-enum">QAbstractTransition::<wbr>InternalTransition</a></code></p>
         */
        InternalTransition(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private TransitionType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull TransitionType resolve(int value) {
            switch (value) {
            case 0: return ExternalTransition;
            case 1: return InternalTransition;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstracttransition.html#targetStateChanged">QAbstractTransition::<wbr>targetStateChanged()</a></code></p>
     */
    @QtPropertyNotify(name="targetState")
    public final @NonNull PrivateSignal0 targetStateChanged = new PrivateSignal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstracttransition.html#targetStatesChanged">QAbstractTransition::<wbr>targetStatesChanged()</a></code></p>
     */
    @QtPropertyNotify(name="targetStates")
    public final @NonNull PrivateSignal0 targetStatesChanged = new PrivateSignal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstracttransition.html#triggered">QAbstractTransition::<wbr>triggered()</a></code></p>
     */
    public final @NonNull PrivateSignal0 triggered = new PrivateSignal0();
    
    /**
     * <p>Overloaded constructor for {@link #QAbstractTransition(io.qt.statemachine.QState)}
     *  with <code>sourceState = null</code>.</p>
     */
    public QAbstractTransition() {
        this((io.qt.statemachine.QState)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstracttransition.html#QAbstractTransition">QAbstractTransition::<wbr>QAbstractTransition(QState*)</a></code></p>
     */
    public QAbstractTransition(io.qt.statemachine.@Nullable QState sourceState){
        super((QPrivateConstructor)null);
        initialize_native(this, sourceState);
    }
    
    private native static void initialize_native(QAbstractTransition instance, io.qt.statemachine.QState sourceState);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstracttransition.html#addAnimation">QAbstractTransition::<wbr>addAnimation(QAbstractAnimation*)</a></code></p>
     */
    @QtUninvokable
    public final void addAnimation(io.qt.core.@Nullable QAbstractAnimation animation){
        addAnimation_native_QAbstractAnimation_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(animation));
        if (animation != null) {
            if(__rcAnimation==null)
                __rcAnimation = QtJambi_LibraryUtilities.internal.newRCList();
            __rcAnimation.add(animation);
        }
    }
    
    @QtUninvokable
    private native void addAnimation_native_QAbstractAnimation_ptr(long __this__nativeId, long animation);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstracttransition.html#animations">QAbstractTransition::<wbr>animations()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.core.@Nullable QAbstractAnimation> animations(){
        return animations_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.core.QAbstractAnimation> animations_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstracttransition.html#transitionType-prop">QAbstractTransition::<wbr>bindableTransitionType()</a></code></p>
     */
    @QtPropertyBindable(name="transitionType")
    @QtUninvokable
    public final io.qt.core.@NonNull QBindable<io.qt.statemachine.QAbstractTransition.@NonNull TransitionType> bindableTransitionType(){
        return bindableTransitionType_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBindable<io.qt.statemachine.QAbstractTransition.TransitionType> bindableTransitionType_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstracttransition.html#machine">QAbstractTransition::<wbr>machine()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.statemachine.@Nullable QStateMachine machine(){
        return machine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.statemachine.QStateMachine machine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstracttransition.html#removeAnimation">QAbstractTransition::<wbr>removeAnimation(QAbstractAnimation*)</a></code></p>
     */
    @QtUninvokable
    public final void removeAnimation(io.qt.core.@Nullable QAbstractAnimation animation){
        removeAnimation_native_QAbstractAnimation_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(animation));
        if (animation != null) {
            while (__rcAnimation != null && __rcAnimation.remove(animation)) ;
        }
    }
    
    @QtUninvokable
    private native void removeAnimation_native_QAbstractAnimation_ptr(long __this__nativeId, long animation);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstracttransition.html#setTargetState">QAbstractTransition::<wbr>setTargetState(QAbstractState*)</a></code></p>
     */
    @QtPropertyWriter(name="targetState")
    @QtUninvokable
    public final void setTargetState(io.qt.statemachine.@Nullable QAbstractState target){
        setTargetState_native_QAbstractState_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(target));
        if (target != null) {
            if(__rcTargetStates!=null)
                __rcTargetStates.clear();
            if(__rcTargetStates==null)
                __rcTargetStates = QtJambi_LibraryUtilities.internal.newRCList();
            __rcTargetStates.add(target);
        }
    }
    
    @QtUninvokable
    private native void setTargetState_native_QAbstractState_ptr(long __this__nativeId, long target);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstracttransition.html#setTargetStates">QAbstractTransition::<wbr>setTargetStates(QList&lt;QAbstractState*&gt;)</a></code></p>
     */
    @QtPropertyWriter(name="targetStates")
    @QtUninvokable
    public final void setTargetStates(java.util.@NonNull Collection<? extends io.qt.statemachine.@Nullable QAbstractState> targets){
        setTargetStates_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), targets);
        if (targets != null) {
            if(__rcTargetStates!=null)
                __rcTargetStates.clear();
            if(__rcTargetStates==null)
                __rcTargetStates = QtJambi_LibraryUtilities.internal.newRCList();
            __rcTargetStates.addAll(targets);
        }
    }
    
    @QtUninvokable
    private native void setTargetStates_native_cref_QList(long __this__nativeId, java.util.Collection<? extends io.qt.statemachine.QAbstractState> targets);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstracttransition.html#setTransitionType">QAbstractTransition::<wbr>setTransitionType(QAbstractTransition::TransitionType)</a></code></p>
     */
    @QtPropertyWriter(name="transitionType")
    @QtUninvokable
    public final void setTransitionType(io.qt.statemachine.QAbstractTransition.@NonNull TransitionType type){
        setTransitionType_native_QAbstractTransition_TransitionType(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @QtUninvokable
    private native void setTransitionType_native_QAbstractTransition_TransitionType(long __this__nativeId, int type);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #sourceState()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.statemachine.@Nullable QState getSourceState() {
        return sourceState();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstracttransition.html#sourceState">QAbstractTransition::<wbr>sourceState()const</a></code></p>
     */
    @QtPropertyReader(name="sourceState")
    @QtUninvokable
    public final io.qt.statemachine.@Nullable QState sourceState(){
        return sourceState_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.statemachine.QState sourceState_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #targetState()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.statemachine.@Nullable QAbstractState getTargetState() {
        return targetState();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstracttransition.html#targetState">QAbstractTransition::<wbr>targetState()const</a></code></p>
     */
    @QtPropertyReader(name="targetState")
    @QtUninvokable
    public final io.qt.statemachine.@Nullable QAbstractState targetState(){
        return targetState_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.statemachine.QAbstractState targetState_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #targetStates()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.statemachine.@Nullable QAbstractState> getTargetStates() {
        return targetStates();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstracttransition.html#targetStates">QAbstractTransition::<wbr>targetStates()const</a></code></p>
     */
    @QtPropertyReader(name="targetStates")
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.statemachine.@Nullable QAbstractState> targetStates(){
        return targetStates_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.statemachine.QAbstractState> targetStates_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #transitionType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.statemachine.QAbstractTransition.@NonNull TransitionType getTransitionType() {
        return transitionType();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstracttransition.html#transitionType">QAbstractTransition::<wbr>transitionType()const</a></code></p>
     */
    @QtPropertyReader(name="transitionType")
    @QtUninvokable
    public final io.qt.statemachine.QAbstractTransition.@NonNull TransitionType transitionType(){
        return io.qt.statemachine.QAbstractTransition.TransitionType.resolve(transitionType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int transitionType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qobject.html#event">QObject::<wbr>event(QEvent*)</a></code></p>
     */
    @QtUninvokable
    public boolean event(io.qt.core.@Nullable QEvent e){
        return event_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @QtUninvokable
    private native boolean event_native_QEvent_ptr(long __this__nativeId, long e);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstracttransition.html#eventTest">QAbstractTransition::<wbr>eventTest(QEvent*)</a></code></p>
     */
    @QtUninvokable
    protected abstract boolean eventTest(io.qt.core.@Nullable QEvent event);
    
    @QtUninvokable
    private native boolean eventTest_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstracttransition.html#onTransition">QAbstractTransition::<wbr>onTransition(QEvent*)</a></code></p>
     */
    @QtUninvokable
    protected abstract void onTransition(io.qt.core.@Nullable QEvent event);
    
    @QtUninvokable
    private native void onTransition_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAbstractTransition(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QAbstractTransition(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAbstractTransition instance, QDeclarativeConstructor constructor);
    
}
