package io.qt.statemachine;

import io.qt.*;


/**
 * <p>Hierarchical finite state machine</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qstatemachine.html">QStateMachine</a></p>
 */
public class QStateMachine extends io.qt.statemachine.QState
{
    @QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcDefaultAnimations;
    @QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcStates;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QStateMachine.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qstatemachine.html#Error-enum">QStateMachine::Error</a></p>
     */
    @QtUnlistedEnum
    public enum Error implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qstatemachine.html#Error-enum">QStateMachine::NoError</a></p>
         */
        NoError(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qstatemachine.html#Error-enum">QStateMachine::NoInitialStateError</a></p>
         */
        NoInitialStateError(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qstatemachine.html#Error-enum">QStateMachine::NoDefaultStateInHistoryStateError</a></p>
         */
        NoDefaultStateInHistoryStateError(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qstatemachine.html#Error-enum">QStateMachine::NoCommonAncestorForTransitionError</a></p>
         */
        NoCommonAncestorForTransitionError(3),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qstatemachine.html#Error-enum">QStateMachine::StateMachineChildModeSetToParallelError</a></p>
         */
        StateMachineChildModeSetToParallelError(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Error(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Error resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return NoInitialStateError;
            case 2: return NoDefaultStateInHistoryStateError;
            case 3: return NoCommonAncestorForTransitionError;
            case 4: return StateMachineChildModeSetToParallelError;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qstatemachine.html#EventPriority-enum">QStateMachine::EventPriority</a></p>
     */
    @QtUnlistedEnum
    public enum EventPriority implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qstatemachine.html#EventPriority-enum">QStateMachine::NormalPriority</a></p>
         */
        NormalPriority(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qstatemachine.html#EventPriority-enum">QStateMachine::HighPriority</a></p>
         */
        HighPriority(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private EventPriority(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull EventPriority resolve(int value) {
            switch (value) {
            case 0: return NormalPriority;
            case 1: return HighPriority;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>Represents a Qt signal event</p>
     * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qstatemachine-signalevent.html">QStateMachine::SignalEvent</a></p>
     */
    public static class SignalEvent extends io.qt.core.QEvent
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        public SignalEvent(io.qt.core.@Nullable QObject sender, int signalIndex, java.util.@NonNull Collection<? extends java.lang.Object> arguments){
            super((QPrivateConstructor)null);
            initialize_native(this, sender, signalIndex, arguments);
        }
        
        private native static void initialize_native(SignalEvent instance, io.qt.core.QObject sender, int signalIndex, java.util.Collection<? extends java.lang.Object> arguments);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qstatemachine-signalevent.html#arguments">QStateMachine::SignalEvent::arguments()const</a></p>
         */
        @QtUninvokable
        public final io.qt.core.@NonNull QList<java.lang.Object> arguments(){
            return arguments_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native io.qt.core.QList<java.lang.Object> arguments_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qstatemachine-signalevent.html#sender">QStateMachine::SignalEvent::sender()const</a></p>
         */
        @QtUninvokable
        public final io.qt.core.@Nullable QObject sender(){
            return sender_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native io.qt.core.QObject sender_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qstatemachine-signalevent.html#signalIndex">QStateMachine::SignalEvent::signalIndex()const</a></p>
         */
        @QtUninvokable
        public final int signalIndex(){
            return signalIndex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native int signalIndex_native_constfct(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @NativeAccess
        protected SignalEvent(QPrivateConstructor p) { super(p); } 
        

        @Override
        @QtUninvokable
        public @NonNull String toString() {
            return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private static native String toString_native(long __this_nativeId);
    }
    /**
     * <p>Inherits QEvent and holds a clone of an event associated with a QObject</p>
     * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qstatemachine-wrappedevent.html">QStateMachine::WrappedEvent</a></p>
     */
    public static class WrappedEvent extends io.qt.core.QEvent
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        public WrappedEvent(io.qt.core.@Nullable QObject object, io.qt.core.@Nullable QEvent event){
            super((QPrivateConstructor)null);
            initialize_native(this, object, event);
        }
        
        private native static void initialize_native(WrappedEvent instance, io.qt.core.QObject object, io.qt.core.QEvent event);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qstatemachine-wrappedevent.html#event">QStateMachine::WrappedEvent::event()const</a></p>
         */
        @QtUninvokable
        public final io.qt.core.@Nullable QEvent event(){
            return event_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native io.qt.core.QEvent event_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qstatemachine-wrappedevent.html#object">QStateMachine::WrappedEvent::object()const</a></p>
         */
        @QtUninvokable
        public final io.qt.core.@Nullable QObject object(){
            return object_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native io.qt.core.QObject object_native_constfct(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @NativeAccess
        protected WrappedEvent(QPrivateConstructor p) { super(p); } 
        

        @Override
        @QtUninvokable
        public @NonNull String toString() {
            return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private static native String toString_native(long __this_nativeId);
    }


    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#runningChanged">QStateMachine::runningChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="running")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> runningChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#started">QStateMachine::started()</a></p>
     */
    public final @NonNull PrivateSignal0 started = new PrivateSignal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#stopped">QStateMachine::stopped()</a></p>
     */
    public final @NonNull PrivateSignal0 stopped = new PrivateSignal0();
    
    /**
     * <p>Overloaded constructor for {@link #QStateMachine(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QStateMachine() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#QStateMachine">QStateMachine::QStateMachine(QObject*)</a></p>
     */
    public QStateMachine(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QStateMachine instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QStateMachine(io.qt.statemachine.QState.ChildMode, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QStateMachine(io.qt.statemachine.QState.@NonNull ChildMode childMode) {
        this(childMode, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#QStateMachine">QStateMachine::QStateMachine(QState::ChildMode,QObject*)</a></p>
     */
    public QStateMachine(io.qt.statemachine.QState.@NonNull ChildMode childMode, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, childMode, parent);
    }
    
    private native static void initialize_native(QStateMachine instance, io.qt.statemachine.QState.ChildMode childMode, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#addDefaultAnimation">QStateMachine::addDefaultAnimation(QAbstractAnimation*)</a></p>
     */
    @QtUninvokable
    public final void addDefaultAnimation(io.qt.core.@Nullable QAbstractAnimation animation){
        addDefaultAnimation_native_QAbstractAnimation_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(animation));
        if (animation != null) {
            if(__rcDefaultAnimations==null)
                __rcDefaultAnimations = QtJambi_LibraryUtilities.internal.newRCList();
            __rcDefaultAnimations.add(animation);
        }
    }
    
    @QtUninvokable
    private native void addDefaultAnimation_native_QAbstractAnimation_ptr(long __this__nativeId, long animation);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#addState">QStateMachine::addState(QAbstractState*)</a></p>
     */
    @QtUninvokable
    public final void addState(io.qt.statemachine.@Nullable QAbstractState state){
        addState_native_QAbstractState_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(state));
        if (state != null) {
            if(__rcStates==null)
                __rcStates = QtJambi_LibraryUtilities.internal.newRCList();
            __rcStates.add(state);
        }
    }
    
    @QtUninvokable
    private native void addState_native_QAbstractState_ptr(long __this__nativeId, long state);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#animated-prop">QStateMachine::bindableAnimated()</a></p>
     */
    @QtPropertyBindable(name="animated")
    @QtUninvokable
    public final io.qt.core.@NonNull QBooleanBindable bindableAnimated(){
        return bindableAnimated_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBooleanBindable bindableAnimated_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#errorString-prop">QStateMachine::bindableErrorString()const</a></p>
     */
    @QtPropertyBindable(name="errorString")
    @QtUninvokable
    public final io.qt.core.@NonNull QBindable<java.lang.@NonNull String> bindableErrorString(){
        return bindableErrorString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBindable<java.lang.String> bindableErrorString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#globalRestorePolicy-prop">QStateMachine::bindableGlobalRestorePolicy()</a></p>
     */
    @QtPropertyBindable(name="globalRestorePolicy")
    @QtUninvokable
    public final io.qt.core.@NonNull QBindable<io.qt.statemachine.QState.@NonNull RestorePolicy> bindableGlobalRestorePolicy(){
        return bindableGlobalRestorePolicy_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBindable<io.qt.statemachine.QState.RestorePolicy> bindableGlobalRestorePolicy_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#cancelDelayedEvent">QStateMachine::cancelDelayedEvent(int)</a></p>
     */
    @QtUninvokable
    public final boolean cancelDelayedEvent(int id){
        return cancelDelayedEvent_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @QtUninvokable
    private native boolean cancelDelayedEvent_native_int(long __this__nativeId, int id);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#clearError">QStateMachine::clearError()</a></p>
     */
    @QtUninvokable
    public final void clearError(){
        clearError_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void clearError_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#configuration">QStateMachine::configuration()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QSet<io.qt.statemachine.@Nullable QAbstractState> configuration(){
        return configuration_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QSet<io.qt.statemachine.QAbstractState> configuration_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#defaultAnimations">QStateMachine::defaultAnimations()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.core.@Nullable QAbstractAnimation> defaultAnimations(){
        return defaultAnimations_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.core.QAbstractAnimation> defaultAnimations_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#error">QStateMachine::error()const</a></p>
     */
    @QtUninvokable
    public final io.qt.statemachine.QStateMachine.@NonNull Error error(){
        return io.qt.statemachine.QStateMachine.Error.resolve(error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int error_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #errorString()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getErrorString() {
        return errorString();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#errorString">QStateMachine::errorString()const</a></p>
     */
    @QtPropertyReader(name="errorString")
    @QtUninvokable
    public final java.lang.@NonNull String errorString(){
        return errorString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String errorString_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #globalRestorePolicy()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.statemachine.QState.@NonNull RestorePolicy getGlobalRestorePolicy() {
        return globalRestorePolicy();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#globalRestorePolicy">QStateMachine::globalRestorePolicy()const</a></p>
     */
    @QtPropertyReader(name="globalRestorePolicy")
    @QtUninvokable
    public final io.qt.statemachine.QState.@NonNull RestorePolicy globalRestorePolicy(){
        return io.qt.statemachine.QState.RestorePolicy.resolve(globalRestorePolicy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int globalRestorePolicy_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isAnimated()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAnimated() {
        return isAnimated();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#isAnimated">QStateMachine::isAnimated()const</a></p>
     */
    @QtPropertyReader(name="animated")
    @QtUninvokable
    public final boolean isAnimated(){
        return isAnimated_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isAnimated_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isRunning()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getRunning() {
        return isRunning();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#running-prop">QStateMachine::isRunning()const</a></p>
     */
    @QtPropertyReader(name="running")
    @QtUninvokable
    public final boolean isRunning(){
        return isRunning_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isRunning_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#postDelayedEvent">QStateMachine::postDelayedEvent(QEvent*,int)</a></p>
     */
    @QtUninvokable
    public final int postDelayedEvent(io.qt.core.@Nullable QEvent event, int delay){
        return postDelayedEvent_native_QEvent_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event), delay);
    }
    
    @QtUninvokable
    private native int postDelayedEvent_native_QEvent_ptr_int(long __this__nativeId, long event, int delay);
    
    /**
     * <p>Overloaded function for {@link #postEvent(io.qt.core.QEvent, io.qt.statemachine.QStateMachine.EventPriority)}
     *  with <code>priority = io.qt.statemachine.QStateMachine.EventPriority.NormalPriority</code>.</p>
     */
    @QtUninvokable
    public final void postEvent(io.qt.core.@Nullable QEvent event) {
        postEvent(event, io.qt.statemachine.QStateMachine.EventPriority.NormalPriority);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#postEvent">QStateMachine::postEvent(QEvent*,QStateMachine::EventPriority)</a></p>
     */
    @QtUninvokable
    public final void postEvent(io.qt.core.@Nullable QEvent event, io.qt.statemachine.QStateMachine.@NonNull EventPriority priority){
        postEvent_native_QEvent_ptr_QStateMachine_EventPriority(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event), priority.value());
    }
    
    @QtUninvokable
    private native void postEvent_native_QEvent_ptr_QStateMachine_EventPriority(long __this__nativeId, long event, int priority);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#removeDefaultAnimation">QStateMachine::removeDefaultAnimation(QAbstractAnimation*)</a></p>
     */
    @QtUninvokable
    public final void removeDefaultAnimation(io.qt.core.@Nullable QAbstractAnimation animation){
        removeDefaultAnimation_native_QAbstractAnimation_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(animation));
        if (animation != null) {
            while (__rcDefaultAnimations != null && __rcDefaultAnimations.remove(animation)) ;
        }
    }
    
    @QtUninvokable
    private native void removeDefaultAnimation_native_QAbstractAnimation_ptr(long __this__nativeId, long animation);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#removeState">QStateMachine::removeState(QAbstractState*)</a></p>
     */
    @QtUninvokable
    public final void removeState(io.qt.statemachine.@Nullable QAbstractState state){
        removeState_native_QAbstractState_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(state));
        if (state != null) {
            while (__rcStates != null && __rcStates.remove(state)) ;
        }
    }
    
    @QtUninvokable
    private native void removeState_native_QAbstractState_ptr(long __this__nativeId, long state);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#setAnimated">QStateMachine::setAnimated(bool)</a></p>
     */
    @QtPropertyWriter(name="animated")
    @QtUninvokable
    public final void setAnimated(boolean enabled){
        setAnimated_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setAnimated_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#setGlobalRestorePolicy">QStateMachine::setGlobalRestorePolicy(QState::RestorePolicy)</a></p>
     */
    @QtPropertyWriter(name="globalRestorePolicy")
    @QtUninvokable
    public final void setGlobalRestorePolicy(io.qt.statemachine.QState.@NonNull RestorePolicy restorePolicy){
        setGlobalRestorePolicy_native_QState_RestorePolicy(QtJambi_LibraryUtilities.internal.nativeId(this), restorePolicy.value());
    }
    
    @QtUninvokable
    private native void setGlobalRestorePolicy_native_QState_RestorePolicy(long __this__nativeId, int restorePolicy);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#running-prop">QStateMachine::setRunning(bool)</a></p>
     */
    @QtPropertyWriter(name="running")
    public final void setRunning(boolean running){
        setRunning_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), running);
    }
    
    private native void setRunning_native_bool(long __this__nativeId, boolean running);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#start">QStateMachine::start()</a></p>
     */
    public final void start(){
        start_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void start_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qstatemachine.html#stop">QStateMachine::stop()</a></p>
     */
    public final void stop(){
        stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void stop_native(long __this__nativeId);
    
    @QtUninvokable
    protected void beginMicrostep(io.qt.core.@Nullable QEvent event){
        beginMicrostep_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void beginMicrostep_native_QEvent_ptr(long __this__nativeId, long event);
    
    @QtUninvokable
    protected void beginSelectTransitions(io.qt.core.@Nullable QEvent event){
        beginSelectTransitions_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void beginSelectTransitions_native_QEvent_ptr(long __this__nativeId, long event);
    
    @QtUninvokable
    protected void endMicrostep(io.qt.core.@Nullable QEvent event){
        endMicrostep_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void endMicrostep_native_QEvent_ptr(long __this__nativeId, long event);
    
    @QtUninvokable
    protected void endSelectTransitions(io.qt.core.@Nullable QEvent event){
        endSelectTransitions_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void endSelectTransitions_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qobject.html#event">QObject::event(QEvent*)</a></p>
     */
    @QtUninvokable
    public boolean event(io.qt.core.@Nullable QEvent e){
        return event_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @QtUninvokable
    private native boolean event_native_QEvent_ptr(long __this__nativeId, long e);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qobject.html#eventFilter">QObject::eventFilter(QObject*,QEvent*)</a></p>
     */
    @QtUninvokable
    public boolean eventFilter(io.qt.core.@Nullable QObject watched, io.qt.core.@Nullable QEvent event){
        return eventFilter_native_QObject_ptr_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(watched), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native boolean eventFilter_native_QObject_ptr_QEvent_ptr(long __this__nativeId, long watched, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractstate.html#onEntry">QAbstractState::onEntry(QEvent*)</a></p>
     */
    @QtUninvokable
    protected void onEntry(io.qt.core.@Nullable QEvent event){
        onEntry_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void onEntry_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractstate.html#onExit">QAbstractState::onExit(QEvent*)</a></p>
     */
    @QtUninvokable
    protected void onExit(io.qt.core.@Nullable QEvent event){
        onExit_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void onExit_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QStateMachine(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QStateMachine(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QStateMachine instance, QDeclarativeConstructor constructor);
    
}
