package io.qt.statemachine;

import io.qt.*;


/**
 * <p>Transition based on a Qt signal</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsignaltransition.html">QSignalTransition</a></p>
 */
public class QSignalTransition extends io.qt.statemachine.QAbstractTransition
{
    @QtPropertyMember(enabled=false)
    private Object __rcSenderObject = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSignalTransition.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsignaltransition.html#senderObjectChanged">QSignalTransition::senderObjectChanged()</a></p>
     */
    @QtPropertyNotify(name="senderObject")
    public final @NonNull PrivateSignal0 senderObjectChanged = new PrivateSignal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsignaltransition.html#signalChanged">QSignalTransition::signalChanged()</a></p>
     */
    @QtPropertyNotify(name="signal")
    public final @NonNull PrivateSignal0 signalChanged = new PrivateSignal0();
    
    /**
     * <p>Overloaded constructor for {@link #QSignalTransition(io.qt.statemachine.QState)}
     *  with <code>sourceState = null</code>.</p>
     */
    public QSignalTransition() {
        this((io.qt.statemachine.QState)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsignaltransition.html#QSignalTransition">QSignalTransition::QSignalTransition(QState*)</a></p>
     */
    public QSignalTransition(io.qt.statemachine.@Nullable QState sourceState){
        super((QPrivateConstructor)null);
        initialize_native(this, sourceState);
    }
    
    private native static void initialize_native(QSignalTransition instance, io.qt.statemachine.QState sourceState);
    
    /**
     * <p>Overloaded constructor for {@link #QSignalTransition(io.qt.core.QObject, java.lang.String, io.qt.statemachine.QState)}
     *  with <code>sourceState = null</code>.</p>
     */
    public QSignalTransition(io.qt.core.@Nullable QObject sender, java.lang.@Nullable String signal) {
        this(sender, signal, (io.qt.statemachine.QState)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsignaltransition.html#QSignalTransition-1">QSignalTransition::QSignalTransition(const QObject*,const char*,QState*)</a></p>
     */
    public QSignalTransition(io.qt.core.@Nullable QObject sender, java.lang.@Nullable String signal, io.qt.statemachine.@Nullable QState sourceState){
        super((QPrivateConstructor)null);
        if(signal!=null && !signal.startsWith("2")){
            io.qt.core.QMetaMethod method = sender.metaObject().method(signal);
            if(method!=null && method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal) {
                signal = "2" + method.cppMethodSignature();
            }
        }
        initialize_native(this, sender, signal, sourceState);
    }
    
    private native static void initialize_native(QSignalTransition instance, io.qt.core.QObject sender, java.lang.String signal, io.qt.statemachine.QState sourceState);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsignaltransition.html#senderObject-prop">QSignalTransition::bindableSenderObject()</a></p>
     */
    @QtPropertyBindable(name="senderObject")
    @QtUninvokable
    public final io.qt.core.@NonNull QBindable<io.qt.core.@Nullable QObject> bindableSenderObject(){
        return bindableSenderObject_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBindable<io.qt.core.QObject> bindableSenderObject_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsignaltransition.html#signal-prop">QSignalTransition::bindableSignal()</a></p>
     */
    @QtPropertyBindable(name="signal")
    @QtUninvokable
    public final io.qt.core.@NonNull QBindable<io.qt.core.@NonNull QByteArray> bindableSignal(){
        return bindableSignal_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBindable<io.qt.core.QByteArray> bindableSignal_native(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #senderObject()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@Nullable QObject getSenderObject() {
        return senderObject();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsignaltransition.html#senderObject">QSignalTransition::senderObject()const</a></p>
     */
    @QtPropertyReader(name="senderObject")
    @QtUninvokable
    public final io.qt.core.@Nullable QObject senderObject(){
        return senderObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QObject senderObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsignaltransition.html#setSenderObject">QSignalTransition::setSenderObject(const QObject*)</a></p>
     */
    @QtPropertyWriter(name="senderObject")
    @QtUninvokable
    public final void setSenderObject(io.qt.core.@Nullable QObject sender){
        setSenderObject_native_const_QObject_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sender));
        __rcSenderObject = sender;
    }
    
    @QtUninvokable
    private native void setSenderObject_native_const_QObject_ptr(long __this__nativeId, long sender);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsignaltransition.html#setSignal">QSignalTransition::setSignal(QByteArray)</a></p>
     */
    @QtPropertyWriter(name="signal")
    @QtUninvokable
    public final void setSignal(io.qt.core.@NonNull QByteArray signal){
        if(signal!=null && !signal.startsWith("2")){
            io.qt.core.QMetaMethod method = senderObject().metaObject().method(signal.toString());
            if(method!=null && method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal) {
                signal = new io.qt.core.QByteArray("2");
                signal.append(method.cppMethodSignature());
            }
        }
        setSignal_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(signal));
    }
    
    @QtUninvokable
    private native void setSignal_native_cref_QByteArray(long __this__nativeId, long signal);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #signal()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray getSignal() {
        return signal();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsignaltransition.html#signal">QSignalTransition::signal()const</a></p>
     */
    @QtPropertyReader(name="signal")
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray signal(){
        return signal_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray signal_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qobject.html#event">QObject::event(QEvent*)</a></p>
     */
    @QtUninvokable
    public boolean event(io.qt.core.@Nullable QEvent e){
        return event_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @QtUninvokable
    private native boolean event_native_QEvent_ptr(long __this__nativeId, long e);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstracttransition.html#eventTest">QAbstractTransition::eventTest(QEvent*)</a></p>
     */
    @QtUninvokable
    protected boolean eventTest(io.qt.core.@Nullable QEvent event){
        return eventTest_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native boolean eventTest_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstracttransition.html#onTransition">QAbstractTransition::onTransition(QEvent*)</a></p>
     */
    @QtUninvokable
    protected void onTransition(io.qt.core.@Nullable QEvent event){
        onTransition_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void onTransition_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QSignalTransition(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QSignalTransition(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QSignalTransition instance, QDeclarativeConstructor constructor);
    
    /**
     * Overloaded constructor for {@link #QSignalTransition(io.qt.core.QMetaObject.AbstractSignal, io.qt.core.QState)}.
     */
    public QSignalTransition(io.qt.core.QMetaObject.AbstractSignal signal) {
        this(signal, null);
    }
    
    /**
     * Constructs a new signal transition associated with the given signal of the given sender object and with the given sourceState.
     */
    public QSignalTransition(io.qt.core.QMetaObject.AbstractSignal signal, QState sourceState) {
        super((QPrivateConstructor)null);
        if(signal.containingObject() instanceof io.qt.core.QObject) {
            io.qt.core.QObject sender = (io.qt.core.QObject)signal.containingObject();
            String signalSignature = "2" + sender.metaObject().methods().get(signal.methodIndex()).cppMethodSignature();
            initialize_native(this, sender, signalSignature, sourceState);
        }else {
            throw new IllegalArgumentException("Signal is not owned by a QObject.");
        }
    }
    
    /**
     * Sets the signal associated with this signal transition.
     */
    @QtUninvokable
    public final void setSignal(io.qt.core.QMetaObject.AbstractSignal signal){
        if(signal.containingObject() instanceof io.qt.core.QObject) {
            io.qt.core.QObject sender = (io.qt.core.QObject)signal.containingObject();
            String signalSignature = "2" + sender.metaObject().methods().get(signal.methodIndex()).cppMethodSignature();
            setSenderObject(sender);
            setSignal(new io.qt.core.QByteArray(signalSignature));
        }else {
            throw new IllegalArgumentException("Signal is not owned by a QObject.");
        }
    }
}
