package io.qt.statemachine;

import io.qt.*;


/**
 * <p>Transition for mouse events</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qmouseeventtransition.html">QMouseEventTransition</a></p>
 */
public class QMouseEventTransition extends io.qt.statemachine.QEventTransition
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QMouseEventTransition.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #QMouseEventTransition(io.qt.core.QObject, io.qt.core.QEvent.Type, io.qt.core.Qt.MouseButton, io.qt.statemachine.QState)}
     *  with <code>sourceState = null</code>.</p>
     */
    public QMouseEventTransition(io.qt.core.@Nullable QObject object, io.qt.core.QEvent.@NonNull Type type, io.qt.core.Qt.@NonNull MouseButton button) {
        this(object, type, button, (io.qt.statemachine.QState)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qmouseeventtransition.html#QMouseEventTransition-1">QMouseEventTransition::QMouseEventTransition(QObject*,QEvent::Type,Qt::MouseButton,QState*)</a></p>
     */
    public QMouseEventTransition(io.qt.core.@Nullable QObject object, io.qt.core.QEvent.@NonNull Type type, io.qt.core.Qt.@NonNull MouseButton button, io.qt.statemachine.@Nullable QState sourceState){
        super((QPrivateConstructor)null);
        initialize_native(this, object, type, button, sourceState);
    }
    
    private native static void initialize_native(QMouseEventTransition instance, io.qt.core.QObject object, io.qt.core.QEvent.Type type, io.qt.core.Qt.MouseButton button, io.qt.statemachine.QState sourceState);
    
    /**
     * <p>Overloaded constructor for {@link #QMouseEventTransition(io.qt.statemachine.QState)}
     *  with <code>sourceState = null</code>.</p>
     */
    public QMouseEventTransition() {
        this((io.qt.statemachine.QState)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qmouseeventtransition.html#QMouseEventTransition">QMouseEventTransition::QMouseEventTransition(QState*)</a></p>
     */
    public QMouseEventTransition(io.qt.statemachine.@Nullable QState sourceState){
        super((QPrivateConstructor)null);
        initialize_native(this, sourceState);
    }
    
    private native static void initialize_native(QMouseEventTransition instance, io.qt.statemachine.QState sourceState);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qmouseeventtransition.html#button-prop">QMouseEventTransition::bindableButton()</a></p>
     */
    @QtPropertyBindable(name="button")
    @QtUninvokable
    public final io.qt.core.@NonNull QBindable<io.qt.core.Qt.@NonNull MouseButton> bindableButton(){
        return bindableButton_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBindable<io.qt.core.Qt.MouseButton> bindableButton_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qmouseeventtransition.html#modifierMask-prop">QMouseEventTransition::bindableModifierMask()</a></p>
     */
    @QtPropertyBindable(name="modifierMask")
    @QtUninvokable
    public final io.qt.core.@NonNull QBindable<io.qt.core.Qt.@NonNull KeyboardModifiers> bindableModifierMask(){
        return bindableModifierMask_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBindable<io.qt.core.Qt.KeyboardModifiers> bindableModifierMask_native(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #button()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.Qt.@NonNull MouseButton getButton() {
        return button();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qmouseeventtransition.html#button">QMouseEventTransition::button()const</a></p>
     */
    @QtPropertyReader(name="button")
    @QtUninvokable
    public final io.qt.core.Qt.@NonNull MouseButton button(){
        return io.qt.core.Qt.MouseButton.resolve(button_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int button_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qmouseeventtransition.html#hitTestPath">QMouseEventTransition::hitTestPath()const</a></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QPainterPath hitTestPath(){
        return hitTestPath_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QPainterPath hitTestPath_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #modifierMask()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.Qt.@NonNull KeyboardModifiers getModifierMask() {
        return modifierMask();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qmouseeventtransition.html#modifierMask">QMouseEventTransition::modifierMask()const</a></p>
     */
    @QtPropertyReader(name="modifierMask")
    @QtUninvokable
    public final io.qt.core.Qt.@NonNull KeyboardModifiers modifierMask(){
        return new io.qt.core.Qt.KeyboardModifiers(modifierMask_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int modifierMask_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qmouseeventtransition.html#setButton">QMouseEventTransition::setButton(Qt::MouseButton)</a></p>
     */
    @QtPropertyWriter(name="button")
    @QtUninvokable
    public final void setButton(io.qt.core.Qt.@NonNull MouseButton button){
        setButton_native_Qt_MouseButton(QtJambi_LibraryUtilities.internal.nativeId(this), button.value());
    }
    
    @QtUninvokable
    private native void setButton_native_Qt_MouseButton(long __this__nativeId, int button);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qmouseeventtransition.html#setHitTestPath">QMouseEventTransition::setHitTestPath(QPainterPath)</a></p>
     */
    @QtUninvokable
    public final void setHitTestPath(io.qt.gui.@NonNull QPainterPath path){
        setHitTestPath_native_cref_QPainterPath(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(path));
    }
    
    @QtUninvokable
    private native void setHitTestPath_native_cref_QPainterPath(long __this__nativeId, long path);
    
    /**
     * <p>Overloaded function for {@link #setModifierMask(io.qt.core.Qt.KeyboardModifiers)}.</p>
     */
    @QtUninvokable
    public final void setModifierMask(io.qt.core.Qt.@NonNull KeyboardModifier @NonNull... modifiers){
        setModifierMask(new io.qt.core.Qt.KeyboardModifiers(modifiers));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qmouseeventtransition.html#setModifierMask">QMouseEventTransition::setModifierMask(Qt::KeyboardModifiers)</a></p>
     */
    @QtPropertyWriter(name="modifierMask")
    @QtUninvokable
    public final void setModifierMask(io.qt.core.Qt.@NonNull KeyboardModifiers modifiers){
        setModifierMask_native_Qt_KeyboardModifiers(QtJambi_LibraryUtilities.internal.nativeId(this), modifiers.value());
    }
    
    @QtUninvokable
    private native void setModifierMask_native_Qt_KeyboardModifiers(long __this__nativeId, int modifiers);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstracttransition.html#eventTest">QAbstractTransition::eventTest(QEvent*)</a></p>
     */
    @QtUninvokable
    protected boolean eventTest(io.qt.core.@Nullable QEvent event){
        return eventTest_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native boolean eventTest_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstracttransition.html#onTransition">QAbstractTransition::onTransition(QEvent*)</a></p>
     */
    @QtUninvokable
    protected void onTransition(io.qt.core.@Nullable QEvent event){
        onTransition_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void onTransition_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QMouseEventTransition(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QMouseEventTransition(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QMouseEventTransition instance, QDeclarativeConstructor constructor);
    
}
