package io.qt.statemachine;

import io.qt.*;


/**
 * <p>Transition for key events</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qkeyeventtransition.html">QKeyEventTransition</a></p>
 */
public class QKeyEventTransition extends io.qt.statemachine.QEventTransition
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QKeyEventTransition.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #QKeyEventTransition(io.qt.core.QObject, io.qt.core.QEvent.Type, int, io.qt.statemachine.QState)}
     *  with <code>sourceState = null</code>.</p>
     */
    public QKeyEventTransition(io.qt.core.@Nullable QObject object, io.qt.core.QEvent.@NonNull Type type, int key) {
        this(object, type, key, (io.qt.statemachine.QState)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qkeyeventtransition.html#QKeyEventTransition-1">QKeyEventTransition::QKeyEventTransition(QObject*,QEvent::Type,int,QState*)</a></p>
     */
    public QKeyEventTransition(io.qt.core.@Nullable QObject object, io.qt.core.QEvent.@NonNull Type type, int key, io.qt.statemachine.@Nullable QState sourceState){
        super((QPrivateConstructor)null);
        initialize_native(this, object, type, key, sourceState);
    }
    
    private native static void initialize_native(QKeyEventTransition instance, io.qt.core.QObject object, io.qt.core.QEvent.Type type, int key, io.qt.statemachine.QState sourceState);
    
    /**
     * <p>Overloaded constructor for {@link #QKeyEventTransition(io.qt.statemachine.QState)}
     *  with <code>sourceState = null</code>.</p>
     */
    public QKeyEventTransition() {
        this((io.qt.statemachine.QState)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qkeyeventtransition.html#QKeyEventTransition">QKeyEventTransition::QKeyEventTransition(QState*)</a></p>
     */
    public QKeyEventTransition(io.qt.statemachine.@Nullable QState sourceState){
        super((QPrivateConstructor)null);
        initialize_native(this, sourceState);
    }
    
    private native static void initialize_native(QKeyEventTransition instance, io.qt.statemachine.QState sourceState);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qkeyeventtransition.html#key-prop">QKeyEventTransition::bindableKey()</a></p>
     */
    @QtPropertyBindable(name="key")
    @QtUninvokable
    public final io.qt.core.@NonNull QIntBindable bindableKey(){
        return bindableKey_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QIntBindable bindableKey_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qkeyeventtransition.html#modifierMask-prop">QKeyEventTransition::bindableModifierMask()</a></p>
     */
    @QtPropertyBindable(name="modifierMask")
    @QtUninvokable
    public final io.qt.core.@NonNull QBindable<io.qt.core.Qt.@NonNull KeyboardModifiers> bindableModifierMask(){
        return bindableModifierMask_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBindable<io.qt.core.Qt.KeyboardModifiers> bindableModifierMask_native(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #key()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getKey() {
        return key();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qkeyeventtransition.html#key">QKeyEventTransition::key()const</a></p>
     */
    @QtPropertyReader(name="key")
    @QtUninvokable
    public final int key(){
        return key_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int key_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #modifierMask()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.Qt.@NonNull KeyboardModifiers getModifierMask() {
        return modifierMask();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qkeyeventtransition.html#modifierMask">QKeyEventTransition::modifierMask()const</a></p>
     */
    @QtPropertyReader(name="modifierMask")
    @QtUninvokable
    public final io.qt.core.Qt.@NonNull KeyboardModifiers modifierMask(){
        return new io.qt.core.Qt.KeyboardModifiers(modifierMask_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int modifierMask_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qkeyeventtransition.html#setKey">QKeyEventTransition::setKey(int)</a></p>
     */
    @QtPropertyWriter(name="key")
    @QtUninvokable
    public final void setKey(int key){
        setKey_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), key);
    }
    
    @QtUninvokable
    private native void setKey_native_int(long __this__nativeId, int key);
    
    /**
     * <p>Overloaded function for {@link #setModifierMask(io.qt.core.Qt.KeyboardModifiers)}.</p>
     */
    @QtUninvokable
    public final void setModifierMask(io.qt.core.Qt.@NonNull KeyboardModifier @NonNull... modifiers){
        setModifierMask(new io.qt.core.Qt.KeyboardModifiers(modifiers));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qkeyeventtransition.html#setModifierMask">QKeyEventTransition::setModifierMask(Qt::KeyboardModifiers)</a></p>
     */
    @QtPropertyWriter(name="modifierMask")
    @QtUninvokable
    public final void setModifierMask(io.qt.core.Qt.@NonNull KeyboardModifiers modifiers){
        setModifierMask_native_Qt_KeyboardModifiers(QtJambi_LibraryUtilities.internal.nativeId(this), modifiers.value());
    }
    
    @QtUninvokable
    private native void setModifierMask_native_Qt_KeyboardModifiers(long __this__nativeId, int modifiers);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstracttransition.html#eventTest">QAbstractTransition::eventTest(QEvent*)</a></p>
     */
    @QtUninvokable
    protected boolean eventTest(io.qt.core.@Nullable QEvent event){
        return eventTest_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native boolean eventTest_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstracttransition.html#onTransition">QAbstractTransition::onTransition(QEvent*)</a></p>
     */
    @QtUninvokable
    protected void onTransition(io.qt.core.@Nullable QEvent event){
        onTransition_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void onTransition_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QKeyEventTransition(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QKeyEventTransition(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QKeyEventTransition instance, QDeclarativeConstructor constructor);
    
}
