package io.qt.statemachine;

import io.qt.*;


/**
 * <p>QObject-specific transition for Qt events</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qeventtransition.html">QEventTransition</a></p>
 */
public class QEventTransition extends io.qt.statemachine.QAbstractTransition
{
    @QtPropertyMember(enabled=false)
    private Object __rcEventSource = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QEventTransition.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #QEventTransition(io.qt.core.QObject, io.qt.core.QEvent.Type, io.qt.statemachine.QState)}
     *  with <code>sourceState = null</code>.</p>
     */
    public QEventTransition(io.qt.core.@Nullable QObject object, io.qt.core.QEvent.@NonNull Type type) {
        this(object, type, (io.qt.statemachine.QState)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qeventtransition.html#QEventTransition-1">QEventTransition::QEventTransition(QObject*,QEvent::Type,QState*)</a></p>
     */
    public QEventTransition(io.qt.core.@Nullable QObject object, io.qt.core.QEvent.@NonNull Type type, io.qt.statemachine.@Nullable QState sourceState){
        super((QPrivateConstructor)null);
        initialize_native(this, object, type, sourceState);
    }
    
    private native static void initialize_native(QEventTransition instance, io.qt.core.QObject object, io.qt.core.QEvent.Type type, io.qt.statemachine.QState sourceState);
    
    /**
     * <p>Overloaded constructor for {@link #QEventTransition(io.qt.statemachine.QState)}
     *  with <code>sourceState = null</code>.</p>
     */
    public QEventTransition() {
        this((io.qt.statemachine.QState)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qeventtransition.html#QEventTransition">QEventTransition::QEventTransition(QState*)</a></p>
     */
    public QEventTransition(io.qt.statemachine.@Nullable QState sourceState){
        super((QPrivateConstructor)null);
        initialize_native(this, sourceState);
    }
    
    private native static void initialize_native(QEventTransition instance, io.qt.statemachine.QState sourceState);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qeventtransition.html#eventSource-prop">QEventTransition::bindableEventSource()</a></p>
     */
    @QtPropertyBindable(name="eventSource")
    @QtUninvokable
    public final io.qt.core.@NonNull QBindable<io.qt.core.@Nullable QObject> bindableEventSource(){
        return bindableEventSource_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBindable<io.qt.core.QObject> bindableEventSource_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qeventtransition.html#eventType-prop">QEventTransition::bindableEventType()</a></p>
     */
    @QtPropertyBindable(name="eventType")
    @QtUninvokable
    public final io.qt.core.@NonNull QBindable<io.qt.core.QEvent.@NonNull Type> bindableEventType(){
        return bindableEventType_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBindable<io.qt.core.QEvent.Type> bindableEventType_native(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #eventSource()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@Nullable QObject getEventSource() {
        return eventSource();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qeventtransition.html#eventSource">QEventTransition::eventSource()const</a></p>
     */
    @QtPropertyReader(name="eventSource")
    @QtUninvokable
    public final io.qt.core.@Nullable QObject eventSource(){
        return eventSource_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QObject eventSource_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #eventType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.QEvent.@NonNull Type getEventType() {
        return eventType();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qeventtransition.html#eventType">QEventTransition::eventType()const</a></p>
     */
    @QtPropertyReader(name="eventType")
    @QtUninvokable
    public final io.qt.core.QEvent.@NonNull Type eventType(){
        return io.qt.core.QEvent.Type.resolve(eventType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int eventType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qeventtransition.html#setEventSource">QEventTransition::setEventSource(QObject*)</a></p>
     */
    @QtPropertyWriter(name="eventSource")
    @QtUninvokable
    public final void setEventSource(io.qt.core.@Nullable QObject object){
        setEventSource_native_QObject_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object));
        __rcEventSource = object;
    }
    
    @QtUninvokable
    private native void setEventSource_native_QObject_ptr(long __this__nativeId, long object);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qeventtransition.html#setEventType">QEventTransition::setEventType(QEvent::Type)</a></p>
     */
    @QtPropertyWriter(name="eventType")
    @QtUninvokable
    public final void setEventType(io.qt.core.QEvent.@NonNull Type type){
        setEventType_native_QEvent_Type(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @QtUninvokable
    private native void setEventType_native_QEvent_Type(long __this__nativeId, int type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qobject.html#event">QObject::event(QEvent*)</a></p>
     */
    @QtUninvokable
    public boolean event(io.qt.core.@Nullable QEvent e){
        return event_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @QtUninvokable
    private native boolean event_native_QEvent_ptr(long __this__nativeId, long e);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstracttransition.html#eventTest">QAbstractTransition::eventTest(QEvent*)</a></p>
     */
    @QtUninvokable
    protected boolean eventTest(io.qt.core.@Nullable QEvent event){
        return eventTest_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native boolean eventTest_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstracttransition.html#onTransition">QAbstractTransition::onTransition(QEvent*)</a></p>
     */
    @QtUninvokable
    protected void onTransition(io.qt.core.@Nullable QEvent event){
        onTransition_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void onTransition_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QEventTransition(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QEventTransition(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QEventTransition instance, QDeclarativeConstructor constructor);
    
}
