package io.qt.statemachine;

import io.qt.*;


/**
 * <p>The base class of transitions between QAbstractState objects</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qabstracttransition.html">QAbstractTransition</a></p>
 */
public abstract class QAbstractTransition extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcAnimation;
    @QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcTargetStates;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractTransition.class);
    
    @NativeAccess
    private static final class ConcreteWrapper extends QAbstractTransition {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        protected boolean eventTest(io.qt.core.@Nullable QEvent event){
            return eventTest_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
        }
        @QtUninvokable
        private native boolean eventTest_native_QEvent_ptr(long __this__nativeId, long event);
        
        
        @Override
        @QtUninvokable
        protected void onTransition(io.qt.core.@Nullable QEvent event){
            onTransition_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
        }
        @QtUninvokable
        private native void onTransition_native_QEvent_ptr(long __this__nativeId, long event);
        
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qabstracttransition.html#TransitionType-enum">QAbstractTransition::TransitionType</a></p>
     */
    public enum TransitionType implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qabstracttransition.html#TransitionType-enum">QAbstractTransition::ExternalTransition</a></p>
         */
        ExternalTransition(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qabstracttransition.html#TransitionType-enum">QAbstractTransition::InternalTransition</a></p>
         */
        InternalTransition(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private TransitionType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull TransitionType resolve(int value) {
            switch (value) {
            case 0: return ExternalTransition;
            case 1: return InternalTransition;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstracttransition.html#targetStateChanged">QAbstractTransition::targetStateChanged()</a></p>
     */
    @QtPropertyNotify(name="targetState")
    public final @NonNull PrivateSignal0 targetStateChanged = new PrivateSignal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstracttransition.html#targetStatesChanged">QAbstractTransition::targetStatesChanged()</a></p>
     */
    @QtPropertyNotify(name="targetStates")
    public final @NonNull PrivateSignal0 targetStatesChanged = new PrivateSignal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstracttransition.html#triggered">QAbstractTransition::triggered()</a></p>
     */
    public final @NonNull PrivateSignal0 triggered = new PrivateSignal0();
    
    /**
     * <p>Overloaded constructor for {@link #QAbstractTransition(io.qt.statemachine.QState)}
     *  with <code>sourceState = null</code>.</p>
     */
    public QAbstractTransition() {
        this((io.qt.statemachine.QState)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstracttransition.html#QAbstractTransition">QAbstractTransition::QAbstractTransition(QState*)</a></p>
     */
    public QAbstractTransition(io.qt.statemachine.@Nullable QState sourceState){
        super((QPrivateConstructor)null);
        initialize_native(this, sourceState);
    }
    
    private native static void initialize_native(QAbstractTransition instance, io.qt.statemachine.QState sourceState);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstracttransition.html#addAnimation">QAbstractTransition::addAnimation(QAbstractAnimation*)</a></p>
     */
    @QtUninvokable
    public final void addAnimation(io.qt.core.@Nullable QAbstractAnimation animation){
        addAnimation_native_QAbstractAnimation_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(animation));
        if (animation != null) {
            if(__rcAnimation==null)
                __rcAnimation = QtJambi_LibraryUtilities.internal.newRCList();
            __rcAnimation.add(animation);
        }
    }
    
    @QtUninvokable
    private native void addAnimation_native_QAbstractAnimation_ptr(long __this__nativeId, long animation);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstracttransition.html#animations">QAbstractTransition::animations()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.core.@Nullable QAbstractAnimation> animations(){
        return animations_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.core.QAbstractAnimation> animations_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstracttransition.html#transitionType-prop">QAbstractTransition::bindableTransitionType()</a></p>
     */
    @QtPropertyBindable(name="transitionType")
    @QtUninvokable
    public final io.qt.core.@NonNull QBindable<io.qt.statemachine.QAbstractTransition.@NonNull TransitionType> bindableTransitionType(){
        return bindableTransitionType_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBindable<io.qt.statemachine.QAbstractTransition.TransitionType> bindableTransitionType_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstracttransition.html#machine">QAbstractTransition::machine()const</a></p>
     */
    @QtUninvokable
    public final io.qt.statemachine.@Nullable QStateMachine machine(){
        return machine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.statemachine.QStateMachine machine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstracttransition.html#removeAnimation">QAbstractTransition::removeAnimation(QAbstractAnimation*)</a></p>
     */
    @QtUninvokable
    public final void removeAnimation(io.qt.core.@Nullable QAbstractAnimation animation){
        removeAnimation_native_QAbstractAnimation_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(animation));
        if (animation != null) {
            while (__rcAnimation != null && __rcAnimation.remove(animation)) ;
        }
    }
    
    @QtUninvokable
    private native void removeAnimation_native_QAbstractAnimation_ptr(long __this__nativeId, long animation);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstracttransition.html#setTargetState">QAbstractTransition::setTargetState(QAbstractState*)</a></p>
     */
    @QtPropertyWriter(name="targetState")
    @QtUninvokable
    public final void setTargetState(io.qt.statemachine.@Nullable QAbstractState target){
        setTargetState_native_QAbstractState_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(target));
        if (target != null) {
            if(__rcTargetStates!=null)
                __rcTargetStates.clear();
            if(__rcTargetStates==null)
                __rcTargetStates = QtJambi_LibraryUtilities.internal.newRCList();
            __rcTargetStates.add(target);
        }
    }
    
    @QtUninvokable
    private native void setTargetState_native_QAbstractState_ptr(long __this__nativeId, long target);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstracttransition.html#setTargetStates">QAbstractTransition::setTargetStates(QList&lt;QAbstractState*&gt;)</a></p>
     */
    @QtPropertyWriter(name="targetStates")
    @QtUninvokable
    public final void setTargetStates(java.util.@NonNull Collection<? extends io.qt.statemachine.@Nullable QAbstractState> targets){
        setTargetStates_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), targets);
        if (targets != null) {
            if(__rcTargetStates!=null)
                __rcTargetStates.clear();
            if(__rcTargetStates==null)
                __rcTargetStates = QtJambi_LibraryUtilities.internal.newRCList();
            __rcTargetStates.addAll(targets);
        }
    }
    
    @QtUninvokable
    private native void setTargetStates_native_cref_QList(long __this__nativeId, java.util.Collection<? extends io.qt.statemachine.QAbstractState> targets);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstracttransition.html#setTransitionType">QAbstractTransition::setTransitionType(QAbstractTransition::TransitionType)</a></p>
     */
    @QtPropertyWriter(name="transitionType")
    @QtUninvokable
    public final void setTransitionType(io.qt.statemachine.QAbstractTransition.@NonNull TransitionType type){
        setTransitionType_native_QAbstractTransition_TransitionType(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @QtUninvokable
    private native void setTransitionType_native_QAbstractTransition_TransitionType(long __this__nativeId, int type);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #sourceState()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.statemachine.@Nullable QState getSourceState() {
        return sourceState();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstracttransition.html#sourceState">QAbstractTransition::sourceState()const</a></p>
     */
    @QtPropertyReader(name="sourceState")
    @QtUninvokable
    public final io.qt.statemachine.@Nullable QState sourceState(){
        return sourceState_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.statemachine.QState sourceState_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #targetState()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.statemachine.@Nullable QAbstractState getTargetState() {
        return targetState();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstracttransition.html#targetState">QAbstractTransition::targetState()const</a></p>
     */
    @QtPropertyReader(name="targetState")
    @QtUninvokable
    public final io.qt.statemachine.@Nullable QAbstractState targetState(){
        return targetState_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.statemachine.QAbstractState targetState_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #targetStates()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.statemachine.@Nullable QAbstractState> getTargetStates() {
        return targetStates();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstracttransition.html#targetStates">QAbstractTransition::targetStates()const</a></p>
     */
    @QtPropertyReader(name="targetStates")
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.statemachine.@Nullable QAbstractState> targetStates(){
        return targetStates_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.statemachine.QAbstractState> targetStates_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #transitionType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.statemachine.QAbstractTransition.@NonNull TransitionType getTransitionType() {
        return transitionType();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstracttransition.html#transitionType">QAbstractTransition::transitionType()const</a></p>
     */
    @QtPropertyReader(name="transitionType")
    @QtUninvokable
    public final io.qt.statemachine.QAbstractTransition.@NonNull TransitionType transitionType(){
        return io.qt.statemachine.QAbstractTransition.TransitionType.resolve(transitionType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int transitionType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qobject.html#event">QObject::event(QEvent*)</a></p>
     */
    @QtUninvokable
    public boolean event(io.qt.core.@Nullable QEvent e){
        return event_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @QtUninvokable
    private native boolean event_native_QEvent_ptr(long __this__nativeId, long e);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstracttransition.html#eventTest">QAbstractTransition::eventTest(QEvent*)</a></p>
     */
    @QtUninvokable
    protected abstract boolean eventTest(io.qt.core.@Nullable QEvent event);
    
    @QtUninvokable
    private native boolean eventTest_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstracttransition.html#onTransition">QAbstractTransition::onTransition(QEvent*)</a></p>
     */
    @QtUninvokable
    protected abstract void onTransition(io.qt.core.@Nullable QEvent event);
    
    @QtUninvokable
    private native void onTransition_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QAbstractTransition(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QAbstractTransition(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAbstractTransition instance, QDeclarativeConstructor constructor);
    
}
