package io.qt.statemachine;

import io.qt.*;


/**
 * <p>The base class of states of a QStateMachine</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qabstractstate.html">QAbstractState</a></p>
 */
public abstract class QAbstractState extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractState.class);
    
    @NativeAccess
    private static final class ConcreteWrapper extends QAbstractState {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        protected void onEntry(io.qt.core.@Nullable QEvent event){
            onEntry_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
        }
        @QtUninvokable
        private native void onEntry_native_QEvent_ptr(long __this__nativeId, long event);
        
        
        @Override
        @QtUninvokable
        protected void onExit(io.qt.core.@Nullable QEvent event){
            onExit_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
        }
        @QtUninvokable
        private native void onExit_native_QEvent_ptr(long __this__nativeId, long event);
        
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractstate.html#activeChanged">QAbstractState::activeChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="active")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> activeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractstate.html#entered">QAbstractState::entered()</a></p>
     */
    public final @NonNull PrivateSignal0 entered = new PrivateSignal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractstate.html#exited">QAbstractState::exited()</a></p>
     */
    public final @NonNull PrivateSignal0 exited = new PrivateSignal0();
    
    /**
     * <p>Overloaded constructor for {@link #QAbstractState(io.qt.statemachine.QState)}
     *  with <code>parent = null</code>.</p>
     */
    protected QAbstractState() {
        this((io.qt.statemachine.QState)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractstate.html#QAbstractState">QAbstractState::QAbstractState(QState*)</a></p>
     */
    protected QAbstractState(io.qt.statemachine.@Nullable QState parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAbstractState instance, io.qt.statemachine.QState parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #active()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getActive() {
        return active();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractstate.html#active">QAbstractState::active()const</a></p>
     */
    @QtPropertyReader(name="active")
    @QtUninvokable
    public final boolean active(){
        return active_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean active_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractstate.html#active-prop">QAbstractState::bindableActive()</a></p>
     */
    @QtPropertyBindable(name="active")
    @QtUninvokable
    public final io.qt.core.@NonNull QBooleanBindable bindableActive(){
        return bindableActive_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBooleanBindable bindableActive_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractstate.html#machine">QAbstractState::machine()const</a></p>
     */
    @QtUninvokable
    public final io.qt.statemachine.@Nullable QStateMachine machine(){
        return machine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.statemachine.QStateMachine machine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractstate.html#parentState">QAbstractState::parentState()const</a></p>
     */
    @QtUninvokable
    public final io.qt.statemachine.@Nullable QState parentState(){
        return parentState_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.statemachine.QState parentState_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qobject.html#event">QObject::event(QEvent*)</a></p>
     */
    @QtUninvokable
    public boolean event(io.qt.core.@Nullable QEvent e){
        return event_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @QtUninvokable
    private native boolean event_native_QEvent_ptr(long __this__nativeId, long e);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractstate.html#onEntry">QAbstractState::onEntry(QEvent*)</a></p>
     */
    @QtUninvokable
    protected abstract void onEntry(io.qt.core.@Nullable QEvent event);
    
    @QtUninvokable
    private native void onEntry_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractstate.html#onExit">QAbstractState::onExit(QEvent*)</a></p>
     */
    @QtUninvokable
    protected abstract void onExit(io.qt.core.@Nullable QEvent event);
    
    @QtUninvokable
    private native void onExit_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QAbstractState(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QAbstractState(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAbstractState instance, QDeclarativeConstructor constructor);
    
}
