package io.qt.statemachine;


/**
 * <p>Java wrapper for Qt class QStateMachine</p>
 */
public class QStateMachine extends io.qt.statemachine.QState
{
    @io.qt.QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcDefaultAnimations;
    @io.qt.QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcStates;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QStateMachine.class);
    
    /**
     * <p>Java wrapper for Qt enum QStateMachine::Error</p>
     */
    @io.qt.QtUnlistedEnum
    public enum Error implements io.qt.QtEnumerator {
        NoError(0),
        NoInitialStateError(1),
        NoDefaultStateInHistoryStateError(2),
        NoCommonAncestorForTransitionError(3),
        StateMachineChildModeSetToParallelError(4);

        private Error(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Error resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return NoInitialStateError;
            case 2: return NoDefaultStateInHistoryStateError;
            case 3: return NoCommonAncestorForTransitionError;
            case 4: return StateMachineChildModeSetToParallelError;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum QStateMachine::EventPriority</p>
     */
    @io.qt.QtUnlistedEnum
    public enum EventPriority implements io.qt.QtEnumerator {
        NormalPriority(0),
        HighPriority(1);

        private EventPriority(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static EventPriority resolve(int value) {
            switch (value) {
            case 0: return NormalPriority;
            case 1: return HighPriority;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>Java wrapper for Qt class QStateMachine::SignalEvent</p>
     */
    public static class SignalEvent extends io.qt.core.QEvent
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        public SignalEvent(io.qt.core.QObject sender, int signalIndex, java.util.Collection<java.lang.Object> arguments){
            super((QPrivateConstructor)null);
            initialize_native(this, sender, signalIndex, arguments);
        }
        
        private native static void initialize_native(SignalEvent instance, io.qt.core.QObject sender, int signalIndex, java.util.Collection<java.lang.Object> arguments);
        
        @io.qt.QtUninvokable
        public final io.qt.core.QList<java.lang.Object> arguments(){
            return arguments_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.core.QList<java.lang.Object> arguments_native_constfct(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final io.qt.core.QObject sender(){
            return sender_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.core.QObject sender_native_constfct(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final int signalIndex(){
            return signalIndex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int signalIndex_native_constfct(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected SignalEvent(QPrivateConstructor p) { super(p); } 
        

        @Override
        @io.qt.QtUninvokable
        public String toString() {
            return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private static native String toString_native(long __this_nativeId);
    }
    /**
     * <p>Java wrapper for Qt class QStateMachine::WrappedEvent</p>
     */
    public static class WrappedEvent extends io.qt.core.QEvent
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        public WrappedEvent(io.qt.core.QObject object, io.qt.core.QEvent event){
            super((QPrivateConstructor)null);
            initialize_native(this, object, event);
        }
        
        private native static void initialize_native(WrappedEvent instance, io.qt.core.QObject object, io.qt.core.QEvent event);
        
        @io.qt.QtUninvokable
        public final io.qt.core.QEvent event(){
            return event_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.core.QEvent event_native_constfct(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final io.qt.core.QObject object(){
            return object_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.core.QObject object_native_constfct(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected WrappedEvent(QPrivateConstructor p) { super(p); } 
        

        @Override
        @io.qt.QtUninvokable
        public String toString() {
            return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private static native String toString_native(long __this_nativeId);
    }


    @io.qt.QtPropertyNotify(name="running")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> runningChanged = new Signal1<>();

    public final PrivateSignal0 started = new PrivateSignal0();

    public final PrivateSignal0 stopped = new PrivateSignal0();
    
    /**
     * <p>Overloaded constructor for {@link #QStateMachine(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QStateMachine() {
        this((io.qt.core.QObject)null);
    }
    
    public QStateMachine(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QStateMachine instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QStateMachine(io.qt.statemachine.QState.ChildMode, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QStateMachine(io.qt.statemachine.QState.ChildMode childMode) {
        this(childMode, (io.qt.core.QObject)null);
    }
    
    public QStateMachine(io.qt.statemachine.QState.ChildMode childMode, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, childMode, parent);
    }
    
    private native static void initialize_native(QStateMachine instance, io.qt.statemachine.QState.ChildMode childMode, io.qt.core.QObject parent);
    
    @io.qt.QtUninvokable
    public final void addDefaultAnimation(io.qt.core.QAbstractAnimation animation){
        addDefaultAnimation_native_QAbstractAnimation_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(animation));
        if (animation != null) {
            if(__rcDefaultAnimations==null)
                __rcDefaultAnimations = QtJambi_LibraryUtilities.internal.newRCList();
            __rcDefaultAnimations.add(animation);
        }
    }
    
    @io.qt.QtUninvokable
    private native void addDefaultAnimation_native_QAbstractAnimation_ptr(long __this__nativeId, long animation);
    
    @io.qt.QtUninvokable
    public final void addState(io.qt.statemachine.QAbstractState state){
        addState_native_QAbstractState_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(state));
        if (state != null) {
            if(__rcStates==null)
                __rcStates = QtJambi_LibraryUtilities.internal.newRCList();
            __rcStates.add(state);
        }
    }
    
    @io.qt.QtUninvokable
    private native void addState_native_QAbstractState_ptr(long __this__nativeId, long state);
    
    @io.qt.QtPropertyBindable(name="animated")
    @io.qt.QtUninvokable
    public final io.qt.core.QBooleanBindable bindableAnimated(){
        return bindableAnimated_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QBooleanBindable bindableAnimated_native(long __this__nativeId);
    
    @io.qt.QtPropertyBindable(name="errorString")
    @io.qt.QtUninvokable
    public final io.qt.core.QBindable<java.lang.String> bindableErrorString(){
        return bindableErrorString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QBindable<java.lang.String> bindableErrorString_native_constfct(long __this__nativeId);
    
    @io.qt.QtPropertyBindable(name="globalRestorePolicy")
    @io.qt.QtUninvokable
    public final io.qt.core.QBindable<io.qt.statemachine.QState.RestorePolicy> bindableGlobalRestorePolicy(){
        return bindableGlobalRestorePolicy_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QBindable<io.qt.statemachine.QState.RestorePolicy> bindableGlobalRestorePolicy_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final boolean cancelDelayedEvent(int id){
        return cancelDelayedEvent_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @io.qt.QtUninvokable
    private native boolean cancelDelayedEvent_native_int(long __this__nativeId, int id);
    
    @io.qt.QtUninvokable
    public final void clearError(){
        clearError_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void clearError_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.core.QSet<io.qt.statemachine.QAbstractState> configuration(){
        return configuration_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QSet<io.qt.statemachine.QAbstractState> configuration_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.core.QAbstractAnimation> defaultAnimations(){
        return defaultAnimations_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.core.QAbstractAnimation> defaultAnimations_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.statemachine.QStateMachine.Error error(){
        return io.qt.statemachine.QStateMachine.Error.resolve(error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int error_native_constfct(long __this__nativeId);
    
    @io.qt.QtPropertyReader(name="errorString")
    @io.qt.QtUninvokable
    public final java.lang.String errorString(){
        return errorString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String errorString_native_constfct(long __this__nativeId);
    
    @io.qt.QtPropertyReader(name="globalRestorePolicy")
    @io.qt.QtUninvokable
    public final io.qt.statemachine.QState.RestorePolicy globalRestorePolicy(){
        return io.qt.statemachine.QState.RestorePolicy.resolve(globalRestorePolicy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int globalRestorePolicy_native_constfct(long __this__nativeId);
    
    @io.qt.QtPropertyReader(name="animated")
    @io.qt.QtUninvokable
    public final boolean isAnimated(){
        return isAnimated_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isAnimated_native_constfct(long __this__nativeId);
    
    @io.qt.QtPropertyReader(name="running")
    @io.qt.QtUninvokable
    public final boolean isRunning(){
        return isRunning_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isRunning_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final int postDelayedEvent(io.qt.core.QEvent event, int delay){
        return postDelayedEvent_native_QEvent_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event), delay);
    }
    
    @io.qt.QtUninvokable
    private native int postDelayedEvent_native_QEvent_ptr_int(long __this__nativeId, long event, int delay);
    
    /**
     * <p>Overloaded function for {@link #postEvent(io.qt.core.QEvent, io.qt.statemachine.QStateMachine.EventPriority)}
     *  with <code>priority = io.qt.statemachine.QStateMachine.EventPriority.NormalPriority</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void postEvent(io.qt.core.QEvent event) {
        postEvent(event, io.qt.statemachine.QStateMachine.EventPriority.NormalPriority);
    }
    
    @io.qt.QtUninvokable
    public final void postEvent(io.qt.core.QEvent event, io.qt.statemachine.QStateMachine.EventPriority priority){
        postEvent_native_QEvent_ptr_QStateMachine_EventPriority(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event), priority.value());
    }
    
    @io.qt.QtUninvokable
    private native void postEvent_native_QEvent_ptr_QStateMachine_EventPriority(long __this__nativeId, long event, int priority);
    
    @io.qt.QtUninvokable
    public final void removeDefaultAnimation(io.qt.core.QAbstractAnimation animation){
        removeDefaultAnimation_native_QAbstractAnimation_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(animation));
        if (animation != null) {
            while (__rcDefaultAnimations != null && __rcDefaultAnimations.remove(animation)) ;
        }
    }
    
    @io.qt.QtUninvokable
    private native void removeDefaultAnimation_native_QAbstractAnimation_ptr(long __this__nativeId, long animation);
    
    @io.qt.QtUninvokable
    public final void removeState(io.qt.statemachine.QAbstractState state){
        removeState_native_QAbstractState_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(state));
        if (state != null) {
            while (__rcStates != null && __rcStates.remove(state)) ;
        }
    }
    
    @io.qt.QtUninvokable
    private native void removeState_native_QAbstractState_ptr(long __this__nativeId, long state);
    
    @io.qt.QtPropertyWriter(name="animated")
    @io.qt.QtUninvokable
    public final void setAnimated(boolean enabled){
        setAnimated_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @io.qt.QtUninvokable
    private native void setAnimated_native_bool(long __this__nativeId, boolean enabled);
    
    @io.qt.QtPropertyWriter(name="globalRestorePolicy")
    @io.qt.QtUninvokable
    public final void setGlobalRestorePolicy(io.qt.statemachine.QState.RestorePolicy restorePolicy){
        setGlobalRestorePolicy_native_QState_RestorePolicy(QtJambi_LibraryUtilities.internal.nativeId(this), restorePolicy.value());
    }
    
    @io.qt.QtUninvokable
    private native void setGlobalRestorePolicy_native_QState_RestorePolicy(long __this__nativeId, int restorePolicy);
    
    @io.qt.QtPropertyWriter(name="running")
    public final void setRunning(boolean running){
        setRunning_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), running);
    }
    
    private native void setRunning_native_bool(long __this__nativeId, boolean running);
    
    public final void start(){
        start_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void start_native(long __this__nativeId);
    
    public final void stop(){
        stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void stop_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected void beginMicrostep(io.qt.core.QEvent event){
        beginMicrostep_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void beginMicrostep_native_QEvent_ptr(long __this__nativeId, long event);
    
    @io.qt.QtUninvokable
    protected void beginSelectTransitions(io.qt.core.QEvent event){
        beginSelectTransitions_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void beginSelectTransitions_native_QEvent_ptr(long __this__nativeId, long event);
    
    @io.qt.QtUninvokable
    protected void endMicrostep(io.qt.core.QEvent event){
        endMicrostep_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void endMicrostep_native_QEvent_ptr(long __this__nativeId, long event);
    
    @io.qt.QtUninvokable
    protected void endSelectTransitions(io.qt.core.QEvent event){
        endSelectTransitions_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void endSelectTransitions_native_QEvent_ptr(long __this__nativeId, long event);
    
    @io.qt.QtUninvokable
    public boolean event(io.qt.core.QEvent e){
        return event_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @io.qt.QtUninvokable
    private native boolean event_native_QEvent_ptr(long __this__nativeId, long e);
    
    @io.qt.QtUninvokable
    public boolean eventFilter(io.qt.core.QObject watched, io.qt.core.QEvent event){
        return eventFilter_native_QObject_ptr_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(watched), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native boolean eventFilter_native_QObject_ptr_QEvent_ptr(long __this__nativeId, long watched, long event);
    
    @io.qt.QtUninvokable
    protected void onEntry(io.qt.core.QEvent event){
        onEntry_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void onEntry_native_QEvent_ptr(long __this__nativeId, long event);
    
    @io.qt.QtUninvokable
    protected void onExit(io.qt.core.QEvent event){
        onExit_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void onExit_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QStateMachine(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QStateMachine(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QStateMachine instance, QDeclarativeConstructor constructor);
    
}
