package io.qt.statemachine;


/**
 * <p>Java wrapper for Qt class QSignalTransition</p>
 */
public class QSignalTransition extends io.qt.statemachine.QAbstractTransition
{
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcSenderObject = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSignalTransition.class);
    

    @io.qt.QtPropertyNotify(name="senderObject")
    public final PrivateSignal0 senderObjectChanged = new PrivateSignal0();

    @io.qt.QtPropertyNotify(name="signal")
    public final PrivateSignal0 signalChanged = new PrivateSignal0();
    
    /**
     * <p>Overloaded constructor for {@link #QSignalTransition(io.qt.statemachine.QState)}
     *  with <code>sourceState = null</code>.</p>
     */
    public QSignalTransition() {
        this((io.qt.statemachine.QState)null);
    }
    
    public QSignalTransition(io.qt.statemachine.QState sourceState){
        super((QPrivateConstructor)null);
        initialize_native(this, sourceState);
    }
    
    private native static void initialize_native(QSignalTransition instance, io.qt.statemachine.QState sourceState);
    
    /**
     * <p>Overloaded constructor for {@link #QSignalTransition(io.qt.core.QObject, java.lang.String, io.qt.statemachine.QState)}
     *  with <code>sourceState = null</code>.</p>
     */
    public QSignalTransition(io.qt.core.QObject sender, java.lang.String signal) {
        this(sender, signal, (io.qt.statemachine.QState)null);
    }
    
    public QSignalTransition(io.qt.core.QObject sender, java.lang.String signal, io.qt.statemachine.QState sourceState){
        super((QPrivateConstructor)null);
        if(signal!=null && !signal.startsWith("2")){
                            io.qt.core.QMetaMethod method = sender.metaObject().method(signal);
                            if(method!=null && method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal) {
                                signal = "2" + method.cppMethodSignature();
                            }
                        }
        initialize_native(this, sender, signal, sourceState);
    }
    
    private native static void initialize_native(QSignalTransition instance, io.qt.core.QObject sender, java.lang.String signal, io.qt.statemachine.QState sourceState);
    
    @io.qt.QtPropertyBindable(name="senderObject")
    @io.qt.QtUninvokable
    public final io.qt.core.QBindable<io.qt.core.QObject> bindableSenderObject(){
        return bindableSenderObject_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QBindable<io.qt.core.QObject> bindableSenderObject_native(long __this__nativeId);
    
    @io.qt.QtPropertyBindable(name="signal")
    @io.qt.QtUninvokable
    public final io.qt.core.QBindable<io.qt.core.QByteArray> bindableSignal(){
        return bindableSignal_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QBindable<io.qt.core.QByteArray> bindableSignal_native(long __this__nativeId);
    
    @io.qt.QtPropertyReader(name="senderObject")
    @io.qt.QtUninvokable
    public final io.qt.core.QObject senderObject(){
        return senderObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QObject senderObject_native_constfct(long __this__nativeId);
    
    @io.qt.QtPropertyWriter(name="senderObject")
    @io.qt.QtUninvokable
    public final void setSenderObject(io.qt.core.QObject sender){
        setSenderObject_native_const_QObject_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sender));
        __rcSenderObject = sender;
    }
    
    @io.qt.QtUninvokable
    private native void setSenderObject_native_const_QObject_ptr(long __this__nativeId, long sender);
    
    @io.qt.QtPropertyWriter(name="signal")
    @io.qt.QtUninvokable
    public final void setSignal(io.qt.core.QByteArray signal){
        if(signal!=null && !signal.startsWith("2")){
                            io.qt.core.QMetaMethod method = senderObject().metaObject().method(signal.toString());
                            if(method!=null && method.methodType()==io.qt.core.QMetaMethod.MethodType.Signal) {
                                signal = new io.qt.core.QByteArray("2");
                                signal.append(method.cppMethodSignature());
                            }
                        }
        setSignal_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(signal));
    }
    
    @io.qt.QtUninvokable
    private native void setSignal_native_cref_QByteArray(long __this__nativeId, long signal);
    
    @io.qt.QtPropertyReader(name="signal")
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray signal(){
        return signal_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray signal_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public boolean event(io.qt.core.QEvent e){
        return event_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @io.qt.QtUninvokable
    private native boolean event_native_QEvent_ptr(long __this__nativeId, long e);
    
    @io.qt.QtUninvokable
    protected boolean eventTest(io.qt.core.QEvent event){
        return eventTest_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native boolean eventTest_native_QEvent_ptr(long __this__nativeId, long event);
    
    @io.qt.QtUninvokable
    protected void onTransition(io.qt.core.QEvent event){
        onTransition_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void onTransition_native_QEvent_ptr(long __this__nativeId, long event);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSignalTransition(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QSignalTransition(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QSignalTransition instance, QDeclarativeConstructor constructor);
    
    /**
     * Overloaded constructor for {@link #QSignalTransition(io.qt.core.QMetaObject.AbstractSignal, io.qt.core.QState)}.
     */
    public QSignalTransition(io.qt.core.QMetaObject.AbstractSignal signal) {
        this(signal, null);
    }
    
    /**
     * Constructs a new signal transition associated with the given signal of the given sender object and with the given sourceState.
     */
    public QSignalTransition(io.qt.core.QMetaObject.AbstractSignal signal, QState sourceState) {
        super((QPrivateConstructor)null);
        if(signal.containingObject() instanceof io.qt.core.QObject) {
            io.qt.core.QObject sender = (io.qt.core.QObject)signal.containingObject();
            String signalSignature = "2" + sender.metaObject().methods().get(signal.methodIndex()).cppMethodSignature();
            initialize_native(this, sender, signalSignature, sourceState);
        }else {
            throw new IllegalArgumentException("Signal is not owned by a QObject.");
        }
    }
    
    /**
     * Sets the signal associated with this signal transition.
     */
    @io.qt.QtUninvokable
    public final void setSignal(io.qt.core.QMetaObject.AbstractSignal signal){
        if(signal.containingObject() instanceof io.qt.core.QObject) {
            io.qt.core.QObject sender = (io.qt.core.QObject)signal.containingObject();
            String signalSignature = "2" + sender.metaObject().methods().get(signal.methodIndex()).cppMethodSignature();
            setSenderObject(sender);
            setSignal(new io.qt.core.QByteArray(signalSignature));
        }else {
            throw new IllegalArgumentException("Signal is not owned by a QObject.");
        }
    }
}
