package io.qt.sql;

import io.qt.*;


/**
 * <p>Manipulates the fields in SQL database tables and views</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qsqlfield.html">QSqlField</a></code></p>
 */
public class QSqlField extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qsqlfield.html#RequiredStatus-enum">QSqlField::RequiredStatus</a></code></p>
     */
    public enum RequiredStatus implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsqlfield.html#RequiredStatus-enum">QSqlField::<wbr/>Unknown</a></code></p>
         */
        Unknown(-1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsqlfield.html#RequiredStatus-enum">QSqlField::<wbr/>Optional</a></code></p>
         */
        Optional(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsqlfield.html#RequiredStatus-enum">QSqlField::<wbr/>Required</a></code></p>
         */
        Required(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private RequiredStatus(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull RequiredStatus resolve(int value) {
            switch (value) {
            case -1: return Unknown;
            case 0: return Optional;
            case 1: return Required;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#QSqlField">QSqlField::<wbr/>QSqlField(QSqlField)</a></code></p>
     */
    public QSqlField(io.qt.sql.@NonNull QSqlField other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QSqlField instance, io.qt.sql.QSqlField other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#QSqlField-1">QSqlField::<wbr/>QSqlField(QString,<wbr/>QMetaType,<wbr/>QString)</a></code></p>
     */
    public QSqlField(java.lang.@NonNull String fieldName, io.qt.core.@NonNull QMetaType type, java.lang.@NonNull String tableName){
        super((QPrivateConstructor)null);
        initialize_native(this, fieldName, type, tableName);
    }
    
    private native static void initialize_native(QSqlField instance, java.lang.String fieldName, io.qt.core.QMetaType type, java.lang.String tableName);
    
    /**
     * <p>See <code>QSqlField::<wbr/>QSqlField(QString,<wbr/>QVariant::Type,<wbr/>QString)</code></p>
     * 
     * @deprecated Use the constructor using a QMetaType instead
     */
    @Deprecated
    public QSqlField(java.lang.@NonNull String fieldName, io.qt.core.QVariant.@NonNull Type type, java.lang.@NonNull String tableName){
        super((QPrivateConstructor)null);
        initialize_native(this, fieldName, type, tableName);
    }
    
    @Deprecated
    private native static void initialize_native(QSqlField instance, java.lang.String fieldName, io.qt.core.QVariant.Type type, java.lang.String tableName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#clear">QSqlField::<wbr/>clear()</a></code></p>
     */
    @QtUninvokable
    public final void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void clear_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#defaultValue">QSqlField::<wbr/>defaultValue()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.Object defaultValue(){
        return defaultValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.Object defaultValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#isAutoValue">QSqlField::<wbr/>isAutoValue()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isAutoValue(){
        return isAutoValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isAutoValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#isGenerated">QSqlField::<wbr/>isGenerated()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isGenerated(){
        return isGenerated_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isGenerated_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#isNull">QSqlField::<wbr/>isNull()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#isReadOnly">QSqlField::<wbr/>isReadOnly()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isReadOnly(){
        return isReadOnly_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isReadOnly_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#isValid">QSqlField::<wbr/>isValid()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#length">QSqlField::<wbr/>length()const</a></code></p>
     */
    @QtUninvokable
    public final int length(){
        return length_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int length_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#metaType">QSqlField::<wbr/>metaType()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QMetaType metaType(){
        return metaType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QMetaType metaType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#name">QSqlField::<wbr/>name()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#operator-eq">QSqlField::<wbr/>operator=(QSqlField)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.sql.@NonNull QSqlField other){
        assign_native_cref_QSqlField(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QSqlField(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#operator-eq-eq">QSqlField::<wbr/>operator==(QSqlField)const</a></code></p>
     */
    @QtUninvokable
    public final boolean equals(io.qt.sql.@NonNull QSqlField other){
        return equals_native_cref_QSqlField_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean equals_native_cref_QSqlField_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#precision">QSqlField::<wbr/>precision()const</a></code></p>
     */
    @QtUninvokable
    public final int precision(){
        return precision_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int precision_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#requiredStatus">QSqlField::<wbr/>requiredStatus()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.sql.QSqlField.@NonNull RequiredStatus requiredStatus(){
        return io.qt.sql.QSqlField.RequiredStatus.resolve(requiredStatus_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int requiredStatus_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#setAutoValue">QSqlField::<wbr/>setAutoValue(bool)</a></code></p>
     */
    @QtUninvokable
    public final void setAutoValue(boolean autoVal){
        setAutoValue_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), autoVal);
    }
    
    @QtUninvokable
    private native void setAutoValue_native_bool(long __this__nativeId, boolean autoVal);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#setDefaultValue">QSqlField::<wbr/>setDefaultValue(QVariant)</a></code></p>
     */
    @QtUninvokable
    public final void setDefaultValue(java.lang.Object value){
        setDefaultValue_native_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setDefaultValue_native_cref_QVariant(long __this__nativeId, java.lang.Object value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#setGenerated">QSqlField::<wbr/>setGenerated(bool)</a></code></p>
     */
    @QtUninvokable
    public final void setGenerated(boolean gen){
        setGenerated_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), gen);
    }
    
    @QtUninvokable
    private native void setGenerated_native_bool(long __this__nativeId, boolean gen);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#setLength">QSqlField::<wbr/>setLength(int)</a></code></p>
     */
    @QtUninvokable
    public final void setLength(int fieldLength){
        setLength_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), fieldLength);
    }
    
    @QtUninvokable
    private native void setLength_native_int(long __this__nativeId, int fieldLength);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#setMetaType">QSqlField::<wbr/>setMetaType(QMetaType)</a></code></p>
     */
    @QtUninvokable
    public final void setMetaType(io.qt.core.@NonNull QMetaType type){
        setMetaType_native_QMetaType(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(type));
    }
    
    @QtUninvokable
    private native void setMetaType_native_QMetaType(long __this__nativeId, long type);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#setName">QSqlField::<wbr/>setName(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setName(java.lang.@NonNull String name){
        setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void setName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#setPrecision">QSqlField::<wbr/>setPrecision(int)</a></code></p>
     */
    @QtUninvokable
    public final void setPrecision(int precision){
        setPrecision_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), precision);
    }
    
    @QtUninvokable
    private native void setPrecision_native_int(long __this__nativeId, int precision);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#setReadOnly">QSqlField::<wbr/>setReadOnly(bool)</a></code></p>
     */
    @QtUninvokable
    public final void setReadOnly(boolean readOnly){
        setReadOnly_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), readOnly);
    }
    
    @QtUninvokable
    private native void setReadOnly_native_bool(long __this__nativeId, boolean readOnly);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#setRequired">QSqlField::<wbr/>setRequired(bool)</a></code></p>
     */
    @QtUninvokable
    public final void setRequired(boolean required){
        setRequired_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), required);
    }
    
    @QtUninvokable
    private native void setRequired_native_bool(long __this__nativeId, boolean required);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#setRequiredStatus">QSqlField::<wbr/>setRequiredStatus(QSqlField::RequiredStatus)</a></code></p>
     */
    @QtUninvokable
    public final void setRequiredStatus(io.qt.sql.QSqlField.@NonNull RequiredStatus status){
        setRequiredStatus_native_QSqlField_RequiredStatus(QtJambi_LibraryUtilities.internal.nativeId(this), status.value());
    }
    
    @QtUninvokable
    private native void setRequiredStatus_native_QSqlField_RequiredStatus(long __this__nativeId, int status);
    
    /**
     * <p>See <code>QSqlField::<wbr/>setSqlType(int)</code></p>
     */
    @QtUninvokable
    public final void setSqlType(int type){
        setSqlType_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), type);
    }
    
    @QtUninvokable
    private native void setSqlType_native_int(long __this__nativeId, int type);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#setTableName">QSqlField::<wbr/>setTableName(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setTableName(java.lang.@NonNull String tableName){
        setTableName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), tableName);
    }
    
    @QtUninvokable
    private native void setTableName_native_cref_QString(long __this__nativeId, java.lang.String tableName);
    
    /**
     * <p>See <code>QSqlField::<wbr/>setType(QVariant::Type)</code></p>
     * 
     * @deprecated Use {@link io.qt.sql.QSqlField#setMetaType(io.qt.core.QMetaType)} instead
     */
    @Deprecated
    @QtUninvokable
    public final void setType(io.qt.core.QVariant.@NonNull Type type){
        setType_native_QVariant_Type(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @Deprecated
    @QtUninvokable
    private native void setType_native_QVariant_Type(long __this__nativeId, int type);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#setValue">QSqlField::<wbr/>setValue(QVariant)</a></code></p>
     */
    @QtUninvokable
    public final void setValue(java.lang.Object value){
        setValue_native_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setValue_native_cref_QVariant(long __this__nativeId, java.lang.Object value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#swap">QSqlField::<wbr/>swap(QSqlField&amp;)</a></code></p>
     */
    @QtUninvokable
    public final void swap(io.qt.sql.@StrictNonNull QSqlField other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QSqlField(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QSqlField(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#tableName">QSqlField::<wbr/>tableName()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String tableName(){
        return tableName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String tableName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QSqlField::<wbr/>type()const</code></p>
     * 
     * @deprecated Use {@link io.qt.sql.QSqlField#metaType()} instead
     */
    @Deprecated
    @QtUninvokable
    public final io.qt.core.QVariant.@NonNull Type type(){
        return io.qt.core.QVariant.Type.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @Deprecated
    @QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QSqlField::<wbr/>typeID()const</code></p>
     */
    @QtUninvokable
    public final int typeID(){
        return typeID_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int typeID_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#value">QSqlField::<wbr/>value()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.Object value(){
        return value_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.Object value_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QSqlField(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#operator-eq-eq">QSqlField::<wbr/>operator==(QSqlField)const</a></code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.sql.QSqlField) {
            return equals((io.qt.sql.QSqlField) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QSqlField)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);

    /**
     * <p>See <code>operator&lt;&lt;(QDebug,<wbr/>QSqlField)</code></p>
     */
    @QtUninvokable
    @Override
    public @NonNull String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private static native String toString_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="https://doc.qt.io/qt/qsqlfield.html#QSqlField">QSqlField::<wbr/>QSqlField(QSqlField)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QSqlField clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QSqlField clone_native(long __this_nativeId);
    
    /**
     * <p>Overloaded constructor for {@link #QSqlField(java.lang.String, io.qt.core.QMetaType, java.lang.String)}
     *  with <code>tableName = (String)null</code>.</p>
     */
    public QSqlField(java.lang.@NonNull String fieldName, io.qt.core.@NonNull QMetaType type) {
        this(fieldName, type, (String)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QSqlField(java.lang.String, io.qt.core.QMetaType, java.lang.String)}</p>
     * <p>with: </p><ul>
     * <li><code>type = new io.qt.core.QMetaType()</code></li>
     * <li><code>tableName = (String)null</code></li>
     * </ul>
     */
    public QSqlField(java.lang.@NonNull String fieldName) {
        this(fieldName, new io.qt.core.QMetaType(), (String)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QSqlField(java.lang.String, io.qt.core.QMetaType, java.lang.String)}</p>
     * <p>with: </p><ul>
     * <li><code>fieldName = (String)null</code></li>
     * <li><code>type = new io.qt.core.QMetaType()</code></li>
     * <li><code>tableName = (String)null</code></li>
     * </ul>
     */
    public QSqlField() {
        this((String)null, new io.qt.core.QMetaType(), (String)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QSqlField(java.lang.String, io.qt.core.QVariant.Type, java.lang.String)}
     *  with <code>tableName = (String)null</code>.</p>
     * 
     * @deprecated Use the constructor using a QMetaType instead
     */
    @Deprecated
    public QSqlField(java.lang.@NonNull String fieldName, io.qt.core.QVariant.@NonNull Type type) {
        this(fieldName, type, (String)null);
    }
}
