package io.qt.sql;

import io.qt.*;


/**
 * <p>The base class for SQL driver factories</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qsqldrivercreatorbase.html">QSqlDriverCreatorBase</a></code></p>
 */
public abstract class QSqlDriverCreatorBase extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @NativeAccess
    private static final class ConcreteWrapper extends QSqlDriverCreatorBase {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        public io.qt.sql.@Nullable QSqlDriver createObject(){
            return createObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native io.qt.sql.QSqlDriver createObject_native_constfct(long __this__nativeId);
        
    }
    
    
    /**
     * <p>See <code>QSqlDriverCreatorBase::<wbr/>QSqlDriverCreatorBase()</code></p>
     */
    public QSqlDriverCreatorBase(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSqlDriverCreatorBase instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldrivercreatorbase.html#createObject">QSqlDriverCreatorBase::<wbr/>createObject()const</a></code></p>
     */
    @QtUninvokable
    public abstract io.qt.sql.@Nullable QSqlDriver createObject();
    
    @QtUninvokable
    private native io.qt.sql.QSqlDriver createObject_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QSqlDriverCreatorBase(QPrivateConstructor p) { super(p); } 
    
}
