package io.qt.sql;

import io.qt.*;


/**
 * <p>Contains miscellaneous identifiers used throughout the Qt SQL module</p>
 * <p>Java wrapper for Qt header file <code><a href="https://doc.qt.io/qt/qsql.html">QSql</a></code></p>
 */
public final class QSql
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private QSql() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace QSql."); }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qsql.html#Location-enum">QSql::Location</a></code></p>
     */
    public enum Location implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsql.html#Location-enum">QSql::<wbr/>BeforeFirstRow</a></code></p>
         */
        BeforeFirstRow(-1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsql.html#Location-enum">QSql::<wbr/>AfterLastRow</a></code></p>
         */
        AfterLastRow(-2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Location(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Location resolve(int value) {
            switch (value) {
            case -1: return BeforeFirstRow;
            case -2: return AfterLastRow;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qsql.html#NumericalPrecisionPolicy-enum">QSql::NumericalPrecisionPolicy</a></code></p>
     */
    public enum NumericalPrecisionPolicy implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsql.html#NumericalPrecisionPolicy-enum">QSql::<wbr/>LowPrecisionInt32</a></code></p>
         */
        LowPrecisionInt32(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsql.html#NumericalPrecisionPolicy-enum">QSql::<wbr/>LowPrecisionInt64</a></code></p>
         */
        LowPrecisionInt64(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsql.html#NumericalPrecisionPolicy-enum">QSql::<wbr/>LowPrecisionDouble</a></code></p>
         */
        LowPrecisionDouble(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsql.html#NumericalPrecisionPolicy-enum">QSql::<wbr/>HighPrecision</a></code></p>
         */
        HighPrecision(0);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private NumericalPrecisionPolicy(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull NumericalPrecisionPolicy resolve(int value) {
            switch (value) {
            case 1: return LowPrecisionInt32;
            case 2: return LowPrecisionInt64;
            case 4: return LowPrecisionDouble;
            case 0: return HighPrecision;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qsql.html#ParamTypeFlag-enum">QSql::ParamTypeFlag</a></code></p>
     * 
     * @see ParamType
     */
    public enum ParamTypeFlag implements QtFlagEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsql.html#ParamTypeFlag-enum">QSql::<wbr/>In</a></code></p>
         */
        In(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsql.html#ParamTypeFlag-enum">QSql::<wbr/>Out</a></code></p>
         */
        Out(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsql.html#ParamTypeFlag-enum">QSql::<wbr/>InOut</a></code></p>
         */
        InOut(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsql.html#ParamTypeFlag-enum">QSql::<wbr/>Binary</a></code></p>
         */
        Binary(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ParamTypeFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull ParamType asFlags() {
            return new ParamType(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull ParamType combined(@NonNull ParamTypeFlag e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull ParamType cleared(@NonNull ParamTypeFlag e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link ParamType} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull ParamType flags(@Nullable ParamTypeFlag @NonNull... values) {
            return new ParamType(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ParamTypeFlag resolve(int value) {
            switch (value) {
            case 1: return In;
            case 2: return Out;
            case 3: return InOut;
            case 4: return Binary;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link ParamTypeFlag}
     */
    public static final class ParamType extends QFlags<ParamTypeFlag> implements Comparable<ParamType> {
        private static final long serialVersionUID = 0x53e415e7b2e0668eL;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new ParamType where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public ParamType(@Nullable ParamTypeFlag @NonNull... args){
            super(args);
        }

        /**
         * Creates a new ParamType with given <code>value</code>.
         * @param value
         */
        public ParamType(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new ParamType
         */
        @Override
        public final @NonNull ParamType combined(@StrictNonNull ParamTypeFlag e){
            return new ParamType(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull ParamType setFlag(@Nullable ParamTypeFlag e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull ParamType setFlag(@Nullable ParamTypeFlag e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this ParamType.
         * @return array of enum entries
         */
        @Override
        public final @NonNull ParamTypeFlag @NonNull[] flags(){
            return super.flags(ParamTypeFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull ParamType clone(){
            return new ParamType(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull ParamType other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qsql.html#TableType-enum">QSql::TableType</a></code></p>
     */
    public enum TableType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsql.html#TableType-enum">QSql::<wbr/>Tables</a></code></p>
         */
        Tables(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsql.html#TableType-enum">QSql::<wbr/>SystemTables</a></code></p>
         */
        SystemTables(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsql.html#TableType-enum">QSql::<wbr/>Views</a></code></p>
         */
        Views(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsql.html#TableType-enum">QSql::<wbr/>AllTables</a></code></p>
         */
        AllTables(255);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private TableType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull TableType resolve(int value) {
            switch (value) {
            case 1: return Tables;
            case 2: return SystemTables;
            case 4: return Views;
            case 255: return AllTables;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
}
