/*
 * Decompiled with CFR 0.152.
 */
package io.qt.sql;

import io.qt.NonNull;
import io.qt.Nullable;
import io.qt.QtObject;
import io.qt.core.QAbstractItemModel;
import io.qt.core.QModelIndex;
import io.qt.core.QObject;
import io.qt.sql.QSqlDriver;
import io.qt.sql.QSqlRelationalTableModel;
import io.qt.sql.QSqlTableModel;
import io.qt.sql.QtJambi_LibraryUtilities;
import io.qt.widgets.QComboBox;
import io.qt.widgets.QStyleOptionViewItem;
import io.qt.widgets.QStyledItemDelegate;
import io.qt.widgets.QWidget;

public class QSqlRelationalDelegate
extends QStyledItemDelegate {
    public QSqlRelationalDelegate() {
        super((QObject)null);
    }

    public QSqlRelationalDelegate(@Nullable QObject parent) {
        super(parent);
    }

    protected QSqlRelationalDelegate(QtObject.QPrivateConstructor p) {
        super(p);
    }

    public @Nullable QWidget createEditor(@Nullable QWidget parent, @NonNull QStyleOptionViewItem option, @NonNull QModelIndex index) {
        QSqlTableModel childModel;
        if (!index.isValid()) {
            return null;
        }
        QSqlRelationalTableModel sqlModel = (QSqlRelationalTableModel)QSqlRelationalDelegate.qobject_cast(QSqlRelationalTableModel.class, (QObject)index.model());
        QSqlTableModel qSqlTableModel = childModel = sqlModel != null ? sqlModel.relationModel(index.column()) : null;
        if (childModel == null) {
            return super.createEditor(parent, option, index);
        }
        QSqlDriver driver = childModel.database().driver();
        QComboBox combo = new QComboBox(parent);
        combo.setModel((QAbstractItemModel)childModel);
        combo.setModelColumn(QSqlRelationalDelegate.fieldIndex(childModel, driver, sqlModel.relation(index.column()).displayColumn()));
        combo.installEventFilter((QObject)this);
        return combo;
    }

    public void setEditorData(@Nullable QWidget editor, @NonNull QModelIndex index) {
        if (index == null || !index.isValid()) {
            return;
        }
        if (editor instanceof QComboBox) {
            Object value = index.data(0);
            String n = editor.metaObject().userProperty().name();
            if (!n.isEmpty()) {
                if (value == null) {
                    value = editor.metaObject().userProperty().metaType().create();
                }
                editor.setProperty(n, value);
                return;
            }
        }
        super.setEditorData(editor, index);
    }

    public void setModelData(@Nullable QWidget editor, @Nullable QAbstractItemModel model, @NonNull QModelIndex index) {
        if (!index.isValid()) {
            return;
        }
        QSqlRelationalTableModel sqlModel = (QSqlRelationalTableModel)QSqlRelationalDelegate.qobject_cast(QSqlRelationalTableModel.class, (QObject)index.model());
        QSqlTableModel childModel = sqlModel != null ? sqlModel.relationModel(index.column()) : null;
        QComboBox combo = (QComboBox)QSqlRelationalDelegate.qobject_cast(QComboBox.class, (QObject)editor);
        if (sqlModel == null || childModel == null || combo == null) {
            super.setModelData(editor, model, index);
            return;
        }
        QSqlDriver driver = childModel.database().driver();
        int currentItem = combo.currentIndex();
        int childColIndex = QSqlRelationalDelegate.fieldIndex(childModel, driver, sqlModel.relation(index.column()).displayColumn());
        int childEditIndex = QSqlRelationalDelegate.fieldIndex(childModel, driver, sqlModel.relation(index.column()).indexColumn());
        sqlModel.setData(index, childModel.data(childModel.index(currentItem, childColIndex), 0), 0);
        sqlModel.setData(index, childModel.data(childModel.index(currentItem, childEditIndex), 2), 2);
    }

    private static int fieldIndex(QSqlTableModel model, QSqlDriver driver, String fieldName) {
        String stripped = driver.isIdentifierEscaped(fieldName, QSqlDriver.IdentifierType.FieldName) ? driver.stripDelimiters(fieldName, QSqlDriver.IdentifierType.FieldName) : fieldName;
        return model.fieldIndex(stripped);
    }

    static {
        QtJambi_LibraryUtilities.initialize();
    }
}

