/*
 * Decompiled with CFR 0.152.
 */
package io.qt.sql;

import io.qt.NonNull;
import io.qt.StrictNonNull;
import io.qt.sql.QSqlDriver;
import io.qt.sql.QSqlDriverCreatorBase;
import io.qt.sql.QtJambi_LibraryUtilities;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.function.Supplier;

public class QSqlDriverCreator<T extends QSqlDriver>
extends QSqlDriverCreatorBase {
    private final Supplier<T> constructorHandle;

    public QSqlDriverCreator(@StrictNonNull Supplier<@NonNull T> constructor) {
        this.constructorHandle = Objects.requireNonNull(constructor);
    }

    public QSqlDriverCreator(@StrictNonNull Class<T> type) {
        Constructor<T> constructor;
        if (Modifier.isAbstract(type.getModifiers())) {
            throw new RuntimeException("Cannot construct QSqlDriverCreator for abstract widget type " + type.getName() + ".");
        }
        try {
            constructor = type.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException("Cannot construct QSqlDriverCreator for widget type " + type.getName() + " due to missing constructor " + type.getSimpleName() + "().", e);
        }
        this.constructorHandle = QtJambi_LibraryUtilities.internal.getFactory0(constructor);
    }

    public @NonNull T createObject() {
        return (T)((Object)((QSqlDriver)((Object)this.constructorHandle.get())));
    }
}

