package io.qt.sql;

import io.qt.*;


/**
 * <p>Handles a connection to a database</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qsqldatabase.html">QSqlDatabase</a></code></p>
 */
public class QSqlDatabase extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#QSqlDatabase">QSqlDatabase::<wbr>QSqlDatabase()</a></code></p>
     */
    public QSqlDatabase(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSqlDatabase instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#QSqlDatabase-3">QSqlDatabase::<wbr>QSqlDatabase(QSqlDriver*)</a></code></p>
     */
    protected QSqlDatabase(io.qt.sql.@Nullable QSqlDriver driver){
        super((QPrivateConstructor)null);
        initialize_native(this, driver);
    }
    
    private native static void initialize_native(QSqlDatabase instance, io.qt.sql.QSqlDriver driver);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#QSqlDatabase-1">QSqlDatabase::<wbr>QSqlDatabase(QSqlDatabase)</a></code></p>
     */
    public QSqlDatabase(io.qt.sql.@NonNull QSqlDatabase other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QSqlDatabase instance, io.qt.sql.QSqlDatabase other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#QSqlDatabase-2">QSqlDatabase::<wbr>QSqlDatabase(QString)</a></code></p>
     */
    protected QSqlDatabase(java.lang.@NonNull String type){
        super((QPrivateConstructor)null);
        initialize_native(this, type);
    }
    
    private native static void initialize_native(QSqlDatabase instance, java.lang.String type);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#close">QSqlDatabase::<wbr>close()</a></code></p>
     */
    @QtUninvokable
    public final void close(){
        close_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void close_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#commit">QSqlDatabase::<wbr>commit()</a></code></p>
     */
    @QtUninvokable
    public final boolean commit(){
        return commit_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean commit_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#connectOptions">QSqlDatabase::<wbr>connectOptions()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String connectOptions(){
        return connectOptions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String connectOptions_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#connectionName">QSqlDatabase::<wbr>connectionName()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String connectionName(){
        return connectionName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String connectionName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#databaseName">QSqlDatabase::<wbr>databaseName()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String databaseName(){
        return databaseName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String databaseName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#driver">QSqlDatabase::<wbr>driver()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.sql.@Nullable QSqlDriver driver(){
        return driver_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlDriver driver_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#driverName">QSqlDatabase::<wbr>driverName()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String driverName(){
        return driverName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String driverName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#exec">QSqlDatabase::<wbr>exec(QString)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.sql.@NonNull QSqlQuery exec(java.lang.@NonNull String query){
        return exec_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), query);
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlQuery exec_native_cref_QString_constfct(long __this__nativeId, java.lang.String query);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#hostName">QSqlDatabase::<wbr>hostName()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String hostName(){
        return hostName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String hostName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#isOpen">QSqlDatabase::<wbr>isOpen()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isOpen(){
        return isOpen_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isOpen_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#isOpenError">QSqlDatabase::<wbr>isOpenError()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isOpenError(){
        return isOpenError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isOpenError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#isValid">QSqlDatabase::<wbr>isValid()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#lastError">QSqlDatabase::<wbr>lastError()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.sql.@NonNull QSqlError lastError(){
        return lastError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlError lastError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#numericalPrecisionPolicy">QSqlDatabase::<wbr>numericalPrecisionPolicy()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.sql.QSql.@NonNull NumericalPrecisionPolicy numericalPrecisionPolicy(){
        return io.qt.sql.QSql.NumericalPrecisionPolicy.resolve(numericalPrecisionPolicy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int numericalPrecisionPolicy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#open">QSqlDatabase::<wbr>open()</a></code></p>
     */
    @QtUninvokable
    public final boolean open(){
        return open_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean open_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#open-1">QSqlDatabase::<wbr>open(QString,<wbr>QString)</a></code></p>
     */
    @QtUninvokable
    public final boolean open(java.lang.@NonNull String user, java.lang.@NonNull String password){
        return open_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), user, password);
    }
    
    @QtUninvokable
    private native boolean open_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String user, java.lang.String password);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#operator-eq">QSqlDatabase::<wbr>operator=(QSqlDatabase)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.sql.@NonNull QSqlDatabase other){
        assign_native_cref_QSqlDatabase(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QSqlDatabase(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#password">QSqlDatabase::<wbr>password()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String password(){
        return password_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String password_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#port">QSqlDatabase::<wbr>port()const</a></code></p>
     */
    @QtUninvokable
    public final int port(){
        return port_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int port_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#primaryIndex">QSqlDatabase::<wbr>primaryIndex(QString)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.sql.@NonNull QSqlIndex primaryIndex(java.lang.@NonNull String tablename){
        return primaryIndex_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), tablename);
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlIndex primaryIndex_native_cref_QString_constfct(long __this__nativeId, java.lang.String tablename);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#record">QSqlDatabase::<wbr>record(QString)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.sql.@NonNull QSqlRecord record(java.lang.@NonNull String tablename){
        return record_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), tablename);
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlRecord record_native_cref_QString_constfct(long __this__nativeId, java.lang.String tablename);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#rollback">QSqlDatabase::<wbr>rollback()</a></code></p>
     */
    @QtUninvokable
    public final boolean rollback(){
        return rollback_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean rollback_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#setConnectOptions">QSqlDatabase::<wbr>setConnectOptions(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setConnectOptions(java.lang.@NonNull String options){
        setConnectOptions_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), options);
    }
    
    @QtUninvokable
    private native void setConnectOptions_native_cref_QString(long __this__nativeId, java.lang.String options);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#setDatabaseName">QSqlDatabase::<wbr>setDatabaseName(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setDatabaseName(java.lang.@NonNull String name){
        setDatabaseName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void setDatabaseName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#setHostName">QSqlDatabase::<wbr>setHostName(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setHostName(java.lang.@NonNull String host){
        setHostName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), host);
    }
    
    @QtUninvokable
    private native void setHostName_native_cref_QString(long __this__nativeId, java.lang.String host);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#setNumericalPrecisionPolicy">QSqlDatabase::<wbr>setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy)</a></code></p>
     */
    @QtUninvokable
    public final void setNumericalPrecisionPolicy(io.qt.sql.QSql.@NonNull NumericalPrecisionPolicy precisionPolicy){
        setNumericalPrecisionPolicy_native_QSql_NumericalPrecisionPolicy(QtJambi_LibraryUtilities.internal.nativeId(this), precisionPolicy.value());
    }
    
    @QtUninvokable
    private native void setNumericalPrecisionPolicy_native_QSql_NumericalPrecisionPolicy(long __this__nativeId, int precisionPolicy);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#setPassword">QSqlDatabase::<wbr>setPassword(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setPassword(java.lang.@NonNull String password){
        setPassword_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), password);
    }
    
    @QtUninvokable
    private native void setPassword_native_cref_QString(long __this__nativeId, java.lang.String password);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#setPort">QSqlDatabase::<wbr>setPort(int)</a></code></p>
     */
    @QtUninvokable
    public final void setPort(int p){
        setPort_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), p);
    }
    
    @QtUninvokable
    private native void setPort_native_int(long __this__nativeId, int p);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#setUserName">QSqlDatabase::<wbr>setUserName(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setUserName(java.lang.@NonNull String name){
        setUserName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void setUserName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#tables">QSqlDatabase::<wbr>tables(QSql::TableType)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList tables(io.qt.sql.QSql.@NonNull TableType type){
        return tables_native_QSql_TableType_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList tables_native_QSql_TableType_constfct(long __this__nativeId, int type);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#transaction">QSqlDatabase::<wbr>transaction()</a></code></p>
     */
    @QtUninvokable
    public final boolean transaction(){
        return transaction_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean transaction_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#userName">QSqlDatabase::<wbr>userName()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String userName(){
        return userName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String userName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#addDatabase-1">QSqlDatabase::<wbr>addDatabase(QSqlDriver*,<wbr>QString)</a></code></p>
     */
    public static io.qt.sql.@NonNull QSqlDatabase addDatabase(io.qt.sql.@Nullable QSqlDriver driver, java.lang.@NonNull String connectionName){
        return addDatabase_native_QSqlDriver_ptr_cref_QString(QtJambi_LibraryUtilities.internal.checkedNativeId(driver), connectionName);
    }
    
    private native static io.qt.sql.QSqlDatabase addDatabase_native_QSqlDriver_ptr_cref_QString(long driver, java.lang.String connectionName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#addDatabase">QSqlDatabase::<wbr>addDatabase(QString,<wbr>QString)</a></code></p>
     */
    public native static io.qt.sql.@NonNull QSqlDatabase addDatabase(java.lang.@NonNull String type, java.lang.@NonNull String connectionName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#cloneDatabase">QSqlDatabase::<wbr>cloneDatabase(QSqlDatabase,<wbr>QString)</a></code></p>
     */
    public static io.qt.sql.@NonNull QSqlDatabase cloneDatabase(io.qt.sql.@NonNull QSqlDatabase other, java.lang.@NonNull String connectionName){
        return cloneDatabase_native_cref_QSqlDatabase_cref_QString(QtJambi_LibraryUtilities.internal.checkedNativeId(other), connectionName);
    }
    
    private native static io.qt.sql.QSqlDatabase cloneDatabase_native_cref_QSqlDatabase_cref_QString(long other, java.lang.String connectionName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#cloneDatabase-1">QSqlDatabase::<wbr>cloneDatabase(QString,<wbr>QString)</a></code></p>
     */
    public native static io.qt.sql.@NonNull QSqlDatabase cloneDatabase(java.lang.@NonNull String other, java.lang.@NonNull String connectionName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#connectionNames">QSqlDatabase::<wbr>connectionNames()</a></code></p>
     */
    public native static io.qt.core.@NonNull QStringList connectionNames();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#contains">QSqlDatabase::<wbr>contains(QString)</a></code></p>
     */
    public native static boolean contains(java.lang.@NonNull String connectionName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#database">QSqlDatabase::<wbr>database(QString,<wbr>bool)</a></code></p>
     */
    public native static io.qt.sql.@NonNull QSqlDatabase database(java.lang.@NonNull String connectionName, boolean open);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#drivers">QSqlDatabase::<wbr>drivers()</a></code></p>
     */
    public native static io.qt.core.@NonNull QStringList drivers();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#isDriverAvailable">QSqlDatabase::<wbr>isDriverAvailable(QString)</a></code></p>
     */
    public native static boolean isDriverAvailable(java.lang.@NonNull String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#registerSqlDriver">QSqlDatabase::<wbr>registerSqlDriver(QString,<wbr>QSqlDriverCreatorBase*)</a></code></p>
     */
    public static void registerSqlDriver(java.lang.@NonNull String name, io.qt.sql.@Nullable QSqlDriverCreatorBase creator){
        registerSqlDriver_native_cref_QString_QSqlDriverCreatorBase_ptr(name, QtJambi_LibraryUtilities.internal.checkedNativeId(creator));
    }
    
    private native static void registerSqlDriver_native_cref_QString_QSqlDriverCreatorBase_ptr(java.lang.String name, long creator);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqldatabase.html#removeDatabase">QSqlDatabase::<wbr>removeDatabase(QString)</a></code></p>
     */
    public native static void removeDatabase(java.lang.@NonNull String connectionName);
    
    /**
     * <p>See <code>QSqlDatabase::<wbr>defaultConnection</code></p>
     */
    public native static void setDefaultConnection(java.lang.@Nullable String defaultConnection);
    
    /**
     * <p>See <code>QSqlDatabase::<wbr>defaultConnection</code></p>
     */
    public native static java.lang.@Nullable String defaultConnection();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QSqlDatabase(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code>operator&lt;&lt;(QDebug,<wbr>QSqlDatabase)</code></p>
     */
    @QtUninvokable
    @Override
    public @NonNull String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private static native String toString_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QSqlDatabase clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QSqlDatabase clone_native(long __this_nativeId);
    
    /**
     * <p>Overloaded function for {@link #exec(java.lang.String)}
     *  with <code>query = (String)null</code>.</p>
     */
    @QtUninvokable
    public final io.qt.sql.@NonNull QSqlQuery exec() {
        return exec((String)null);
    }
    
    /**
     * <p>Overloaded function for {@link #setConnectOptions(java.lang.String)}
     *  with <code>options = (String)null</code>.</p>
     */
    @QtUninvokable
    public final void setConnectOptions() {
        setConnectOptions((String)null);
    }
    
    /**
     * <p>Overloaded function for {@link #tables(io.qt.sql.QSql.TableType)}
     *  with <code>type = io.qt.sql.QSql.TableType.Tables</code>.</p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList tables() {
        return tables(io.qt.sql.QSql.TableType.Tables);
    }
    
    /**
     * <p>Overloaded function for {@link #addDatabase(io.qt.sql.QSqlDriver, java.lang.String)}
     *  with <code>connectionName = defaultConnection()</code>.</p>
     */
    public static io.qt.sql.@NonNull QSqlDatabase addDatabase(io.qt.sql.@Nullable QSqlDriver driver) {
        return addDatabase(driver, defaultConnection());
    }
    
    /**
     * <p>Overloaded function for {@link #addDatabase(java.lang.String, java.lang.String)}
     *  with <code>connectionName = defaultConnection()</code>.</p>
     */
    public static io.qt.sql.@NonNull QSqlDatabase addDatabase(java.lang.@NonNull String type) {
        return addDatabase(type, defaultConnection());
    }
    
    /**
     * <p>Overloaded function for {@link #contains(java.lang.String)}
     *  with <code>connectionName = defaultConnection()</code>.</p>
     */
    public static boolean contains() {
        return contains(defaultConnection());
    }
    
    /**
     * <p>Overloaded function for {@link #database(java.lang.String, boolean)}
     *  with <code>open = true</code>.</p>
     */
    public static io.qt.sql.@NonNull QSqlDatabase database(java.lang.@NonNull String connectionName) {
        return database(connectionName, (boolean)true);
    }
    
    /**
     * <p>Overloaded function for {@link #database(java.lang.String, boolean)}</p>
     * <p>with: </p><ul>
     * <li><code>connectionName = defaultConnection()</code></li>
     * <li><code>open = true</code></li>
     * </ul>
     */
    public static io.qt.sql.@NonNull QSqlDatabase database() {
        return database(defaultConnection(), (boolean)true);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #defaultConnection()} instead.</p>
     */
    public static java.lang.@Nullable String getDefaultConnection() {
        return defaultConnection();
    }
}
