package io.qt.sql;

import io.qt.*;


/**
 * <p>Editable data model for a single database table</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qsqltablemodel.html">QSqlTableModel</a></code></p>
 */
public class QSqlTableModel extends io.qt.sql.QSqlQueryModel
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSqlTableModel.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#EditStrategy-enum">QSqlTableModel::EditStrategy</a></code></p>
     */
    @QtUnlistedEnum
    public enum EditStrategy implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#EditStrategy-enum">QSqlTableModel::<wbr>OnFieldChange</a></code></p>
         */
        OnFieldChange(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#EditStrategy-enum">QSqlTableModel::<wbr>OnRowChange</a></code></p>
         */
        OnRowChange(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#EditStrategy-enum">QSqlTableModel::<wbr>OnManualSubmit</a></code></p>
         */
        OnManualSubmit(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private EditStrategy(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull EditStrategy resolve(int value) {
            switch (value) {
            case 0: return OnFieldChange;
            case 1: return OnRowChange;
            case 2: return OnManualSubmit;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#beforeDelete">QSqlTableModel::<wbr>beforeDelete(int)</a></code></p>
     */
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> beforeDelete = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#beforeInsert">QSqlTableModel::<wbr>beforeInsert(QSqlRecord&amp;)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.sql.@NonNull QSqlRecord> beforeInsert = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#beforeUpdate">QSqlTableModel::<wbr>beforeUpdate(int,<wbr>QSqlRecord&amp;)</a></code></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, io.qt.sql.@NonNull QSqlRecord> beforeUpdate = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#primeInsert">QSqlTableModel::<wbr>primeInsert(int,<wbr>QSqlRecord&amp;)</a></code></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, io.qt.sql.@NonNull QSqlRecord> primeInsert = new Signal2<>();
    
    /**
     * <p>Overloaded constructor for {@link #QSqlTableModel(io.qt.core.QObject, io.qt.sql.QSqlDatabase)}
     *  with <code>db = new io.qt.sql.QSqlDatabase()</code>.</p>
     */
    public QSqlTableModel(io.qt.core.@Nullable QObject parent) {
        this(parent, new io.qt.sql.QSqlDatabase());
    }
    
    /**
     * <p>Overloaded constructor for {@link #QSqlTableModel(io.qt.core.QObject, io.qt.sql.QSqlDatabase)}</p>
     * <p>with: </p><ul>
     * <li><code>parent = null</code></li>
     * <li><code>db = new io.qt.sql.QSqlDatabase()</code></li>
     * </ul>
     */
    public QSqlTableModel() {
        this((io.qt.core.QObject)null, new io.qt.sql.QSqlDatabase());
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#QSqlTableModel">QSqlTableModel::<wbr>QSqlTableModel(QObject*,<wbr>QSqlDatabase)</a></code></p>
     */
    public QSqlTableModel(io.qt.core.@Nullable QObject parent, io.qt.sql.@NonNull QSqlDatabase db){
        super((QPrivateConstructor)null);
        initialize_native(this, parent, db);
    }
    
    private native static void initialize_native(QSqlTableModel instance, io.qt.core.QObject parent, io.qt.sql.QSqlDatabase db);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#database">QSqlTableModel::<wbr>database()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.sql.@NonNull QSqlDatabase database(){
        return database_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlDatabase database_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#editStrategy">QSqlTableModel::<wbr>editStrategy()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.sql.QSqlTableModel.@NonNull EditStrategy editStrategy(){
        return io.qt.sql.QSqlTableModel.EditStrategy.resolve(editStrategy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int editStrategy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#fieldIndex">QSqlTableModel::<wbr>fieldIndex(QString)const</a></code></p>
     */
    @QtUninvokable
    public final int fieldIndex(java.lang.@NonNull String fieldName){
        return fieldIndex_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), fieldName);
    }
    
    @QtUninvokable
    private native int fieldIndex_native_cref_QString_constfct(long __this__nativeId, java.lang.String fieldName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#filter">QSqlTableModel::<wbr>filter()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String filter(){
        return filter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String filter_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#insertRecord">QSqlTableModel::<wbr>insertRecord(int,<wbr>QSqlRecord)</a></code></p>
     */
    @QtUninvokable
    public final boolean insertRecord(int row, io.qt.sql.@NonNull QSqlRecord record){
        return insertRecord_native_int_cref_QSqlRecord(QtJambi_LibraryUtilities.internal.nativeId(this), row, QtJambi_LibraryUtilities.internal.checkedNativeId(record));
    }
    
    @QtUninvokable
    private native boolean insertRecord_native_int_cref_QSqlRecord(long __this__nativeId, int row, long record);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#isDirty-1">QSqlTableModel::<wbr>isDirty()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isDirty(){
        return isDirty_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isDirty_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#isDirty">QSqlTableModel::<wbr>isDirty(QModelIndex)const</a></code></p>
     */
    @QtUninvokable
    public final boolean isDirty(io.qt.core.@NonNull QModelIndex index){
        return isDirty_native_cref_QModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(index));
    }
    
    @QtUninvokable
    private native boolean isDirty_native_cref_QModelIndex_constfct(long __this__nativeId, long index);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#primaryKey">QSqlTableModel::<wbr>primaryKey()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.sql.@NonNull QSqlIndex primaryKey(){
        return primaryKey_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlIndex primaryKey_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#primaryValues">QSqlTableModel::<wbr>primaryValues(int)const</a></code></p>
     */
    @QtUninvokable
    protected final io.qt.sql.@NonNull QSqlRecord primaryValues(int row){
        return primaryValues_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), row);
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlRecord primaryValues_native_int_constfct(long __this__nativeId, int row);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlquerymodel.html#record-1">QSqlQueryModel::<wbr>record()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.sql.@NonNull QSqlRecord record(){
        return record_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlRecord record_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlquerymodel.html#record">QSqlQueryModel::<wbr>record(int)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.sql.@NonNull QSqlRecord record(int row){
        return record_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), row);
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlRecord record_native_int_constfct(long __this__nativeId, int row);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#revertAll">QSqlTableModel::<wbr>revertAll()</a></code></p>
     */
    public final void revertAll(){
        revertAll_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void revertAll_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#setPrimaryKey">QSqlTableModel::<wbr>setPrimaryKey(QSqlIndex)</a></code></p>
     */
    @QtUninvokable
    protected final void setPrimaryKey(io.qt.sql.@NonNull QSqlIndex key){
        setPrimaryKey_native_cref_QSqlIndex(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(key));
    }
    
    @QtUninvokable
    private native void setPrimaryKey_native_cref_QSqlIndex(long __this__nativeId, long key);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#setRecord">QSqlTableModel::<wbr>setRecord(int,<wbr>QSqlRecord)</a></code></p>
     */
    @QtUninvokable
    public final boolean setRecord(int row, io.qt.sql.@NonNull QSqlRecord record){
        return setRecord_native_int_cref_QSqlRecord(QtJambi_LibraryUtilities.internal.nativeId(this), row, QtJambi_LibraryUtilities.internal.checkedNativeId(record));
    }
    
    @QtUninvokable
    private native boolean setRecord_native_int_cref_QSqlRecord(long __this__nativeId, int row, long record);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#submitAll">QSqlTableModel::<wbr>submitAll()</a></code></p>
     */
    public final boolean submitAll(){
        return submitAll_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native boolean submitAll_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#tableName">QSqlTableModel::<wbr>tableName()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String tableName(){
        return tableName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String tableName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlquerymodel.html#clear">QSqlQueryModel::<wbr>clear()</a></code></p>
     */
    @QtUninvokable
    public void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void clear_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodel.html#clearItemData">QAbstractItemModel::<wbr>clearItemData(QModelIndex)</a></code></p>
     */
    @QtUninvokable
    public boolean clearItemData(io.qt.core.@NonNull QModelIndex index){
        return clearItemData_native_cref_QModelIndex(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(index));
    }
    
    @QtUninvokable
    private native boolean clearItemData_native_cref_QModelIndex(long __this__nativeId, long index);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodel.html#data">QAbstractItemModel::<wbr>data(QModelIndex,<wbr>int)const</a></code></p>
     */
    @QtUninvokable
    public java.lang.Object data(io.qt.core.@NonNull QModelIndex idx, int role){
        return data_native_cref_QModelIndex_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(idx), role);
    }
    
    @QtUninvokable
    private native java.lang.Object data_native_cref_QModelIndex_int_constfct(long __this__nativeId, long idx, int role);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#deleteRowFromTable">QSqlTableModel::<wbr>deleteRowFromTable(int)</a></code></p>
     */
    @QtUninvokable
    protected boolean deleteRowFromTable(int row){
        return deleteRowFromTable_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), row);
    }
    
    @QtUninvokable
    private native boolean deleteRowFromTable_native_int(long __this__nativeId, int row);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodel.html#flags">QAbstractItemModel::<wbr>flags(QModelIndex)const</a></code></p>
     */
    @QtUninvokable
    public io.qt.core.Qt.@NonNull ItemFlags flags(io.qt.core.@NonNull QModelIndex index){
        return new io.qt.core.Qt.ItemFlags(flags_native_cref_QModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(index)));
    }
    
    @QtUninvokable
    private native int flags_native_cref_QModelIndex_constfct(long __this__nativeId, long index);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodel.html#headerData">QAbstractItemModel::<wbr>headerData(int,<wbr>Qt::Orientation,<wbr>int)const</a></code></p>
     */
    @QtUninvokable
    public java.lang.Object headerData(int section, io.qt.core.Qt.@NonNull Orientation orientation, int role){
        return headerData_native_int_Qt_Orientation_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), section, orientation.value(), role);
    }
    
    @QtUninvokable
    private native java.lang.Object headerData_native_int_Qt_Orientation_int_constfct(long __this__nativeId, int section, int orientation, int role);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlquerymodel.html#indexInQuery">QSqlQueryModel::<wbr>indexInQuery(QModelIndex)const</a></code></p>
     */
    @QtUninvokable
    protected io.qt.core.@NonNull QModelIndex indexInQuery(io.qt.core.@NonNull QModelIndex item){
        return indexInQuery_native_cref_QModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(item));
    }
    
    @QtUninvokable
    private native io.qt.core.QModelIndex indexInQuery_native_cref_QModelIndex_constfct(long __this__nativeId, long item);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#insertRowIntoTable">QSqlTableModel::<wbr>insertRowIntoTable(QSqlRecord)</a></code></p>
     */
    @QtUninvokable
    protected boolean insertRowIntoTable(io.qt.sql.@NonNull QSqlRecord values){
        return insertRowIntoTable_native_cref_QSqlRecord(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(values));
    }
    
    @QtUninvokable
    private native boolean insertRowIntoTable_native_cref_QSqlRecord(long __this__nativeId, long values);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodel.html#insertRows">QAbstractItemModel::<wbr>insertRows(int,<wbr>int,<wbr>QModelIndex)</a></code></p>
     */
    @QtUninvokable
    public boolean insertRows(int row, int count, io.qt.core.@NonNull QModelIndex parent){
        return insertRows_native_int_int_cref_QModelIndex(QtJambi_LibraryUtilities.internal.nativeId(this), row, count, QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @QtUninvokable
    private native boolean insertRows_native_int_int_cref_QModelIndex(long __this__nativeId, int row, int count, long parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#orderByClause">QSqlTableModel::<wbr>orderByClause()const</a></code></p>
     */
    @QtUninvokable
    protected java.lang.@NonNull String orderByClause(){
        return orderByClause_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String orderByClause_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodel.html#removeColumns">QAbstractItemModel::<wbr>removeColumns(int,<wbr>int,<wbr>QModelIndex)</a></code></p>
     */
    @QtUninvokable
    public boolean removeColumns(int column, int count, io.qt.core.@NonNull QModelIndex parent){
        return removeColumns_native_int_int_cref_QModelIndex(QtJambi_LibraryUtilities.internal.nativeId(this), column, count, QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @QtUninvokable
    private native boolean removeColumns_native_int_int_cref_QModelIndex(long __this__nativeId, int column, int count, long parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodel.html#removeRows">QAbstractItemModel::<wbr>removeRows(int,<wbr>int,<wbr>QModelIndex)</a></code></p>
     */
    @QtUninvokable
    public boolean removeRows(int row, int count, io.qt.core.@NonNull QModelIndex parent){
        return removeRows_native_int_int_cref_QModelIndex(QtJambi_LibraryUtilities.internal.nativeId(this), row, count, QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @QtUninvokable
    private native boolean removeRows_native_int_int_cref_QModelIndex(long __this__nativeId, int row, int count, long parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodel.html#revert">QAbstractItemModel::<wbr>revert()</a></code></p>
     */
    public void revert(){
        revert_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void revert_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#revertRow">QSqlTableModel::<wbr>revertRow(int)</a></code></p>
     */
    @QtUninvokable
    public void revertRow(int row){
        revertRow_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), row);
    }
    
    @QtUninvokable
    private native void revertRow_native_int(long __this__nativeId, int row);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodel.html#rowCount">QAbstractItemModel::<wbr>rowCount(QModelIndex)const</a></code></p>
     */
    @QtUninvokable
    public int rowCount(io.qt.core.@NonNull QModelIndex parent){
        return rowCount_native_cref_QModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @QtUninvokable
    private native int rowCount_native_cref_QModelIndex_constfct(long __this__nativeId, long parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#select">QSqlTableModel::<wbr>select()</a></code></p>
     */
    public boolean select(){
        return select_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native boolean select_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#selectRow">QSqlTableModel::<wbr>selectRow(int)</a></code></p>
     */
    public boolean selectRow(int row){
        return selectRow_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), row);
    }
    
    private native boolean selectRow_native_int(long __this__nativeId, int row);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#selectStatement">QSqlTableModel::<wbr>selectStatement()const</a></code></p>
     */
    @QtUninvokable
    protected java.lang.@NonNull String selectStatement(){
        return selectStatement_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String selectStatement_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodel.html#setData">QAbstractItemModel::<wbr>setData(QModelIndex,<wbr>QVariant,<wbr>int)</a></code></p>
     */
    @QtUninvokable
    public boolean setData(io.qt.core.@NonNull QModelIndex index, java.lang.Object value, int role){
        return setData_native_cref_QModelIndex_cref_QVariant_int(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(index), value, role);
    }
    
    @QtUninvokable
    private native boolean setData_native_cref_QModelIndex_cref_QVariant_int(long __this__nativeId, long index, java.lang.Object value, int role);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#setEditStrategy">QSqlTableModel::<wbr>setEditStrategy(QSqlTableModel::EditStrategy)</a></code></p>
     */
    @QtUninvokable
    public void setEditStrategy(io.qt.sql.QSqlTableModel.@NonNull EditStrategy strategy){
        setEditStrategy_native_QSqlTableModel_EditStrategy(QtJambi_LibraryUtilities.internal.nativeId(this), strategy.value());
    }
    
    @QtUninvokable
    private native void setEditStrategy_native_QSqlTableModel_EditStrategy(long __this__nativeId, int strategy);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#setFilter">QSqlTableModel::<wbr>setFilter(QString)</a></code></p>
     */
    @QtUninvokable
    public void setFilter(java.lang.@NonNull String filter){
        setFilter_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), filter);
    }
    
    @QtUninvokable
    private native void setFilter_native_cref_QString(long __this__nativeId, java.lang.String filter);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#setSort">QSqlTableModel::<wbr>setSort(int,<wbr>Qt::SortOrder)</a></code></p>
     */
    @QtUninvokable
    public void setSort(int column, io.qt.core.Qt.@NonNull SortOrder order){
        setSort_native_int_Qt_SortOrder(QtJambi_LibraryUtilities.internal.nativeId(this), column, order.value());
    }
    
    @QtUninvokable
    private native void setSort_native_int_Qt_SortOrder(long __this__nativeId, int column, int order);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#setTable">QSqlTableModel::<wbr>setTable(QString)</a></code></p>
     */
    @QtUninvokable
    public void setTable(java.lang.@NonNull String tableName){
        setTable_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), tableName);
    }
    
    @QtUninvokable
    private native void setTable_native_cref_QString(long __this__nativeId, java.lang.String tableName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodel.html#sort">QAbstractItemModel::<wbr>sort(int,<wbr>Qt::SortOrder)</a></code></p>
     */
    @QtUninvokable
    public void sort(int column, io.qt.core.Qt.@NonNull SortOrder order){
        sort_native_int_Qt_SortOrder(QtJambi_LibraryUtilities.internal.nativeId(this), column, order.value());
    }
    
    @QtUninvokable
    private native void sort_native_int_Qt_SortOrder(long __this__nativeId, int column, int order);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodel.html#submit">QAbstractItemModel::<wbr>submit()</a></code></p>
     */
    public boolean submit(){
        return submit_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native boolean submit_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqltablemodel.html#updateRowInTable">QSqlTableModel::<wbr>updateRowInTable(int,<wbr>QSqlRecord)</a></code></p>
     */
    @QtUninvokable
    protected boolean updateRowInTable(int row, io.qt.sql.@NonNull QSqlRecord values){
        return updateRowInTable_native_int_cref_QSqlRecord(QtJambi_LibraryUtilities.internal.nativeId(this), row, QtJambi_LibraryUtilities.internal.checkedNativeId(values));
    }
    
    @QtUninvokable
    private native boolean updateRowInTable_native_int_cref_QSqlRecord(long __this__nativeId, int row, long values);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QSqlTableModel(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QSqlTableModel(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QSqlTableModel instance, QDeclarativeConstructor constructor);
    
}
