package io.qt.sql;

import io.qt.*;


/**
 * <p>Encapsulates a database record</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qsqlrecord.html">QSqlRecord</a></code></p>
 */
public class QSqlRecord extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#QSqlRecord">QSqlRecord::<wbr>QSqlRecord()</a></code></p>
     */
    public QSqlRecord(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSqlRecord instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#QSqlRecord-1">QSqlRecord::<wbr>QSqlRecord(QSqlRecord)</a></code></p>
     */
    public QSqlRecord(io.qt.sql.@NonNull QSqlRecord other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QSqlRecord instance, io.qt.sql.QSqlRecord other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#append">QSqlRecord::<wbr>append(QSqlField)</a></code></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public void append(io.qt.sql.@NonNull QSqlField field){
        append_native_cref_QSqlField(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(field));
    }
    
    @QtUninvokable
    private native void append_native_cref_QSqlField(long __this__nativeId, long field);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#clear">QSqlRecord::<wbr>clear()</a></code></p>
     */
    @QtUninvokable
    public final void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void clear_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#clearValues">QSqlRecord::<wbr>clearValues()</a></code></p>
     */
    @QtUninvokable
    public final void clearValues(){
        clearValues_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void clearValues_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#contains">QSqlRecord::<wbr>contains(QString)const</a></code></p>
     */
    @QtUninvokable
    public final boolean contains(java.lang.@NonNull String name){
        return contains_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native boolean contains_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#count">QSqlRecord::<wbr>count()const</a></code></p>
     */
    @QtUninvokable
    public final int count(){
        return count_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int count_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#field-1">QSqlRecord::<wbr>field(QString)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.sql.@NonNull QSqlField field(java.lang.@NonNull String name){
        return field_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlField field_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#field">QSqlRecord::<wbr>field(int)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.sql.@NonNull QSqlField field(int i){
        return field_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), i);
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlField field_native_int_constfct(long __this__nativeId, int i);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#fieldName">QSqlRecord::<wbr>fieldName(int)const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String fieldName(int i){
        return fieldName_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), i);
    }
    
    @QtUninvokable
    private native java.lang.String fieldName_native_int_constfct(long __this__nativeId, int i);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#indexOf">QSqlRecord::<wbr>indexOf(QString)const</a></code></p>
     */
    @QtUninvokable
    public final int indexOf(java.lang.@NonNull String name){
        return indexOf_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native int indexOf_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#insert">QSqlRecord::<wbr>insert(int,<wbr>QSqlField)</a></code></p>
     */
    @QtUninvokable
    public final void insert(int pos, io.qt.sql.@NonNull QSqlField field){
        insert_native_int_cref_QSqlField(QtJambi_LibraryUtilities.internal.nativeId(this), pos, QtJambi_LibraryUtilities.internal.checkedNativeId(field));
    }
    
    @QtUninvokable
    private native void insert_native_int_cref_QSqlField(long __this__nativeId, int pos, long field);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#isEmpty">QSqlRecord::<wbr>isEmpty()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isEmpty(){
        return isEmpty_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isEmpty_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#isGenerated">QSqlRecord::<wbr>isGenerated(QString)const</a></code></p>
     */
    @QtUninvokable
    public final boolean isGenerated(java.lang.@NonNull String name){
        return isGenerated_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native boolean isGenerated_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#isGenerated-1">QSqlRecord::<wbr>isGenerated(int)const</a></code></p>
     */
    @QtUninvokable
    public final boolean isGenerated(int i){
        return isGenerated_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), i);
    }
    
    @QtUninvokable
    private native boolean isGenerated_native_int_constfct(long __this__nativeId, int i);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#isNull">QSqlRecord::<wbr>isNull(QString)const</a></code></p>
     */
    @QtUninvokable
    public final boolean isNull(java.lang.@NonNull String name){
        return isNull_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native boolean isNull_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#isNull-1">QSqlRecord::<wbr>isNull(int)const</a></code></p>
     */
    @QtUninvokable
    public final boolean isNull(int i){
        return isNull_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), i);
    }
    
    @QtUninvokable
    private native boolean isNull_native_int_constfct(long __this__nativeId, int i);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#keyValues">QSqlRecord::<wbr>keyValues(QSqlRecord)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.sql.@NonNull QSqlRecord keyValues(io.qt.sql.@NonNull QSqlRecord keyFields){
        return keyValues_native_cref_QSqlRecord_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(keyFields));
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlRecord keyValues_native_cref_QSqlRecord_constfct(long __this__nativeId, long keyFields);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#operator-eq">QSqlRecord::<wbr>operator=(QSqlRecord)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.sql.@NonNull QSqlRecord other){
        assign_native_cref_QSqlRecord(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QSqlRecord(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#operator-eq-eq">QSqlRecord::<wbr>operator==(QSqlRecord)const</a></code></p>
     */
    @QtUninvokable
    private final boolean operator_equal(io.qt.sql.@NonNull QSqlRecord other){
        return operator_equal_native_cref_QSqlRecord_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QSqlRecord_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#remove">QSqlRecord::<wbr>remove(int)</a></code></p>
     */
    @QtUninvokable
    public final void remove(int pos){
        remove_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), pos);
    }
    
    @QtUninvokable
    private native void remove_native_int(long __this__nativeId, int pos);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#replace">QSqlRecord::<wbr>replace(int,<wbr>QSqlField)</a></code></p>
     */
    @QtUninvokable
    public final void replace(int pos, io.qt.sql.@NonNull QSqlField field){
        replace_native_int_cref_QSqlField(QtJambi_LibraryUtilities.internal.nativeId(this), pos, QtJambi_LibraryUtilities.internal.checkedNativeId(field));
    }
    
    @QtUninvokable
    private native void replace_native_int_cref_QSqlField(long __this__nativeId, int pos, long field);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#setGenerated">QSqlRecord::<wbr>setGenerated(QString,<wbr>bool)</a></code></p>
     */
    @QtUninvokable
    public final void setGenerated(java.lang.@NonNull String name, boolean generated){
        setGenerated_native_cref_QString_bool(QtJambi_LibraryUtilities.internal.nativeId(this), name, generated);
    }
    
    @QtUninvokable
    private native void setGenerated_native_cref_QString_bool(long __this__nativeId, java.lang.String name, boolean generated);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#setGenerated-1">QSqlRecord::<wbr>setGenerated(int,<wbr>bool)</a></code></p>
     */
    @QtUninvokable
    public final void setGenerated(int i, boolean generated){
        setGenerated_native_int_bool(QtJambi_LibraryUtilities.internal.nativeId(this), i, generated);
    }
    
    @QtUninvokable
    private native void setGenerated_native_int_bool(long __this__nativeId, int i, boolean generated);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#setNull-1">QSqlRecord::<wbr>setNull(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setNull(java.lang.@NonNull String name){
        setNull_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void setNull_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#setNull">QSqlRecord::<wbr>setNull(int)</a></code></p>
     */
    @QtUninvokable
    public final void setNull(int i){
        setNull_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), i);
    }
    
    @QtUninvokable
    private native void setNull_native_int(long __this__nativeId, int i);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#setValue-1">QSqlRecord::<wbr>setValue(QString,<wbr>QVariant)</a></code></p>
     */
    @QtUninvokable
    public final void setValue(java.lang.@NonNull String name, java.lang.Object val){
        setValue_native_cref_QString_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), name, val);
    }
    
    @QtUninvokable
    private native void setValue_native_cref_QString_cref_QVariant(long __this__nativeId, java.lang.String name, java.lang.Object val);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#setValue">QSqlRecord::<wbr>setValue(int,<wbr>QVariant)</a></code></p>
     */
    @QtUninvokable
    public final void setValue(int i, java.lang.Object val){
        setValue_native_int_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), i, val);
    }
    
    @QtUninvokable
    private native void setValue_native_int_cref_QVariant(long __this__nativeId, int i, java.lang.Object val);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#value-1">QSqlRecord::<wbr>value(QString)const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.Object value(java.lang.@NonNull String name){
        return value_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native java.lang.Object value_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#value">QSqlRecord::<wbr>value(int)const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.Object value(int i){
        return value_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), i);
    }
    
    @QtUninvokable
    private native java.lang.Object value_native_int_constfct(long __this__nativeId, int i);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QSqlRecord(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsqlrecord.html#operator-eq-eq">QSqlRecord::<wbr>operator==(QSqlRecord)const</a></code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.sql.QSqlRecord) {
            return operator_equal((io.qt.sql.QSqlRecord) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QSqlRecord)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);

    /**
     * <p>See <code>operator&lt;&lt;(QDebug,<wbr>QSqlRecord)</code></p>
     */
    @QtUninvokable
    @Override
    public @NonNull String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private static native String toString_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QSqlRecord clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QSqlRecord clone_native(long __this_nativeId);
}
