package io.qt.sql;

import io.qt.*;


/**
 * <p>Functions to manipulate and describe database indexes</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsqlindex.html">QSqlIndex</a></p>
 */
public class QSqlIndex extends io.qt.sql.QSqlRecord
    implements java.lang.Cloneable
{
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlindex.html#QSqlIndex-1">QSqlIndex::QSqlIndex(QSqlIndex)</a></p>
     */
    public QSqlIndex(io.qt.sql.@NonNull QSqlIndex other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QSqlIndex instance, io.qt.sql.QSqlIndex other);
    
    /**
     * <p>Overloaded constructor for {@link #QSqlIndex(java.lang.String, java.lang.String)}
     *  with <code>name = (String)null</code>.</p>
     */
    public QSqlIndex(java.lang.@NonNull String cursorName) {
        this(cursorName, (String)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QSqlIndex(java.lang.String, java.lang.String)}</p>
     * <p>with: </p><ul>
     * <li><code>cursorName = (String)null</code></li>
     * <li><code>name = (String)null</code></li>
     * </ul>
     */
    public QSqlIndex() {
        this((String)null, (String)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlindex.html#QSqlIndex">QSqlIndex::QSqlIndex(QString,QString)</a></p>
     */
    public QSqlIndex(java.lang.@NonNull String cursorName, java.lang.@NonNull String name){
        super((QPrivateConstructor)null);
        initialize_native(this, cursorName, name);
    }
    
    private native static void initialize_native(QSqlIndex instance, java.lang.String cursorName, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlrecord.html#append">QSqlRecord::append(QSqlField)</a></p>
     */
    @QtUninvokable
    public final void append(io.qt.sql.@NonNull QSqlField field){
        append_native_cref_QSqlField(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(field));
    }
    
    @QtUninvokable
    private native void append_native_cref_QSqlField(long __this__nativeId, long field);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlindex.html#append-1">QSqlIndex::append(QSqlField,bool)</a></p>
     */
    @QtUninvokable
    public final void append(io.qt.sql.@NonNull QSqlField field, boolean desc){
        append_native_cref_QSqlField_bool(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(field), desc);
    }
    
    @QtUninvokable
    private native void append_native_cref_QSqlField_bool(long __this__nativeId, long field, boolean desc);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlindex.html#cursorName">QSqlIndex::cursorName()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String cursorName(){
        return cursorName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String cursorName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlindex.html#isDescending">QSqlIndex::isDescending(int)const</a></p>
     */
    @QtUninvokable
    public final boolean isDescending(int i){
        return isDescending_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), i);
    }
    
    @QtUninvokable
    private native boolean isDescending_native_int_constfct(long __this__nativeId, int i);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlindex.html#name">QSqlIndex::name()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlindex.html#operator-eq">QSqlIndex::operator=(QSqlIndex)</a></p>
     */
    @QtUninvokable
    public final void assign(io.qt.sql.@NonNull QSqlIndex other){
        assign_native_cref_QSqlIndex(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QSqlIndex(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlindex.html#setCursorName">QSqlIndex::setCursorName(QString)</a></p>
     */
    @QtUninvokable
    public final void setCursorName(java.lang.@NonNull String cursorName){
        setCursorName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), cursorName);
    }
    
    @QtUninvokable
    private native void setCursorName_native_cref_QString(long __this__nativeId, java.lang.String cursorName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlindex.html#setDescending">QSqlIndex::setDescending(int,bool)</a></p>
     */
    @QtUninvokable
    public final void setDescending(int i, boolean desc){
        setDescending_native_int_bool(QtJambi_LibraryUtilities.internal.nativeId(this), i, desc);
    }
    
    @QtUninvokable
    private native void setDescending_native_int_bool(long __this__nativeId, int i, boolean desc);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlindex.html#setName">QSqlIndex::setName(QString)</a></p>
     */
    @QtUninvokable
    public final void setName(java.lang.@NonNull String name){
        setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void setName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QSqlIndex(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QSqlIndex clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QSqlIndex clone_native(long __this_nativeId);
}
