package io.qt.sql;

import io.qt.*;


/**
 * <p>SQL database error information</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsqlerror.html">QSqlError</a></p>
 */
public class QSqlError extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsqlerror.html#ErrorType-enum">QSqlError::ErrorType</a></p>
     */
    public enum ErrorType implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qsqlerror.html#ErrorType-enum">QSqlError::NoError</a></p>
         */
        NoError(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qsqlerror.html#ErrorType-enum">QSqlError::ConnectionError</a></p>
         */
        ConnectionError(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qsqlerror.html#ErrorType-enum">QSqlError::StatementError</a></p>
         */
        StatementError(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qsqlerror.html#ErrorType-enum">QSqlError::TransactionError</a></p>
         */
        TransactionError(3),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qsqlerror.html#ErrorType-enum">QSqlError::UnknownError</a></p>
         */
        UnknownError(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ErrorType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ErrorType resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return ConnectionError;
            case 2: return StatementError;
            case 3: return TransactionError;
            case 4: return UnknownError;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlerror.html#QSqlError-1">QSqlError::QSqlError(QSqlError)</a></p>
     */
    public QSqlError(io.qt.sql.@NonNull QSqlError other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QSqlError instance, io.qt.sql.QSqlError other);
    
    /**
     * <p>Overloaded constructor for {@link #QSqlError(java.lang.String, java.lang.String, io.qt.sql.QSqlError.ErrorType, java.lang.String)}
     *  with <code>errorCode = (String)null</code>.</p>
     */
    public QSqlError(java.lang.@NonNull String driverText, java.lang.@NonNull String databaseText, io.qt.sql.QSqlError.@NonNull ErrorType type) {
        this(driverText, databaseText, type, (String)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QSqlError(java.lang.String, java.lang.String, io.qt.sql.QSqlError.ErrorType, java.lang.String)}</p>
     * <p>with: </p><ul>
     * <li><code>type = io.qt.sql.QSqlError.ErrorType.NoError</code></li>
     * <li><code>errorCode = (String)null</code></li>
     * </ul>
     */
    public QSqlError(java.lang.@NonNull String driverText, java.lang.@NonNull String databaseText) {
        this(driverText, databaseText, io.qt.sql.QSqlError.ErrorType.NoError, (String)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QSqlError(java.lang.String, java.lang.String, io.qt.sql.QSqlError.ErrorType, java.lang.String)}</p>
     * <p>with: </p><ul>
     * <li><code>databaseText = (String)null</code></li>
     * <li><code>type = io.qt.sql.QSqlError.ErrorType.NoError</code></li>
     * <li><code>errorCode = (String)null</code></li>
     * </ul>
     */
    public QSqlError(java.lang.@NonNull String driverText) {
        this(driverText, (String)null, io.qt.sql.QSqlError.ErrorType.NoError, (String)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QSqlError(java.lang.String, java.lang.String, io.qt.sql.QSqlError.ErrorType, java.lang.String)}</p>
     * <p>with: </p><ul>
     * <li><code>driverText = (String)null</code></li>
     * <li><code>databaseText = (String)null</code></li>
     * <li><code>type = io.qt.sql.QSqlError.ErrorType.NoError</code></li>
     * <li><code>errorCode = (String)null</code></li>
     * </ul>
     */
    public QSqlError() {
        this((String)null, (String)null, io.qt.sql.QSqlError.ErrorType.NoError, (String)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlerror.html#QSqlError">QSqlError::QSqlError(QString,QString,QSqlError::ErrorType,QString)</a></p>
     */
    public QSqlError(java.lang.@NonNull String driverText, java.lang.@NonNull String databaseText, io.qt.sql.QSqlError.@NonNull ErrorType type, java.lang.@NonNull String errorCode){
        super((QPrivateConstructor)null);
        initialize_native(this, driverText, databaseText, type, errorCode);
    }
    
    private native static void initialize_native(QSqlError instance, java.lang.String driverText, java.lang.String databaseText, io.qt.sql.QSqlError.ErrorType type, java.lang.String errorCode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlerror.html#databaseText">QSqlError::databaseText()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String databaseText(){
        return databaseText_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String databaseText_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlerror.html#driverText">QSqlError::driverText()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String driverText(){
        return driverText_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String driverText_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlerror.html#isValid">QSqlError::isValid()const</a></p>
     */
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlerror.html#nativeErrorCode">QSqlError::nativeErrorCode()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String nativeErrorCode(){
        return nativeErrorCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String nativeErrorCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlerror.html#operator-eq">QSqlError::operator=(QSqlError)</a></p>
     */
    @QtUninvokable
    public final void assign(io.qt.sql.@NonNull QSqlError other){
        assign_native_cref_QSqlError(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QSqlError(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlerror.html#operator-eq-eq">QSqlError::operator==(QSqlError)const</a></p>
     */
    @QtUninvokable
    private final boolean operator_equal(io.qt.sql.@NonNull QSqlError other){
        return operator_equal_native_cref_QSqlError_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QSqlError_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlerror.html#swap">QSqlError::swap(QSqlError&amp;)</a></p>
     */
    @QtUninvokable
    public final void swap(io.qt.sql.@StrictNonNull QSqlError other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QSqlError(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QSqlError(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlerror.html#text">QSqlError::text()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String text(){
        return text_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String text_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlerror.html#type">QSqlError::type()const</a></p>
     */
    @QtUninvokable
    public final io.qt.sql.QSqlError.@NonNull ErrorType type(){
        return io.qt.sql.QSqlError.ErrorType.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QSqlError(QPrivateConstructor p) { super(p); } 
    

    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.sql.QSqlError) {
            return operator_equal((io.qt.sql.QSqlError) other);
        }

        return false;
    }


    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);

    @Override
    @QtUninvokable
    public @NonNull String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private static native String toString_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QSqlError clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QSqlError clone_native(long __this_nativeId);
}
