package io.qt.sql;

import io.qt.*;


/**
 * <p>Editable data model for a single database table</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsqltablemodel.html">QSqlTableModel</a></p>
 */
public class QSqlTableModel extends io.qt.sql.QSqlQueryModel
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSqlTableModel.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsqltablemodel.html#EditStrategy-enum">QSqlTableModel::EditStrategy</a></p>
     */
    @QtUnlistedEnum
    public enum EditStrategy implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qsqltablemodel.html#EditStrategy-enum">QSqlTableModel::OnFieldChange</a></p>
         */
        OnFieldChange(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qsqltablemodel.html#EditStrategy-enum">QSqlTableModel::OnRowChange</a></p>
         */
        OnRowChange(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qsqltablemodel.html#EditStrategy-enum">QSqlTableModel::OnManualSubmit</a></p>
         */
        OnManualSubmit(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private EditStrategy(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull EditStrategy resolve(int value) {
            switch (value) {
            case 0: return OnFieldChange;
            case 1: return OnRowChange;
            case 2: return OnManualSubmit;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#beforeDelete">QSqlTableModel::beforeDelete(int)</a></p>
     */
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> beforeDelete = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#beforeInsert">QSqlTableModel::beforeInsert(QSqlRecord&amp;)</a></p>
     */
    public final @NonNull Signal1<io.qt.sql.@NonNull QSqlRecord> beforeInsert = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#beforeUpdate">QSqlTableModel::beforeUpdate(int,QSqlRecord&amp;)</a></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, io.qt.sql.@NonNull QSqlRecord> beforeUpdate = new Signal2<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#primeInsert">QSqlTableModel::primeInsert(int,QSqlRecord&amp;)</a></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, io.qt.sql.@NonNull QSqlRecord> primeInsert = new Signal2<>();
    
    /**
     * <p>Overloaded constructor for {@link #QSqlTableModel(io.qt.core.QObject, io.qt.sql.QSqlDatabase)}
     *  with <code>db = new io.qt.sql.QSqlDatabase()</code>.</p>
     */
    public QSqlTableModel(io.qt.core.@Nullable QObject parent) {
        this(parent, new io.qt.sql.QSqlDatabase());
    }
    
    /**
     * <p>Overloaded constructor for {@link #QSqlTableModel(io.qt.core.QObject, io.qt.sql.QSqlDatabase)}</p>
     * <p>with: </p><ul>
     * <li><code>parent = null</code></li>
     * <li><code>db = new io.qt.sql.QSqlDatabase()</code></li>
     * </ul>
     */
    public QSqlTableModel() {
        this((io.qt.core.QObject)null, new io.qt.sql.QSqlDatabase());
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#QSqlTableModel">QSqlTableModel::QSqlTableModel(QObject*,QSqlDatabase)</a></p>
     */
    public QSqlTableModel(io.qt.core.@Nullable QObject parent, io.qt.sql.@NonNull QSqlDatabase db){
        super((QPrivateConstructor)null);
        initialize_native(this, parent, db);
    }
    
    private native static void initialize_native(QSqlTableModel instance, io.qt.core.QObject parent, io.qt.sql.QSqlDatabase db);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#database">QSqlTableModel::database()const</a></p>
     */
    @QtUninvokable
    public final io.qt.sql.@NonNull QSqlDatabase database(){
        return database_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlDatabase database_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#editStrategy">QSqlTableModel::editStrategy()const</a></p>
     */
    @QtUninvokable
    public final io.qt.sql.QSqlTableModel.@NonNull EditStrategy editStrategy(){
        return io.qt.sql.QSqlTableModel.EditStrategy.resolve(editStrategy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int editStrategy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#fieldIndex">QSqlTableModel::fieldIndex(QString)const</a></p>
     */
    @QtUninvokable
    public final int fieldIndex(java.lang.@NonNull String fieldName){
        return fieldIndex_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), fieldName);
    }
    
    @QtUninvokable
    private native int fieldIndex_native_cref_QString_constfct(long __this__nativeId, java.lang.String fieldName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#filter">QSqlTableModel::filter()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String filter(){
        return filter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String filter_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#insertRecord">QSqlTableModel::insertRecord(int,QSqlRecord)</a></p>
     */
    @QtUninvokable
    public final boolean insertRecord(int row, io.qt.sql.@NonNull QSqlRecord record){
        return insertRecord_native_int_cref_QSqlRecord(QtJambi_LibraryUtilities.internal.nativeId(this), row, QtJambi_LibraryUtilities.internal.checkedNativeId(record));
    }
    
    @QtUninvokable
    private native boolean insertRecord_native_int_cref_QSqlRecord(long __this__nativeId, int row, long record);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#isDirty-1">QSqlTableModel::isDirty()const</a></p>
     */
    @QtUninvokable
    public final boolean isDirty(){
        return isDirty_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isDirty_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#isDirty">QSqlTableModel::isDirty(QModelIndex)const</a></p>
     */
    @QtUninvokable
    public final boolean isDirty(io.qt.core.@NonNull QModelIndex index){
        return isDirty_native_cref_QModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(index));
    }
    
    @QtUninvokable
    private native boolean isDirty_native_cref_QModelIndex_constfct(long __this__nativeId, long index);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#primaryKey">QSqlTableModel::primaryKey()const</a></p>
     */
    @QtUninvokable
    public final io.qt.sql.@NonNull QSqlIndex primaryKey(){
        return primaryKey_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlIndex primaryKey_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#primaryValues">QSqlTableModel::primaryValues(int)const</a></p>
     */
    @QtUninvokable
    protected final io.qt.sql.@NonNull QSqlRecord primaryValues(int row){
        return primaryValues_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), row);
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlRecord primaryValues_native_int_constfct(long __this__nativeId, int row);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlquerymodel.html#record-1">QSqlQueryModel::record()const</a></p>
     */
    @QtUninvokable
    public final io.qt.sql.@NonNull QSqlRecord record(){
        return record_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlRecord record_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlquerymodel.html#record">QSqlQueryModel::record(int)const</a></p>
     */
    @QtUninvokable
    public final io.qt.sql.@NonNull QSqlRecord record(int row){
        return record_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), row);
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlRecord record_native_int_constfct(long __this__nativeId, int row);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#revertAll">QSqlTableModel::revertAll()</a></p>
     */
    public final void revertAll(){
        revertAll_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void revertAll_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#setPrimaryKey">QSqlTableModel::setPrimaryKey(QSqlIndex)</a></p>
     */
    @QtUninvokable
    protected final void setPrimaryKey(io.qt.sql.@NonNull QSqlIndex key){
        setPrimaryKey_native_cref_QSqlIndex(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(key));
    }
    
    @QtUninvokable
    private native void setPrimaryKey_native_cref_QSqlIndex(long __this__nativeId, long key);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#setRecord">QSqlTableModel::setRecord(int,QSqlRecord)</a></p>
     */
    @QtUninvokable
    public final boolean setRecord(int row, io.qt.sql.@NonNull QSqlRecord record){
        return setRecord_native_int_cref_QSqlRecord(QtJambi_LibraryUtilities.internal.nativeId(this), row, QtJambi_LibraryUtilities.internal.checkedNativeId(record));
    }
    
    @QtUninvokable
    private native boolean setRecord_native_int_cref_QSqlRecord(long __this__nativeId, int row, long record);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#submitAll">QSqlTableModel::submitAll()</a></p>
     */
    public final boolean submitAll(){
        return submitAll_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native boolean submitAll_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#tableName">QSqlTableModel::tableName()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String tableName(){
        return tableName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String tableName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlquerymodel.html#clear">QSqlQueryModel::clear()</a></p>
     */
    @QtUninvokable
    public void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void clear_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#clearItemData">QAbstractItemModel::clearItemData(QModelIndex)</a></p>
     */
    @QtUninvokable
    public boolean clearItemData(io.qt.core.@NonNull QModelIndex index){
        return clearItemData_native_cref_QModelIndex(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(index));
    }
    
    @QtUninvokable
    private native boolean clearItemData_native_cref_QModelIndex(long __this__nativeId, long index);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#data">QAbstractItemModel::data(QModelIndex,int)const</a></p>
     */
    @QtUninvokable
    public java.lang.Object data(io.qt.core.@NonNull QModelIndex idx, int role){
        return data_native_cref_QModelIndex_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(idx), role);
    }
    
    @QtUninvokable
    private native java.lang.Object data_native_cref_QModelIndex_int_constfct(long __this__nativeId, long idx, int role);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#deleteRowFromTable">QSqlTableModel::deleteRowFromTable(int)</a></p>
     */
    @QtUninvokable
    protected boolean deleteRowFromTable(int row){
        return deleteRowFromTable_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), row);
    }
    
    @QtUninvokable
    private native boolean deleteRowFromTable_native_int(long __this__nativeId, int row);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#flags">QAbstractItemModel::flags(QModelIndex)const</a></p>
     */
    @QtUninvokable
    public io.qt.core.Qt.@NonNull ItemFlags flags(io.qt.core.@NonNull QModelIndex index){
        return new io.qt.core.Qt.ItemFlags(flags_native_cref_QModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(index)));
    }
    
    @QtUninvokable
    private native int flags_native_cref_QModelIndex_constfct(long __this__nativeId, long index);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#headerData">QAbstractItemModel::headerData(int,Qt::Orientation,int)const</a></p>
     */
    @QtUninvokable
    public java.lang.Object headerData(int section, io.qt.core.Qt.@NonNull Orientation orientation, int role){
        return headerData_native_int_Qt_Orientation_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), section, orientation.value(), role);
    }
    
    @QtUninvokable
    private native java.lang.Object headerData_native_int_Qt_Orientation_int_constfct(long __this__nativeId, int section, int orientation, int role);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlquerymodel.html#indexInQuery">QSqlQueryModel::indexInQuery(QModelIndex)const</a></p>
     */
    @QtUninvokable
    protected io.qt.core.@NonNull QModelIndex indexInQuery(io.qt.core.@NonNull QModelIndex item){
        return indexInQuery_native_cref_QModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(item));
    }
    
    @QtUninvokable
    private native io.qt.core.QModelIndex indexInQuery_native_cref_QModelIndex_constfct(long __this__nativeId, long item);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#insertRowIntoTable">QSqlTableModel::insertRowIntoTable(QSqlRecord)</a></p>
     */
    @QtUninvokable
    protected boolean insertRowIntoTable(io.qt.sql.@NonNull QSqlRecord values){
        return insertRowIntoTable_native_cref_QSqlRecord(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(values));
    }
    
    @QtUninvokable
    private native boolean insertRowIntoTable_native_cref_QSqlRecord(long __this__nativeId, long values);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#insertRows">QAbstractItemModel::insertRows(int,int,QModelIndex)</a></p>
     */
    @QtUninvokable
    public boolean insertRows(int row, int count, io.qt.core.@NonNull QModelIndex parent){
        return insertRows_native_int_int_cref_QModelIndex(QtJambi_LibraryUtilities.internal.nativeId(this), row, count, QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @QtUninvokable
    private native boolean insertRows_native_int_int_cref_QModelIndex(long __this__nativeId, int row, int count, long parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#orderByClause">QSqlTableModel::orderByClause()const</a></p>
     */
    @QtUninvokable
    protected java.lang.@NonNull String orderByClause(){
        return orderByClause_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String orderByClause_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#removeColumns">QAbstractItemModel::removeColumns(int,int,QModelIndex)</a></p>
     */
    @QtUninvokable
    public boolean removeColumns(int column, int count, io.qt.core.@NonNull QModelIndex parent){
        return removeColumns_native_int_int_cref_QModelIndex(QtJambi_LibraryUtilities.internal.nativeId(this), column, count, QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @QtUninvokable
    private native boolean removeColumns_native_int_int_cref_QModelIndex(long __this__nativeId, int column, int count, long parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#removeRows">QAbstractItemModel::removeRows(int,int,QModelIndex)</a></p>
     */
    @QtUninvokable
    public boolean removeRows(int row, int count, io.qt.core.@NonNull QModelIndex parent){
        return removeRows_native_int_int_cref_QModelIndex(QtJambi_LibraryUtilities.internal.nativeId(this), row, count, QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @QtUninvokable
    private native boolean removeRows_native_int_int_cref_QModelIndex(long __this__nativeId, int row, int count, long parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#revert">QAbstractItemModel::revert()</a></p>
     */
    public void revert(){
        revert_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void revert_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#revertRow">QSqlTableModel::revertRow(int)</a></p>
     */
    @QtUninvokable
    public void revertRow(int row){
        revertRow_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), row);
    }
    
    @QtUninvokable
    private native void revertRow_native_int(long __this__nativeId, int row);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#rowCount">QAbstractItemModel::rowCount(QModelIndex)const</a></p>
     */
    @QtUninvokable
    public int rowCount(io.qt.core.@NonNull QModelIndex parent){
        return rowCount_native_cref_QModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @QtUninvokable
    private native int rowCount_native_cref_QModelIndex_constfct(long __this__nativeId, long parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#select">QSqlTableModel::select()</a></p>
     */
    public boolean select(){
        return select_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native boolean select_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#selectRow">QSqlTableModel::selectRow(int)</a></p>
     */
    public boolean selectRow(int row){
        return selectRow_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), row);
    }
    
    private native boolean selectRow_native_int(long __this__nativeId, int row);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#selectStatement">QSqlTableModel::selectStatement()const</a></p>
     */
    @QtUninvokable
    protected java.lang.@NonNull String selectStatement(){
        return selectStatement_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String selectStatement_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#setData">QAbstractItemModel::setData(QModelIndex,QVariant,int)</a></p>
     */
    @QtUninvokable
    public boolean setData(io.qt.core.@NonNull QModelIndex index, java.lang.Object value, int role){
        return setData_native_cref_QModelIndex_cref_QVariant_int(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(index), value, role);
    }
    
    @QtUninvokable
    private native boolean setData_native_cref_QModelIndex_cref_QVariant_int(long __this__nativeId, long index, java.lang.Object value, int role);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#setEditStrategy">QSqlTableModel::setEditStrategy(QSqlTableModel::EditStrategy)</a></p>
     */
    @QtUninvokable
    public void setEditStrategy(io.qt.sql.QSqlTableModel.@NonNull EditStrategy strategy){
        setEditStrategy_native_QSqlTableModel_EditStrategy(QtJambi_LibraryUtilities.internal.nativeId(this), strategy.value());
    }
    
    @QtUninvokable
    private native void setEditStrategy_native_QSqlTableModel_EditStrategy(long __this__nativeId, int strategy);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#setFilter">QSqlTableModel::setFilter(QString)</a></p>
     */
    @QtUninvokable
    public void setFilter(java.lang.@NonNull String filter){
        setFilter_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), filter);
    }
    
    @QtUninvokable
    private native void setFilter_native_cref_QString(long __this__nativeId, java.lang.String filter);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#setSort">QSqlTableModel::setSort(int,Qt::SortOrder)</a></p>
     */
    @QtUninvokable
    public void setSort(int column, io.qt.core.Qt.@NonNull SortOrder order){
        setSort_native_int_Qt_SortOrder(QtJambi_LibraryUtilities.internal.nativeId(this), column, order.value());
    }
    
    @QtUninvokable
    private native void setSort_native_int_Qt_SortOrder(long __this__nativeId, int column, int order);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#setTable">QSqlTableModel::setTable(QString)</a></p>
     */
    @QtUninvokable
    public void setTable(java.lang.@NonNull String tableName){
        setTable_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), tableName);
    }
    
    @QtUninvokable
    private native void setTable_native_cref_QString(long __this__nativeId, java.lang.String tableName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#sort">QAbstractItemModel::sort(int,Qt::SortOrder)</a></p>
     */
    @QtUninvokable
    public void sort(int column, io.qt.core.Qt.@NonNull SortOrder order){
        sort_native_int_Qt_SortOrder(QtJambi_LibraryUtilities.internal.nativeId(this), column, order.value());
    }
    
    @QtUninvokable
    private native void sort_native_int_Qt_SortOrder(long __this__nativeId, int column, int order);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#submit">QAbstractItemModel::submit()</a></p>
     */
    public boolean submit(){
        return submit_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native boolean submit_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#updateRowInTable">QSqlTableModel::updateRowInTable(int,QSqlRecord)</a></p>
     */
    @QtUninvokable
    protected boolean updateRowInTable(int row, io.qt.sql.@NonNull QSqlRecord values){
        return updateRowInTable_native_int_cref_QSqlRecord(QtJambi_LibraryUtilities.internal.nativeId(this), row, QtJambi_LibraryUtilities.internal.checkedNativeId(values));
    }
    
    @QtUninvokable
    private native boolean updateRowInTable_native_int_cref_QSqlRecord(long __this__nativeId, int row, long values);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QSqlTableModel(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QSqlTableModel(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QSqlTableModel instance, QDeclarativeConstructor constructor);
    
}
