package io.qt.sql;

import io.qt.*;


/**
 * <p>Editable data model for a single database table, with foreign key support</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsqlrelationaltablemodel.html">QSqlRelationalTableModel</a></p>
 */
public class QSqlRelationalTableModel extends io.qt.sql.QSqlTableModel
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSqlRelationalTableModel.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsqlrelationaltablemodel.html#JoinMode-enum">QSqlRelationalTableModel::JoinMode</a></p>
     */
    @QtUnlistedEnum
    public enum JoinMode implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qsqlrelationaltablemodel.html#JoinMode-enum">QSqlRelationalTableModel::InnerJoin</a></p>
         */
        InnerJoin(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qsqlrelationaltablemodel.html#JoinMode-enum">QSqlRelationalTableModel::LeftJoin</a></p>
         */
        LeftJoin(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private JoinMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull JoinMode resolve(int value) {
            switch (value) {
            case 0: return InnerJoin;
            case 1: return LeftJoin;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>Overloaded constructor for {@link #QSqlRelationalTableModel(io.qt.core.QObject, io.qt.sql.QSqlDatabase)}
     *  with <code>db = new io.qt.sql.QSqlDatabase()</code>.</p>
     */
    public QSqlRelationalTableModel(io.qt.core.@Nullable QObject parent) {
        this(parent, new io.qt.sql.QSqlDatabase());
    }
    
    /**
     * <p>Overloaded constructor for {@link #QSqlRelationalTableModel(io.qt.core.QObject, io.qt.sql.QSqlDatabase)}</p>
     * <p>with: </p><ul>
     * <li><code>parent = null</code></li>
     * <li><code>db = new io.qt.sql.QSqlDatabase()</code></li>
     * </ul>
     */
    public QSqlRelationalTableModel() {
        this((io.qt.core.QObject)null, new io.qt.sql.QSqlDatabase());
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlrelationaltablemodel.html#QSqlRelationalTableModel">QSqlRelationalTableModel::QSqlRelationalTableModel(QObject*,QSqlDatabase)</a></p>
     */
    public QSqlRelationalTableModel(io.qt.core.@Nullable QObject parent, io.qt.sql.@NonNull QSqlDatabase db){
        super((QPrivateConstructor)null);
        initialize_native(this, parent, db);
    }
    
    private native static void initialize_native(QSqlRelationalTableModel instance, io.qt.core.QObject parent, io.qt.sql.QSqlDatabase db);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlrelationaltablemodel.html#relation">QSqlRelationalTableModel::relation(int)const</a></p>
     */
    @QtUninvokable
    public final io.qt.sql.@NonNull QSqlRelation relation(int column){
        return relation_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), column);
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlRelation relation_native_int_constfct(long __this__nativeId, int column);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlrelationaltablemodel.html#setJoinMode">QSqlRelationalTableModel::setJoinMode(QSqlRelationalTableModel::JoinMode)</a></p>
     */
    @QtUninvokable
    public final void setJoinMode(io.qt.sql.QSqlRelationalTableModel.@NonNull JoinMode joinMode){
        setJoinMode_native_QSqlRelationalTableModel_JoinMode(QtJambi_LibraryUtilities.internal.nativeId(this), joinMode.value());
    }
    
    @QtUninvokable
    private native void setJoinMode_native_QSqlRelationalTableModel_JoinMode(long __this__nativeId, int joinMode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlquerymodel.html#clear">QSqlQueryModel::clear()</a></p>
     */
    @QtUninvokable
    public void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void clear_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#data">QAbstractItemModel::data(QModelIndex,int)const</a></p>
     */
    @QtUninvokable
    public java.lang.Object data(io.qt.core.@NonNull QModelIndex item, int role){
        return data_native_cref_QModelIndex_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(item), role);
    }
    
    @QtUninvokable
    private native java.lang.Object data_native_cref_QModelIndex_int_constfct(long __this__nativeId, long item, int role);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#insertRowIntoTable">QSqlTableModel::insertRowIntoTable(QSqlRecord)</a></p>
     */
    @QtUninvokable
    protected boolean insertRowIntoTable(io.qt.sql.@NonNull QSqlRecord values){
        return insertRowIntoTable_native_cref_QSqlRecord(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(values));
    }
    
    @QtUninvokable
    private native boolean insertRowIntoTable_native_cref_QSqlRecord(long __this__nativeId, long values);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#orderByClause">QSqlTableModel::orderByClause()const</a></p>
     */
    @QtUninvokable
    protected java.lang.@NonNull String orderByClause(){
        return orderByClause_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String orderByClause_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlrelationaltablemodel.html#relationModel">QSqlRelationalTableModel::relationModel(int)const</a></p>
     */
    @QtUninvokable
    public io.qt.sql.@Nullable QSqlTableModel relationModel(int column){
        return relationModel_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), column);
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlTableModel relationModel_native_int_constfct(long __this__nativeId, int column);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#removeColumns">QAbstractItemModel::removeColumns(int,int,QModelIndex)</a></p>
     */
    @QtUninvokable
    public boolean removeColumns(int column, int count, io.qt.core.@NonNull QModelIndex parent){
        return removeColumns_native_int_int_cref_QModelIndex(QtJambi_LibraryUtilities.internal.nativeId(this), column, count, QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @QtUninvokable
    private native boolean removeColumns_native_int_int_cref_QModelIndex(long __this__nativeId, int column, int count, long parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#revertRow">QSqlTableModel::revertRow(int)</a></p>
     */
    public void revertRow(int row){
        revertRow_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), row);
    }
    
    private native void revertRow_native_int(long __this__nativeId, int row);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#select">QSqlTableModel::select()</a></p>
     */
    @QtUninvokable
    public boolean select(){
        return select_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean select_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#selectStatement">QSqlTableModel::selectStatement()const</a></p>
     */
    @QtUninvokable
    protected java.lang.@NonNull String selectStatement(){
        return selectStatement_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String selectStatement_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#setData">QAbstractItemModel::setData(QModelIndex,QVariant,int)</a></p>
     */
    @QtUninvokable
    public boolean setData(io.qt.core.@NonNull QModelIndex item, java.lang.Object value, int role){
        return setData_native_cref_QModelIndex_cref_QVariant_int(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(item), value, role);
    }
    
    @QtUninvokable
    private native boolean setData_native_cref_QModelIndex_cref_QVariant_int(long __this__nativeId, long item, java.lang.Object value, int role);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlrelationaltablemodel.html#setRelation">QSqlRelationalTableModel::setRelation(int,QSqlRelation)</a></p>
     */
    @QtUninvokable
    public void setRelation(int column, io.qt.sql.@NonNull QSqlRelation relation){
        setRelation_native_int_cref_QSqlRelation(QtJambi_LibraryUtilities.internal.nativeId(this), column, QtJambi_LibraryUtilities.internal.checkedNativeId(relation));
    }
    
    @QtUninvokable
    private native void setRelation_native_int_cref_QSqlRelation(long __this__nativeId, int column, long relation);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#setTable">QSqlTableModel::setTable(QString)</a></p>
     */
    @QtUninvokable
    public void setTable(java.lang.@NonNull String tableName){
        setTable_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), tableName);
    }
    
    @QtUninvokable
    private native void setTable_native_cref_QString(long __this__nativeId, java.lang.String tableName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqltablemodel.html#updateRowInTable">QSqlTableModel::updateRowInTable(int,QSqlRecord)</a></p>
     */
    @QtUninvokable
    protected boolean updateRowInTable(int row, io.qt.sql.@NonNull QSqlRecord values){
        return updateRowInTable_native_int_cref_QSqlRecord(QtJambi_LibraryUtilities.internal.nativeId(this), row, QtJambi_LibraryUtilities.internal.checkedNativeId(values));
    }
    
    @QtUninvokable
    private native boolean updateRowInTable_native_int_cref_QSqlRecord(long __this__nativeId, int row, long values);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QSqlRelationalTableModel(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QSqlRelationalTableModel(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QSqlRelationalTableModel instance, QDeclarativeConstructor constructor);
    
}
