package io.qt.sql;

import io.qt.*;


/**
 * <p>Read-only data model for SQL result sets</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsqlquerymodel.html">QSqlQueryModel</a></p>
 */
public class QSqlQueryModel extends io.qt.core.QAbstractTableModel
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSqlQueryModel.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QSqlQueryModel() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlquerymodel.html#QSqlQueryModel">QSqlQueryModel::QSqlQueryModel(QObject*)</a></p>
     */
    public QSqlQueryModel(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QSqlQueryModel instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#beginInsertColumns">QAbstractItemModel::beginInsertColumns(QModelIndex,int,int)</a></p>
     */
    @QtUninvokable
    protected final void beginInsertColumns(io.qt.core.@NonNull QModelIndex parent, int first, int last){
        beginInsertColumns_native_cref_QModelIndex_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent), first, last);
    }
    
    @QtUninvokable
    private native void beginInsertColumns_native_cref_QModelIndex_int_int(long __this__nativeId, long parent, int first, int last);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#beginInsertRows">QAbstractItemModel::beginInsertRows(QModelIndex,int,int)</a></p>
     */
    @QtUninvokable
    protected final void beginInsertRows(io.qt.core.@NonNull QModelIndex parent, int first, int last){
        beginInsertRows_native_cref_QModelIndex_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent), first, last);
    }
    
    @QtUninvokable
    private native void beginInsertRows_native_cref_QModelIndex_int_int(long __this__nativeId, long parent, int first, int last);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#beginRemoveColumns">QAbstractItemModel::beginRemoveColumns(QModelIndex,int,int)</a></p>
     */
    @QtUninvokable
    protected final void beginRemoveColumns(io.qt.core.@NonNull QModelIndex parent, int first, int last){
        beginRemoveColumns_native_cref_QModelIndex_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent), first, last);
    }
    
    @QtUninvokable
    private native void beginRemoveColumns_native_cref_QModelIndex_int_int(long __this__nativeId, long parent, int first, int last);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#beginRemoveRows">QAbstractItemModel::beginRemoveRows(QModelIndex,int,int)</a></p>
     */
    @QtUninvokable
    protected final void beginRemoveRows(io.qt.core.@NonNull QModelIndex parent, int first, int last){
        beginRemoveRows_native_cref_QModelIndex_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent), first, last);
    }
    
    @QtUninvokable
    private native void beginRemoveRows_native_cref_QModelIndex_int_int(long __this__nativeId, long parent, int first, int last);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#beginResetModel">QAbstractItemModel::beginResetModel()</a></p>
     */
    @QtUninvokable
    protected final void beginResetModel(){
        beginResetModel_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void beginResetModel_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#endInsertColumns">QAbstractItemModel::endInsertColumns()</a></p>
     */
    @QtUninvokable
    protected final void endInsertColumns(){
        endInsertColumns_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void endInsertColumns_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#endInsertRows">QAbstractItemModel::endInsertRows()</a></p>
     */
    @QtUninvokable
    protected final void endInsertRows(){
        endInsertRows_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void endInsertRows_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#endRemoveColumns">QAbstractItemModel::endRemoveColumns()</a></p>
     */
    @QtUninvokable
    protected final void endRemoveColumns(){
        endRemoveColumns_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void endRemoveColumns_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#endRemoveRows">QAbstractItemModel::endRemoveRows()</a></p>
     */
    @QtUninvokable
    protected final void endRemoveRows(){
        endRemoveRows_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void endRemoveRows_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#endResetModel">QAbstractItemModel::endResetModel()</a></p>
     */
    @QtUninvokable
    protected final void endResetModel(){
        endResetModel_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void endResetModel_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlquerymodel.html#lastError">QSqlQueryModel::lastError()const</a></p>
     */
    @QtUninvokable
    public final io.qt.sql.@NonNull QSqlError lastError(){
        return lastError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlError lastError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlquerymodel.html#query">QSqlQueryModel::query()const</a></p>
     */
    @QtUninvokable
    public final io.qt.sql.@NonNull QSqlQuery query(){
        return query_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlQuery query_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlquerymodel.html#record-1">QSqlQueryModel::record()const</a></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public io.qt.sql.@NonNull QSqlRecord record(){
        return record_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlRecord record_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlquerymodel.html#record">QSqlQueryModel::record(int)const</a></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public io.qt.sql.@NonNull QSqlRecord record(int row){
        return record_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), row);
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlRecord record_native_int_constfct(long __this__nativeId, int row);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlquerymodel.html#setLastError">QSqlQueryModel::setLastError(QSqlError)</a></p>
     */
    @QtUninvokable
    protected final void setLastError(io.qt.sql.@NonNull QSqlError error){
        setLastError_native_cref_QSqlError(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(error));
    }
    
    @QtUninvokable
    private native void setLastError_native_cref_QSqlError(long __this__nativeId, long error);
    
    /**
     * @deprecated QSqlQuery is not meant to be copied. Pass it by move instead.
     */
    @Deprecated
    @QtUninvokable
    public final void setQuery(io.qt.sql.@NonNull QSqlQuery query){
        setQuery_native_cref_QSqlQuery(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(query));
    }
    
    @Deprecated
    @QtUninvokable
    private native void setQuery_native_cref_QSqlQuery(long __this__nativeId, long query);
    
    /**
     * <p>Overloaded function for {@link #setQuery(java.lang.String, io.qt.sql.QSqlDatabase)}
     *  with <code>db = new io.qt.sql.QSqlDatabase()</code>.</p>
     */
    @QtUninvokable
    public final void setQuery(java.lang.@NonNull String query) {
        setQuery(query, new io.qt.sql.QSqlDatabase());
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlquerymodel.html#setQuery-2">QSqlQueryModel::setQuery(QString,QSqlDatabase)</a></p>
     */
    @QtUninvokable
    public final void setQuery(java.lang.@NonNull String query, io.qt.sql.@NonNull QSqlDatabase db){
        setQuery_native_cref_QString_cref_QSqlDatabase(QtJambi_LibraryUtilities.internal.nativeId(this), query, QtJambi_LibraryUtilities.internal.checkedNativeId(db));
    }
    
    @QtUninvokable
    private native void setQuery_native_cref_QString_cref_QSqlDatabase(long __this__nativeId, java.lang.String query, long db);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#canFetchMore">QAbstractItemModel::canFetchMore(QModelIndex)const</a></p>
     */
    @QtUninvokable
    public boolean canFetchMore(io.qt.core.@NonNull QModelIndex parent){
        return canFetchMore_native_cref_QModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @QtUninvokable
    private native boolean canFetchMore_native_cref_QModelIndex_constfct(long __this__nativeId, long parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlquerymodel.html#clear">QSqlQueryModel::clear()</a></p>
     */
    @QtUninvokable
    public void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void clear_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#columnCount">QAbstractItemModel::columnCount(QModelIndex)const</a></p>
     */
    @QtUninvokable
    public int columnCount(io.qt.core.@NonNull QModelIndex parent){
        return columnCount_native_cref_QModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @QtUninvokable
    private native int columnCount_native_cref_QModelIndex_constfct(long __this__nativeId, long parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#data">QAbstractItemModel::data(QModelIndex,int)const</a></p>
     */
    @QtUninvokable
    public java.lang.Object data(io.qt.core.@NonNull QModelIndex item, int role){
        return data_native_cref_QModelIndex_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(item), role);
    }
    
    @QtUninvokable
    private native java.lang.Object data_native_cref_QModelIndex_int_constfct(long __this__nativeId, long item, int role);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#fetchMore">QAbstractItemModel::fetchMore(QModelIndex)</a></p>
     */
    @QtUninvokable
    public void fetchMore(io.qt.core.@NonNull QModelIndex parent){
        fetchMore_native_cref_QModelIndex(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @QtUninvokable
    private native void fetchMore_native_cref_QModelIndex(long __this__nativeId, long parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#headerData">QAbstractItemModel::headerData(int,Qt::Orientation,int)const</a></p>
     */
    @QtUninvokable
    public java.lang.Object headerData(int section, io.qt.core.Qt.@NonNull Orientation orientation, int role){
        return headerData_native_int_Qt_Orientation_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), section, orientation.value(), role);
    }
    
    @QtUninvokable
    private native java.lang.Object headerData_native_int_Qt_Orientation_int_constfct(long __this__nativeId, int section, int orientation, int role);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlquerymodel.html#indexInQuery">QSqlQueryModel::indexInQuery(QModelIndex)const</a></p>
     */
    @QtUninvokable
    protected io.qt.core.@NonNull QModelIndex indexInQuery(io.qt.core.@NonNull QModelIndex item){
        return indexInQuery_native_cref_QModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(item));
    }
    
    @QtUninvokable
    private native io.qt.core.QModelIndex indexInQuery_native_cref_QModelIndex_constfct(long __this__nativeId, long item);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#insertColumns">QAbstractItemModel::insertColumns(int,int,QModelIndex)</a></p>
     */
    @QtUninvokable
    public boolean insertColumns(int column, int count, io.qt.core.@NonNull QModelIndex parent){
        return insertColumns_native_int_int_cref_QModelIndex(QtJambi_LibraryUtilities.internal.nativeId(this), column, count, QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @QtUninvokable
    private native boolean insertColumns_native_int_int_cref_QModelIndex(long __this__nativeId, int column, int count, long parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlquerymodel.html#queryChange">QSqlQueryModel::queryChange()</a></p>
     */
    @QtUninvokable
    protected void queryChange(){
        queryChange_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void queryChange_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#removeColumns">QAbstractItemModel::removeColumns(int,int,QModelIndex)</a></p>
     */
    @QtUninvokable
    public boolean removeColumns(int column, int count, io.qt.core.@NonNull QModelIndex parent){
        return removeColumns_native_int_int_cref_QModelIndex(QtJambi_LibraryUtilities.internal.nativeId(this), column, count, QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @QtUninvokable
    private native boolean removeColumns_native_int_int_cref_QModelIndex(long __this__nativeId, int column, int count, long parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#roleNames">QAbstractItemModel::roleNames()const</a></p>
     */
    @QtUninvokable
    public java.util.@NonNull Map<java.lang.@QtPrimitiveType@NonNull Integer, io.qt.core.@NonNull QByteArray> roleNames(){
        return roleNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.util.Map<java.lang.@QtPrimitiveType Integer, io.qt.core.QByteArray> roleNames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#rowCount">QAbstractItemModel::rowCount(QModelIndex)const</a></p>
     */
    @QtUninvokable
    public int rowCount(io.qt.core.@NonNull QModelIndex parent){
        return rowCount_native_cref_QModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @QtUninvokable
    private native int rowCount_native_cref_QModelIndex_constfct(long __this__nativeId, long parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#setHeaderData">QAbstractItemModel::setHeaderData(int,Qt::Orientation,QVariant,int)</a></p>
     */
    @QtUninvokable
    public boolean setHeaderData(int section, io.qt.core.Qt.@NonNull Orientation orientation, java.lang.Object value, int role){
        return setHeaderData_native_int_Qt_Orientation_cref_QVariant_int(QtJambi_LibraryUtilities.internal.nativeId(this), section, orientation.value(), value, role);
    }
    
    @QtUninvokable
    private native boolean setHeaderData_native_int_Qt_Orientation_cref_QVariant_int(long __this__nativeId, int section, int orientation, java.lang.Object value, int role);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QSqlQueryModel(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QSqlQueryModel(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QSqlQueryModel instance, QDeclarativeConstructor constructor);
    
}
