package io.qt.sql;


/**
 * <p>Abstract interface for accessing data from specific SQL databases</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsqlresult.html">QSqlResult</a></p>
 */
public abstract class QSqlResult extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QSqlResult {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        protected java.lang.Object data(int i){
            return data_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), i);
        }
        @io.qt.QtUninvokable
        private native java.lang.Object data_native_int(long __this__nativeId, int i);
        
        
        @Override
        @io.qt.QtUninvokable
        protected boolean fetch(int i){
            return fetch_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), i);
        }
        @io.qt.QtUninvokable
        private native boolean fetch_native_int(long __this__nativeId, int i);
        
        
        @Override
        @io.qt.QtUninvokable
        protected boolean fetchFirst(){
            return fetchFirst_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native boolean fetchFirst_native(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        protected boolean fetchLast(){
            return fetchLast_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native boolean fetchLast_native(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        protected boolean isNull(int i){
            return isNull_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), i);
        }
        @io.qt.QtUninvokable
        private native boolean isNull_native_int(long __this__nativeId, int i);
        
        
        @Override
        @io.qt.QtUninvokable
        protected int numRowsAffected(){
            return numRowsAffected_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native int numRowsAffected_native(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        protected boolean reset(java.lang.String sqlquery){
            return reset_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), sqlquery);
        }
        @io.qt.QtUninvokable
        private native boolean reset_native_cref_QString(long __this__nativeId, java.lang.String sqlquery);
        
        
        @Override
        @io.qt.QtUninvokable
        protected int size(){
            return size_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native int size_native(long __this__nativeId);
        
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsqlresult.html#BindingSyntax-enum">QSqlResult::BindingSyntax</a></p>
     */
    protected enum BindingSyntax implements io.qt.QtEnumerator {
        PositionalBinding(0),
        NamedBinding(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private BindingSyntax(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static BindingSyntax resolve(int value) {
            switch (value) {
            case 0: return PositionalBinding;
            case 1: return NamedBinding;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum QSqlResult::VirtualHookOperation</p>
     */
    protected enum VirtualHookOperation implements io.qt.QtEnumerator {
;

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private VirtualHookOperation(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static VirtualHookOperation resolve(int value) {
            switch (value) {
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#QSqlResult">QSqlResult::QSqlResult(const QSqlDriver*)</a></p>
     */
    protected QSqlResult(io.qt.sql.QSqlDriver db){
        super((QPrivateConstructor)null);
        initialize_native(this, db);
    }
    
    private native static void initialize_native(QSqlResult instance, io.qt.sql.QSqlDriver db);
    
    /**
     * <p>Overloaded function for {@link #addBindValue(java.lang.Object, io.qt.sql.QSql.ParamType)}.</p>
     */
    @io.qt.QtUninvokable
    protected final void addBindValue(java.lang.Object val, io.qt.sql.QSql.ParamTypeFlag ... type){
        addBindValue(val, new io.qt.sql.QSql.ParamType(type));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#addBindValue">QSqlResult::addBindValue(QVariant,QSql::ParamType)</a></p>
     */
    @io.qt.QtUninvokable
    protected final void addBindValue(java.lang.Object val, io.qt.sql.QSql.ParamType type){
        addBindValue_native_cref_QVariant_QFlags_QSql_ParamTypeFlag_(QtJambi_LibraryUtilities.internal.nativeId(this), val, type.value());
    }
    
    @io.qt.QtUninvokable
    private native void addBindValue_native_cref_QVariant_QFlags_QSql_ParamTypeFlag_(long __this__nativeId, java.lang.Object val, int type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#at">QSqlResult::at()const</a></p>
     */
    @io.qt.QtUninvokable
    protected final int at(){
        return at_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int at_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#bindValueType-1">QSqlResult::bindValueType(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    protected final io.qt.sql.QSql.ParamType bindValueType(java.lang.String placeholder){
        return new io.qt.sql.QSql.ParamType(bindValueType_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), placeholder));
    }
    
    @io.qt.QtUninvokable
    private native int bindValueType_native_cref_QString_constfct(long __this__nativeId, java.lang.String placeholder);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#bindValueType">QSqlResult::bindValueType(int)const</a></p>
     */
    @io.qt.QtUninvokable
    protected final io.qt.sql.QSql.ParamType bindValueType(int pos){
        return new io.qt.sql.QSql.ParamType(bindValueType_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), pos));
    }
    
    @io.qt.QtUninvokable
    private native int bindValueType_native_int_constfct(long __this__nativeId, int pos);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#bindingSyntax">QSqlResult::bindingSyntax()const</a></p>
     */
    @io.qt.QtUninvokable
    protected final io.qt.sql.QSqlResult.BindingSyntax bindingSyntax(){
        return io.qt.sql.QSqlResult.BindingSyntax.resolve(bindingSyntax_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int bindingSyntax_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#boundValue-1">QSqlResult::boundValue(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    protected final java.lang.Object boundValue(java.lang.String placeholder){
        return boundValue_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), placeholder);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object boundValue_native_cref_QString_constfct(long __this__nativeId, java.lang.String placeholder);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#boundValue">QSqlResult::boundValue(int)const</a></p>
     */
    @io.qt.QtUninvokable
    protected final java.lang.Object boundValue(int pos){
        return boundValue_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), pos);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object boundValue_native_int_constfct(long __this__nativeId, int pos);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#boundValueCount">QSqlResult::boundValueCount()const</a></p>
     */
    @io.qt.QtUninvokable
    protected final int boundValueCount(){
        return boundValueCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int boundValueCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#boundValueName">QSqlResult::boundValueName(int)const</a></p>
     */
    @io.qt.QtUninvokable
    protected final java.lang.String boundValueName(int pos){
        return boundValueName_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), pos);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String boundValueName_native_int_constfct(long __this__nativeId, int pos);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#boundValues">QSqlResult::boundValues()const</a></p>
     */
    @io.qt.QtUninvokable
    protected final io.qt.core.QList<java.lang.Object> boundValues(){
        return boundValues_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<java.lang.Object> boundValues_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#clear">QSqlResult::clear()</a></p>
     */
    @io.qt.QtUninvokable
    protected final void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void clear_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#driver">QSqlResult::driver()const</a></p>
     */
    @io.qt.QtUninvokable
    protected final io.qt.sql.QSqlDriver driver(){
        return driver_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.sql.QSqlDriver driver_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#executedQuery">QSqlResult::executedQuery()const</a></p>
     */
    @io.qt.QtUninvokable
    protected final java.lang.String executedQuery(){
        return executedQuery_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String executedQuery_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#hasOutValues">QSqlResult::hasOutValues()const</a></p>
     */
    @io.qt.QtUninvokable
    protected final boolean hasOutValues(){
        return hasOutValues_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean hasOutValues_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#isActive">QSqlResult::isActive()const</a></p>
     */
    @io.qt.QtUninvokable
    protected final boolean isActive(){
        return isActive_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isActive_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#isForwardOnly">QSqlResult::isForwardOnly()const</a></p>
     */
    @io.qt.QtUninvokable
    protected final boolean isForwardOnly(){
        return isForwardOnly_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isForwardOnly_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#isSelect">QSqlResult::isSelect()const</a></p>
     */
    @io.qt.QtUninvokable
    protected final boolean isSelect(){
        return isSelect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isSelect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#isValid">QSqlResult::isValid()const</a></p>
     */
    @io.qt.QtUninvokable
    protected final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#lastError">QSqlResult::lastError()const</a></p>
     */
    @io.qt.QtUninvokable
    protected final io.qt.sql.QSqlError lastError(){
        return lastError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.sql.QSqlError lastError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#lastQuery">QSqlResult::lastQuery()const</a></p>
     */
    @io.qt.QtUninvokable
    protected final java.lang.String lastQuery(){
        return lastQuery_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String lastQuery_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected final io.qt.sql.QSql.NumericalPrecisionPolicy numericalPrecisionPolicy(){
        return io.qt.sql.QSql.NumericalPrecisionPolicy.resolve(numericalPrecisionPolicy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int numericalPrecisionPolicy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#resetBindCount">QSqlResult::resetBindCount()</a></p>
     */
    @io.qt.QtUninvokable
    protected final void resetBindCount(){
        resetBindCount_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void resetBindCount_native(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #bindValue(java.lang.String, java.lang.Object, io.qt.sql.QSql.ParamType)}.</p>
     */
    @io.qt.QtUninvokable
    protected final void bindValue(java.lang.String placeholder, java.lang.Object val, io.qt.sql.QSql.ParamTypeFlag ... type){
        bindValue(placeholder, val, new io.qt.sql.QSql.ParamType(type));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#bindValue-1">QSqlResult::bindValue(QString,QVariant,QSql::ParamType)</a></p>
     */
    @io.qt.QtUninvokable
    protected void bindValue(java.lang.String placeholder, java.lang.Object val, io.qt.sql.QSql.ParamType type){
        bindValue_native_cref_QString_cref_QVariant_QFlags_QSql_ParamTypeFlag_(QtJambi_LibraryUtilities.internal.nativeId(this), placeholder, val, type.value());
    }
    
    @io.qt.QtUninvokable
    private native void bindValue_native_cref_QString_cref_QVariant_QFlags_QSql_ParamTypeFlag_(long __this__nativeId, java.lang.String placeholder, java.lang.Object val, int type);
    
    /**
     * <p>Overloaded function for {@link #bindValue(int, java.lang.Object, io.qt.sql.QSql.ParamType)}.</p>
     */
    @io.qt.QtUninvokable
    protected final void bindValue(int pos, java.lang.Object val, io.qt.sql.QSql.ParamTypeFlag ... type){
        bindValue(pos, val, new io.qt.sql.QSql.ParamType(type));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#bindValue">QSqlResult::bindValue(int,QVariant,QSql::ParamType)</a></p>
     */
    @io.qt.QtUninvokable
    protected void bindValue(int pos, java.lang.Object val, io.qt.sql.QSql.ParamType type){
        bindValue_native_int_cref_QVariant_QFlags_QSql_ParamTypeFlag_(QtJambi_LibraryUtilities.internal.nativeId(this), pos, val, type.value());
    }
    
    @io.qt.QtUninvokable
    private native void bindValue_native_int_cref_QVariant_QFlags_QSql_ParamTypeFlag_(long __this__nativeId, int pos, java.lang.Object val, int type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#data">QSqlResult::data(int)</a></p>
     */
    @io.qt.QtUninvokable
    protected abstract java.lang.Object data(int i);
    
    @io.qt.QtUninvokable
    private native java.lang.Object data_native_int(long __this__nativeId, int i);
    
    @io.qt.QtUninvokable
    protected void detachFromResultSet(){
        detachFromResultSet_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void detachFromResultSet_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#exec">QSqlResult::exec()</a></p>
     */
    @io.qt.QtUninvokable
    protected boolean exec(){
        return exec_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean exec_native(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #execBatch(boolean)}
     *  with <code>arrayBind = false</code>.</p>
     */
    @io.qt.QtUninvokable
    protected final boolean execBatch() {
        return execBatch((boolean)false);
    }
    
    @io.qt.QtUninvokable
    protected boolean execBatch(boolean arrayBind){
        return execBatch_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arrayBind);
    }
    
    @io.qt.QtUninvokable
    private native boolean execBatch_native_bool(long __this__nativeId, boolean arrayBind);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#fetch">QSqlResult::fetch(int)</a></p>
     */
    @io.qt.QtUninvokable
    protected abstract boolean fetch(int i);
    
    @io.qt.QtUninvokable
    private native boolean fetch_native_int(long __this__nativeId, int i);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#fetchFirst">QSqlResult::fetchFirst()</a></p>
     */
    @io.qt.QtUninvokable
    protected abstract boolean fetchFirst();
    
    @io.qt.QtUninvokable
    private native boolean fetchFirst_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#fetchLast">QSqlResult::fetchLast()</a></p>
     */
    @io.qt.QtUninvokable
    protected abstract boolean fetchLast();
    
    @io.qt.QtUninvokable
    private native boolean fetchLast_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#fetchNext">QSqlResult::fetchNext()</a></p>
     */
    @io.qt.QtUninvokable
    protected boolean fetchNext(){
        return fetchNext_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean fetchNext_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#fetchPrevious">QSqlResult::fetchPrevious()</a></p>
     */
    @io.qt.QtUninvokable
    protected boolean fetchPrevious(){
        return fetchPrevious_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean fetchPrevious_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#handle">QSqlResult::handle()const</a></p>
     */
    @io.qt.QtUninvokable
    public java.lang.Object handle(){
        return handle_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object handle_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#isNull">QSqlResult::isNull(int)</a></p>
     */
    @io.qt.QtUninvokable
    protected abstract boolean isNull(int i);
    
    @io.qt.QtUninvokable
    private native boolean isNull_native_int(long __this__nativeId, int i);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#lastInsertId">QSqlResult::lastInsertId()const</a></p>
     */
    @io.qt.QtUninvokable
    protected java.lang.Object lastInsertId(){
        return lastInsertId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object lastInsertId_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected boolean nextResult(){
        return nextResult_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean nextResult_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#numRowsAffected">QSqlResult::numRowsAffected()</a></p>
     */
    @io.qt.QtUninvokable
    protected abstract int numRowsAffected();
    
    @io.qt.QtUninvokable
    private native int numRowsAffected_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#prepare">QSqlResult::prepare(QString)</a></p>
     */
    @io.qt.QtUninvokable
    protected boolean prepare(java.lang.String query){
        return prepare_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), query);
    }
    
    @io.qt.QtUninvokable
    private native boolean prepare_native_cref_QString(long __this__nativeId, java.lang.String query);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#record">QSqlResult::record()const</a></p>
     */
    @io.qt.QtUninvokable
    protected io.qt.sql.QSqlRecord record(){
        return record_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.sql.QSqlRecord record_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#reset">QSqlResult::reset(QString)</a></p>
     */
    @io.qt.QtUninvokable
    protected abstract boolean reset(java.lang.String sqlquery);
    
    @io.qt.QtUninvokable
    private native boolean reset_native_cref_QString(long __this__nativeId, java.lang.String sqlquery);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#savePrepare">QSqlResult::savePrepare(QString)</a></p>
     */
    @io.qt.QtUninvokable
    protected boolean savePrepare(java.lang.String sqlquery){
        return savePrepare_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), sqlquery);
    }
    
    @io.qt.QtUninvokable
    private native boolean savePrepare_native_cref_QString(long __this__nativeId, java.lang.String sqlquery);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#setActive">QSqlResult::setActive(bool)</a></p>
     */
    @io.qt.QtUninvokable
    protected void setActive(boolean a){
        setActive_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), a);
    }
    
    @io.qt.QtUninvokable
    private native void setActive_native_bool(long __this__nativeId, boolean a);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#setAt">QSqlResult::setAt(int)</a></p>
     */
    @io.qt.QtUninvokable
    protected void setAt(int at){
        setAt_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), at);
    }
    
    @io.qt.QtUninvokable
    private native void setAt_native_int(long __this__nativeId, int at);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#setForwardOnly">QSqlResult::setForwardOnly(bool)</a></p>
     */
    @io.qt.QtUninvokable
    protected void setForwardOnly(boolean forward){
        setForwardOnly_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), forward);
    }
    
    @io.qt.QtUninvokable
    private native void setForwardOnly_native_bool(long __this__nativeId, boolean forward);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#setLastError">QSqlResult::setLastError(QSqlError)</a></p>
     */
    @io.qt.QtUninvokable
    protected void setLastError(io.qt.sql.QSqlError e){
        setLastError_native_cref_QSqlError(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @io.qt.QtUninvokable
    private native void setLastError_native_cref_QSqlError(long __this__nativeId, long e);
    
    @io.qt.QtUninvokable
    protected void setNumericalPrecisionPolicy(io.qt.sql.QSql.NumericalPrecisionPolicy policy){
        setNumericalPrecisionPolicy_native_QSql_NumericalPrecisionPolicy(QtJambi_LibraryUtilities.internal.nativeId(this), policy.value());
    }
    
    @io.qt.QtUninvokable
    private native void setNumericalPrecisionPolicy_native_QSql_NumericalPrecisionPolicy(long __this__nativeId, int policy);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#setQuery">QSqlResult::setQuery(QString)</a></p>
     */
    @io.qt.QtUninvokable
    protected void setQuery(java.lang.String query){
        setQuery_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), query);
    }
    
    @io.qt.QtUninvokable
    private native void setQuery_native_cref_QString(long __this__nativeId, java.lang.String query);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#setSelect">QSqlResult::setSelect(bool)</a></p>
     */
    @io.qt.QtUninvokable
    protected void setSelect(boolean s){
        setSelect_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @io.qt.QtUninvokable
    private native void setSelect_native_bool(long __this__nativeId, boolean s);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlresult.html#size">QSqlResult::size()</a></p>
     */
    @io.qt.QtUninvokable
    protected abstract int size();
    
    @io.qt.QtUninvokable
    private native int size_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSqlResult(QPrivateConstructor p) { super(p); } 
    
}
