/*
 * Decompiled with CFR 0.152.
 */
package io.qt.sql;

import io.qt.sql.QSqlDriver;
import io.qt.sql.QSqlDriverCreatorBase;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.function.Supplier;

public class QSqlDriverCreator<T extends QSqlDriver>
extends QSqlDriverCreatorBase {
    private final Supplier<T> constructorHandle;

    private native long getConstructorHandle(Class<T> var1) throws NoSuchMethodException, SecurityException, IllegalAccessException;

    private native T create(Class<T> var1, long var2);

    public QSqlDriverCreator(Supplier<T> constructor) {
        this.constructorHandle = Objects.requireNonNull(constructor);
    }

    public QSqlDriverCreator(Class<T> type) {
        long constructor;
        if (Modifier.isAbstract(type.getModifiers())) {
            throw new RuntimeException("Cannot construct QSqlDriverCreator for abstract widget type " + type.getName() + ".");
        }
        try {
            constructor = this.getConstructorHandle(type);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException("Cannot construct QSqlDriverCreator for widget type " + type.getName() + " due to missing constructor " + type.getSimpleName() + "().", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot construct QSqlDriverCreator for widget type " + type.getName() + " due to missing access to constructor " + type.getSimpleName() + "().", e);
        }
        this.constructorHandle = () -> this.create(type, constructor);
    }

    public T createObject() {
        return (T)((Object)((QSqlDriver)((Object)this.constructorHandle.get())));
    }
}

