package io.qt.sql;


/**
 * <p>Handles a connection to a database</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qsqldatabase.html">QSqlDatabase</a></p>
 */
public class QSqlDatabase extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#QSqlDatabase">QSqlDatabase::QSqlDatabase()</a></p>
     */
    public QSqlDatabase(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSqlDatabase instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#QSqlDatabase-3">QSqlDatabase::QSqlDatabase(QSqlDriver*)</a></p>
     */
    protected QSqlDatabase(io.qt.sql.QSqlDriver driver){
        super((QPrivateConstructor)null);
        initialize_native(this, driver);
    }
    
    private native static void initialize_native(QSqlDatabase instance, io.qt.sql.QSqlDriver driver);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#QSqlDatabase-1">QSqlDatabase::QSqlDatabase(QSqlDatabase)</a></p>
     */
    public QSqlDatabase(io.qt.sql.QSqlDatabase other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QSqlDatabase instance, io.qt.sql.QSqlDatabase other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#QSqlDatabase-2">QSqlDatabase::QSqlDatabase(QString)</a></p>
     */
    protected QSqlDatabase(java.lang.String type){
        super((QPrivateConstructor)null);
        initialize_native(this, type);
    }
    
    private native static void initialize_native(QSqlDatabase instance, java.lang.String type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#close">QSqlDatabase::close()</a></p>
     */
    @io.qt.QtUninvokable
    public final void close(){
        close_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void close_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#commit">QSqlDatabase::commit()</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean commit(){
        return commit_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean commit_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#connectOptions">QSqlDatabase::connectOptions()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String connectOptions(){
        return connectOptions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String connectOptions_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#connectionName">QSqlDatabase::connectionName()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String connectionName(){
        return connectionName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String connectionName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#databaseName">QSqlDatabase::databaseName()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String databaseName(){
        return databaseName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String databaseName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#driver">QSqlDatabase::driver()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.sql.QSqlDriver driver(){
        return driver_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.sql.QSqlDriver driver_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#driverName">QSqlDatabase::driverName()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String driverName(){
        return driverName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String driverName_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #exec(java.lang.String)}
     *  with <code>query = ""</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.sql.QSqlQuery exec() {
        return exec("");
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#exec">QSqlDatabase::exec(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.sql.QSqlQuery exec(java.lang.String query){
        return exec_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), query);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.sql.QSqlQuery exec_native_cref_QString_constfct(long __this__nativeId, java.lang.String query);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#hostName">QSqlDatabase::hostName()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String hostName(){
        return hostName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String hostName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#isOpen">QSqlDatabase::isOpen()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isOpen(){
        return isOpen_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isOpen_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#isOpenError">QSqlDatabase::isOpenError()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isOpenError(){
        return isOpenError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isOpenError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#isValid">QSqlDatabase::isValid()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#lastError">QSqlDatabase::lastError()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.sql.QSqlError lastError(){
        return lastError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.sql.QSqlError lastError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#numericalPrecisionPolicy">QSqlDatabase::numericalPrecisionPolicy()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.sql.QSql.NumericalPrecisionPolicy numericalPrecisionPolicy(){
        return io.qt.sql.QSql.NumericalPrecisionPolicy.resolve(numericalPrecisionPolicy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int numericalPrecisionPolicy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#open">QSqlDatabase::open()</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean open(){
        return open_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean open_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#open-1">QSqlDatabase::open(QString,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean open(java.lang.String user, java.lang.String password){
        return open_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), user, password);
    }
    
    @io.qt.QtUninvokable
    private native boolean open_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String user, java.lang.String password);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#password">QSqlDatabase::password()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String password(){
        return password_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String password_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#port">QSqlDatabase::port()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int port(){
        return port_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int port_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#primaryIndex">QSqlDatabase::primaryIndex(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.sql.QSqlIndex primaryIndex(java.lang.String tablename){
        return primaryIndex_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), tablename);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.sql.QSqlIndex primaryIndex_native_cref_QString_constfct(long __this__nativeId, java.lang.String tablename);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#record">QSqlDatabase::record(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.sql.QSqlRecord record(java.lang.String tablename){
        return record_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), tablename);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.sql.QSqlRecord record_native_cref_QString_constfct(long __this__nativeId, java.lang.String tablename);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#rollback">QSqlDatabase::rollback()</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean rollback(){
        return rollback_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean rollback_native(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #setConnectOptions(java.lang.String)}
     *  with <code>options = ""</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setConnectOptions() {
        setConnectOptions("");
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#setConnectOptions">QSqlDatabase::setConnectOptions(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setConnectOptions(java.lang.String options){
        setConnectOptions_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), options);
    }
    
    @io.qt.QtUninvokable
    private native void setConnectOptions_native_cref_QString(long __this__nativeId, java.lang.String options);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#setDatabaseName">QSqlDatabase::setDatabaseName(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setDatabaseName(java.lang.String name){
        setDatabaseName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native void setDatabaseName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#setHostName">QSqlDatabase::setHostName(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setHostName(java.lang.String host){
        setHostName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), host);
    }
    
    @io.qt.QtUninvokable
    private native void setHostName_native_cref_QString(long __this__nativeId, java.lang.String host);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#setNumericalPrecisionPolicy">QSqlDatabase::setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setNumericalPrecisionPolicy(io.qt.sql.QSql.NumericalPrecisionPolicy precisionPolicy){
        setNumericalPrecisionPolicy_native_QSql_NumericalPrecisionPolicy(QtJambi_LibraryUtilities.internal.nativeId(this), precisionPolicy.value());
    }
    
    @io.qt.QtUninvokable
    private native void setNumericalPrecisionPolicy_native_QSql_NumericalPrecisionPolicy(long __this__nativeId, int precisionPolicy);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#setPassword">QSqlDatabase::setPassword(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPassword(java.lang.String password){
        setPassword_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), password);
    }
    
    @io.qt.QtUninvokable
    private native void setPassword_native_cref_QString(long __this__nativeId, java.lang.String password);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#setPort">QSqlDatabase::setPort(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPort(int p){
        setPort_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), p);
    }
    
    @io.qt.QtUninvokable
    private native void setPort_native_int(long __this__nativeId, int p);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#setUserName">QSqlDatabase::setUserName(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUserName(java.lang.String name){
        setUserName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native void setUserName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>Overloaded function for {@link #tables(io.qt.sql.QSql.TableType)}
     *  with <code>type = io.qt.sql.QSql.TableType.Tables</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList tables() {
        return tables(io.qt.sql.QSql.TableType.Tables);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#tables">QSqlDatabase::tables(QSql::TableType)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList tables(io.qt.sql.QSql.TableType type){
        return tables_native_QSql_TableType_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList tables_native_QSql_TableType_constfct(long __this__nativeId, int type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#transaction">QSqlDatabase::transaction()</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean transaction(){
        return transaction_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean transaction_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#userName">QSqlDatabase::userName()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String userName(){
        return userName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String userName_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #addDatabase(io.qt.sql.QSqlDriver, java.lang.String)}
     *  with <code>connectionName = defaultConnection()</code>.</p>
     */
    public static io.qt.sql.QSqlDatabase addDatabase(io.qt.sql.QSqlDriver driver) {
        return addDatabase(driver, defaultConnection());
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#addDatabase-1">QSqlDatabase::addDatabase(QSqlDriver*,QString)</a></p>
     */
    public static io.qt.sql.QSqlDatabase addDatabase(io.qt.sql.QSqlDriver driver, java.lang.String connectionName){
        return addDatabase_native_QSqlDriver_ptr_cref_QString(QtJambi_LibraryUtilities.internal.checkedNativeId(driver), connectionName);
    }
    
    private native static io.qt.sql.QSqlDatabase addDatabase_native_QSqlDriver_ptr_cref_QString(long driver, java.lang.String connectionName);
    
    /**
     * <p>Overloaded function for {@link #addDatabase(java.lang.String, java.lang.String)}
     *  with <code>connectionName = defaultConnection()</code>.</p>
     */
    public static io.qt.sql.QSqlDatabase addDatabase(java.lang.String type) {
        return addDatabase(type, defaultConnection());
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#addDatabase">QSqlDatabase::addDatabase(QString,QString)</a></p>
     */
    public native static io.qt.sql.QSqlDatabase addDatabase(java.lang.String type, java.lang.String connectionName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#cloneDatabase">QSqlDatabase::cloneDatabase(QSqlDatabase,QString)</a></p>
     */
    public static io.qt.sql.QSqlDatabase cloneDatabase(io.qt.sql.QSqlDatabase other, java.lang.String connectionName){
        return cloneDatabase_native_cref_QSqlDatabase_cref_QString(QtJambi_LibraryUtilities.internal.checkedNativeId(other), connectionName);
    }
    
    private native static io.qt.sql.QSqlDatabase cloneDatabase_native_cref_QSqlDatabase_cref_QString(long other, java.lang.String connectionName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#cloneDatabase-1">QSqlDatabase::cloneDatabase(QString,QString)</a></p>
     */
    public native static io.qt.sql.QSqlDatabase cloneDatabase(java.lang.String other, java.lang.String connectionName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#connectionNames">QSqlDatabase::connectionNames()</a></p>
     */
    public native static io.qt.core.QStringList connectionNames();
    
    /**
     * <p>Overloaded function for {@link #contains(java.lang.String)}
     *  with <code>connectionName = defaultConnection()</code>.</p>
     */
    public static boolean contains() {
        return contains(defaultConnection());
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#contains">QSqlDatabase::contains(QString)</a></p>
     */
    public native static boolean contains(java.lang.String connectionName);
    
    /**
     * <p>Overloaded function for {@link #database(java.lang.String, boolean)}
     *  with <code>open = true</code>.</p>
     */
    public static io.qt.sql.QSqlDatabase database(java.lang.String connectionName) {
        return database(connectionName, (boolean)true);
    }
    
    /**
     * <p>Overloaded function for {@link #database(java.lang.String, boolean)}</p>
     * <p>with: </p><ul>
     * <li><code>connectionName = defaultConnection()</code></li>
     * <li><code>open = true</code></li>
     * </ul>
     */
    public static io.qt.sql.QSqlDatabase database() {
        return database(defaultConnection(), (boolean)true);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#database">QSqlDatabase::database(QString,bool)</a></p>
     */
    public native static io.qt.sql.QSqlDatabase database(java.lang.String connectionName, boolean open);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#drivers">QSqlDatabase::drivers()</a></p>
     */
    public native static io.qt.core.QStringList drivers();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#isDriverAvailable">QSqlDatabase::isDriverAvailable(QString)</a></p>
     */
    public native static boolean isDriverAvailable(java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#registerSqlDriver">QSqlDatabase::registerSqlDriver(QString,QSqlDriverCreatorBase*)</a></p>
     */
    public static void registerSqlDriver(java.lang.String name, io.qt.sql.QSqlDriverCreatorBase creator){
        registerSqlDriver_native_cref_QString_QSqlDriverCreatorBase_ptr(name, QtJambi_LibraryUtilities.internal.checkedNativeId(creator));
    }
    
    private native static void registerSqlDriver_native_cref_QString_QSqlDriverCreatorBase_ptr(java.lang.String name, long creator);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldatabase.html#removeDatabase">QSqlDatabase::removeDatabase(QString)</a></p>
     */
    public native static void removeDatabase(java.lang.String connectionName);
    
    public native static void setDefaultConnection(java.lang.String defaultConnection);
    
    public native static java.lang.String defaultConnection();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSqlDatabase(QPrivateConstructor p) { super(p); } 
    

    @Override
    @io.qt.QtUninvokable
    public String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private static native String toString_native(long __this_nativeId);
    
    @Override
    public QSqlDatabase clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QSqlDatabase clone_native(long __this_nativeId);
}
