package io.qt.sql;


/**
 * <p>The base class for SQL driver factories</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qsqldrivercreatorbase.html">QSqlDriverCreatorBase</a></p>
 */
public abstract class QSqlDriverCreatorBase extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QSqlDriverCreatorBase {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.sql.QSqlDriver createObject(){
            return createObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native io.qt.sql.QSqlDriver createObject_native_constfct(long __this__nativeId);
        
    }
    
    
    public QSqlDriverCreatorBase(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSqlDriverCreatorBase instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldrivercreatorbase.html#createObject">QSqlDriverCreatorBase::createObject()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.sql.QSqlDriver createObject();
    
    @io.qt.QtUninvokable
    private native io.qt.sql.QSqlDriver createObject_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSqlDriverCreatorBase(QPrivateConstructor p) { super(p); } 
    
}
