package io.qt.sql;


/**
 * <p>SQL database error information</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsqlerror.html">QSqlError</a></p>
 */
public class QSqlError extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsqlerror.html#ErrorType-enum">QSqlError::ErrorType</a></p>
     */
    public enum ErrorType implements io.qt.QtEnumerator {
        NoError(0),
        ConnectionError(1),
        StatementError(2),
        TransactionError(3),
        UnknownError(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ErrorType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ErrorType resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return ConnectionError;
            case 2: return StatementError;
            case 3: return TransactionError;
            case 4: return UnknownError;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlerror.html#QSqlError-1">QSqlError::QSqlError(QSqlError)</a></p>
     */
    public QSqlError(io.qt.sql.QSqlError other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QSqlError instance, io.qt.sql.QSqlError other);
    
    /**
     * <p>Overloaded constructor for {@link #QSqlError(java.lang.String, java.lang.String, io.qt.sql.QSqlError.ErrorType, java.lang.String)}
     *  with <code>errorCode = (String)null</code>.</p>
     */
    public QSqlError(java.lang.String driverText, java.lang.String databaseText, io.qt.sql.QSqlError.ErrorType type) {
        this(driverText, databaseText, type, (String)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QSqlError(java.lang.String, java.lang.String, io.qt.sql.QSqlError.ErrorType, java.lang.String)}</p>
     * <p>with: </p><ul>
     * <li><code>type = io.qt.sql.QSqlError.ErrorType.NoError</code></li>
     * <li><code>errorCode = (String)null</code></li>
     * </ul>
     */
    public QSqlError(java.lang.String driverText, java.lang.String databaseText) {
        this(driverText, databaseText, io.qt.sql.QSqlError.ErrorType.NoError, (String)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QSqlError(java.lang.String, java.lang.String, io.qt.sql.QSqlError.ErrorType, java.lang.String)}</p>
     * <p>with: </p><ul>
     * <li><code>databaseText = (String)null</code></li>
     * <li><code>type = io.qt.sql.QSqlError.ErrorType.NoError</code></li>
     * <li><code>errorCode = (String)null</code></li>
     * </ul>
     */
    public QSqlError(java.lang.String driverText) {
        this(driverText, (String)null, io.qt.sql.QSqlError.ErrorType.NoError, (String)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QSqlError(java.lang.String, java.lang.String, io.qt.sql.QSqlError.ErrorType, java.lang.String)}</p>
     * <p>with: </p><ul>
     * <li><code>driverText = (String)null</code></li>
     * <li><code>databaseText = (String)null</code></li>
     * <li><code>type = io.qt.sql.QSqlError.ErrorType.NoError</code></li>
     * <li><code>errorCode = (String)null</code></li>
     * </ul>
     */
    public QSqlError() {
        this((String)null, (String)null, io.qt.sql.QSqlError.ErrorType.NoError, (String)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlerror.html#QSqlError">QSqlError::QSqlError(QString,QString,QSqlError::ErrorType,QString)</a></p>
     */
    public QSqlError(java.lang.String driverText, java.lang.String databaseText, io.qt.sql.QSqlError.ErrorType type, java.lang.String errorCode){
        super((QPrivateConstructor)null);
        initialize_native(this, driverText, databaseText, type, errorCode);
    }
    
    private native static void initialize_native(QSqlError instance, java.lang.String driverText, java.lang.String databaseText, io.qt.sql.QSqlError.ErrorType type, java.lang.String errorCode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlerror.html#databaseText">QSqlError::databaseText()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String databaseText(){
        return databaseText_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String databaseText_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlerror.html#driverText">QSqlError::driverText()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String driverText(){
        return driverText_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String driverText_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlerror.html#isValid">QSqlError::isValid()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlerror.html#nativeErrorCode">QSqlError::nativeErrorCode()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String nativeErrorCode(){
        return nativeErrorCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String nativeErrorCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlerror.html#operator-eq-eq">QSqlError::operator==(QSqlError)const</a></p>
     */
    @io.qt.QtUninvokable
    private final boolean operator_equal(io.qt.sql.QSqlError other){
        return operator_equal_native_cref_QSqlError_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native boolean operator_equal_native_cref_QSqlError_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlerror.html#swap">QSqlError::swap(QSqlError&amp;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void swap(io.qt.sql.QSqlError other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QSqlError(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native void swap_native_ref_QSqlError(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlerror.html#text">QSqlError::text()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String text(){
        return text_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String text_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqlerror.html#type">QSqlError::type()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.sql.QSqlError.ErrorType type(){
        return io.qt.sql.QSqlError.ErrorType.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSqlError(QPrivateConstructor p) { super(p); } 
    

    @Override
    @io.qt.QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.sql.QSqlError) {
            return operator_equal((io.qt.sql.QSqlError) other);
        }

        return false;
    }


    @io.qt.QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private native static int hashCode_native(long __this_nativeId);

    @Override
    @io.qt.QtUninvokable
    public String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private static native String toString_native(long __this_nativeId);
    
    @Override
    public QSqlError clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QSqlError clone_native(long __this_nativeId);
}
