package io.qt.sql;


/**
 * <p>Abstract base class for accessing specific SQL databases</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsqldriver.html">QSqlDriver</a></p>
 */
public abstract class QSqlDriver extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSqlDriver.class);
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QSqlDriver {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public void close(){
            close_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native void close_native(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.sql.QSqlResult createResult(){
            return createResult_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native io.qt.sql.QSqlResult createResult_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public boolean hasFeature(io.qt.sql.QSqlDriver.DriverFeature f){
            return hasFeature_native_QSqlDriver_DriverFeature_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), f.value());
        }
        @io.qt.QtUninvokable
        private native boolean hasFeature_native_QSqlDriver_DriverFeature_constfct(long __this__nativeId, int f);
        
        
        @Override
        @io.qt.QtUninvokable
        public boolean open(java.lang.String db, java.lang.String user, java.lang.String password, java.lang.String host, int port, java.lang.String connOpts){
            return open_native_cref_QString_cref_QString_cref_QString_cref_QString_int_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), db, user, password, host, port, connOpts);
        }
        @io.qt.QtUninvokable
        private native boolean open_native_cref_QString_cref_QString_cref_QString_cref_QString_int_cref_QString(long __this__nativeId, java.lang.String db, java.lang.String user, java.lang.String password, java.lang.String host, int port, java.lang.String connOpts);
        
    }
    
    /**
     * <p>Java wrapper for Qt enum QSqlDriver::DbmsType</p>
     */
    @io.qt.QtUnlistedEnum
    public enum DbmsType implements io.qt.QtEnumerator {
        UnknownDbms(0),
        MSSqlServer(1),
        MySqlServer(2),
        PostgreSQL(3),
        Oracle(4),
        Sybase(5),
        SQLite(6),
        Interbase(7),
        DB2(8);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DbmsType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static DbmsType resolve(int value) {
            switch (value) {
            case 0: return UnknownDbms;
            case 1: return MSSqlServer;
            case 2: return MySqlServer;
            case 3: return PostgreSQL;
            case 4: return Oracle;
            case 5: return Sybase;
            case 6: return SQLite;
            case 7: return Interbase;
            case 8: return DB2;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsqldriver.html#DriverFeature-enum">QSqlDriver::DriverFeature</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum DriverFeature implements io.qt.QtEnumerator {
        Transactions(0),
        QuerySize(1),
        BLOB(2),
        Unicode(3),
        PreparedQueries(4),
        NamedPlaceholders(5),
        PositionalPlaceholders(6),
        LastInsertId(7),
        BatchOperations(8),
        SimpleLocking(9),
        LowPrecisionNumbers(10),
        EventNotifications(11),
        FinishQuery(12),
        MultipleResultSets(13),
        CancelQuery(14);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DriverFeature(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static DriverFeature resolve(int value) {
            switch (value) {
            case 0: return Transactions;
            case 1: return QuerySize;
            case 2: return BLOB;
            case 3: return Unicode;
            case 4: return PreparedQueries;
            case 5: return NamedPlaceholders;
            case 6: return PositionalPlaceholders;
            case 7: return LastInsertId;
            case 8: return BatchOperations;
            case 9: return SimpleLocking;
            case 10: return LowPrecisionNumbers;
            case 11: return EventNotifications;
            case 12: return FinishQuery;
            case 13: return MultipleResultSets;
            case 14: return CancelQuery;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsqldriver.html#IdentifierType-enum">QSqlDriver::IdentifierType</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum IdentifierType implements io.qt.QtEnumerator {
        FieldName(0),
        TableName(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private IdentifierType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static IdentifierType resolve(int value) {
            switch (value) {
            case 0: return FieldName;
            case 1: return TableName;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsqldriver.html#NotificationSource-enum">QSqlDriver::NotificationSource</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum NotificationSource implements io.qt.QtEnumerator {
        UnknownSource(0),
        SelfSource(1),
        OtherSource(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private NotificationSource(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static NotificationSource resolve(int value) {
            switch (value) {
            case 0: return UnknownSource;
            case 1: return SelfSource;
            case 2: return OtherSource;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsqldriver.html#StatementType-enum">QSqlDriver::StatementType</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum StatementType implements io.qt.QtEnumerator {
        WhereStatement(0),
        SelectStatement(1),
        UpdateStatement(2),
        InsertStatement(3),
        DeleteStatement(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private StatementType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static StatementType resolve(int value) {
            switch (value) {
            case 0: return WhereStatement;
            case 1: return SelectStatement;
            case 2: return UpdateStatement;
            case 3: return InsertStatement;
            case 4: return DeleteStatement;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#notification">QSqlDriver::notification(QString,QSqlDriver::NotificationSource,QVariant)</a></p>
     */
    public final Signal3<java.lang.String, io.qt.sql.QSqlDriver.NotificationSource, java.lang.Object> notification = new Signal3<>();
    
    /**
     * <p>Overloaded constructor for {@link #QSqlDriver(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QSqlDriver() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#QSqlDriver">QSqlDriver::QSqlDriver(QObject*)</a></p>
     */
    public QSqlDriver(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QSqlDriver instance, io.qt.core.QObject parent);
    
    @io.qt.QtUninvokable
    public final io.qt.sql.QSqlDriver.DbmsType dbmsType(){
        return io.qt.sql.QSqlDriver.DbmsType.resolve(dbmsType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int dbmsType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#isOpenError">QSqlDriver::isOpenError()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isOpenError(){
        return isOpenError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isOpenError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#lastError">QSqlDriver::lastError()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.sql.QSqlError lastError(){
        return lastError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.sql.QSqlError lastError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#numericalPrecisionPolicy">QSqlDriver::numericalPrecisionPolicy()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.sql.QSql.NumericalPrecisionPolicy numericalPrecisionPolicy(){
        return io.qt.sql.QSql.NumericalPrecisionPolicy.resolve(numericalPrecisionPolicy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int numericalPrecisionPolicy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#setNumericalPrecisionPolicy">QSqlDriver::setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setNumericalPrecisionPolicy(io.qt.sql.QSql.NumericalPrecisionPolicy precisionPolicy){
        setNumericalPrecisionPolicy_native_QSql_NumericalPrecisionPolicy(QtJambi_LibraryUtilities.internal.nativeId(this), precisionPolicy.value());
    }
    
    @io.qt.QtUninvokable
    private native void setNumericalPrecisionPolicy_native_QSql_NumericalPrecisionPolicy(long __this__nativeId, int precisionPolicy);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#beginTransaction">QSqlDriver::beginTransaction()</a></p>
     */
    @io.qt.QtUninvokable
    public boolean beginTransaction(){
        return beginTransaction_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean beginTransaction_native(long __this__nativeId);
    
    public boolean cancelQuery(){
        return cancelQuery_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native boolean cancelQuery_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#close">QSqlDriver::close()</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void close();
    
    @io.qt.QtUninvokable
    private native void close_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#commitTransaction">QSqlDriver::commitTransaction()</a></p>
     */
    @io.qt.QtUninvokable
    public boolean commitTransaction(){
        return commitTransaction_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean commitTransaction_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#createResult">QSqlDriver::createResult()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.sql.QSqlResult createResult();
    
    @io.qt.QtUninvokable
    private native io.qt.sql.QSqlResult createResult_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#escapeIdentifier">QSqlDriver::escapeIdentifier(QString,QSqlDriver::IdentifierType)const</a></p>
     */
    @io.qt.QtUninvokable
    public java.lang.String escapeIdentifier(java.lang.String identifier, io.qt.sql.QSqlDriver.IdentifierType type){
        return escapeIdentifier_native_cref_QString_QSqlDriver_IdentifierType_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), identifier, type.value());
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String escapeIdentifier_native_cref_QString_QSqlDriver_IdentifierType_constfct(long __this__nativeId, java.lang.String identifier, int type);
    
    /**
     * <p>Overloaded function for {@link #formatValue(io.qt.sql.QSqlField, boolean)}
     *  with <code>trimStrings = false</code>.</p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String formatValue(io.qt.sql.QSqlField field) {
        return formatValue(field, (boolean)false);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#formatValue">QSqlDriver::formatValue(QSqlField,bool)const</a></p>
     */
    @io.qt.QtUninvokable
    public java.lang.String formatValue(io.qt.sql.QSqlField field, boolean trimStrings){
        return formatValue_native_cref_QSqlField_bool_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(field), trimStrings);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String formatValue_native_cref_QSqlField_bool_constfct(long __this__nativeId, long field, boolean trimStrings);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#handle">QSqlDriver::handle()const</a></p>
     */
    @io.qt.QtUninvokable
    public java.lang.Object handle(){
        return handle_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object handle_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#hasFeature">QSqlDriver::hasFeature(QSqlDriver::DriverFeature)const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean hasFeature(io.qt.sql.QSqlDriver.DriverFeature f);
    
    @io.qt.QtUninvokable
    private native boolean hasFeature_native_QSqlDriver_DriverFeature_constfct(long __this__nativeId, int f);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#isIdentifierEscaped">QSqlDriver::isIdentifierEscaped(QString,QSqlDriver::IdentifierType)const</a></p>
     */
    @io.qt.QtUninvokable
    public boolean isIdentifierEscaped(java.lang.String identifier, io.qt.sql.QSqlDriver.IdentifierType type){
        return isIdentifierEscaped_native_cref_QString_QSqlDriver_IdentifierType_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), identifier, type.value());
    }
    
    @io.qt.QtUninvokable
    private native boolean isIdentifierEscaped_native_cref_QString_QSqlDriver_IdentifierType_constfct(long __this__nativeId, java.lang.String identifier, int type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#isOpen">QSqlDriver::isOpen()const</a></p>
     */
    @io.qt.QtUninvokable
    public boolean isOpen(){
        return isOpen_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isOpen_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#maximumIdentifierLength">QSqlDriver::maximumIdentifierLength(QSqlDriver::IdentifierType)const</a></p>
     */
    @io.qt.QtUninvokable
    public int maximumIdentifierLength(io.qt.sql.QSqlDriver.IdentifierType type){
        return maximumIdentifierLength_native_QSqlDriver_IdentifierType_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @io.qt.QtUninvokable
    private native int maximumIdentifierLength_native_QSqlDriver_IdentifierType_constfct(long __this__nativeId, int type);
    
    /**
     * <p>Overloaded function for {@link #open(java.lang.String, java.lang.String, java.lang.String, java.lang.String, int, java.lang.String)}
     *  with <code>connOpts = (String)null</code>.</p>
     */
    @io.qt.QtUninvokable
    public final boolean open(java.lang.String db, java.lang.String user, java.lang.String password, java.lang.String host, int port) {
        return open(db, user, password, host, port, (String)null);
    }
    
    /**
     * <p>Overloaded function for {@link #open(java.lang.String, java.lang.String, java.lang.String, java.lang.String, int, java.lang.String)}</p>
     * <p>with: </p><ul>
     * <li><code>port = -1</code></li>
     * <li><code>connOpts = (String)null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final boolean open(java.lang.String db, java.lang.String user, java.lang.String password, java.lang.String host) {
        return open(db, user, password, host, (int)-1, (String)null);
    }
    
    /**
     * <p>Overloaded function for {@link #open(java.lang.String, java.lang.String, java.lang.String, java.lang.String, int, java.lang.String)}</p>
     * <p>with: </p><ul>
     * <li><code>host = (String)null</code></li>
     * <li><code>port = -1</code></li>
     * <li><code>connOpts = (String)null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final boolean open(java.lang.String db, java.lang.String user, java.lang.String password) {
        return open(db, user, password, (String)null, (int)-1, (String)null);
    }
    
    /**
     * <p>Overloaded function for {@link #open(java.lang.String, java.lang.String, java.lang.String, java.lang.String, int, java.lang.String)}</p>
     * <p>with: </p><ul>
     * <li><code>password = (String)null</code></li>
     * <li><code>host = (String)null</code></li>
     * <li><code>port = -1</code></li>
     * <li><code>connOpts = (String)null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final boolean open(java.lang.String db, java.lang.String user) {
        return open(db, user, (String)null, (String)null, (int)-1, (String)null);
    }
    
    /**
     * <p>Overloaded function for {@link #open(java.lang.String, java.lang.String, java.lang.String, java.lang.String, int, java.lang.String)}</p>
     * <p>with: </p><ul>
     * <li><code>user = (String)null</code></li>
     * <li><code>password = (String)null</code></li>
     * <li><code>host = (String)null</code></li>
     * <li><code>port = -1</code></li>
     * <li><code>connOpts = (String)null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final boolean open(java.lang.String db) {
        return open(db, (String)null, (String)null, (String)null, (int)-1, (String)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#open">QSqlDriver::open(QString,QString,QString,QString,int,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean open(java.lang.String db, java.lang.String user, java.lang.String password, java.lang.String host, int port, java.lang.String connOpts);
    
    @io.qt.QtUninvokable
    private native boolean open_native_cref_QString_cref_QString_cref_QString_cref_QString_int_cref_QString(long __this__nativeId, java.lang.String db, java.lang.String user, java.lang.String password, java.lang.String host, int port, java.lang.String connOpts);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#primaryIndex">QSqlDriver::primaryIndex(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.sql.QSqlIndex primaryIndex(java.lang.String tableName){
        return primaryIndex_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), tableName);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.sql.QSqlIndex primaryIndex_native_cref_QString_constfct(long __this__nativeId, java.lang.String tableName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#record">QSqlDriver::record(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.sql.QSqlRecord record(java.lang.String tableName){
        return record_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), tableName);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.sql.QSqlRecord record_native_cref_QString_constfct(long __this__nativeId, java.lang.String tableName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#rollbackTransaction">QSqlDriver::rollbackTransaction()</a></p>
     */
    @io.qt.QtUninvokable
    public boolean rollbackTransaction(){
        return rollbackTransaction_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean rollbackTransaction_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#setLastError">QSqlDriver::setLastError(QSqlError)</a></p>
     */
    @io.qt.QtUninvokable
    protected void setLastError(io.qt.sql.QSqlError e){
        setLastError_native_cref_QSqlError(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @io.qt.QtUninvokable
    private native void setLastError_native_cref_QSqlError(long __this__nativeId, long e);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#setOpen">QSqlDriver::setOpen(bool)</a></p>
     */
    @io.qt.QtUninvokable
    protected void setOpen(boolean o){
        setOpen_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), o);
    }
    
    @io.qt.QtUninvokable
    private native void setOpen_native_bool(long __this__nativeId, boolean o);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#setOpenError">QSqlDriver::setOpenError(bool)</a></p>
     */
    @io.qt.QtUninvokable
    protected void setOpenError(boolean e){
        setOpenError_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), e);
    }
    
    @io.qt.QtUninvokable
    private native void setOpenError_native_bool(long __this__nativeId, boolean e);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#sqlStatement">QSqlDriver::sqlStatement(QSqlDriver::StatementType,QString,QSqlRecord,bool)const</a></p>
     */
    @io.qt.QtUninvokable
    public java.lang.String sqlStatement(io.qt.sql.QSqlDriver.StatementType type, java.lang.String tableName, io.qt.sql.QSqlRecord rec, boolean preparedStatement){
        return sqlStatement_native_QSqlDriver_StatementType_cref_QString_cref_QSqlRecord_bool_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), tableName, QtJambi_LibraryUtilities.internal.checkedNativeId(rec), preparedStatement);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String sqlStatement_native_QSqlDriver_StatementType_cref_QString_cref_QSqlRecord_bool_constfct(long __this__nativeId, int type, java.lang.String tableName, long rec, boolean preparedStatement);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#stripDelimiters">QSqlDriver::stripDelimiters(QString,QSqlDriver::IdentifierType)const</a></p>
     */
    @io.qt.QtUninvokable
    public java.lang.String stripDelimiters(java.lang.String identifier, io.qt.sql.QSqlDriver.IdentifierType type){
        return stripDelimiters_native_cref_QString_QSqlDriver_IdentifierType_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), identifier, type.value());
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String stripDelimiters_native_cref_QString_QSqlDriver_IdentifierType_constfct(long __this__nativeId, java.lang.String identifier, int type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#subscribeToNotification">QSqlDriver::subscribeToNotification(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public boolean subscribeToNotification(java.lang.String name){
        return subscribeToNotification_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native boolean subscribeToNotification_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#subscribedToNotifications">QSqlDriver::subscribedToNotifications()const</a></p>
     */
    @io.qt.QtUninvokable
    public java.util.List<java.lang.String> subscribedToNotifications(){
        return subscribedToNotifications_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.util.List<java.lang.String> subscribedToNotifications_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#tables">QSqlDriver::tables(QSql::TableType)const</a></p>
     */
    @io.qt.QtUninvokable
    public java.util.List<java.lang.String> tables(io.qt.sql.QSql.TableType tableType){
        return tables_native_QSql_TableType_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), tableType.value());
    }
    
    @io.qt.QtUninvokable
    private native java.util.List<java.lang.String> tables_native_QSql_TableType_constfct(long __this__nativeId, int tableType);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsqldriver.html#unsubscribeFromNotification">QSqlDriver::unsubscribeFromNotification(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public boolean unsubscribeFromNotification(java.lang.String name){
        return unsubscribeFromNotification_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native boolean unsubscribeFromNotification_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSqlDriver(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QSqlDriver(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QSqlDriver instance, QDeclarativeConstructor constructor);
    
}
