package io.qt.sql;


/**
 * <p>Means of executing and manipulating SQL statements</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qsqlquery.html">QSqlQuery</a></p>
 */
public class QSqlQuery extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsqlquery.html#BatchExecutionMode-enum">QSqlQuery::BatchExecutionMode</a></p>
     */
    public enum BatchExecutionMode implements io.qt.QtEnumerator {
        ValuesAsRows(0),
        ValuesAsColumns(1);

        private BatchExecutionMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static BatchExecutionMode resolve(int value) {
            switch (value) {
            case 0: return ValuesAsRows;
            case 1: return ValuesAsColumns;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#QSqlQuery-2">QSqlQuery::QSqlQuery(QSqlDatabase)</a></p>
     */
    public QSqlQuery(io.qt.sql.QSqlDatabase db){
        super((QPrivateConstructor)null);
        initialize_native(this, db);
    }
    
    private native static void initialize_native(QSqlQuery instance, io.qt.sql.QSqlDatabase db);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#QSqlQuery">QSqlQuery::QSqlQuery(QSqlResult*)</a></p>
     */
    public QSqlQuery(io.qt.sql.QSqlResult r){
        super((QPrivateConstructor)null);
        initialize_native(this, r);
    }
    
    private native static void initialize_native(QSqlQuery instance, io.qt.sql.QSqlResult r);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#QSqlQuery-3">QSqlQuery::QSqlQuery(QSqlQuery)</a></p>
     */
    public QSqlQuery(io.qt.sql.QSqlQuery other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QSqlQuery instance, io.qt.sql.QSqlQuery other);
    
    /**
     * <p>Overloaded constructor for {@link #QSqlQuery(java.lang.String, io.qt.sql.QSqlDatabase)}
     *  with <code>db = new io.qt.sql.QSqlDatabase()</code>.</p>
     */
    public QSqlQuery(java.lang.String query) {
        this(query, new io.qt.sql.QSqlDatabase());
    }
    
    /**
     * <p>Overloaded constructor for {@link #QSqlQuery(java.lang.String, io.qt.sql.QSqlDatabase)}</p>
     * <p>with: </p><ul>
     * <li><code>query = ""</code></li>
     * <li><code>db = new io.qt.sql.QSqlDatabase()</code></li>
     * </ul>
     */
    public QSqlQuery() {
        this("", new io.qt.sql.QSqlDatabase());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#QSqlQuery-1">QSqlQuery::QSqlQuery(QString,QSqlDatabase)</a></p>
     */
    public QSqlQuery(java.lang.String query, io.qt.sql.QSqlDatabase db){
        super((QPrivateConstructor)null);
        initialize_native(this, query, db);
    }
    
    private native static void initialize_native(QSqlQuery instance, java.lang.String query, io.qt.sql.QSqlDatabase db);
    
    /**
     * <p>Overloaded function for {@link #addBindValue(java.lang.Object, io.qt.sql.QSql.ParamType)}.</p>
     */
    @io.qt.QtUninvokable
    public final void addBindValue(java.lang.Object val, io.qt.sql.QSql.ParamTypeFlag ... type){
        addBindValue(val, new io.qt.sql.QSql.ParamType(type));
    }
    
    /**
     * <p>Overloaded function for {@link #addBindValue(java.lang.Object, io.qt.sql.QSql.ParamType)}
     *  with <code>type = new io.qt.sql.QSql.ParamType(1)</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void addBindValue(java.lang.Object val) {
        addBindValue(val, new io.qt.sql.QSql.ParamType(1));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#addBindValue">QSqlQuery::addBindValue(QVariant,QSql::ParamType)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addBindValue(java.lang.Object val, io.qt.sql.QSql.ParamType type){
        addBindValue_native_cref_QVariant_QFlags_QSql_ParamTypeFlag_(QtJambi_LibraryUtilities.internal.nativeId(this), val, type.value());
    }
    
    @io.qt.QtUninvokable
    private native void addBindValue_native_cref_QVariant_QFlags_QSql_ParamTypeFlag_(long __this__nativeId, java.lang.Object val, int type);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#at">QSqlQuery::at()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int at(){
        return at_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int at_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #bindValue(java.lang.String, java.lang.Object, io.qt.sql.QSql.ParamType)}.</p>
     */
    @io.qt.QtUninvokable
    public final void bindValue(java.lang.String placeholder, java.lang.Object val, io.qt.sql.QSql.ParamTypeFlag ... type){
        bindValue(placeholder, val, new io.qt.sql.QSql.ParamType(type));
    }
    
    /**
     * <p>Overloaded function for {@link #bindValue(java.lang.String, java.lang.Object, io.qt.sql.QSql.ParamType)}
     *  with <code>type = new io.qt.sql.QSql.ParamType(1)</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void bindValue(java.lang.String placeholder, java.lang.Object val) {
        bindValue(placeholder, val, new io.qt.sql.QSql.ParamType(1));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#bindValue">QSqlQuery::bindValue(QString,QVariant,QSql::ParamType)</a></p>
     */
    @io.qt.QtUninvokable
    public final void bindValue(java.lang.String placeholder, java.lang.Object val, io.qt.sql.QSql.ParamType type){
        bindValue_native_cref_QString_cref_QVariant_QFlags_QSql_ParamTypeFlag_(QtJambi_LibraryUtilities.internal.nativeId(this), placeholder, val, type.value());
    }
    
    @io.qt.QtUninvokable
    private native void bindValue_native_cref_QString_cref_QVariant_QFlags_QSql_ParamTypeFlag_(long __this__nativeId, java.lang.String placeholder, java.lang.Object val, int type);
    
    /**
     * <p>Overloaded function for {@link #bindValue(int, java.lang.Object, io.qt.sql.QSql.ParamType)}.</p>
     */
    @io.qt.QtUninvokable
    public final void bindValue(int pos, java.lang.Object val, io.qt.sql.QSql.ParamTypeFlag ... type){
        bindValue(pos, val, new io.qt.sql.QSql.ParamType(type));
    }
    
    /**
     * <p>Overloaded function for {@link #bindValue(int, java.lang.Object, io.qt.sql.QSql.ParamType)}
     *  with <code>type = new io.qt.sql.QSql.ParamType(1)</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void bindValue(int pos, java.lang.Object val) {
        bindValue(pos, val, new io.qt.sql.QSql.ParamType(1));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#bindValue-1">QSqlQuery::bindValue(int,QVariant,QSql::ParamType)</a></p>
     */
    @io.qt.QtUninvokable
    public final void bindValue(int pos, java.lang.Object val, io.qt.sql.QSql.ParamType type){
        bindValue_native_int_cref_QVariant_QFlags_QSql_ParamTypeFlag_(QtJambi_LibraryUtilities.internal.nativeId(this), pos, val, type.value());
    }
    
    @io.qt.QtUninvokable
    private native void bindValue_native_int_cref_QVariant_QFlags_QSql_ParamTypeFlag_(long __this__nativeId, int pos, java.lang.Object val, int type);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#boundValue">QSqlQuery::boundValue(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object boundValue(java.lang.String placeholder){
        return boundValue_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), placeholder);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object boundValue_native_cref_QString_constfct(long __this__nativeId, java.lang.String placeholder);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#boundValue-1">QSqlQuery::boundValue(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object boundValue(int pos){
        return boundValue_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), pos);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object boundValue_native_int_constfct(long __this__nativeId, int pos);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#boundValues">QSqlQuery::boundValues()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QMap<java.lang.String, java.lang.Object> boundValues(){
        return boundValues_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QMap<java.lang.String, java.lang.Object> boundValues_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#clear">QSqlQuery::clear()</a></p>
     */
    @io.qt.QtUninvokable
    public final void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void clear_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#driver">QSqlQuery::driver()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.sql.QSqlDriver driver(){
        return driver_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.sql.QSqlDriver driver_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#exec-1">QSqlQuery::exec()</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean exec(){
        return exec_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean exec_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#exec">QSqlQuery::exec(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean exec(java.lang.String query){
        return exec_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), query);
    }
    
    @io.qt.QtUninvokable
    private native boolean exec_native_cref_QString(long __this__nativeId, java.lang.String query);
    
    /**
     * <p>Overloaded function for {@link #execBatch(io.qt.sql.QSqlQuery.BatchExecutionMode)}
     *  with <code>mode = io.qt.sql.QSqlQuery.BatchExecutionMode.ValuesAsRows</code>.</p>
     */
    @io.qt.QtUninvokable
    public final boolean execBatch() {
        return execBatch(io.qt.sql.QSqlQuery.BatchExecutionMode.ValuesAsRows);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#execBatch">QSqlQuery::execBatch(QSqlQuery::BatchExecutionMode)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean execBatch(io.qt.sql.QSqlQuery.BatchExecutionMode mode){
        return execBatch_native_QSqlQuery_BatchExecutionMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    @io.qt.QtUninvokable
    private native boolean execBatch_native_QSqlQuery_BatchExecutionMode(long __this__nativeId, int mode);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#executedQuery">QSqlQuery::executedQuery()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String executedQuery(){
        return executedQuery_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String executedQuery_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#finish">QSqlQuery::finish()</a></p>
     */
    @io.qt.QtUninvokable
    public final void finish(){
        finish_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void finish_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#first">QSqlQuery::first()</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean first(){
        return first_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean first_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#isActive">QSqlQuery::isActive()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isActive(){
        return isActive_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isActive_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#isForwardOnly">QSqlQuery::isForwardOnly()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isForwardOnly(){
        return isForwardOnly_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isForwardOnly_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#isNull-1">QSqlQuery::isNull(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isNull(java.lang.String name){
        return isNull_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native boolean isNull_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#isNull">QSqlQuery::isNull(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isNull(int field){
        return isNull_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), field);
    }
    
    @io.qt.QtUninvokable
    private native boolean isNull_native_int_constfct(long __this__nativeId, int field);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#isSelect">QSqlQuery::isSelect()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isSelect(){
        return isSelect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isSelect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#isValid">QSqlQuery::isValid()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#last">QSqlQuery::last()</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean last(){
        return last_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean last_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#lastError">QSqlQuery::lastError()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.sql.QSqlError lastError(){
        return lastError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.sql.QSqlError lastError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#lastInsertId">QSqlQuery::lastInsertId()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object lastInsertId(){
        return lastInsertId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object lastInsertId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#lastQuery">QSqlQuery::lastQuery()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String lastQuery(){
        return lastQuery_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String lastQuery_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#next">QSqlQuery::next()</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean next(){
        return next_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean next_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#nextResult">QSqlQuery::nextResult()</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean nextResult(){
        return nextResult_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean nextResult_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#numRowsAffected">QSqlQuery::numRowsAffected()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int numRowsAffected(){
        return numRowsAffected_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int numRowsAffected_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#numericalPrecisionPolicy">QSqlQuery::numericalPrecisionPolicy()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.sql.QSql.NumericalPrecisionPolicy numericalPrecisionPolicy(){
        return io.qt.sql.QSql.NumericalPrecisionPolicy.resolve(numericalPrecisionPolicy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int numericalPrecisionPolicy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#prepare">QSqlQuery::prepare(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean prepare(java.lang.String query){
        return prepare_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), query);
    }
    
    @io.qt.QtUninvokable
    private native boolean prepare_native_cref_QString(long __this__nativeId, java.lang.String query);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#previous">QSqlQuery::previous()</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean previous(){
        return previous_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean previous_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#record">QSqlQuery::record()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.sql.QSqlRecord record(){
        return record_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.sql.QSqlRecord record_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#result">QSqlQuery::result()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.sql.QSqlResult result(){
        return result_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.sql.QSqlResult result_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #seek(int, boolean)}
     *  with <code>relative = false</code>.</p>
     */
    @io.qt.QtUninvokable
    public final boolean seek(int i) {
        return seek(i, (boolean)false);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#seek">QSqlQuery::seek(int,bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean seek(int i, boolean relative){
        return seek_native_int_bool(QtJambi_LibraryUtilities.internal.nativeId(this), i, relative);
    }
    
    @io.qt.QtUninvokable
    private native boolean seek_native_int_bool(long __this__nativeId, int i, boolean relative);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#setForwardOnly">QSqlQuery::setForwardOnly(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setForwardOnly(boolean forward){
        setForwardOnly_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), forward);
    }
    
    @io.qt.QtUninvokable
    private native void setForwardOnly_native_bool(long __this__nativeId, boolean forward);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#setNumericalPrecisionPolicy">QSqlQuery::setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setNumericalPrecisionPolicy(io.qt.sql.QSql.NumericalPrecisionPolicy precisionPolicy){
        setNumericalPrecisionPolicy_native_QSql_NumericalPrecisionPolicy(QtJambi_LibraryUtilities.internal.nativeId(this), precisionPolicy.value());
    }
    
    @io.qt.QtUninvokable
    private native void setNumericalPrecisionPolicy_native_QSql_NumericalPrecisionPolicy(long __this__nativeId, int precisionPolicy);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#size">QSqlQuery::size()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int size(){
        return size_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int size_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#value-1">QSqlQuery::value(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object value(java.lang.String name){
        return value_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object value_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlquery.html#value">QSqlQuery::value(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object value(int i){
        return value_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), i);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object value_native_int_constfct(long __this__nativeId, int i);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSqlQuery(QPrivateConstructor p) { super(p); } 
    
    
    @Override
    public QSqlQuery clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QSqlQuery clone_native(long __this_nativeId);
}
