package io.qt.sql;


/**
 * <p>Contains miscellaneous identifiers used throughout the Qt SQL module</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qsql.html">QSql</a></p>
 */
public final class QSql
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private QSql() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace QSql."); }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsql.html#Location-enum">QSql::Location</a></p>
     */
    public enum Location implements io.qt.QtEnumerator {
        BeforeFirstRow(-1),
        AfterLastRow(-2);

        private Location(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Location resolve(int value) {
            switch (value) {
            case -1: return BeforeFirstRow;
            case -2: return AfterLastRow;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsql.html#NumericalPrecisionPolicy-enum">QSql::NumericalPrecisionPolicy</a></p>
     */
    public enum NumericalPrecisionPolicy implements io.qt.QtEnumerator {
        LowPrecisionInt32(1),
        LowPrecisionInt64(2),
        LowPrecisionDouble(4),
        HighPrecision(0);

        private NumericalPrecisionPolicy(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static NumericalPrecisionPolicy resolve(int value) {
            switch (value) {
            case 1: return LowPrecisionInt32;
            case 2: return LowPrecisionInt64;
            case 4: return LowPrecisionDouble;
            case 0: return HighPrecision;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsql.html#ParamTypeFlag-enum">QSql::ParamTypeFlag</a></p>
     * 
     * @see ParamType
     */
    public enum ParamTypeFlag implements io.qt.QtFlagEnumerator {
        In(1),
        Out(2),
        InOut(3),
        Binary(4);

        private ParamTypeFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public ParamType asFlags() {
            return new ParamType(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public ParamType combined(ParamTypeFlag e) {
            return new ParamType(this, e);
        }

        /**
         * Creates a new {@link ParamType} from the entries.
         * @param values entries
         * @return new flag
         */
        public static ParamType flags(ParamTypeFlag ... values) {
            return new ParamType(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ParamTypeFlag resolve(int value) {
            switch (value) {
            case 1: return In;
            case 2: return Out;
            case 3: return InOut;
            case 4: return Binary;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link ParamTypeFlag}
     */
    public static final class ParamType extends io.qt.QFlags<ParamTypeFlag> implements Comparable<ParamType> {
        private static final long serialVersionUID = 0x53e415e7b2e0668eL;

        /**
         * Creates a new ParamType where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public ParamType(ParamTypeFlag ... args){
            super(args);
        }

        /**
         * Creates a new ParamType with given <code>value</code>.
         * @param value
         */
        public ParamType(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new ParamType
         */
        @Override
        public final ParamType combined(ParamTypeFlag e){
            return new ParamType(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final ParamType setFlag(ParamTypeFlag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final ParamType setFlag(ParamTypeFlag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this ParamType.
         * @return array of enum entries
         */
        @Override
        public final ParamTypeFlag[] flags(){
            return super.flags(ParamTypeFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final ParamType clone(){
            return new ParamType(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(ParamType other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsql.html#TableType-enum">QSql::TableType</a></p>
     */
    public enum TableType implements io.qt.QtEnumerator {
        Tables(1),
        SystemTables(2),
        Views(4),
        AllTables(255);

        private TableType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static TableType resolve(int value) {
            switch (value) {
            case 1: return Tables;
            case 2: return SystemTables;
            case 4: return Views;
            case 255: return AllTables;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
}
