package io.qt.sql;


/**
 * <p>Manipulates the fields in SQL database tables and views</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qsqlfield.html">QSqlField</a></p>
 */
public class QSqlField extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsqlfield.html#RequiredStatus-enum">QSqlField::RequiredStatus</a></p>
     */
    public enum RequiredStatus implements io.qt.QtEnumerator {
        Unknown(-1),
        Optional(0),
        Required(1);

        private RequiredStatus(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static RequiredStatus resolve(int value) {
            switch (value) {
            case -1: return Unknown;
            case 0: return Optional;
            case 1: return Required;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#QSqlField-2">QSqlField::QSqlField(QSqlField)</a></p>
     */
    public QSqlField(io.qt.sql.QSqlField other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QSqlField instance, io.qt.sql.QSqlField other);
    
    /**
     * <p>Overloaded constructor for {@link #QSqlField(java.lang.String, io.qt.core.QVariant.Type)}
     *  with <code>type = io.qt.core.QVariant.Type.Invalid</code>.</p>
     */
    public QSqlField(java.lang.String fieldName) {
        this(fieldName, io.qt.core.QVariant.Type.Invalid);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QSqlField(java.lang.String, io.qt.core.QVariant.Type)}</p>
     * <p>with: </p><ul>
     * <li><code>fieldName = ""</code></li>
     * <li><code>type = io.qt.core.QVariant.Type.Invalid</code></li>
     * </ul>
     */
    public QSqlField() {
        this("", io.qt.core.QVariant.Type.Invalid);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#QSqlField">QSqlField::QSqlField(QString,QVariant::Type)</a></p>
     */
    public QSqlField(java.lang.String fieldName, io.qt.core.QVariant.Type type){
        super((QPrivateConstructor)null);
        initialize_native(this, fieldName, type);
    }
    
    private native static void initialize_native(QSqlField instance, java.lang.String fieldName, io.qt.core.QVariant.Type type);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#QSqlField-1">QSqlField::QSqlField(QString,QVariant::Type,QString)</a></p>
     */
    public QSqlField(java.lang.String fieldName, io.qt.core.QVariant.Type type, java.lang.String tableName){
        super((QPrivateConstructor)null);
        initialize_native(this, fieldName, type, tableName);
    }
    
    private native static void initialize_native(QSqlField instance, java.lang.String fieldName, io.qt.core.QVariant.Type type, java.lang.String tableName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#clear">QSqlField::clear()</a></p>
     */
    @io.qt.QtUninvokable
    public final void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void clear_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#defaultValue">QSqlField::defaultValue()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object defaultValue(){
        return defaultValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object defaultValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#isAutoValue">QSqlField::isAutoValue()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isAutoValue(){
        return isAutoValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isAutoValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#isGenerated">QSqlField::isGenerated()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isGenerated(){
        return isGenerated_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isGenerated_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#isNull">QSqlField::isNull()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#isReadOnly">QSqlField::isReadOnly()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isReadOnly(){
        return isReadOnly_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isReadOnly_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#isValid">QSqlField::isValid()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#length">QSqlField::length()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int length(){
        return length_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int length_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#name">QSqlField::name()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#operator-eq-eq">QSqlField::operator==(QSqlField)const</a></p>
     */
    @io.qt.QtUninvokable
    private final boolean operator_equal(io.qt.sql.QSqlField other){
        return operator_equal_native_cref_QSqlField_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native boolean operator_equal_native_cref_QSqlField_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#precision">QSqlField::precision()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int precision(){
        return precision_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int precision_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#requiredStatus">QSqlField::requiredStatus()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.sql.QSqlField.RequiredStatus requiredStatus(){
        return io.qt.sql.QSqlField.RequiredStatus.resolve(requiredStatus_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int requiredStatus_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#setAutoValue">QSqlField::setAutoValue(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAutoValue(boolean autoVal){
        setAutoValue_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), autoVal);
    }
    
    @io.qt.QtUninvokable
    private native void setAutoValue_native_bool(long __this__nativeId, boolean autoVal);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#setDefaultValue">QSqlField::setDefaultValue(QVariant)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setDefaultValue(java.lang.Object value){
        setDefaultValue_native_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @io.qt.QtUninvokable
    private native void setDefaultValue_native_cref_QVariant(long __this__nativeId, java.lang.Object value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#setGenerated">QSqlField::setGenerated(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setGenerated(boolean gen){
        setGenerated_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), gen);
    }
    
    @io.qt.QtUninvokable
    private native void setGenerated_native_bool(long __this__nativeId, boolean gen);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#setLength">QSqlField::setLength(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setLength(int fieldLength){
        setLength_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), fieldLength);
    }
    
    @io.qt.QtUninvokable
    private native void setLength_native_int(long __this__nativeId, int fieldLength);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#setName">QSqlField::setName(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setName(java.lang.String name){
        setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native void setName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#setPrecision">QSqlField::setPrecision(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPrecision(int precision){
        setPrecision_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), precision);
    }
    
    @io.qt.QtUninvokable
    private native void setPrecision_native_int(long __this__nativeId, int precision);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#setReadOnly">QSqlField::setReadOnly(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setReadOnly(boolean readOnly){
        setReadOnly_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), readOnly);
    }
    
    @io.qt.QtUninvokable
    private native void setReadOnly_native_bool(long __this__nativeId, boolean readOnly);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#setRequired">QSqlField::setRequired(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setRequired(boolean required){
        setRequired_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), required);
    }
    
    @io.qt.QtUninvokable
    private native void setRequired_native_bool(long __this__nativeId, boolean required);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#setRequiredStatus">QSqlField::setRequiredStatus(QSqlField::RequiredStatus)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setRequiredStatus(io.qt.sql.QSqlField.RequiredStatus status){
        setRequiredStatus_native_QSqlField_RequiredStatus(QtJambi_LibraryUtilities.internal.nativeId(this), status.value());
    }
    
    @io.qt.QtUninvokable
    private native void setRequiredStatus_native_QSqlField_RequiredStatus(long __this__nativeId, int status);
    
    @io.qt.QtUninvokable
    public final void setSqlType(int type){
        setSqlType_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), type);
    }
    
    @io.qt.QtUninvokable
    private native void setSqlType_native_int(long __this__nativeId, int type);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#setTableName">QSqlField::setTableName(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setTableName(java.lang.String tableName){
        setTableName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), tableName);
    }
    
    @io.qt.QtUninvokable
    private native void setTableName_native_cref_QString(long __this__nativeId, java.lang.String tableName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#setType">QSqlField::setType(QVariant::Type)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setType(io.qt.core.QVariant.Type type){
        setType_native_QVariant_Type(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @io.qt.QtUninvokable
    private native void setType_native_QVariant_Type(long __this__nativeId, int type);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#setValue">QSqlField::setValue(QVariant)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setValue(java.lang.Object value){
        setValue_native_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @io.qt.QtUninvokable
    private native void setValue_native_cref_QVariant(long __this__nativeId, java.lang.Object value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#tableName">QSqlField::tableName()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String tableName(){
        return tableName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String tableName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#type">QSqlField::type()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QVariant.Type type(){
        return io.qt.core.QVariant.Type.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final int typeID(){
        return typeID_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int typeID_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsqlfield.html#value">QSqlField::value()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object value(){
        return value_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object value_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSqlField(QPrivateConstructor p) { super(p); } 
    

    @Override
    @io.qt.QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.sql.QSqlField) {
            return operator_equal((io.qt.sql.QSqlField) other);
        }

        return false;
    }


    @io.qt.QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private native static int hashCode_native(long __this_nativeId);

    @Override
    @io.qt.QtUninvokable
    public String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private static native String toString_native(long __this_nativeId);
    
    @Override
    public QSqlField clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QSqlField clone_native(long __this_nativeId);
}
