package io.qt.sql;

import io.qt.*;


/**
 * <p>Means of executing and manipulating SQL statements</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qsqlquery.html">QSqlQuery</a></code></p>
 */
public class QSqlQuery extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#BatchExecutionMode-enum">QSqlQuery::BatchExecutionMode</a></code></p>
     */
    public enum BatchExecutionMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#BatchExecutionMode-enum">QSqlQuery::<wbr/>ValuesAsRows</a></code></p>
         */
        ValuesAsRows(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#BatchExecutionMode-enum">QSqlQuery::<wbr/>ValuesAsColumns</a></code></p>
         */
        ValuesAsColumns(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private BatchExecutionMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull BatchExecutionMode resolve(int value) {
            switch (value) {
            case 0: return ValuesAsRows;
            case 1: return ValuesAsColumns;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#QSqlQuery-2">QSqlQuery::<wbr/>QSqlQuery(QSqlDatabase)</a></code></p>
     */
    public QSqlQuery(io.qt.sql.@NonNull QSqlDatabase db){
        super((QPrivateConstructor)null);
        initialize_native(this, db);
    }
    
    private native static void initialize_native(QSqlQuery instance, io.qt.sql.QSqlDatabase db);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#QSqlQuery-3">QSqlQuery::<wbr/>QSqlQuery(QSqlQuery)</a></code></p>
     */
    public QSqlQuery(io.qt.sql.@NonNull QSqlQuery other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QSqlQuery instance, io.qt.sql.QSqlQuery other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#QSqlQuery">QSqlQuery::<wbr/>QSqlQuery(QSqlResult*)</a></code></p>
     */
    public QSqlQuery(io.qt.sql.@Nullable QSqlResult r){
        super((QPrivateConstructor)null);
        initialize_native(this, r);
    }
    
    private native static void initialize_native(QSqlQuery instance, io.qt.sql.QSqlResult r);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#QSqlQuery-1">QSqlQuery::<wbr/>QSqlQuery(QString,<wbr/>QSqlDatabase)</a></code></p>
     */
    public QSqlQuery(java.lang.@NonNull String query, io.qt.sql.@NonNull QSqlDatabase db){
        super((QPrivateConstructor)null);
        initialize_native(this, query, db);
    }
    
    private native static void initialize_native(QSqlQuery instance, java.lang.String query, io.qt.sql.QSqlDatabase db);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#addBindValue">QSqlQuery::<wbr/>addBindValue(QVariant,<wbr/>QSql::ParamType)</a></code></p>
     */
    @QtUninvokable
    public final void addBindValue(java.lang.Object val, io.qt.sql.QSql.@NonNull ParamType type){
        addBindValue_native_cref_QVariant_QSql_ParamType(QtJambi_LibraryUtilities.internal.nativeId(this), val, type.value());
    }
    
    @QtUninvokable
    private native void addBindValue_native_cref_QVariant_QSql_ParamType(long __this__nativeId, java.lang.Object val, int type);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#at">QSqlQuery::<wbr/>at()const</a></code></p>
     */
    @QtUninvokable
    public final int at(){
        return at_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int at_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#bindValue">QSqlQuery::<wbr/>bindValue(QString,<wbr/>QVariant,<wbr/>QSql::ParamType)</a></code></p>
     */
    @QtUninvokable
    public final void bindValue(java.lang.@NonNull String placeholder, java.lang.Object val, io.qt.sql.QSql.@NonNull ParamType type){
        bindValue_native_cref_QString_cref_QVariant_QSql_ParamType(QtJambi_LibraryUtilities.internal.nativeId(this), placeholder, val, type.value());
    }
    
    @QtUninvokable
    private native void bindValue_native_cref_QString_cref_QVariant_QSql_ParamType(long __this__nativeId, java.lang.String placeholder, java.lang.Object val, int type);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#bindValue-1">QSqlQuery::<wbr/>bindValue(int,<wbr/>QVariant,<wbr/>QSql::ParamType)</a></code></p>
     */
    @QtUninvokable
    public final void bindValue(int pos, java.lang.Object val, io.qt.sql.QSql.@NonNull ParamType type){
        bindValue_native_int_cref_QVariant_QSql_ParamType(QtJambi_LibraryUtilities.internal.nativeId(this), pos, val, type.value());
    }
    
    @QtUninvokable
    private native void bindValue_native_int_cref_QVariant_QSql_ParamType(long __this__nativeId, int pos, java.lang.Object val, int type);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#boundValue">QSqlQuery::<wbr/>boundValue(QString)const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.Object boundValue(java.lang.@NonNull String placeholder){
        return boundValue_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), placeholder);
    }
    
    @QtUninvokable
    private native java.lang.Object boundValue_native_cref_QString_constfct(long __this__nativeId, java.lang.String placeholder);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#boundValue-1">QSqlQuery::<wbr/>boundValue(int)const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.Object boundValue(int pos){
        return boundValue_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), pos);
    }
    
    @QtUninvokable
    private native java.lang.Object boundValue_native_int_constfct(long __this__nativeId, int pos);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#boundValues">QSqlQuery::<wbr/>boundValues()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QMap<java.lang.@NonNull String, java.lang.Object> boundValues(){
        return boundValues_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QMap<java.lang.String, java.lang.Object> boundValues_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#clear">QSqlQuery::<wbr/>clear()</a></code></p>
     */
    @QtUninvokable
    public final void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void clear_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#driver">QSqlQuery::<wbr/>driver()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.sql.@Nullable QSqlDriver driver(){
        return driver_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlDriver driver_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#exec-1">QSqlQuery::<wbr/>exec()</a></code></p>
     */
    @QtUninvokable
    public final boolean exec(){
        return exec_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean exec_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#exec">QSqlQuery::<wbr/>exec(QString)</a></code></p>
     */
    @QtUninvokable
    public final boolean exec(java.lang.@NonNull String query){
        return exec_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), query);
    }
    
    @QtUninvokable
    private native boolean exec_native_cref_QString(long __this__nativeId, java.lang.String query);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#execBatch">QSqlQuery::<wbr/>execBatch(QSqlQuery::BatchExecutionMode)</a></code></p>
     */
    @QtUninvokable
    public final boolean execBatch(io.qt.sql.QSqlQuery.@NonNull BatchExecutionMode mode){
        return execBatch_native_QSqlQuery_BatchExecutionMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    @QtUninvokable
    private native boolean execBatch_native_QSqlQuery_BatchExecutionMode(long __this__nativeId, int mode);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#executedQuery">QSqlQuery::<wbr/>executedQuery()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String executedQuery(){
        return executedQuery_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String executedQuery_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#finish">QSqlQuery::<wbr/>finish()</a></code></p>
     */
    @QtUninvokable
    public final void finish(){
        finish_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void finish_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#first">QSqlQuery::<wbr/>first()</a></code></p>
     */
    @QtUninvokable
    public final boolean first(){
        return first_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean first_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#isActive">QSqlQuery::<wbr/>isActive()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isActive(){
        return isActive_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isActive_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#isForwardOnly">QSqlQuery::<wbr/>isForwardOnly()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isForwardOnly(){
        return isForwardOnly_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isForwardOnly_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#isNull-1">QSqlQuery::<wbr/>isNull(QString)const</a></code></p>
     */
    @QtUninvokable
    public final boolean isNull(java.lang.@NonNull String name){
        return isNull_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native boolean isNull_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#isNull">QSqlQuery::<wbr/>isNull(int)const</a></code></p>
     */
    @QtUninvokable
    public final boolean isNull(int field){
        return isNull_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), field);
    }
    
    @QtUninvokable
    private native boolean isNull_native_int_constfct(long __this__nativeId, int field);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#isSelect">QSqlQuery::<wbr/>isSelect()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isSelect(){
        return isSelect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isSelect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#isValid">QSqlQuery::<wbr/>isValid()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#last">QSqlQuery::<wbr/>last()</a></code></p>
     */
    @QtUninvokable
    public final boolean last(){
        return last_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean last_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#lastError">QSqlQuery::<wbr/>lastError()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.sql.@NonNull QSqlError lastError(){
        return lastError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlError lastError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#lastInsertId">QSqlQuery::<wbr/>lastInsertId()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.Object lastInsertId(){
        return lastInsertId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.Object lastInsertId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#lastQuery">QSqlQuery::<wbr/>lastQuery()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String lastQuery(){
        return lastQuery_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String lastQuery_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#next">QSqlQuery::<wbr/>next()</a></code></p>
     */
    @QtUninvokable
    public final boolean next(){
        return next_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean next_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#nextResult">QSqlQuery::<wbr/>nextResult()</a></code></p>
     */
    @QtUninvokable
    public final boolean nextResult(){
        return nextResult_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean nextResult_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#numRowsAffected">QSqlQuery::<wbr/>numRowsAffected()const</a></code></p>
     */
    @QtUninvokable
    public final int numRowsAffected(){
        return numRowsAffected_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int numRowsAffected_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#numericalPrecisionPolicy">QSqlQuery::<wbr/>numericalPrecisionPolicy()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.sql.QSql.@NonNull NumericalPrecisionPolicy numericalPrecisionPolicy(){
        return io.qt.sql.QSql.NumericalPrecisionPolicy.resolve(numericalPrecisionPolicy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int numericalPrecisionPolicy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#operator-eq">QSqlQuery::<wbr/>operator=(QSqlQuery)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.sql.@NonNull QSqlQuery other){
        assign_native_cref_QSqlQuery(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QSqlQuery(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#prepare">QSqlQuery::<wbr/>prepare(QString)</a></code></p>
     */
    @QtUninvokable
    public final boolean prepare(java.lang.@NonNull String query){
        return prepare_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), query);
    }
    
    @QtUninvokable
    private native boolean prepare_native_cref_QString(long __this__nativeId, java.lang.String query);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#previous">QSqlQuery::<wbr/>previous()</a></code></p>
     */
    @QtUninvokable
    public final boolean previous(){
        return previous_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean previous_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#record">QSqlQuery::<wbr/>record()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.sql.@NonNull QSqlRecord record(){
        return record_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlRecord record_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#result">QSqlQuery::<wbr/>result()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.sql.@Nullable QSqlResult result(){
        return result_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlResult result_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#seek">QSqlQuery::<wbr/>seek(int,<wbr/>bool)</a></code></p>
     */
    @QtUninvokable
    public final boolean seek(int i, boolean relative){
        return seek_native_int_bool(QtJambi_LibraryUtilities.internal.nativeId(this), i, relative);
    }
    
    @QtUninvokable
    private native boolean seek_native_int_bool(long __this__nativeId, int i, boolean relative);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#setForwardOnly">QSqlQuery::<wbr/>setForwardOnly(bool)</a></code></p>
     */
    @QtUninvokable
    public final void setForwardOnly(boolean forward){
        setForwardOnly_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), forward);
    }
    
    @QtUninvokable
    private native void setForwardOnly_native_bool(long __this__nativeId, boolean forward);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#setNumericalPrecisionPolicy">QSqlQuery::<wbr/>setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy)</a></code></p>
     */
    @QtUninvokable
    public final void setNumericalPrecisionPolicy(io.qt.sql.QSql.@NonNull NumericalPrecisionPolicy precisionPolicy){
        setNumericalPrecisionPolicy_native_QSql_NumericalPrecisionPolicy(QtJambi_LibraryUtilities.internal.nativeId(this), precisionPolicy.value());
    }
    
    @QtUninvokable
    private native void setNumericalPrecisionPolicy_native_QSql_NumericalPrecisionPolicy(long __this__nativeId, int precisionPolicy);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#size">QSqlQuery::<wbr/>size()const</a></code></p>
     */
    @QtUninvokable
    public final int size(){
        return size_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int size_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#value-1">QSqlQuery::<wbr/>value(QString)const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.Object value(java.lang.@NonNull String name){
        return value_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native java.lang.Object value_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#value">QSqlQuery::<wbr/>value(int)const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.Object value(int i){
        return value_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), i);
    }
    
    @QtUninvokable
    private native java.lang.Object value_native_int_constfct(long __this__nativeId, int i);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QSqlQuery(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="http://doc.qt.io/qt-5/qsqlquery.html#QSqlQuery-3">QSqlQuery::<wbr/>QSqlQuery(QSqlQuery)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QSqlQuery clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QSqlQuery clone_native(long __this_nativeId);
    
    /**
     * <p>Overloaded constructor for {@link #QSqlQuery(java.lang.String, io.qt.sql.QSqlDatabase)}
     *  with <code>db = new io.qt.sql.QSqlDatabase()</code>.</p>
     */
    public QSqlQuery(java.lang.@NonNull String query) {
        this(query, new io.qt.sql.QSqlDatabase());
    }
    
    /**
     * <p>Overloaded constructor for {@link #QSqlQuery(java.lang.String, io.qt.sql.QSqlDatabase)}</p>
     * <p>with: </p><ul>
     * <li><code>query = (String)null</code></li>
     * <li><code>db = new io.qt.sql.QSqlDatabase()</code></li>
     * </ul>
     */
    public QSqlQuery() {
        this((String)null, new io.qt.sql.QSqlDatabase());
    }
    
    /**
     * <p>Overloaded function for {@link #addBindValue(java.lang.Object, io.qt.sql.QSql.ParamType)}
     *  with <code>type = new io.qt.sql.QSql.ParamType(1)</code>.</p>
     */
    @QtUninvokable
    public final void addBindValue(java.lang.Object val) {
        addBindValue(val, new io.qt.sql.QSql.ParamType(1));
    }
    
    /**
     * <p>Overloaded function for {@link #addBindValue(java.lang.Object, io.qt.sql.QSql.ParamType)}.</p>
     */
    @QtUninvokable
    public final void addBindValue(java.lang.Object val, io.qt.sql.QSql.@NonNull ParamTypeFlag @NonNull... type) {
        addBindValue(val, new io.qt.sql.QSql.ParamType(type));
    }
    
    /**
     * <p>Overloaded function for {@link #bindValue(java.lang.String, java.lang.Object, io.qt.sql.QSql.ParamType)}
     *  with <code>type = new io.qt.sql.QSql.ParamType(1)</code>.</p>
     */
    @QtUninvokable
    public final void bindValue(java.lang.@NonNull String placeholder, java.lang.Object val) {
        bindValue(placeholder, val, new io.qt.sql.QSql.ParamType(1));
    }
    
    /**
     * <p>Overloaded function for {@link #bindValue(java.lang.String, java.lang.Object, io.qt.sql.QSql.ParamType)}.</p>
     */
    @QtUninvokable
    public final void bindValue(java.lang.@NonNull String placeholder, java.lang.Object val, io.qt.sql.QSql.@NonNull ParamTypeFlag @NonNull... type) {
        bindValue(placeholder, val, new io.qt.sql.QSql.ParamType(type));
    }
    
    /**
     * <p>Overloaded function for {@link #bindValue(int, java.lang.Object, io.qt.sql.QSql.ParamType)}
     *  with <code>type = new io.qt.sql.QSql.ParamType(1)</code>.</p>
     */
    @QtUninvokable
    public final void bindValue(int pos, java.lang.Object val) {
        bindValue(pos, val, new io.qt.sql.QSql.ParamType(1));
    }
    
    /**
     * <p>Overloaded function for {@link #bindValue(int, java.lang.Object, io.qt.sql.QSql.ParamType)}.</p>
     */
    @QtUninvokable
    public final void bindValue(int pos, java.lang.Object val, io.qt.sql.QSql.@NonNull ParamTypeFlag @NonNull... type) {
        bindValue(pos, val, new io.qt.sql.QSql.ParamType(type));
    }
    
    /**
     * <p>Overloaded function for {@link #execBatch(io.qt.sql.QSqlQuery.BatchExecutionMode)}
     *  with <code>mode = io.qt.sql.QSqlQuery.BatchExecutionMode.ValuesAsRows</code>.</p>
     */
    @QtUninvokable
    public final boolean execBatch() {
        return execBatch(io.qt.sql.QSqlQuery.BatchExecutionMode.ValuesAsRows);
    }
    
    /**
     * <p>Overloaded function for {@link #seek(int, boolean)}
     *  with <code>relative = false</code>.</p>
     */
    @QtUninvokable
    public final boolean seek(int i) {
        return seek(i, (boolean)false);
    }
}
