package io.qt.sql;

import io.qt.*;


/**
 * <p>Functions to manipulate and describe database indexes</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qsqlindex.html">QSqlIndex</a></code></p>
 */
public class QSqlIndex extends io.qt.sql.QSqlRecord
    implements java.lang.Cloneable
{
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlindex.html#QSqlIndex-1">QSqlIndex::<wbr/>QSqlIndex(QSqlIndex)</a></code></p>
     */
    public QSqlIndex(io.qt.sql.@NonNull QSqlIndex other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QSqlIndex instance, io.qt.sql.QSqlIndex other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlindex.html#QSqlIndex">QSqlIndex::<wbr/>QSqlIndex(QString,<wbr/>QString)</a></code></p>
     */
    public QSqlIndex(java.lang.@NonNull String cursorName, java.lang.@NonNull String name){
        super((QPrivateConstructor)null);
        initialize_native(this, cursorName, name);
    }
    
    private native static void initialize_native(QSqlIndex instance, java.lang.String cursorName, java.lang.String name);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlrecord.html#append">QSqlRecord::<wbr/>append(QSqlField)</a></code></p>
     */
    @QtUninvokable
    public final void append(io.qt.sql.@NonNull QSqlField field){
        append_native_cref_QSqlField(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(field));
    }
    
    @QtUninvokable
    private native void append_native_cref_QSqlField(long __this__nativeId, long field);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlindex.html#append-1">QSqlIndex::<wbr/>append(QSqlField,<wbr/>bool)</a></code></p>
     */
    @QtUninvokable
    public final void append(io.qt.sql.@NonNull QSqlField field, boolean desc){
        append_native_cref_QSqlField_bool(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(field), desc);
    }
    
    @QtUninvokable
    private native void append_native_cref_QSqlField_bool(long __this__nativeId, long field, boolean desc);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlindex.html#cursorName">QSqlIndex::<wbr/>cursorName()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String cursorName(){
        return cursorName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String cursorName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlindex.html#isDescending">QSqlIndex::<wbr/>isDescending(int)const</a></code></p>
     */
    @QtUninvokable
    public final boolean isDescending(int i){
        return isDescending_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), i);
    }
    
    @QtUninvokable
    private native boolean isDescending_native_int_constfct(long __this__nativeId, int i);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlindex.html#name">QSqlIndex::<wbr/>name()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlindex.html#operator-eq">QSqlIndex::<wbr/>operator=(QSqlIndex)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.sql.@NonNull QSqlIndex other){
        assign_native_cref_QSqlIndex(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QSqlIndex(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlindex.html#setCursorName">QSqlIndex::<wbr/>setCursorName(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setCursorName(java.lang.@NonNull String cursorName){
        setCursorName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), cursorName);
    }
    
    @QtUninvokable
    private native void setCursorName_native_cref_QString(long __this__nativeId, java.lang.String cursorName);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlindex.html#setDescending">QSqlIndex::<wbr/>setDescending(int,<wbr/>bool)</a></code></p>
     */
    @QtUninvokable
    public final void setDescending(int i, boolean desc){
        setDescending_native_int_bool(QtJambi_LibraryUtilities.internal.nativeId(this), i, desc);
    }
    
    @QtUninvokable
    private native void setDescending_native_int_bool(long __this__nativeId, int i, boolean desc);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqlindex.html#setName">QSqlIndex::<wbr/>setName(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setName(java.lang.@NonNull String name){
        setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void setName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QSqlIndex(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="http://doc.qt.io/qt-5/qsqlindex.html#QSqlIndex-1">QSqlIndex::<wbr/>QSqlIndex(QSqlIndex)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QSqlIndex clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QSqlIndex clone_native(long __this_nativeId);
    
    /**
     * <p>Overloaded constructor for {@link #QSqlIndex(java.lang.String, java.lang.String)}
     *  with <code>name = (String)null</code>.</p>
     */
    public QSqlIndex(java.lang.@NonNull String cursorName) {
        this(cursorName, (String)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QSqlIndex(java.lang.String, java.lang.String)}</p>
     * <p>with: </p><ul>
     * <li><code>cursorName = (String)null</code></li>
     * <li><code>name = (String)null</code></li>
     * </ul>
     */
    public QSqlIndex() {
        this((String)null, (String)null);
    }
}
