package io.qt.sql;

import io.qt.*;


/**
 * <p>Abstract base class for accessing specific SQL databases</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qsqldriver.html">QSqlDriver</a></code></p>
 */
public abstract class QSqlDriver extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSqlDriver.class);
    
    @NativeAccess
    private static final class ConcreteWrapper extends QSqlDriver {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        public void close(){
            close_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native void close_native(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public io.qt.sql.@Nullable QSqlResult createResult(){
            return createResult_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native io.qt.sql.QSqlResult createResult_native_constfct(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public boolean hasFeature(io.qt.sql.QSqlDriver.@NonNull DriverFeature f){
            return hasFeature_native_QSqlDriver_DriverFeature_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), f.value());
        }
        @QtUninvokable
        private native boolean hasFeature_native_QSqlDriver_DriverFeature_constfct(long __this__nativeId, int f);
        
        
        @Override
        @QtUninvokable
        public boolean open(java.lang.@NonNull String db, java.lang.@NonNull String user, java.lang.@NonNull String password, java.lang.@NonNull String host, int port, java.lang.@NonNull String connOpts){
            return open_native_cref_QString_cref_QString_cref_QString_cref_QString_int_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), db, user, password, host, port, connOpts);
        }
        @QtUninvokable
        private native boolean open_native_cref_QString_cref_QString_cref_QString_cref_QString_int_cref_QString(long __this__nativeId, java.lang.String db, java.lang.String user, java.lang.String password, java.lang.String host, int port, java.lang.String connOpts);
        
    }
    
    /**
     * <p>Java wrapper for Qt enum <code>QSqlDriver::DbmsType</code></p>
     */
    @QtUnlistedEnum
    public enum DbmsType implements QtEnumerator {
        /**
         * <p>Representing <code>QSqlDriver::<wbr/>UnknownDbms</code></p>
         */
        UnknownDbms(0),
        /**
         * <p>Representing <code>QSqlDriver::<wbr/>MSSqlServer</code></p>
         */
        MSSqlServer(1),
        /**
         * <p>Representing <code>QSqlDriver::<wbr/>MySqlServer</code></p>
         */
        MySqlServer(2),
        /**
         * <p>Representing <code>QSqlDriver::<wbr/>PostgreSQL</code></p>
         */
        PostgreSQL(3),
        /**
         * <p>Representing <code>QSqlDriver::<wbr/>Oracle</code></p>
         */
        Oracle(4),
        /**
         * <p>Representing <code>QSqlDriver::<wbr/>Sybase</code></p>
         */
        Sybase(5),
        /**
         * <p>Representing <code>QSqlDriver::<wbr/>SQLite</code></p>
         */
        SQLite(6),
        /**
         * <p>Representing <code>QSqlDriver::<wbr/>Interbase</code></p>
         */
        Interbase(7),
        /**
         * <p>Representing <code>QSqlDriver::<wbr/>DB2</code></p>
         */
        DB2(8);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DbmsType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull DbmsType resolve(int value) {
            switch (value) {
            case 0: return UnknownDbms;
            case 1: return MSSqlServer;
            case 2: return MySqlServer;
            case 3: return PostgreSQL;
            case 4: return Oracle;
            case 5: return Sybase;
            case 6: return SQLite;
            case 7: return Interbase;
            case 8: return DB2;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#DriverFeature-enum">QSqlDriver::DriverFeature</a></code></p>
     */
    @QtUnlistedEnum
    public enum DriverFeature implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#DriverFeature-enum">QSqlDriver::<wbr/>Transactions</a></code></p>
         */
        Transactions(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#DriverFeature-enum">QSqlDriver::<wbr/>QuerySize</a></code></p>
         */
        QuerySize(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#DriverFeature-enum">QSqlDriver::<wbr/>BLOB</a></code></p>
         */
        BLOB(2),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#DriverFeature-enum">QSqlDriver::<wbr/>Unicode</a></code></p>
         */
        Unicode(3),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#DriverFeature-enum">QSqlDriver::<wbr/>PreparedQueries</a></code></p>
         */
        PreparedQueries(4),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#DriverFeature-enum">QSqlDriver::<wbr/>NamedPlaceholders</a></code></p>
         */
        NamedPlaceholders(5),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#DriverFeature-enum">QSqlDriver::<wbr/>PositionalPlaceholders</a></code></p>
         */
        PositionalPlaceholders(6),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#DriverFeature-enum">QSqlDriver::<wbr/>LastInsertId</a></code></p>
         */
        LastInsertId(7),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#DriverFeature-enum">QSqlDriver::<wbr/>BatchOperations</a></code></p>
         */
        BatchOperations(8),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#DriverFeature-enum">QSqlDriver::<wbr/>SimpleLocking</a></code></p>
         */
        SimpleLocking(9),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#DriverFeature-enum">QSqlDriver::<wbr/>LowPrecisionNumbers</a></code></p>
         */
        LowPrecisionNumbers(10),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#DriverFeature-enum">QSqlDriver::<wbr/>EventNotifications</a></code></p>
         */
        EventNotifications(11),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#DriverFeature-enum">QSqlDriver::<wbr/>FinishQuery</a></code></p>
         */
        FinishQuery(12),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#DriverFeature-enum">QSqlDriver::<wbr/>MultipleResultSets</a></code></p>
         */
        MultipleResultSets(13),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#DriverFeature-enum">QSqlDriver::<wbr/>CancelQuery</a></code></p>
         */
        CancelQuery(14);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DriverFeature(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull DriverFeature resolve(int value) {
            switch (value) {
            case 0: return Transactions;
            case 1: return QuerySize;
            case 2: return BLOB;
            case 3: return Unicode;
            case 4: return PreparedQueries;
            case 5: return NamedPlaceholders;
            case 6: return PositionalPlaceholders;
            case 7: return LastInsertId;
            case 8: return BatchOperations;
            case 9: return SimpleLocking;
            case 10: return LowPrecisionNumbers;
            case 11: return EventNotifications;
            case 12: return FinishQuery;
            case 13: return MultipleResultSets;
            case 14: return CancelQuery;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#IdentifierType-enum">QSqlDriver::IdentifierType</a></code></p>
     */
    @QtUnlistedEnum
    public enum IdentifierType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#IdentifierType-enum">QSqlDriver::<wbr/>FieldName</a></code></p>
         */
        FieldName(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#IdentifierType-enum">QSqlDriver::<wbr/>TableName</a></code></p>
         */
        TableName(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private IdentifierType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull IdentifierType resolve(int value) {
            switch (value) {
            case 0: return FieldName;
            case 1: return TableName;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#NotificationSource-enum">QSqlDriver::NotificationSource</a></code></p>
     */
    @QtUnlistedEnum
    public enum NotificationSource implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#NotificationSource-enum">QSqlDriver::<wbr/>UnknownSource</a></code></p>
         */
        UnknownSource(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#NotificationSource-enum">QSqlDriver::<wbr/>SelfSource</a></code></p>
         */
        SelfSource(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#NotificationSource-enum">QSqlDriver::<wbr/>OtherSource</a></code></p>
         */
        OtherSource(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private NotificationSource(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull NotificationSource resolve(int value) {
            switch (value) {
            case 0: return UnknownSource;
            case 1: return SelfSource;
            case 2: return OtherSource;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#StatementType-enum">QSqlDriver::StatementType</a></code></p>
     */
    @QtUnlistedEnum
    public enum StatementType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#StatementType-enum">QSqlDriver::<wbr/>WhereStatement</a></code></p>
         */
        WhereStatement(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#StatementType-enum">QSqlDriver::<wbr/>SelectStatement</a></code></p>
         */
        SelectStatement(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#StatementType-enum">QSqlDriver::<wbr/>UpdateStatement</a></code></p>
         */
        UpdateStatement(2),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#StatementType-enum">QSqlDriver::<wbr/>InsertStatement</a></code></p>
         */
        InsertStatement(3),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#StatementType-enum">QSqlDriver::<wbr/>DeleteStatement</a></code></p>
         */
        DeleteStatement(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private StatementType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull StatementType resolve(int value) {
            switch (value) {
            case 0: return WhereStatement;
            case 1: return SelectStatement;
            case 2: return UpdateStatement;
            case 3: return InsertStatement;
            case 4: return DeleteStatement;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>Wrapper class for overloaded signals:</p>
     * <ul>
     * <li><code>notification(const QString &amp; name)</code></li>
     * <li><code>notification(const QString &amp; name, QSqlDriver::NotificationSource source, const QVariant &amp; payload)</code></li>
     * </ul>
     */
    public final class MultiSignal_notification extends MultiSignal{
        private MultiSignal_notification(){
            super();
        }

        /**
         * <p>Provides an overloaded signal by parameter type.</p>
         * <p>The only valid call is <code>notification.overload(java.lang.String.class)</code></p>
         * <p>{@link QNoSuchSignalException} is thrown otherwise.</p>

         * @param <A> signal parameter type
         * @param type1 value of type A
         * @return overloaded signal
         * @throws QNoSuchSignalException if signal is not available
         */
        @QtAllowedTypeSet({java.lang.String.class})
        public final <A> Signal1<A> overload(Class<A> type1) throws QNoSuchSignalException{
            return (Signal1<A>)super.overload(type1);
        }

        /**
         * Initializes a connection to the <i>slot</i>.
         * 
         * @param slot the slot to be connected
         * @param connectionType type of connection
         * @return connection if successful or <code>null</code> otherwise
         * @throws QMisfittingSignatureException Raised if their signatures are incompatible.
         */
        public final <A> io.qt.core.QMetaObject.@NonNull Connection connect(io.qt.core.QMetaObject.@StrictNonNull Slot1<A> slot, io.qt.core.Qt.@NonNull ConnectionType @NonNull... connectionType) throws QNoSuchSignalException{
            return super.connect(slot, connectionType);
        }

        /**
         * Removes the connection to the given <i>slot</i>.
         * 
         * @param slot the slot to be disconnected
         * @return <code>true</code> if successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A> boolean disconnect(io.qt.core.QMetaObject.@StrictNonNull Slot1<A> slot) {
            return super.disconnect(slot);
        }

        /**
         * Creates a connection from this signal to another. Whenever this signal is emitted, it will cause the second
         * signal to be emitted as well.
         * 
         * @param signal The second signal. This will be emitted whenever this signal is emitted.
         * @param connectionType One of the connection types defined in the Qt interface.
         * @return connection if successful or <code>null</code> otherwise
         * @throws QMisfittingSignatureException Raised if their signatures are incompatible.
         */
        public final <A> io.qt.core.QMetaObject.@NonNull Connection connect(io.qt.core.QMetaObject.@StrictNonNull Connectable1<A> signal, io.qt.core.Qt.@NonNull ConnectionType @NonNull... connectionType) throws QNoSuchSignalException{
            return super.connect((io.qt.core.QMetaObject.AbstractSignal)signal, connectionType);
        }

        /**
         * Disconnects a signal from another signal if the two were previously connected by a call to connect.
         * A call to this function will assure that the emission of the first signal will not cause the emission of the second.
         * 
         * @param signal The second signal.
         * @return <code>true</code> if the two signals were successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A> boolean disconnect(io.qt.core.QMetaObject.@StrictNonNull Connectable1<A> signal) {
            return super.disconnect((io.qt.core.QMetaObject.AbstractSignal)signal);
        }

        /**
         * Creates a connection from this signal to another. Whenever this signal is emitted, it will cause the second
         * signal to be emitted as well.
         * 
         * @param signal The second signal. This will be emitted whenever this signal is emitted.
         * @param connectionType One of the connection types defined in the Qt interface.
         * @return connection if successful or <code>null</code> otherwise
         * @throws QMisfittingSignatureException Raised if their signatures are incompatible.
         */
        public final <A> io.qt.core.QMetaObject.@NonNull Connection connect(io.qt.core.QMetaObject.@StrictNonNull AbstractPublicSignal1<A> signal, io.qt.core.Qt.@NonNull ConnectionType @NonNull... connectionType) throws QNoSuchSignalException{
            return super.connect((io.qt.core.QMetaObject.AbstractSignal)signal, connectionType);
        }

        /**
         * Disconnects a signal from another signal if the two were previously connected by a call to connect.
         * A call to this function will assure that the emission of the first signal will not cause the emission of the second.
         * 
         * @param signal The second signal.
         * @return <code>true</code> if the two signals were successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A> boolean disconnect(io.qt.core.QMetaObject.@StrictNonNull AbstractPublicSignal1<A> signal) {
            return super.disconnect((io.qt.core.QMetaObject.AbstractSignal)signal);
        }

        /**
         * <p>Provides an overloaded signal by parameter types.</p>
         * <p>The only valid call is <code>notification.overload(java.lang.String.class, io.qt.sql.QSqlDriver.NotificationSource.class, java.lang.Object.class)</code></p>
         * <p>{@link QNoSuchSignalException} is thrown otherwise.</p>

         * @param <A> signal parameter type
         * @param <B> signal parameter type
         * @param <C> signal parameter type
         * @param type1 value of type A
         * @param type2 value of type B
         * @param type3 value of type C
         * @return overloaded signal
         * @throws QNoSuchSignalException if signal is not available
         */
        @QtAllowedTypeSet({java.lang.String.class, io.qt.sql.QSqlDriver.NotificationSource.class, java.lang.Object.class})
        public final <A,B,C> Signal3<A,B,C> overload(Class<A> type1, Class<B> type2, Class<C> type3) throws QNoSuchSignalException{
            return (Signal3<A,B,C>)super.overload(type1, type2, type3);
        }

        /**
         * Initializes a connection to the <i>slot</i>.
         * 
         * @param slot the slot to be connected
         * @param connectionType type of connection
         * @return connection if successful or <code>null</code> otherwise
         * @throws QMisfittingSignatureException Raised if their signatures are incompatible.
         */
        public final <A,B,C> io.qt.core.QMetaObject.@NonNull Connection connect(io.qt.core.QMetaObject.@StrictNonNull Slot3<A,B,C> slot, io.qt.core.Qt.@NonNull ConnectionType @NonNull... connectionType) throws QNoSuchSignalException{
            return super.connect(slot, connectionType);
        }

        /**
         * Removes the connection to the given <i>slot</i>.
         * 
         * @param slot the slot to be disconnected
         * @return <code>true</code> if successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A,B,C> boolean disconnect(io.qt.core.QMetaObject.@StrictNonNull Slot3<A,B,C> slot) {
            return super.disconnect(slot);
        }

        /**
         * Creates a connection from this signal to another. Whenever this signal is emitted, it will cause the second
         * signal to be emitted as well.
         * 
         * @param signal The second signal. This will be emitted whenever this signal is emitted.
         * @param connectionType One of the connection types defined in the Qt interface.
         * @return connection if successful or <code>null</code> otherwise
         * @throws QMisfittingSignatureException Raised if their signatures are incompatible.
         */
        public final <A,B,C> io.qt.core.QMetaObject.@NonNull Connection connect(io.qt.core.QMetaObject.@StrictNonNull Connectable3<A,B,C> signal, io.qt.core.Qt.@NonNull ConnectionType @NonNull... connectionType) throws QNoSuchSignalException{
            return super.connect((io.qt.core.QMetaObject.AbstractSignal)signal, connectionType);
        }

        /**
         * Disconnects a signal from another signal if the two were previously connected by a call to connect.
         * A call to this function will assure that the emission of the first signal will not cause the emission of the second.
         * 
         * @param signal The second signal.
         * @return <code>true</code> if the two signals were successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A,B,C> boolean disconnect(io.qt.core.QMetaObject.@StrictNonNull Connectable3<A,B,C> signal) {
            return super.disconnect((io.qt.core.QMetaObject.AbstractSignal)signal);
        }

        /**
         * Creates a connection from this signal to another. Whenever this signal is emitted, it will cause the second
         * signal to be emitted as well.
         * 
         * @param signal The second signal. This will be emitted whenever this signal is emitted.
         * @param connectionType One of the connection types defined in the Qt interface.
         * @return connection if successful or <code>null</code> otherwise
         * @throws QMisfittingSignatureException Raised if their signatures are incompatible.
         */
        public final <A,B,C> io.qt.core.QMetaObject.@NonNull Connection connect(io.qt.core.QMetaObject.@StrictNonNull AbstractPublicSignal3<A,B,C> signal, io.qt.core.Qt.@NonNull ConnectionType @NonNull... connectionType) throws QNoSuchSignalException{
            return super.connect((io.qt.core.QMetaObject.AbstractSignal)signal, connectionType);
        }

        /**
         * Disconnects a signal from another signal if the two were previously connected by a call to connect.
         * A call to this function will assure that the emission of the first signal will not cause the emission of the second.
         * 
         * @param signal The second signal.
         * @return <code>true</code> if the two signals were successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A,B,C> boolean disconnect(io.qt.core.QMetaObject.@StrictNonNull AbstractPublicSignal3<A,B,C> signal) {
            return super.disconnect((io.qt.core.QMetaObject.AbstractSignal)signal);
        }

        /**
         * Initializes a connection to the <i>slot</i>.
         * 
         * @param slot the slot to be connected
         * @param connectionType type of connection
         * @return connection if successful or <code>null</code> otherwise
         * @throws QMisfittingSignatureException Raised if their signatures are incompatible.
         */
        public final <A,B> io.qt.core.QMetaObject.@NonNull Connection connect(io.qt.core.QMetaObject.Slot2<A,B> slot, io.qt.core.Qt.@NonNull ConnectionType @NonNull... connectionType) throws QNoSuchSignalException{
            return super.connect(slot, connectionType);
        }

        /**
         * Removes the connection to the given <i>slot</i>.
         * 
         * @param slot the slot to be disconnected
         * @return <code>true</code> if successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A,B> boolean disconnect(io.qt.core.QMetaObject.Slot2<A,B> slot) {
            return super.disconnect(slot);
        }

        /**
         * Creates a connection from this signal to another. Whenever this signal is emitted, it will cause the second
         * signal to be emitted as well.
         * 
         * @param signal The second signal. This will be emitted whenever this signal is emitted.
         * @param connectionType One of the connection types defined in the Qt interface.
         * @return connection if successful or <code>null</code> otherwise
         * @throws QMisfittingSignatureException Raised if their signatures are incompatible.
         */
        public final <A,B> io.qt.core.QMetaObject.@NonNull Connection connect(io.qt.core.QMetaObject.AbstractPublicSignal2<A,B> signal, io.qt.core.Qt.@NonNull ConnectionType @NonNull... connectionType) throws QNoSuchSignalException{
            return super.connect((io.qt.core.QMetaObject.AbstractSignal)signal, connectionType);
        }

        /**
         * Disconnects a signal from another signal if the two were previously connected by a call to connect.
         * A call to this function will assure that the emission of the first signal will not cause the emission of the second.
         * 
         * @param signal The second signal.
         * @return <code>true</code> if the two signals were successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A,B> boolean disconnect(io.qt.core.QMetaObject.AbstractPublicSignal2<A,B> signal) {
            return super.disconnect((io.qt.core.QMetaObject.AbstractSignal)signal);
        }

        /**
         * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver-obsolete.html#notification">QSqlDriver::<wbr/>notification(QString)</a></code></p>
         * 
         */
        public final void emit(java.lang.@NonNull String name) {
            ((Signal1<java.lang.@NonNull String>)overload(java.lang.String.class)).emit(name);
        }

        /**
         * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#notification-1">QSqlDriver::<wbr/>notification(QString,<wbr/>QSqlDriver::NotificationSource,<wbr/>QVariant)</a></code></p>
         * 
         */
        public final void emit(java.lang.@NonNull String name, io.qt.sql.QSqlDriver.@NonNull NotificationSource source, java.lang.Object payload) {
            ((Signal3<java.lang.@NonNull String, io.qt.sql.QSqlDriver.@NonNull NotificationSource, java.lang.Object>)overload(java.lang.String.class, io.qt.sql.QSqlDriver.NotificationSource.class, java.lang.Object.class)).emit(name, source, payload);
        }

    };


    /**
     * <p>Overloaded signals:</p>
     * <ul>
     * <li><code>notification(QString)</code></li>
     * <li><code>notification(QString,<wbr/>QSqlDriver::NotificationSource,<wbr/>QVariant)</code></li>
     * </ul>
     */
    public final @NonNull MultiSignal_notification notification = new MultiSignal_notification();

    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#QSqlDriver">QSqlDriver::<wbr/>QSqlDriver(QObject*)</a></code></p>
     */
    public QSqlDriver(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QSqlDriver instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code>QSqlDriver::<wbr/>dbmsType()const</code></p>
     */
    @QtUninvokable
    public final io.qt.sql.QSqlDriver.@NonNull DbmsType dbmsType(){
        return io.qt.sql.QSqlDriver.DbmsType.resolve(dbmsType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int dbmsType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#isOpenError">QSqlDriver::<wbr/>isOpenError()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isOpenError(){
        return isOpenError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isOpenError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#lastError">QSqlDriver::<wbr/>lastError()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.sql.@NonNull QSqlError lastError(){
        return lastError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlError lastError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#numericalPrecisionPolicy">QSqlDriver::<wbr/>numericalPrecisionPolicy()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.sql.QSql.@NonNull NumericalPrecisionPolicy numericalPrecisionPolicy(){
        return io.qt.sql.QSql.NumericalPrecisionPolicy.resolve(numericalPrecisionPolicy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int numericalPrecisionPolicy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#setNumericalPrecisionPolicy">QSqlDriver::<wbr/>setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy)</a></code></p>
     */
    @QtUninvokable
    public final void setNumericalPrecisionPolicy(io.qt.sql.QSql.@NonNull NumericalPrecisionPolicy precisionPolicy){
        setNumericalPrecisionPolicy_native_QSql_NumericalPrecisionPolicy(QtJambi_LibraryUtilities.internal.nativeId(this), precisionPolicy.value());
    }
    
    @QtUninvokable
    private native void setNumericalPrecisionPolicy_native_QSql_NumericalPrecisionPolicy(long __this__nativeId, int precisionPolicy);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#beginTransaction">QSqlDriver::<wbr/>beginTransaction()</a></code></p>
     */
    @QtUninvokable
    public boolean beginTransaction(){
        return beginTransaction_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean beginTransaction_native(long __this__nativeId);
    
    /**
     * <p>See <code>QSqlDriver::<wbr/>cancelQuery()</code></p>
     */
    public boolean cancelQuery(){
        return cancelQuery_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native boolean cancelQuery_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#close">QSqlDriver::<wbr/>close()</a></code></p>
     */
    @QtUninvokable
    public abstract void close();
    
    @QtUninvokable
    private native void close_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#commitTransaction">QSqlDriver::<wbr/>commitTransaction()</a></code></p>
     */
    @QtUninvokable
    public boolean commitTransaction(){
        return commitTransaction_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean commitTransaction_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#createResult">QSqlDriver::<wbr/>createResult()const</a></code></p>
     */
    @QtUninvokable
    public abstract io.qt.sql.@Nullable QSqlResult createResult();
    
    @QtUninvokable
    private native io.qt.sql.QSqlResult createResult_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#escapeIdentifier">QSqlDriver::<wbr/>escapeIdentifier(QString,<wbr/>QSqlDriver::IdentifierType)const</a></code></p>
     */
    @QtUninvokable
    public java.lang.@NonNull String escapeIdentifier(java.lang.@NonNull String identifier, io.qt.sql.QSqlDriver.@NonNull IdentifierType type){
        return escapeIdentifier_native_cref_QString_QSqlDriver_IdentifierType_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), identifier, type.value());
    }
    
    @QtUninvokable
    private native java.lang.String escapeIdentifier_native_cref_QString_QSqlDriver_IdentifierType_constfct(long __this__nativeId, java.lang.String identifier, int type);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#formatValue">QSqlDriver::<wbr/>formatValue(QSqlField,<wbr/>bool)const</a></code></p>
     */
    @QtUninvokable
    public java.lang.@NonNull String formatValue(io.qt.sql.@NonNull QSqlField field, boolean trimStrings){
        return formatValue_native_cref_QSqlField_bool_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(field), trimStrings);
    }
    
    @QtUninvokable
    private native java.lang.String formatValue_native_cref_QSqlField_bool_constfct(long __this__nativeId, long field, boolean trimStrings);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#handle">QSqlDriver::<wbr/>handle()const</a></code></p>
     */
    @QtUninvokable
    public java.lang.Object handle(){
        return handle_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.Object handle_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#hasFeature">QSqlDriver::<wbr/>hasFeature(QSqlDriver::DriverFeature)const</a></code></p>
     */
    @QtUninvokable
    public abstract boolean hasFeature(io.qt.sql.QSqlDriver.@NonNull DriverFeature f);
    
    @QtUninvokable
    private native boolean hasFeature_native_QSqlDriver_DriverFeature_constfct(long __this__nativeId, int f);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#isIdentifierEscaped">QSqlDriver::<wbr/>isIdentifierEscaped(QString,<wbr/>QSqlDriver::IdentifierType)const</a></code></p>
     */
    @QtUninvokable
    public boolean isIdentifierEscaped(java.lang.@NonNull String identifier, io.qt.sql.QSqlDriver.@NonNull IdentifierType type){
        return isIdentifierEscaped_native_cref_QString_QSqlDriver_IdentifierType_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), identifier, type.value());
    }
    
    @QtUninvokable
    private native boolean isIdentifierEscaped_native_cref_QString_QSqlDriver_IdentifierType_constfct(long __this__nativeId, java.lang.String identifier, int type);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#isOpen">QSqlDriver::<wbr/>isOpen()const</a></code></p>
     */
    @QtUninvokable
    public boolean isOpen(){
        return isOpen_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isOpen_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#open">QSqlDriver::<wbr/>open(QString,<wbr/>QString,<wbr/>QString,<wbr/>QString,<wbr/>int,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    public abstract boolean open(java.lang.@NonNull String db, java.lang.@NonNull String user, java.lang.@NonNull String password, java.lang.@NonNull String host, int port, java.lang.@NonNull String connOpts);
    
    @QtUninvokable
    private native boolean open_native_cref_QString_cref_QString_cref_QString_cref_QString_int_cref_QString(long __this__nativeId, java.lang.String db, java.lang.String user, java.lang.String password, java.lang.String host, int port, java.lang.String connOpts);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#primaryIndex">QSqlDriver::<wbr/>primaryIndex(QString)const</a></code></p>
     */
    @QtUninvokable
    public io.qt.sql.@NonNull QSqlIndex primaryIndex(java.lang.@NonNull String tableName){
        return primaryIndex_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), tableName);
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlIndex primaryIndex_native_cref_QString_constfct(long __this__nativeId, java.lang.String tableName);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#record">QSqlDriver::<wbr/>record(QString)const</a></code></p>
     */
    @QtUninvokable
    public io.qt.sql.@NonNull QSqlRecord record(java.lang.@NonNull String tableName){
        return record_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), tableName);
    }
    
    @QtUninvokable
    private native io.qt.sql.QSqlRecord record_native_cref_QString_constfct(long __this__nativeId, java.lang.String tableName);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#rollbackTransaction">QSqlDriver::<wbr/>rollbackTransaction()</a></code></p>
     */
    @QtUninvokable
    public boolean rollbackTransaction(){
        return rollbackTransaction_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean rollbackTransaction_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#setLastError">QSqlDriver::<wbr/>setLastError(QSqlError)</a></code></p>
     */
    @QtUninvokable
    protected void setLastError(io.qt.sql.@NonNull QSqlError e){
        setLastError_native_cref_QSqlError(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @QtUninvokable
    private native void setLastError_native_cref_QSqlError(long __this__nativeId, long e);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#setOpen">QSqlDriver::<wbr/>setOpen(bool)</a></code></p>
     */
    @QtUninvokable
    protected void setOpen(boolean o){
        setOpen_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), o);
    }
    
    @QtUninvokable
    private native void setOpen_native_bool(long __this__nativeId, boolean o);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#setOpenError">QSqlDriver::<wbr/>setOpenError(bool)</a></code></p>
     */
    @QtUninvokable
    protected void setOpenError(boolean e){
        setOpenError_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), e);
    }
    
    @QtUninvokable
    private native void setOpenError_native_bool(long __this__nativeId, boolean e);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#sqlStatement">QSqlDriver::<wbr/>sqlStatement(QSqlDriver::StatementType,<wbr/>QString,<wbr/>QSqlRecord,<wbr/>bool)const</a></code></p>
     */
    @QtUninvokable
    public java.lang.@NonNull String sqlStatement(io.qt.sql.QSqlDriver.@NonNull StatementType type, java.lang.@NonNull String tableName, io.qt.sql.@NonNull QSqlRecord rec, boolean preparedStatement){
        return sqlStatement_native_QSqlDriver_StatementType_cref_QString_cref_QSqlRecord_bool_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), tableName, QtJambi_LibraryUtilities.internal.checkedNativeId(rec), preparedStatement);
    }
    
    @QtUninvokable
    private native java.lang.String sqlStatement_native_QSqlDriver_StatementType_cref_QString_cref_QSqlRecord_bool_constfct(long __this__nativeId, int type, java.lang.String tableName, long rec, boolean preparedStatement);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#stripDelimiters">QSqlDriver::<wbr/>stripDelimiters(QString,<wbr/>QSqlDriver::IdentifierType)const</a></code></p>
     */
    @QtUninvokable
    public java.lang.@NonNull String stripDelimiters(java.lang.@NonNull String identifier, io.qt.sql.QSqlDriver.@NonNull IdentifierType type){
        return stripDelimiters_native_cref_QString_QSqlDriver_IdentifierType_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), identifier, type.value());
    }
    
    @QtUninvokable
    private native java.lang.String stripDelimiters_native_cref_QString_QSqlDriver_IdentifierType_constfct(long __this__nativeId, java.lang.String identifier, int type);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#subscribeToNotification">QSqlDriver::<wbr/>subscribeToNotification(QString)</a></code></p>
     */
    @QtUninvokable
    public boolean subscribeToNotification(java.lang.@NonNull String name){
        return subscribeToNotification_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native boolean subscribeToNotification_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#subscribedToNotifications">QSqlDriver::<wbr/>subscribedToNotifications()const</a></code></p>
     */
    @QtUninvokable
    public java.util.@NonNull List<java.lang.@NonNull String> subscribedToNotifications(){
        return subscribedToNotifications_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.util.List<java.lang.String> subscribedToNotifications_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#tables">QSqlDriver::<wbr/>tables(QSql::TableType)const</a></code></p>
     */
    @QtUninvokable
    public java.util.@NonNull List<java.lang.@NonNull String> tables(io.qt.sql.QSql.@NonNull TableType tableType){
        return tables_native_QSql_TableType_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), tableType.value());
    }
    
    @QtUninvokable
    private native java.util.List<java.lang.String> tables_native_QSql_TableType_constfct(long __this__nativeId, int tableType);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsqldriver.html#unsubscribeFromNotification">QSqlDriver::<wbr/>unsubscribeFromNotification(QString)</a></code></p>
     */
    @QtUninvokable
    public boolean unsubscribeFromNotification(java.lang.@NonNull String name){
        return unsubscribeFromNotification_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native boolean unsubscribeFromNotification_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QSqlDriver(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QSqlDriver(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QSqlDriver instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QSqlDriver(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QSqlDriver() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded function for {@link #formatValue(io.qt.sql.QSqlField, boolean)}
     *  with <code>trimStrings = false</code>.</p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String formatValue(io.qt.sql.@NonNull QSqlField field) {
        return formatValue(field, (boolean)false);
    }
    
    /**
     * <p>Overloaded function for {@link #open(java.lang.String, java.lang.String, java.lang.String, java.lang.String, int, java.lang.String)}
     *  with <code>connOpts = (String)null</code>.</p>
     */
    @QtUninvokable
    public final boolean open(java.lang.@NonNull String db, java.lang.@NonNull String user, java.lang.@NonNull String password, java.lang.@NonNull String host, int port) {
        return open(db, user, password, host, port, (String)null);
    }
    
    /**
     * <p>Overloaded function for {@link #open(java.lang.String, java.lang.String, java.lang.String, java.lang.String, int, java.lang.String)}</p>
     * <p>with: </p><ul>
     * <li><code>port = -1</code></li>
     * <li><code>connOpts = (String)null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final boolean open(java.lang.@NonNull String db, java.lang.@NonNull String user, java.lang.@NonNull String password, java.lang.@NonNull String host) {
        return open(db, user, password, host, (int)-1, (String)null);
    }
    
    /**
     * <p>Overloaded function for {@link #open(java.lang.String, java.lang.String, java.lang.String, java.lang.String, int, java.lang.String)}</p>
     * <p>with: </p><ul>
     * <li><code>host = (String)null</code></li>
     * <li><code>port = -1</code></li>
     * <li><code>connOpts = (String)null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final boolean open(java.lang.@NonNull String db, java.lang.@NonNull String user, java.lang.@NonNull String password) {
        return open(db, user, password, (String)null, (int)-1, (String)null);
    }
    
    /**
     * <p>Overloaded function for {@link #open(java.lang.String, java.lang.String, java.lang.String, java.lang.String, int, java.lang.String)}</p>
     * <p>with: </p><ul>
     * <li><code>password = (String)null</code></li>
     * <li><code>host = (String)null</code></li>
     * <li><code>port = -1</code></li>
     * <li><code>connOpts = (String)null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final boolean open(java.lang.@NonNull String db, java.lang.@NonNull String user) {
        return open(db, user, (String)null, (String)null, (int)-1, (String)null);
    }
    
    /**
     * <p>Overloaded function for {@link #open(java.lang.String, java.lang.String, java.lang.String, java.lang.String, int, java.lang.String)}</p>
     * <p>with: </p><ul>
     * <li><code>user = (String)null</code></li>
     * <li><code>password = (String)null</code></li>
     * <li><code>host = (String)null</code></li>
     * <li><code>port = -1</code></li>
     * <li><code>connOpts = (String)null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final boolean open(java.lang.@NonNull String db) {
        return open(db, (String)null, (String)null, (String)null, (int)-1, (String)null);
    }
    
    /**
     * <p>Overloaded function for {@link #setLastError(io.qt.sql.QSqlError)}.</p>
     */
    @QtUninvokable
    protected final void setLastError(java.lang.@NonNull String e) {
        setLastError(new io.qt.sql.QSqlError(e));
    }
}
